/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldButton;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceService;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.spi.APContext;
import com.adobe.internal.pdftoolkit.services.ap.spi.APResources;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextBodyAttributes;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFFieldList;
import com.adobe.internal.pdftoolkit.xml.CopyBlobProcessElement;
import com.adobe.internal.pdftoolkit.xml.XMLUtils;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

final class XFDF2PDFFormReader
extends DefaultHandler {
    private boolean needsAppearance;
    private PDFFieldNode curFormField;
    private XFDFFieldList curFormList;
    private PDFInteractiveForm acroFormTop;
    private StringBuilder valuesBuff = null;
    private LinkedList valuesList = null;
    private int skipElement = 0;
    private int inValue = 0;
    private int countXFDF = 0;
    private boolean inXFDF = false;
    private boolean inFields = false;
    private boolean generateAppearances = false;
    private boolean importLockedFields = true;
    private boolean buildFontSet = false;
    private HashMap afePDFFontMap = null;
    private Locale uLocale = null;
    PDFFontSet fonts = null;
    private int countFields = 0;
    private XMLUtils.CopyBlob2String richTextBlob = null;
    private static final String XFDF_NAME = "xfdf";
    private static final String FIELDS_NAME = "fields";
    private static final String FIELD_NAME = "field";
    private static final String ELEM_NAME = "name";
    private static final String VALUE_NAME = "value";
    private static final String RICH_NAME = "value-richtext";

    public XFDF2PDFFormReader(PDFInteractiveForm form) throws PDFInvalidParameterException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.acroFormTop = form;
        this.curFormField = null;
        if (form != null) {
            this.curFormList = new XFDFFieldList((List)form.getChildren());
        }
        this.needsAppearance = false;
        this.generateAppearances = false;
        this.importLockedFields = true;
    }

    public XFDF2PDFFormReader(PDFInteractiveForm form, PDFFontSet fontSet, Locale locale, boolean importIntoLockedFields) throws PDFInvalidParameterException, PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        this.acroFormTop = form;
        this.curFormField = null;
        this.curFormList = new XFDFFieldList((List)form.getChildren());
        this.needsAppearance = false;
        this.generateAppearances = true;
        this.afePDFFontMap = new HashMap();
        this.buildFontSet = false;
        if (locale == null) {
            locale = AppearanceUtils.convertStringToLocale(form.getPDFDocument().requireCatalog().getLang());
        }
        this.uLocale = locale;
        this.fonts = fontSet;
        this.importLockedFields = importIntoLockedFields;
    }

    private Object getFieldByName(XFDFFieldList parent, String name) throws SAXException {
        if (name == null) {
            return null;
        }
        if (parent == null) {
            return null;
        }
        for (int fieldInd = 0; fieldInd < parent.size(); ++fieldInd) {
            Object curField = parent.get(fieldInd);
            try {
                if (curField instanceof PDFField && name.equals(XFDFFieldList.getBaseFieldName(((PDFField)curField).getPartialName()))) {
                    return curField;
                }
                if (!(curField instanceof XFDFFieldList) || !name.equals(((XFDFFieldList)curField).getName())) continue;
                return curField;
            }
            catch (PDFException e) {
                throw new SAXException("Form fields parsing error", (Exception)((Object)e));
            }
        }
        return null;
    }

    private String getFieldName(Attributes elemAttrs) throws SAXException {
        String elemName = elemAttrs.getLocalName(0);
        if (elemName == null || elemName.length() == 0) {
            elemName = elemAttrs.getQName(0);
        }
        if (elemName == null || elemName.length() == 0) {
            return null;
        }
        if (elemAttrs.getLength() != 1 || !elemName.equals(ELEM_NAME)) {
            throw new SAXException("Wrong PDF Fields structure");
        }
        return elemAttrs.getValue(0);
    }

    String getElementType(String sName, String qName) {
        String elemType = sName;
        if (elemType == null || elemType.length() == 0) {
            elemType = qName;
        }
        return elemType;
    }

    @Override
    public void setDocumentLocator(Locator l) {
    }

    @Override
    public void startDocument() throws SAXException {
        this.skipElement = 0;
        this.inValue = 0;
        this.countXFDF = 0;
        this.inXFDF = false;
        this.inFields = false;
        this.countFields = 0;
    }

    @Override
    public void endDocument() throws SAXException {
        try {
            if (this.needsAppearance && !this.generateAppearances) {
                this.acroFormTop.setNeedAppearances(true);
            }
        }
        catch (PDFException e) {
            throw new SAXException("Cannot set value in PDF document", (Exception)((Object)e));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes elemAttrs) throws SAXException {
        String elemType = this.getElementType(sName, qName);
        if (elemType == null || elemType.length() == 0) {
            throw new SAXException("Wrong XML structure");
        }
        if (elemType.equals(XFDF_NAME)) {
            ++this.countXFDF;
            this.inXFDF = true;
        }
        if (elemType.equals(FIELDS_NAME)) {
            ++this.countFields;
            this.inFields = true;
        }
        if (this.skipElement > 0 || this.countXFDF != 1 || !this.inXFDF && this.countFields != 1) {
            ++this.skipElement;
        } else if (elemType.equals(FIELD_NAME)) {
            Object childField = this.getFieldByName(this.curFormList, this.getFieldName(elemAttrs));
            int flags = 0;
            if (childField instanceof PDFFieldNode) {
                try {
                    flags = ((PDFFieldNode)childField).getFlags();
                }
                catch (PDFException e) {
                    throw new SAXException("PDF document problem", (Exception)((Object)e));
                }
            }
            if (childField == null || !this.importLockedFields && childField instanceof PDFFieldNode && (flags & 1) != 0) {
                ++this.skipElement;
            } else if (childField instanceof PDFField) {
                if (childField instanceof PDFFieldSignature) {
                    ++this.skipElement;
                }
                this.curFormField = (PDFField)childField;
            } else {
                if (!(childField instanceof XFDFFieldList)) throw new SAXException("XFDF forms parsing: unexpected element");
                this.curFormList = (XFDFFieldList)childField;
                this.curFormField = this.curFormList.getBaseField();
            }
        } else if (elemType.equals(VALUE_NAME)) {
            if (this.curFormField == null || this.inValue > 0) {
                ++this.skipElement;
            } else if (this.valuesList == null) {
                this.valuesList = new LinkedList();
            }
            if (this.skipElement == 0) {
                ++this.inValue;
            }
        } else if (elemType.equals(RICH_NAME)) {
            if (this.curFormField == null || this.inValue > 0) {
                ++this.skipElement;
            }
            try {
                this.richTextBlob = new XMLUtils.CopyBlob2String((CopyBlobProcessElement)new RichTextBodyAttributes());
            }
            catch (PDFException e) {
                throw new SAXException("Form fields parsing error", (Exception)((Object)e));
            }
            if (this.skipElement == 0) {
                ++this.inValue;
            }
        } else {
            if (this.richTextBlob != null) {
                this.richTextBlob.startElement(namespaceURI, sName, qName, elemAttrs);
                return;
            }
            if (!this.inXFDF && !this.inFields) {
                ++this.skipElement;
            }
        }
        this.inXFDF = false;
        this.inFields = false;
    }

    @Override
    public void endElement(String namespaceURI, String sName, String qName) throws SAXException {
        block37: {
            boolean changedValue = false;
            try {
                String elemType = this.getElementType(sName, qName);
                if (elemType == null || elemType.length() == 0) {
                    throw new SAXException("Wrong XML structure");
                }
                if (this.skipElement > 0) {
                    --this.skipElement;
                    break block37;
                }
                if (elemType.equals(FIELD_NAME)) {
                    if (this.curFormField != null && this.valuesList != null) {
                        List formOptList;
                        PDFField valueField = PDFField.getInstance((CosObject)this.curFormField.getCosObject());
                        if (this.valuesList.isEmpty()) {
                            valueField.removeValue();
                            if (!(valueField instanceof PDFFieldButton)) {
                                this.needsAppearance = true;
                            }
                        } else if (valueField instanceof PDFFieldButton && (formOptList = ((PDFFieldButton)valueField).getOptionList()) != null) {
                            Iterator valueIterator = this.valuesList.iterator();
                            while (valueIterator.hasNext()) {
                                String curValue = ((PDFText)valueIterator.next()).stringValue();
                                int optIndex = formOptList.indexOf(curValue);
                                if (optIndex < 0) continue;
                                Integer valueIndex = optIndex;
                                valueField.setNameValue(ASName.create((String)valueIndex.toString()));
                                ((PDFFieldButton)valueField).setStateFromValue();
                                break;
                            }
                        } else if (this.valuesList.size() == 1) {
                            if (valueField instanceof PDFFieldButton) {
                                valueField.setNameValue(ASName.create((String)((PDFText)this.valuesList.get(0)).stringValue()));
                                ((PDFFieldButton)valueField).setStateFromValue();
                            } else {
                                valueField.setTextValue((PDFText)this.valuesList.get(0));
                                this.needsAppearance = true;
                                changedValue = true;
                            }
                        } else {
                            valueField.setListValue((List)this.valuesList);
                            this.needsAppearance = true;
                            changedValue = true;
                        }
                        if (valueField instanceof PDFFieldChoice) {
                            ((PDFFieldChoice)valueField).setOptIndex();
                        }
                        if (changedValue && this.generateAppearances) {
                            APResources apResources = new APResources(this.fonts, this.uLocale, this.afePDFFontMap);
                            APContext apContext = new APContext(apResources, this.buildFontSet, null);
                            AppearanceService.generateFieldAppearances(valueField.getPDFDocument(), valueField, apContext, null);
                        }
                    }
                    this.valuesList = null;
                    if (this.curFormField == null || !this.curFormField.isTerminalField()) {
                        this.curFormList = this.curFormList.getParent();
                        if (this.curFormList == null) {
                            this.curFormList = new XFDFFieldList((List)this.acroFormTop.getChildren());
                        }
                    }
                    this.curFormField = null;
                    break block37;
                }
                if (elemType.equals(VALUE_NAME)) {
                    if (this.skipElement == 0) {
                        --this.inValue;
                    }
                    if (this.inValue == 0) {
                        if (this.valuesList == null) {
                            throw new SAXException("Form fields parsing error");
                        }
                        if (this.valuesBuff != null && this.valuesBuff.length() != 0 && this.curFormField != null) {
                            this.valuesList.add(PDFText.newInstance((PDFDocument)this.curFormField.getPDFDocument(), (String)this.valuesBuff.toString()));
                        }
                        if (this.valuesBuff != null) {
                            this.valuesBuff.setLength(0);
                        }
                    }
                } else if (elemType.equals(RICH_NAME)) {
                    if (this.skipElement == 0) {
                        --this.inValue;
                    }
                    if (this.inValue == 0 && this.curFormField != null && this.richTextBlob != null) {
                        String contents;
                        String richText = RichTextHandler.removeXMLPrefix(this.richTextBlob.getBlob());
                        if (richText != null) {
                            this.curFormField.setRichText(PDFText.newInstance((PDFDocument)this.curFormField.getPDFDocument(), (String)richText));
                            this.needsAppearance = true;
                            int doRTF = 0x2000000;
                            int flags = this.curFormField.getFlags();
                            this.curFormField.setFlags(flags | doRTF);
                        }
                        if ((contents = this.richTextBlob.getRawContent()) != null) {
                            boolean isUTF16 = PDFText.isUTF16((String)contents);
                            this.curFormField.setStringValue(contents, isUTF16);
                        }
                        this.richTextBlob = null;
                    }
                } else {
                    if (this.richTextBlob != null) {
                        this.richTextBlob.endElement(namespaceURI, sName, qName);
                        return;
                    }
                    if (elemType.equals(XFDF_NAME) && this.countXFDF > 1) {
                        --this.countXFDF;
                    } else if (elemType.equals(FIELDS_NAME) && this.countFields > 1) {
                        --this.countFields;
                    }
                }
            }
            catch (PDFException e) {
                throw new SAXException("Form fields parsing error", (Exception)((Object)e));
            }
        }
    }

    @Override
    public void characters(char[] buf, int offset, int len) throws SAXException {
        if (this.skipElement > 0 || this.inValue != 1) {
            return;
        }
        if (this.richTextBlob != null) {
            this.richTextBlob.copyCharacters(buf, offset, len);
        } else {
            String content = new String(buf, offset, len);
            if (this.valuesBuff == null) {
                this.valuesBuff = new StringBuilder(content);
            } else {
                this.valuesBuff.append(content);
            }
        }
    }

    @Override
    public void ignorableWhitespace(char[] buf, int offset, int len) throws SAXException {
    }

    @Override
    public void processingInstruction(String target, String data) throws SAXException {
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        throw new SAXException(" ERROR: SAX Exception: Doctype is disallowed!!");
    }

    @Override
    public void error(SAXParseException e) throws SAXParseException {
        throw e;
    }

    @Override
    public void warning(SAXParseException err) throws SAXParseException {
        throw err;
    }
}

