/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosContainerValuesIterator;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.traverser.GeneralDispatcher;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.util.ByteOps;
import com.adobe.internal.pdftoolkit.services.xfdf.impl.XFDFAnnotation;
import com.adobe.internal.util.ArrayListStack;
import java.io.UnsupportedEncodingException;
import java.util.Map;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class Cos2XMLReaderDispatcher
implements GeneralDispatcher {
    private ContentHandler mHandler;
    private Map mRefs;
    private XFDFAnnotation mAnnot;
    boolean mFirstElem;
    private static final String nsu = "";
    static final String DEFINE = "DEFINE";

    public Cos2XMLReaderDispatcher(ContentHandler handler, Map refs, XFDFAnnotation annot) {
        this.mHandler = handler;
        this.mRefs = refs;
        this.mAnnot = annot;
        this.mFirstElem = true;
    }

    public boolean finishDispatch(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        try {
            String tag = null;
            CosObject cosObject = entry.getValue();
            if (cosObject == null) {
                return true;
            }
            switch (cosObject.getType()) {
                case 5: {
                    tag = "ARRAY";
                    break;
                }
                case 2: {
                    tag = "BOOL";
                    break;
                }
                case 6: {
                    tag = "DICT";
                    break;
                }
                case 3: {
                    tag = "NAME";
                    break;
                }
                case 1: {
                    Number value = cosObject.numberValue();
                    tag = value instanceof Integer ? "INT" : "FIXED";
                    break;
                }
                case 7: {
                    tag = "STREAM";
                    AttributesImpl dataAttrs = new AttributesImpl();
                    dataAttrs.addAttribute(nsu, "MODE", "MODE", "CDATA", "RAW");
                    dataAttrs.addAttribute(nsu, "ENCODING", "ENCODING", "CDATA", "HEX");
                    this.mAnnot.createStreamDataElement(this.mHandler, ((CosStream)cosObject).getStreamEncoded(), dataAttrs, "DATA", true);
                    break;
                }
                case 4: {
                    tag = "STRING";
                }
            }
            this.mHandler.endElement(nsu, tag, tag);
        }
        catch (SAXException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        return true;
    }

    public boolean isCandidate(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack, boolean wasSeen) {
        return true;
    }

    public boolean startDispatch(CosContainerValuesIterator.Entry entry, ArrayListStack visitorStack, boolean wasSeen) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        AttributesImpl attributes = new AttributesImpl();
        CosObject cosObject = entry.getValue();
        this.setKey(attributes, entry.getKey());
        boolean start = this.setRef(attributes, cosObject, wasSeen);
        try {
            if (!this.mFirstElem) {
                this.mHandler.characters(XFDFAnnotation.END_ELEM, 0, 1);
            }
            this.mFirstElem = false;
        }
        catch (SAXException e2) {
            throw new PDFIOException((Throwable)e2);
        }
        switch (cosObject.getType()) {
            case 2: {
                this.setValue(attributes, ((Boolean)cosObject.getValue()).toString());
                try {
                    this.mHandler.startElement(nsu, "BOOL", "BOOL", attributes);
                    break;
                }
                catch (SAXException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            case 1: {
                Number value = cosObject.numberValue();
                String tag = value instanceof Integer ? "INT" : "FIXED";
                this.setValue(attributes, value.toString());
                try {
                    this.mHandler.startElement(nsu, tag, tag, attributes);
                    break;
                }
                catch (SAXException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            case 3: {
                try {
                    this.setValue(attributes, cosObject.nameValue().asString());
                    this.mHandler.startElement(nsu, "NAME", "NAME", attributes);
                    break;
                }
                catch (SAXException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            case 4: {
                String strData;
                String encoding = "ASCII";
                byte[] stringBytes = ((CosString)cosObject).byteArrayValue();
                boolean ascii = ByteOps.isASCII((byte[])stringBytes);
                if (!ascii) {
                    stringBytes = ByteOps.getHex((byte[])stringBytes);
                    encoding = "HEX";
                }
                try {
                    strData = new String(stringBytes, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException("UTF-8 encoding not supported.", e);
                }
                try {
                    attributes.addAttribute(nsu, "ENCODING", "ENCODING", "CDATA", encoding);
                    this.mHandler.startElement(nsu, "STRING", "STRING", attributes);
                    this.mHandler.characters(strData.toCharArray(), 0, strData.length());
                    break;
                }
                catch (SAXException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            case 6: {
                this.startContainer("DICT", this.mHandler, attributes, start);
                break;
            }
            case 7: {
                this.startContainer("STREAM", this.mHandler, attributes, true);
                break;
            }
            case 5: {
                this.startContainer("ARRAY", this.mHandler, attributes, start);
            }
        }
        return true;
    }

    private void startContainer(String tag, ContentHandler handler, AttributesImpl attributes, boolean start) throws PDFInvalidDocumentException {
        if (start) {
            attributes.addAttribute(nsu, DEFINE, DEFINE, "CDATA", nsu);
        }
        try {
            handler.startElement(nsu, tag, tag, attributes);
        }
        catch (SAXException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    private void setKey(AttributesImpl attributes, ASName key) throws PDFInvalidDocumentException {
        if (key != null) {
            attributes.addAttribute(nsu, "KEY", "KEY", "CDATA", key.asString());
        }
    }

    private void setValue(AttributesImpl attributes, String value) {
        attributes.addAttribute(nsu, "VAL", "VAL", "CDATA", value);
    }

    private boolean setRef(AttributesImpl attributes, CosObject cosObject, boolean wasSeen) {
        boolean start = false;
        if (this.mRefs.containsKey(cosObject)) {
            String refNum = String.valueOf((Integer)this.mRefs.get(cosObject));
            if (wasSeen) {
                attributes.addAttribute(nsu, "REF", "REF", "CDATA", refNum);
            } else {
                String indirectRef = "XFDFINDIRECTREF_" + refNum;
                attributes.addAttribute(nsu, indirectRef, indirectRef, "CDATA", nsu);
                start = true;
            }
        }
        return start;
    }

    public boolean continueTraversing(PDFInvalidDocumentException e) {
        return false;
    }
}

