/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.template;

import com.adobe.internal.pdftoolkit.services.xfa.template.XFAElement;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.XFA;
import com.adobe.xfa.ut.UnitSpan;

public class XFACaption
extends XFAElement {
    public XFACaption(Element element) {
        super(element);
    }

    public UnitSpan getReserve() {
        Attribute reserve = this.element.getAttribute(XFA.RESERVETAG);
        if (reserve == null) {
            return new UnitSpan(-1);
        }
        return new UnitSpan(reserve.getAttrValue());
    }

    public Placement getPlacement() {
        Attribute placement = this.element.getAttribute(XFA.PLACEMENTTAG);
        if (placement == null) {
            return Placement.LEFT;
        }
        return Placement.parse(placement.getAttrValue());
    }

    public boolean hasReserveAttribute() {
        return this.element.getAttribute(XFA.RESERVETAG) != null;
    }

    public static final class Placement {
        private final String name;
        public static final Placement LEFT = new Placement("left");
        public static final Placement TOP = new Placement("top");
        public static final Placement RIGHT = new Placement("right");
        public static final Placement BOTTOM = new Placement("bottom");
        public static final Placement INLINE = new Placement("inline");
        private static final Placement[] values = new Placement[]{LEFT, TOP, RIGHT, BOTTOM, INLINE};

        private Placement(String name) {
            this.name = name;
        }

        public static Placement parse(String s) {
            for (int i = 0; i < values.length; ++i) {
                if (!s.equals(Placement.values[i].name)) continue;
                return values[i];
            }
            return null;
        }

        public String toString() {
            return this.name;
        }
    }
}

