/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.Base64Engine;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldXFA;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.SOMExpressionUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFACanonicalizer;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMProcessor;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMServiceListener;
import com.adobe.internal.pdftoolkit.services.xfa.template.XFACaption;
import com.adobe.xfa.Attribute;
import com.adobe.xfa.Element;
import com.adobe.xfa.Node;
import com.adobe.xfa.StringAttr;
import com.adobe.xfa.XFA;
import com.adobe.xfa.layout.BoxModelLayout;
import com.adobe.xfa.layout.LayoutEnv;
import com.adobe.xfa.template.TemplateModel;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.ut.ExFull;
import com.adobe.xfa.ut.UnitSpan;
import java.util.List;
import java.util.StringTokenizer;

public class XFAInternalUtils {
    private static final String STROKE_SOLID = "solid";
    private static final String STROKE_DASHED = "dashed";
    private static final String STROKE_LOWERED = "lowered";
    private static final String STROKE_RAISED = "raised";
    private static final String STROKE_EMBOSSED = "embossed";
    private static final String STROKE_ETCHED = "etched";
    public static final String STROKE_UNDERLINED = "underlined";
    private static final String STROKE_DASHDOT = "dashDot";
    private static final String STROKE_DASHDOTDOT = "dashdotdot";
    private static final String STROKE_DOTTED = "dotted";

    private XFAInternalUtils() {
    }

    public static final void canonicalizeXFATemplate(PDFDocument pdfDoc, InputByteStream original, OutputByteStream canonical) throws PDFIOException, PDFInvalidXMLException, PDFInvalidParameterException, PDFInvalidDocumentException, PDFSecurityException {
        XFADOM xfaDOM = XFADOMService.ensureXFADOMCreated(pdfDoc);
        XFACanonicalizer.canonicalize(XFAUtils.g_packets_CommentsAndDefault, xfaDOM.getXFADocument(), xfaDOM.getAppModel(), original, canonical);
    }

    public static void enableLeanDocGeneration(PDFDocument pdfDoc) {
        XFADOMServiceListener serviceListener = XFADOMService.procureXFADOMServiceListener(pdfDoc, new XFAProcessingOptions(false, false), false);
        if (serviceListener != null) {
            serviceListener.setLeanDocGenerationEnabled(true);
        }
    }

    public static void enableMergeIncrSectionsDuringLeanDocGeneration(PDFDocument pdfDoc) {
        XFADOMServiceListener serviceListener = XFADOMService.procureXFADOMServiceListener(pdfDoc, new XFAProcessingOptions(false, false), false);
        if (serviceListener != null) {
            serviceListener.setMergeIncrSectionsDuringLeanDoc(true);
        }
    }

    public static XFADOMServiceListener getXFADOMServiceListener(PDFDocument pdfDocument) {
        DocumentListenerRegistry registry = pdfDocument.getListenerRegistry();
        return (XFADOMServiceListener)registry.getListener(XFADOMServiceListener.class);
    }

    public static byte[] getDecodedBase64DERCert(byte[] base64EncodedCert) {
        int decodedLen = Base64Engine.decode((byte[])base64EncodedCert, (int)0, (int)base64EncodedCert.length, null, (int)0);
        byte[] base64DecodedCert = new byte[decodedLen];
        Base64Engine.decode((byte[])base64EncodedCert, (int)0, (int)base64EncodedCert.length, (byte[])base64DecodedCert, (int)0);
        return base64DecodedCert;
    }

    public static BoxModelLayout getBoxModelLayout(Field signatureField) {
        return BoxModelLayout.newBoxModel((Element)signatureField, (LayoutEnv)new LayoutEnv(), (boolean)false);
    }

    public static XFACaption getCaptionForField(Field field) {
        if (field == null) {
            return null;
        }
        Element caption = (Element)field.resolveNode("caption");
        if (caption == null) {
            return null;
        }
        return new XFACaption(caption);
    }

    private static double[] getEdgeColor(PDFDocument pdfDoc, Field xfaField) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            String sRGB = "";
            if (xfaField != null) {
                Element colorNode;
                Element edgeNode;
                Element sigField = XFAInternalUtils.findTemplateModelElement(pdfDoc, xfaField, "ui.signature", true);
                if (sigField == null) {
                    throw new PDFInvalidParameterException("There is no signature element in the field");
                }
                Element borderNode = sigField.getElement(XFA.BORDERTAG, false, 0, true, false);
                if (borderNode != null && (edgeNode = borderNode.getElement(XFA.EDGETAG, false, 0, true, false)) != null && (colorNode = edgeNode.getElement(XFA.COLORTAG, false, 0, true, false)) != null) {
                    sRGB = colorNode.getAttribute(XFA.VALUETAG).getAttrValue();
                }
            }
            return XFAInternalUtils.convertStringToDoubleArray(sRGB);
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
    }

    private static String getEdgeStroke(PDFDocument pdfDoc, Field xfaField) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            String stroke = STROKE_SOLID;
            if (xfaField != null) {
                Element sigField = XFAInternalUtils.findTemplateModelElement(pdfDoc, xfaField, "ui.signature", true);
                if (sigField == null) {
                    throw new PDFInvalidParameterException("There is no signature element in the field");
                }
                Element borderNode = sigField.getElement(XFA.BORDERTAG, false, 0, true, false);
                if (borderNode != null) {
                    if (XFAInternalUtils.usesUnderlinedStyle(borderNode)) {
                        return STROKE_UNDERLINED;
                    }
                    Element edgeNode = borderNode.getElement(XFA.EDGETAG, false, 0, true, false);
                    if (edgeNode != null) {
                        stroke = edgeNode.getAttribute(XFA.STROKETAG, false, false).getAttrValue();
                    }
                }
            }
            return stroke;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
    }

    private static String getEdgeThicknessAsString(PDFDocument pdfDoc, Field xfaField) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            String thickness = "";
            if (xfaField != null) {
                Element edgeNode;
                Element sigField = XFAInternalUtils.findTemplateModelElement(pdfDoc, xfaField, "ui.signature", true);
                if (sigField == null) {
                    throw new PDFInvalidParameterException("There is no signature element in the field");
                }
                Element borderNode = sigField.getElement(XFA.BORDERTAG, false, 0, true, false);
                if (borderNode != null && (edgeNode = borderNode.getElement(XFA.EDGETAG, false, 0, true, false)) != null) {
                    thickness = edgeNode.getAttribute(XFA.THICKNESSTAG, false, false).getAttrValue();
                }
            }
            return thickness;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
    }

    private static Element findTemplateModelElement(PDFDocument pdfDoc, Field sigField, String elementSomExpr, boolean createIfNotPresent) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            XFADOM xfaDOM = XFADOMService.ensureXFADOMCreated(pdfDoc);
            TemplateModel template = xfaDOM.getTemplateModel();
            if (template == null) {
                return null;
            }
            Node nodeFound = null;
            nodeFound = createIfNotPresent ? sigField.resolveNode(elementSomExpr) : sigField.resolveNode(elementSomExpr, true, false, false);
            if (!(nodeFound instanceof Element)) {
                return null;
            }
            return (Element)nodeFound;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
    }

    private static double[] getFillColor(PDFDocument pdfDoc, Field xfaField) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            String sRGB = "";
            if (xfaField != null) {
                Element colorNode;
                Element fillNode;
                Element sigField = XFAInternalUtils.findTemplateModelElement(pdfDoc, xfaField, "ui.signature", true);
                if (sigField == null) {
                    throw new PDFInvalidParameterException("There is no signature element in the field");
                }
                Element borderNode = sigField.getElement(XFA.BORDERTAG, false, 0, false, false);
                if (borderNode != null && (fillNode = borderNode.getElement(XFA.FILLTAG, false, 0, false, false)) != null && (colorNode = fillNode.getElement(XFA.COLORTAG, false, 0, false, false)) != null) {
                    sRGB = colorNode.getAttribute(XFA.VALUETAG).getAttrValue();
                }
            }
            return XFAInternalUtils.convertStringToDoubleArray(sRGB);
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
    }

    public static void populateSigWidgetAPCharacteristics(SignatureFieldInterface signatureField, BoxModelLayout boxModel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (signatureField == null) {
            throw new PDFInvalidParameterException("Signature Field passed is null.");
        }
        SignatureFieldPDF sigFieldPDF = signatureField.getPDFField();
        PDFAnnotationWidget signatureFieldWidget = null;
        signatureFieldWidget = sigFieldPDF.getPDFFieldSignature().getAnnotation();
        SignatureFieldXFA sigFieldXFA = signatureField.getXFAField();
        signatureFieldWidget.setBorderStyle(XFAInternalUtils.getBorderStyleAttributes(sigFieldXFA != null ? sigFieldXFA.getXFAFieldSignature() : null, signatureField.getPDFDocument()));
        signatureFieldWidget.setAppearanceCharacteristics(XFAInternalUtils.createPDFAPCharacteristics(sigFieldXFA != null ? sigFieldXFA.getXFAFieldSignature() : null, signatureField.getPDFDocument(), boxModel));
    }

    private static PDFBorderStyle getBorderStyleAttributes(Field xfaField, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        UnitSpan unitSpan = new UnitSpan(XFAInternalUtils.getEdgeThicknessAsString(pdfDoc, xfaField));
        UnitSpan unitSpanPica = new UnitSpan(unitSpan.valueAsUnit(19));
        double borderWidth = (double)unitSpanPica.value() / 1000.0;
        PDFBorderStyle.Style style = XFAInternalUtils.createPDFBorderStyle(XFAInternalUtils.getEdgeStroke(pdfDoc, xfaField));
        PDFBorderStyle borderStyle = PDFBorderStyle.newInstance((PDFDocument)pdfDoc, (double)borderWidth, (PDFBorderStyle.Style)style, (long[])XFAInternalUtils.getDashArray(style, XFAInternalUtils.getEdgeStroke(pdfDoc, xfaField)));
        return borderStyle;
    }

    private static PDFBorderStyle.Style createPDFBorderStyle(String edgeStroke) throws PDFInvalidParameterException {
        if (edgeStroke.equalsIgnoreCase(STROKE_DASHED) || edgeStroke.equalsIgnoreCase(STROKE_DASHDOT) || edgeStroke.equalsIgnoreCase(STROKE_DASHDOTDOT) || edgeStroke.equalsIgnoreCase(STROKE_DOTTED)) {
            return PDFBorderStyle.Style.Dashed;
        }
        if (edgeStroke.equalsIgnoreCase(STROKE_SOLID)) {
            return PDFBorderStyle.Style.Solid;
        }
        if (edgeStroke.equalsIgnoreCase(STROKE_LOWERED) || edgeStroke.equalsIgnoreCase(STROKE_ETCHED)) {
            return PDFBorderStyle.Style.Inset;
        }
        if (edgeStroke.equalsIgnoreCase(STROKE_RAISED) || edgeStroke.equalsIgnoreCase(STROKE_EMBOSSED)) {
            return PDFBorderStyle.Style.Beveled;
        }
        if (edgeStroke.equalsIgnoreCase(STROKE_UNDERLINED)) {
            return PDFBorderStyle.Style.Underline;
        }
        throw new PDFInvalidParameterException("Edge Stroke value of " + edgeStroke + " is not supported by our ap generation code");
    }

    private static long[] getDashArray(PDFBorderStyle.Style lineStyle, String edgeStroke) {
        long[] dash = new long[]{};
        if (lineStyle == PDFBorderStyle.Style.Dashed) {
            if (edgeStroke.equalsIgnoreCase(STROKE_DOTTED)) {
                dash = new long[]{1L, 2L};
            }
            if (edgeStroke.equalsIgnoreCase(STROKE_DASHDOT)) {
                dash = new long[]{3L, 2L, 1L, 2L};
            }
            if (edgeStroke.equalsIgnoreCase(STROKE_DASHDOTDOT)) {
                dash = new long[]{3L, 2L, 1L, 2L, 1L, 2L};
            }
            if (edgeStroke.equalsIgnoreCase(STROKE_DASHED)) {
                dash = new long[]{4L, 2L};
            }
        }
        if (lineStyle == PDFBorderStyle.Style.Solid) {
            dash = new long[]{1L, 0L};
        }
        return dash;
    }

    private static double[] convertStringToDoubleArray(String strValue) {
        String delimiter = ",";
        StringTokenizer tokenizer = new StringTokenizer(strValue, delimiter);
        int tokens = tokenizer.countTokens();
        double[] doubleValue = new double[tokens];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            doubleValue[i++] = Double.parseDouble(tokenizer.nextToken());
        }
        return doubleValue;
    }

    private static PDFAppearanceCharacteristics createPDFAPCharacteristics(Field signatureField, PDFDocument pdfDoc, BoxModelLayout boxModel) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        double[] bgColor;
        PDFAppearanceCharacteristics apCharacteristics = PDFAppearanceCharacteristics.newInstance((PDFDocument)pdfDoc);
        double[] edgeColor = XFAInternalUtils.getEdgeColor(pdfDoc, signatureField);
        if (edgeColor.length > 0) {
            apCharacteristics.setBorderColor(edgeColor);
        }
        if ((bgColor = XFAInternalUtils.getFillColor(pdfDoc, signatureField)).length > 0) {
            apCharacteristics.setBackgroundColor(bgColor);
        }
        int rotationAngle = 0;
        if (boxModel != null) {
            rotationAngle = boxModel.getAngle().degrees();
        }
        apCharacteristics.setRotation(PDFRotation.getInstance((int)rotationAngle));
        return apCharacteristics;
    }

    private static boolean usesUnderlinedStyle(Element borderNode) throws PDFInvalidParameterException {
        try {
            boolean usesStyleUnderlined = false;
            int numHiddenEdges = 0;
            if (borderNode != null) {
                for (Node child = borderNode.getFirstXFAChild(); child != null; child = child.getNextXFASibling()) {
                    if (!child.getClassName().equals("edge") || !((Element)child).getAttribute(XFA.PRESENCETAG, false, false).getAttrValue().equals("hidden")) continue;
                    ++numHiddenEdges;
                }
            }
            if (numHiddenEdges == 3) {
                usesStyleUnderlined = true;
            }
            return usesStyleUnderlined;
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
    }

    public static void updateAttribute(Element element, int attrTag, String attrName, String value) throws PDFInvalidParameterException {
        if (value != null) {
            if (element.getAttribute(attrTag, true, false) != null) {
                element.setAttribute(null, attrName, attrName, value);
            } else {
                XFAInternalUtils.setAttributeValue(element, (Attribute)XFAInternalUtils.createAttribute(attrName, value), attrTag);
            }
        } else {
            XFAInternalUtils.setAttributeValue(element, (Attribute)XFAInternalUtils.createAttribute(attrName, ""), attrTag);
        }
    }

    private static StringAttr createAttribute(String xfaTag, String value) {
        return new StringAttr(xfaTag, value);
    }

    private static void setAttributeValue(Element xfaElement, Attribute attribute, int attrTag) throws PDFInvalidParameterException {
        try {
            xfaElement.setAttribute(attribute, attrTag);
        }
        catch (ExFull e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
    }

    public static Field getXFASignatureField(XFADOM xfaDOM, String somExpression) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (xfaDOM == null) {
            return null;
        }
        try {
            List<Field> sigFields = null;
            if (XFAService.getDocumentType(xfaDOM.getPDFDocument()).isXFA()) {
                String SIGNATURE_FIELD = "ui.signature";
                XFADOMProcessor xfaDOMProcessor = new XFADOMProcessor(xfaDOM);
                sigFields = xfaDOMProcessor.getFieldsFromFormDOM(SIGNATURE_FIELD);
            }
            return XFAInternalUtils.iterateAndSearchField(sigFields, somExpression);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("No XFA field with som expression " + somExpression + " exists in the XFA", (Throwable)e);
        }
    }

    public static Field iterateAndSearchField(List<Field> sigFields, String somExpression) throws PDFInvalidParameterException {
        if (sigFields != null) {
            for (int fInd = 0; fInd < sigFields.size(); ++fInd) {
                Field sigField = sigFields.get(fInd);
                String fieldSomExpr = SOMExpressionUtils.trimSomExpression(sigField.getSOMExpression());
                if (!fieldSomExpr.equals(somExpression)) continue;
                return sigField;
            }
        }
        return null;
    }

    public static void markXFADOMDirty(XFADOM xfaDOM) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        xfaDOM.setChanged();
    }
}

