/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.SkippingOutputStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.xfa.AppModel;
import com.adobe.xfa.Document;
import com.adobe.xfa.Model;
import com.adobe.xfa.ModelFactory;
import com.adobe.xfa.Node;
import com.adobe.xfa.Packet;
import com.adobe.xfa.configuration.ConfigurationModel;
import com.adobe.xfa.configuration.ConfigurationModelFactory;
import com.adobe.xfa.service.canonicalize.Canonicalize;
import com.adobe.xfa.template.TemplateModelFactory;
import com.adobe.xfa.ut.ExFull;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public final class XFACanonicalizer {
    private XFACanonicalizer() {
    }

    public static final boolean isDocDynamic(InputByteStream xfaStream) throws PDFIOException, PDFInvalidXMLException {
        AppModel appModel = new AppModel(null);
        appModel.addFactory((ModelFactory)new ConfigurationModelFactory());
        Document xfaDoc = new Document(appModel);
        XFACanonicalizer.loadXFADoc(xfaDoc, xfaStream);
        ConfigurationModel configModel = ConfigurationModel.getConfigurationModel((AppModel)appModel, (boolean)false);
        if (configModel == null) {
            return false;
        }
        StringBuilder value = new StringBuilder();
        configModel.getConfigValue("acrobat.acrobat7.dynamicRender", value);
        return value.toString().equals("required");
    }

    public static final void canonicalizeXFA(InputByteStream original, OutputByteStream canonical, String[] packetsToUse) throws PDFIOException, PDFInvalidXMLException {
        try {
            AppModel appModel = new AppModel(null);
            Document xfaDoc = new Document(appModel);
            TemplateModelFactory templateFactory = new TemplateModelFactory();
            appModel.addFactory((ModelFactory)templateFactory);
            XFACanonicalizer.loadXFADoc(xfaDoc, original);
            XFACanonicalizer.canonicalize(packetsToUse, xfaDoc, appModel, original, canonical);
        }
        catch (ExFull e) {
            throw new PDFInvalidXMLException(e.toString(), (Throwable)e);
        }
    }

    public static final void canonicalize(String[] packetsToUse, Document xfaDoc, AppModel appModel, InputByteStream original, OutputByteStream canonical) throws PDFIOException, PDFInvalidXMLException {
        try {
            Canonicalize c = null;
            if (packetsToUse == null) {
                c = new Canonicalize((Node)xfaDoc, true, true);
            } else {
                ArrayList<Node> oPacketList = new ArrayList<Node>();
                block11: for (Node oNext = appModel.getFirstXFAChild(); oNext != null; oNext = oNext.getNextXFASibling()) {
                    if (!(oNext instanceof Packet) && !(oNext instanceof Model)) continue;
                    for (int i = 0; i < packetsToUse.length; ++i) {
                        if (!oNext.getName().equals(packetsToUse[i])) continue;
                        oPacketList.add(oNext);
                        continue block11;
                    }
                }
                c = new Canonicalize(oPacketList, true, true);
            }
            SkippingOutputStream canonicalStream = null;
            try {
                canonicalStream = canonical.toOutputStream();
                c.canonicalize((OutputStream)canonicalStream, 4, null);
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
            finally {
                if (canonicalStream != null) {
                    try {
                        canonicalStream.close();
                    }
                    catch (IOException e) {
                        throw new PDFIOException((Throwable)e);
                    }
                }
            }
        }
        catch (ExFull e) {
            throw new PDFInvalidXMLException(e.toString(), (Throwable)e);
        }
    }

    private static final void loadXFADoc(Document xfaDoc, InputByteStream xfaStream) throws PDFIOException, PDFInvalidXMLException {
        InputStream inputStream = null;
        try {
            inputStream = xfaStream.toInputStream();
            xfaDoc.load(inputStream, "UTF-8", false);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
    }
}

