/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.form.scripthandler;

import com.adobe.internal.pdftoolkit.services.javascript.GibsonTopLevelScope;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import java.util.ArrayList;
import java.util.List;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.debug.DebuggableScript;

public class ScriptObject {
    private ScriptableObject moScriptableObj;
    private final List<String> mMethods;
    private final List<String> mVars;

    public ScriptObject(Script oScript) {
        assert (oScript != null);
        Context context = Context.getCurrentContext();
        DebuggableScript view = Context.getDebuggableView((Script)oScript);
        this.mVars = new ArrayList<String>();
        this.mMethods = new ArrayList<String>();
        if (view != null) {
            int nVars = view.getParamAndVarCount();
            for (int i = 0; i < nVars; ++i) {
                String name = view.getParamOrVarName(i);
                this.mVars.add(name);
            }
            int nFuncs = view.getFunctionCount();
            for (int i = 0; i < nFuncs; ++i) {
                DebuggableScript func = view.getFunction(i);
                String name = func.getFunctionName();
                this.mMethods.add(name);
            }
        }
        this.compile(context.decompileScript(oScript, 0));
    }

    private void compile(String sSource) {
        boolean bSuccess;
        Context context = Context.getCurrentContext();
        GibsonTopLevelScope scope = JavaScriptHandler.getTopLevelScope();
        this.moScriptableObj = (ScriptableObject)context.newObject((Scriptable)scope);
        boolean bl = bSuccess = this.moScriptableObj != null;
        if (!bSuccess) {
            return;
        }
        StringBuilder sBuf = new StringBuilder(sSource);
        sBuf.append('\n');
        String sThisDot = "this.";
        String sEquals = " = ";
        String sSemiColon = ";\n";
        for (String sName : this.mMethods) {
            sBuf.append("this.");
            sBuf.append(sName);
            sBuf.append(" = ");
            sBuf.append(sName);
            sBuf.append(";\n");
        }
        for (String sName : this.mVars) {
            sBuf.append("this.");
            sBuf.append(sName);
            sBuf.append(" = ");
            sBuf.append(sName);
            sBuf.append(";\n");
        }
        context.evaluateString((Scriptable)this.moScriptableObj, sBuf.toString(), null, 0, null);
    }

    public Object get(String name, Scriptable start) {
        if (this.mVars.contains(name)) {
            return ScriptableObject.getProperty((Scriptable)this.moScriptableObj, (String)name);
        }
        return Scriptable.NOT_FOUND;
    }

    public void put(String name, Scriptable start, Object value) {
        if (this.mVars.contains(name)) {
            ScriptableObject.putProperty((Scriptable)this.moScriptableObj, (String)name, (Object)value);
        }
    }
}

