/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.xfa.acroform;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosString;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldChoice;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.AFUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CWidget;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class CChoiceBasedField
extends CPDField {
    CChoiceBasedField(CPDFields pCPDFlds, PDFFieldNode coFld, String esFldName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(pCPDFlds, coFld, esFldName);
    }

    PDFFieldChoice getPDFFieldChoice() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return (PDFFieldChoice)this.getPDFFieldNode();
    }

    @Override
    boolean setValue(CosObject coValue, ASName asaKey) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        boolean bRet = false;
        AFChoicesRec arrChoices = new AFChoicesRec();
        this.getOptions(arrChoices);
        String[] esValues = this.convertValuesIntoArrayOfEStrs(coValue);
        int nValues = esValues.length;
        boolean bDidItWithIndices = false;
        if (nValues == 1 || nValues > 1 && this.getPDFFieldChoice().isMultipleSelectionAllowed()) {
            ArrayList<Integer> vectorIndices = new ArrayList<Integer>(nValues);
            block0: for (String nVal : esValues) {
                for (int j = 0; j < arrChoices.nChoices; ++j) {
                    if (!nVal.equals(arrChoices.esExports.size() > 0 ? arrChoices.esExports.get(j) : arrChoices.esValues.get(j))) continue;
                    vectorIndices.add(j);
                    continue block0;
                }
            }
            if (!vectorIndices.isEmpty()) {
                Collections.sort(vectorIndices);
                bRet = this.setIndices(vectorIndices);
                bDidItWithIndices = true;
            }
        }
        if (!bDidItWithIndices) {
            this.getPDFFieldNode().removeValue(ASName.k_I);
            bRet = super.setValue(coValue, ASName.k_V);
        }
        return bRet;
    }

    boolean setIndices(List<Integer> pIndices) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        CosArray coIndices = null;
        CosArray coValues = null;
        int iIndices = 0;
        PDFFieldChoice coFldChoice = this.getPDFFieldChoice();
        if (pIndices == null || pIndices.isEmpty()) {
            coFldChoice.removeValue(ASName.k_I);
            return super.setValue((CosObject)this.getCosDoc().createCosNull(), ASName.k_V);
        }
        coIndices = this.getCosDoc().createCosArray();
        if (pIndices.size() > 1) {
            coValues = this.getCosDoc().createCosArray();
        }
        CosObject coOpts = this.getOptions();
        for (iIndices = 0; iIndices < pIndices.size(); ++iIndices) {
            coIndices.add((CosObject)this.getCosDoc().createCosNumeric((Number)pIndices.get(iIndices)));
            CosObject coOpt = ((CosArray)coOpts).get(pIndices.get(iIndices).intValue());
            CosObject coVal = coOpt.getType() == 5 ? new CosCloneMgr(this.getCosDoc()).clone(((CosArray)coOpt).get(0)) : new CosCloneMgr(this.getCosDoc()).clone(coOpt);
            if (pIndices.size() == 1) {
                coValues = coVal;
                continue;
            }
            coValues.add(coVal);
        }
        if (this.AFCosObjEquivalent((CosObject)coIndices, coFldChoice.getCosDictionary().get(ASName.k_I)) && this.AFCosObjEquivalent((CosObject)coValues, coFldChoice.getCosDictionary().get(ASName.k_V))) {
            return false;
        }
        coFldChoice.getCosDictionary().put(ASName.k_I, (CosObject)coIndices);
        coFldChoice.getCosDictionary().put(ASName.k_V, (CosObject)coValues);
        return true;
    }

    String[] convertValuesIntoArrayOfEStrs(CosObject coValues) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int type = coValues != null ? coValues.getType() : 0;
        String[] esValues = new String[type == 5 ? ((CosArray)coValues).size() : 1];
        for (int i = 0; i < esValues.length; ++i) {
            CosObject value;
            if (type == 0) {
                esValues[i] = "";
                continue;
            }
            CosObject cosObject = value = type == 4 ? coValues : ((CosArray)coValues).get(i);
            if (value.getType() == 6) {
                value = ((CosDictionary)value).get(ASName.k_V);
            }
            esValues[i] = AFUtils.EStrNewFromCosObj(value);
        }
        return esValues;
    }

    String[] getValuesAsArrayOfEStrs() throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, PDFFontException {
        return this.convertValuesIntoArrayOfEStrs(this.getValue(ASName.k_V));
    }

    void getOptions(AFChoicesRec arrChoices) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        arrChoices.iDefault = -1;
        CosObject coOpts = this.getOptions();
        if (coOpts != null && coOpts.getType() == 5) {
            arrChoices.nChoices = ((CosArray)coOpts).size();
            if (arrChoices.nChoices > 0) {
                String[] esValues = this.getValuesAsArrayOfEStrs();
                int nValues = esValues.length;
                if (nValues > 0) {
                    arrChoices.iValues = this.getIndices();
                }
                String esDefault = this.getDefaultValueAsEStr();
                arrChoices.esValues = new ArrayList<String>(arrChoices.nChoices);
                arrChoices.esExports = new ArrayList<String>(arrChoices.nChoices);
                for (int i = 0; i < arrChoices.nChoices; ++i) {
                    CosObject coOpt = ((CosArray)coOpts).get(i);
                    if (coOpt.getType() == 5) {
                        arrChoices.esExports.add(i, AFUtils.EStrNewFromCosObj(((CosArray)coOpt).get(0)));
                        arrChoices.esValues.add(i, AFUtils.EStrNewFromCosObj(((CosArray)coOpt).get(1)));
                    } else {
                        arrChoices.esValues.add(i, AFUtils.EStrNewFromCosObj(coOpt));
                    }
                    if (arrChoices.iValues == null && esValues != null && esValues[0].equals(arrChoices.esExports.get(i) != null ? arrChoices.esExports.get(i) : arrChoices.esValues.get(i))) {
                        arrChoices.iValues = new Integer[1];
                        arrChoices.iValues[0] = i;
                        arrChoices.nValues = 1;
                    }
                    if (arrChoices.iDefault != -1 || AFUtils.EStrIsNull(esDefault)) continue;
                    if (arrChoices.esExports.get(i) != null) {
                        if (!esDefault.equals(arrChoices.esExports.get(i))) continue;
                        arrChoices.iDefault = i;
                        continue;
                    }
                    if (!esDefault.equals(arrChoices.esValues.get(i))) continue;
                    arrChoices.iDefault = i;
                }
            }
        }
    }

    private String getDefaultValueAsEStr() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return AFUtils.EStrNewFromCosObj(this.getDefaultValue());
    }

    private Integer[] getIndices() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject coIndices = this.getPDFFieldNode().getDictionaryCosObjectValue(ASName.k_I);
        Integer[] pIndices = null;
        if (coIndices != null && coIndices.getType() == 5) {
            pIndices = new Integer[((CosArray)coIndices).size()];
            for (int i = 0; i < pIndices.length; ++i) {
                pIndices[i] = ((CosNumeric)((CosArray)coIndices).get(i)).intValue();
            }
        }
        return pIndices;
    }

    CosObject getOptions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        CWidget pCWidget;
        CosObject coOpts = this.getPDFFieldNode().getDictionaryCosObjectValue(ASName.k_Opt);
        if ((coOpts == null || coOpts.getType() == 0) && (pCWidget = this.getWidget(0)) != null) {
            PDFAnnotationWidget coAnnot = pCWidget.getPDAnnot();
            coOpts = coAnnot.getDictionaryCosObjectValue(ASName.k_Opt);
        }
        return coOpts;
    }

    public void setOptions(CosObject coOpt) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        PDFFieldNode coFld = this.getPDFFieldNode();
        if (coOpt.getType() == 5 && ((CosArray)coOpt).size() > 0) {
            coFld.getCosDictionary().put(ASName.k_Opt, coOpt);
        } else {
            coFld.removeValue(ASName.k_Opt);
            CWidget pCWidget = this.getWidget(0);
            if (pCWidget != null) {
                PDFAnnotationWidget coAnnot = pCWidget.getPDAnnot();
                coAnnot.removeValue(ASName.k_Opt);
            }
        }
        coFld.removeValue(ASName.k_I);
    }

    public void setOptions(AFChoicesRec arrChoices) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFUnableToCompleteOperationException, PDFFontException {
        if (arrChoices.nChoices == 0) {
            this.setOptions((CosObject)this.getCosDoc().createCosNull());
            this.setIndices(null);
        } else {
            CosDocument cd = this.getCosDoc();
            CosArray coOpts = cd.createCosArray();
            for (int i = 0; i < arrChoices.nChoices; ++i) {
                CosString coOpt = cd.createCosString(arrChoices.esValues.get(i));
                if (arrChoices.esExports != null && arrChoices.esExports.get(i) != null) {
                    CosString coVal = coOpt;
                    CosString coExp = cd.createCosString(arrChoices.esExports.get(i));
                    coOpt = cd.createCosArray();
                    ((CosArray)coOpt).add(0, (CosObject)coExp);
                    ((CosArray)coOpt).add(0, (CosObject)coVal);
                }
                coOpts.add(i, (CosObject)coOpt);
            }
            this.setOptions((CosObject)coOpts);
            this.setIndices(Arrays.asList(arrChoices.iValues));
        }
    }

    @Override
    public String getValueAsEStr() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        if (this.getValue(ASName.k_V).getType() == 5) {
            return null;
        }
        return super.getValueAsEStr();
    }

    public static class AFChoicesRec {
        public List<String> esValues;
        public List<String> esExports;
        public int nChoices;
        public int nValues;
        public Integer[] iValues;
        public int iDefault;
    }
}

