/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationSquare;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.utils.ContentUtil;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterCallBackInterface;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.PDFToRasterConverter;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.ContentStreamSanitizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.HiddenContentManager;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.OverlappingObjectsDetector;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.PDFOptimizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.ResourceSanitizer;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class PageSanitizer {
    private static boolean debug = false;

    private PageSanitizer() {
    }

    public static void sanitize(PDFPage pdfPage, SanitizationContext context) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException, PDFConfigurationException, PDFUnableToCompleteOperationException {
        PDFOptimizer.doPageLevelOptimization(pdfPage);
        PDFResources resources = pdfPage.getResources();
        ResourceSanitizer.sanitize(resources, context, new HashSet<Integer>(), pdfPage);
        ContentWriter contentWriter = null;
        HiddenContentManager hiddenContentManager = new HiddenContentManager(pdfPage, context);
        try {
            RasterizationOptions rasterOptions = new RasterizationOptions();
            rasterOptions.registerCallBackManager((RasterCallBackInterface)hiddenContentManager);
            BufferedImage image = PDFToRasterConverter.toBufferedImage((PDFPage)pdfPage, (PDFFontSet)context.getUserOptions().getPDFFontSet(), (RasterizationOptions)rasterOptions);
            OverlappingObjectsDetector overlappingProc = hiddenContentManager.getOverlappingObjectsDetector();
            if (debug) {
                PageSanitizer.markBoundingBoxes(overlappingProc.getOverlappingBoundingBoxes(), pdfPage);
                return;
            }
            contentWriter = ContentWriter.newInstance((ModifiableContent)ModifiableContent.getInstance((PDFContents)PDFContents.newInstance((PDFDocument)pdfPage.getPDFDocument()), (PDFResources)resources));
            PDFOptimizer.addContentDelimiter(contentWriter);
            int resolution = context.getUserOptions().getResolution();
            if (resolution != 1 && image != null) {
                rasterOptions.setWidth((int)Math.round(pdfPage.getCropBox().width() * (double)resolution));
                rasterOptions.setHeight((int)Math.round(pdfPage.getCropBox().height() * (double)resolution));
                hiddenContentManager.setResolution(resolution);
                image = PDFToRasterConverter.toBufferedImage((PDFPage)pdfPage, (PDFFontSet)context.getUserOptions().getPDFFontSet(), (RasterizationOptions)rasterOptions);
            }
            if (overlappingProc.rasterFullPage()) {
                PageSanitizer.rasterFullPage(pdfPage, image, contentWriter, context, resolution);
                image = null;
                pdfPage.setContents(contentWriter.close().getContents());
            } else {
                if (!overlappingProc.getOverlappingBoundingBoxes().isEmpty() && image != null) {
                    PageSanitizer.writeOverlappedObjectsAsRaster(context, overlappingProc.getOverlappingBoundingBoxes(), ((DataBufferInt)image.getRaster().getDataBuffer()).getData(), image.getWidth(), image.getHeight(), contentWriter, pdfPage, resolution);
                }
                image = null;
                context.setHiddenContentManager(hiddenContentManager);
                PDFContents newContents = ContentStreamSanitizer.sanitize(pdfPage.getContents(), contentWriter, pdfPage.getResources(), context, pdfPage);
                pdfPage.setContents(newContents);
            }
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            hiddenContentManager.destroy();
            context.setHiddenContentManager(null);
        }
    }

    private static void rasterFullPage(PDFPage pdfPage, BufferedImage bufImage, ContentWriter contentWriter, SanitizationContext context, int resolution) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, IOException {
        int width = bufImage.getWidth();
        int height = bufImage.getHeight();
        int[] pageRaster = ((DataBufferInt)bufImage.getRaster().getDataBuffer()).getData();
        PDFXObjectImage xObjImage = PageSanitizer.createImageXObject(pdfPage, pageRaster, width, 0, 0, width, height);
        contentWriter.write(InstructionFactory.newGSave());
        ASMatrix ctm = new ASMatrix((double)(width / resolution), 0.0, 0.0, (double)(height / resolution), 0.0, 0.0);
        contentWriter.write(InstructionFactory.newConcatMatrix((double)ctm.geta(), (double)ctm.getb(), (double)ctm.getc(), (double)ctm.getd(), (double)ctm.getx(), (double)ctm.gety()));
        ASName imageName = contentWriter.write((PDFXObject)xObjImage);
        contentWriter.write(InstructionFactory.newGRestore());
        context.addResource(pdfPage.getResources().getCosObject(), ASName.k_XObject, imageName);
        pdfPage.setRotation(PDFRotation.ROTATE_0);
        pdfPage.setMediaBox(0.0, 0.0, (double)(width / resolution), (double)(height / resolution));
        pdfPage.setCropBox(null);
        context.getImageOptimizer().gatherImageOptimizationInfo(xObjImage, pdfPage, pdfPage.getMediaBox().getRectangle(), false);
    }

    private static void writeOverlappedObjectsAsRaster(SanitizationContext context, Map<HashSet<Integer>, Rectangle2D> overlappingBounds, int[] pageRaster, int width, int height, ContentWriter contentWriter, PDFPage pdfPage, int resolution) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, IOException, PDFInvalidParameterException {
        Iterator<Map.Entry<HashSet<Integer>, Rectangle2D>> itr = overlappingBounds.entrySet().iterator();
        Map.Entry<HashSet<Integer>, Rectangle2D> entry = null;
        Rectangle2D rect = null;
        ASMatrix pageMatrix = ContentUtil.computeMatrixFromBox((PDFPage)pdfPage);
        while (itr.hasNext()) {
            entry = itr.next();
            rect = entry.getValue();
            if (rect == null) continue;
            ASRectangle imageBox = new ASRectangle(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY()).transform(pageMatrix);
            if ((imageBox = imageBox.normalized()).left() > (double)width || imageBox.right() < 0.0 || imageBox.bottom() > (double)height || imageBox.top() < 0.0) continue;
            int x = (int)Math.max(Math.ceil((double)resolution * imageBox.left()), 0.0);
            int y = (int)((double)height - Math.min(Math.ceil((double)resolution * imageBox.top()), (double)height));
            int w = (int)Math.min(Math.floor((double)resolution * imageBox.right()), (double)width);
            int h = (int)((double)height - Math.max(Math.floor((double)resolution * imageBox.bottom()), 0.0));
            if ((w -= x) <= 0 || (h -= y) <= 0) continue;
            PDFXObjectImage xObjImage = PageSanitizer.createImageXObject(pdfPage, pageRaster, width, x, y, w, h);
            if (resolution != 1) {
                x = (int)Math.max(Math.ceil(imageBox.left()), 0.0);
                y = (int)((double)height - Math.min(Math.ceil(imageBox.top()), (double)height));
                w = (int)Math.min(Math.floor(imageBox.right()), (double)width);
                w -= x;
                h = (int)((double)height - Math.max(Math.floor(imageBox.bottom()), 0.0));
                h -= y;
            }
            contentWriter.write(InstructionFactory.newGSave());
            ASMatrix ctm = new ASMatrix((double)w, 0.0, 0.0, (double)h, (double)x, (double)(height - y - h)).concat(pageMatrix.getInverse());
            contentWriter.write(InstructionFactory.newConcatMatrix((double)ctm.geta(), (double)ctm.getb(), (double)ctm.getc(), (double)ctm.getd(), (double)ctm.getx(), (double)ctm.gety()));
            ASName imageName = contentWriter.write((PDFXObject)xObjImage);
            contentWriter.write(InstructionFactory.newGRestore());
            context.addResource(pdfPage.getResources().getCosObject(), ASName.k_XObject, imageName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static PDFXObjectImage createImageXObject(PDFPage pdfPage, int[] pageRaster, int rasterWidth, int x, int y, int w, int h) throws IOException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] image = null;
        try {
            int rgbValue = 0;
            for (int i = y; i < y + h; ++i) {
                for (int j = x; j < x + w; ++j) {
                    rgbValue = pageRaster[i * rasterWidth + j];
                    os.write(rgbValue >> 16);
                    os.write(rgbValue >> 8);
                    os.write(rgbValue);
                }
            }
        }
        finally {
            if (os != null) {
                image = os.toByteArray();
                os.close();
            }
        }
        PDFXObjectImage xObjImage = PDFXObjectImage.newInstance((PDFDocument)pdfPage.getPDFDocument());
        xObjImage.setStreamData((InputStream)new ByteArrayInputStream(image));
        xObjImage.setWidth(w);
        xObjImage.setHeight(h);
        xObjImage.setColorSpace((PDFColorSpace)PDFColorSpaceDeviceRGB.newInstance((PDFDocument)pdfPage.getPDFDocument()));
        xObjImage.setBitsPerComponent(8);
        return xObjImage;
    }

    private static void markBoundingBoxes(Map<HashSet<Integer>, Rectangle2D> overlappingBounds, PDFPage pdfPage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (overlappingBounds == null) {
            return;
        }
        Iterator<Map.Entry<HashSet<Integer>, Rectangle2D>> itr = overlappingBounds.entrySet().iterator();
        Map.Entry<HashSet<Integer>, Rectangle2D> entry = null;
        Rectangle2D rect = null;
        while (itr.hasNext()) {
            entry = itr.next();
            if (entry.getValue() == null) continue;
            rect = entry.getValue();
            System.out.println(entry);
            PDFAnnotationSquare annot = PDFAnnotationSquare.newInstance((PDFDocument)pdfPage.getPDFDocument());
            annot.setRect(rect.getMinX(), rect.getMinY(), rect.getMaxX(), rect.getMaxY());
            annot.setColor(new double[]{1.0, 0.0, 0.0});
            pdfPage.addAnnotation((PDFAnnotation)annot);
        }
    }
}

