/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.io.stream.BitInputStream;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.color.ColorSpaceCache;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.filter.CustomFilterRegistry;
import com.adobe.internal.pdftoolkit.core.filter.spi.ImageFilterInterface;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.graphicsDOM.utils.ImageInputSourceImpl;
import com.adobe.internal.pdftoolkit.image.ARGBImage;
import com.adobe.internal.pdftoolkit.image.ImageInputSource;
import com.adobe.internal.pdftoolkit.image.ImageResamplingMethod;
import com.adobe.internal.pdftoolkit.image.Resampler;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilter;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterList;
import com.adobe.internal.pdftoolkit.pdf.filters.PDFFilterParams;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpace;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceCMYK;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceGray;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceDeviceRGB;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceIndexed;
import com.adobe.internal.pdftoolkit.pdf.graphics.impl.ColorSpaceCacheImpl;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.transparency.PDFXObjectImageSoftMask;
import com.adobe.internal.pdftoolkit.pdf.utils.ContentUtil;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000BoxesList;
import com.adobe.internal.pdftoolkit.services.Jpeg2000.Jpeg2000Parser;
import com.adobe.internal.pdftoolkit.services.sanitization.SanitizationHandler;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationUtils;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

class ImageOptimizer {
    private IdentityHashMap<CosObject, OptimizationInfo> imagesToOptimize = new IdentityHashMap();
    private IdentityHashMap<CosObject, CosObject> clonedColorspaces = new IdentityHashMap();
    private CosObject clonedRGBColorspace;
    private CosObject clonedGrayColorspace;
    private CosObject clonedCMYKColorspace = null;
    private static final HashSet<ASName> supportedEncodingFilters = new HashSet();

    ImageOptimizer() {
    }

    private boolean isJPXImage(PDFXObjectImage xObjImage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFilterList list = xObjImage.getInputFilters();
        return list != null && !list.isEmpty() && ((PDFFilter)list.get(0)).getFilterName() == ASName.k_JPXDecode;
    }

    void gatherImageOptimizationInfo(PDFXObjectImage imageXObject, PDFPage pdfPage, ASRectangle imageBBox, boolean checkForDownsampling) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFilterList filters;
        PDFXObjectImageSoftMask sMask = imageXObject.getSoftMask();
        if (sMask != null) {
            sMask.getCosStream().newDataDecoded(sMask.getCosStream().getStreamDecoded());
            this.gatherImageOptimizationInfo((PDFXObjectImage)sMask, pdfPage, imageBBox, checkForDownsampling);
        }
        int width = imageXObject.getWidth();
        int height = imageXObject.getHeight();
        int bpc = imageXObject.getBitsPerComponent();
        PDFColorSpace colorspace = imageXObject.getColorSpace();
        if (colorspace == null) {
            if (imageXObject.getIsImageMask()) {
                colorspace = PDFColorSpaceDeviceGray.newInstance((PDFDocument)imageXObject.getPDFDocument());
            } else if (this.isJPXImage(imageXObject)) {
                ImageFilterInterface.ImageInfo imageInfo = this.getJPXImageInfo(imageXObject);
                colorspace = this.getPDFColorSpaceFromJPXImageInfo(imageInfo, imageXObject.getPDFDocument());
            }
        }
        ColorSpaceType csType = this.getColorSpaceType(colorspace, bpc);
        OptimizationInfo currentInfo = this.imagesToOptimize.get(imageXObject.getCosObject());
        if (checkForDownsampling && !(imageXObject instanceof PDFXObjectImageSoftMask)) {
            double userUnit = pdfPage.getUserUnit();
            double[] imageResolutions = this.getImageResolution(pdfPage, userUnit, width, height, imageBBox);
            double imageRes = Math.min(imageResolutions[0], imageResolutions[1]);
            if (imageRes > csType.downSampleAfter) {
                if (currentInfo == null) {
                    currentInfo = new OptimizationInfo(imageRes, imageResolutions[0], imageResolutions[1], csType.compressionAlgo);
                    this.imagesToOptimize.put(imageXObject.getCosObject(), currentInfo);
                } else if (imageRes < currentInfo.res) {
                    currentInfo.res = imageRes;
                    currentInfo.xRes = imageResolutions[0];
                    currentInfo.yRes = imageResolutions[1];
                }
                if (currentInfo.doDownsampling) {
                    this.validateDownsampling(colorspace, currentInfo, imageXObject);
                }
            } else if (currentInfo != null) {
                currentInfo.doDownsampling = false;
                if (imageRes < currentInfo.res) {
                    currentInfo.res = imageRes;
                    currentInfo.xRes = imageResolutions[0];
                    currentInfo.yRes = imageResolutions[1];
                }
            }
        }
        if (currentInfo == null) {
            currentInfo = new OptimizationInfo(0.0, 0.0, 0.0, csType.compressionAlgo);
            this.imagesToOptimize.put(imageXObject.getCosObject(), currentInfo);
            currentInfo.doDownsampling = false;
        }
        if ((filters = imageXObject.getInputFilters()) != null && !filters.isEmpty()) {
            currentInfo.doExifRemoval = filters.contains(ASName.k_DCTDecode.asString());
        }
        if (currentInfo.doCompression) {
            this.validateCompressionAlgo(colorspace, currentInfo, imageXObject, csType);
        }
    }

    private PDFColorSpace getPDFColorSpaceFromJPXImageInfo(ImageFilterInterface.ImageInfo imageInfo, PDFDocument pdfDoc) throws PDFInvalidDocumentException {
        switch (imageInfo.getNumberOfColorComponents()) {
            case 1: {
                return PDFColorSpaceDeviceGray.newInstance((PDFDocument)pdfDoc);
            }
            case 3: {
                return PDFColorSpaceDeviceRGB.newInstance((PDFDocument)pdfDoc);
            }
            case 4: {
                return PDFColorSpaceDeviceCMYK.newInstance((PDFDocument)pdfDoc);
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ImageFilterInterface.ImageInfo getJPXImageInfo(PDFXObjectImage imageXObject) throws PDFIOException, PDFCosParseException, PDFSecurityException {
        ImageFilterInterface.ImageInfo imageInfo;
        block6: {
            InputByteStream jpxStream = imageXObject.getCosStream().getStreamEncoded();
            try {
                imageInfo = Jpeg2000Parser.getImageInfo((Jpeg2000BoxesList)Jpeg2000Parser.parse((InputByteStream)jpxStream));
                if (jpxStream == null) break block6;
            }
            catch (Throwable throwable) {
                try {
                    if (jpxStream != null) {
                        jpxStream.close();
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new PDFIOException((Throwable)e);
                }
            }
            jpxStream.close();
        }
        return imageInfo;
    }

    private void validateDownsampling(PDFColorSpace cs, OptimizationInfo optInfo, PDFXObjectImage xObjectImage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectImage sMask;
        if (cs.getName() == ASName.k_Lab) {
            optInfo.doDownsampling = false;
        }
        if (xObjectImage.getMaskInData() != 0) {
            optInfo.doDownsampling = false;
        }
        if (xObjectImage.getIsImageMask() && cs.getName() == ASName.k_Indexed) {
            optInfo.doDownsampling = false;
        }
        if ((sMask = xObjectImage.getSMask()) != null && sMask.dictionaryContains(ASName.k_Matte)) {
            optInfo.doDownsampling = false;
        }
        if (xObjectImage.getMask() != null) {
            optInfo.doDownsampling = false;
        }
        if (cs.getName() == ASName.k_Indexed && ((PDFColorSpaceIndexed)cs).getBaseColorSpace().getName() == ASName.k_DeviceN) {
            optInfo.doDownsampling = false;
        }
    }

    private void validateCompressionAlgo(PDFColorSpace cs, OptimizationInfo optInfo, PDFXObjectImage xObjectImage, ColorSpaceType csType) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cs.getName() == ASName.k_Lab) {
            optInfo.doCompression = false;
        }
        if (xObjectImage.getMaskInData() != 0) {
            optInfo.doCompression = false;
        }
        if (cs.getName() == ASName.k_Indexed && !optInfo.doDownsampling && optInfo.compressionAlgo == ASName.k_DCTDecode) {
            optInfo.compressionAlgo = ASName.k_JPXDecode;
        }
        if (xObjectImage.getIsImageMask() && csType != ColorSpaceType.Monochrome) {
            optInfo.compressionAlgo = ASName.k_JPXDecode;
        }
        if (xObjectImage.getMask() != null && csType != ColorSpaceType.Monochrome) {
            optInfo.compressionAlgo = ASName.k_JPXDecode;
        }
        if (cs.getName() == ASName.k_Indexed && ((PDFColorSpaceIndexed)cs).getBaseColorSpace().getName() == ASName.k_DeviceN && optInfo.compressionAlgo == ASName.k_DCTDecode) {
            optInfo.doCompression = false;
        }
        if (xObjectImage.getWidth() <= 16 && xObjectImage.getHeight() <= 16 && !optInfo.doDownsampling) {
            optInfo.doCompression = false;
        }
    }

    private double[] getImageResolution(PDFPage pdfPage, double userUnit, int width, int height, ASRectangle imageBBox) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix matrix = ContentUtil.computeMatrixFromBox((PDFPage)pdfPage);
        ASRectangle imageBox = imageBBox.transform(matrix);
        double xPoints = Math.abs(imageBox.right() - imageBox.left());
        double yPoints = Math.abs(imageBox.bottom() - imageBox.top());
        double imgResX = xPoints != 0.0 ? (double)(width * 72) / (xPoints * userUnit) : 1000.0;
        imgResX = imgResX < 1.0 ? 1.0 : imgResX;
        double imgResY = yPoints != 0.0 ? (double)(height * 72) / (yPoints * userUnit) : 1000.0;
        imgResY = imgResX < 1.0 ? 1.0 : imgResY;
        return new double[]{imgResX, imgResY};
    }

    private ColorSpaceType getColorSpaceType(PDFColorSpace cs, int bpc) {
        int numberOfComp = cs.getNumberOfComponents();
        if (numberOfComp == 1) {
            if (bpc == 1) {
                return ColorSpaceType.Monochrome;
            }
            return ColorSpaceType.Greyscale;
        }
        return ColorSpaceType.Color;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void optimizeImages(SanitizationHandler handler) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Set<Map.Entry<CosObject, OptimizationInfo>> entrySet = this.imagesToOptimize.entrySet();
        Iterator<Map.Entry<CosObject, OptimizationInfo>> itr = entrySet.iterator();
        Map.Entry<CosObject, OptimizationInfo> entry = null;
        PDFXObjectImage image = null;
        OptimizationInfo info = null;
        while (itr.hasNext()) {
            int numBytes;
            entry = itr.next();
            info = entry.getValue();
            image = PDFXObjectImage.getInstance((CosObject)entry.getKey());
            image.setDictionaryValue(ASName.k_DecodeParms, (CosObject)null);
            PDFColorSpace cs = image.getColorSpace();
            if (cs == null && image.getIsImageMask()) {
                cs = PDFColorSpaceDeviceGray.newInstance((PDFDocument)image.getPDFDocument());
            }
            if (info.doDownsampling) {
                int height = image.getHeight();
                int width = image.getWidth();
                int destWidth = (int)Math.ceil(this.getColorSpaceType(cs, image.getBitsPerComponent()).downSampleTo * (double)width / info.xRes);
                int destHeight = (int)Math.ceil(this.getColorSpaceType(cs, image.getBitsPerComponent()).downSampleTo * (double)height / info.yRes);
                ARGBImage argbImage = null;
                boolean isImageMask = image.getIsImageMask();
                int[] downSampledData = null;
                BitInputStream bis = null;
                try {
                    argbImage = new ARGBImage((ImageInputSource)new ImageInputSourceImpl((Object)image.getImageStreamData(), false), width, height, image.getBitsPerComponent(), (ColorSpaceCache)ColorSpaceCacheImpl.newInstance((PDFColorSpace)cs, null, null, (double[])image.getDecode()), image.hasDecodeArray() ? image.getDecode() : null);
                    ByteArrayOutputStream os = new ByteArrayOutputStream();
                    try {
                        SanitizationUtils.ImageWriter writer = new SanitizationUtils.ImageWriter(isImageMask, os);
                        if (isImageMask) {
                            int rightMargin = 8 - width % 8;
                            rightMargin = rightMargin == 8 ? 0 : rightMargin;
                            double heightDownScaleRatio = (double)destHeight * 1.0 / (double)height;
                            bis = argbImage.getImageBitInputStream();
                            int tileHeight = 12000000 / width;
                            tileHeight = Math.min(height, tileHeight);
                            int[] imageTileData = new int[tileHeight * width];
                            int destHeightCopy = destHeight;
                            while (height > 0) {
                                int j;
                                int i;
                                tileHeight = Math.min(height, tileHeight);
                                int destTileHeight = (int)Math.round((double)tileHeight * heightDownScaleRatio);
                                destTileHeight = Math.min(destTileHeight, destHeightCopy);
                                for (i = 0; i < tileHeight; ++i) {
                                    for (j = 0; j < width; ++j) {
                                        imageTileData[i * width + j] = bis.read();
                                    }
                                    bis.skip((long)rightMargin);
                                }
                                downSampledData = Resampler.downSampleWithBicubicMethod((int)destWidth, (int)destTileHeight, (int)width, (int)tileHeight, (int[])imageTileData, (int)1);
                                for (i = 0; i < destTileHeight; ++i) {
                                    for (j = 0; j < destWidth; ++j) {
                                        writer.write(downSampledData[i * destWidth + j]);
                                    }
                                    writer.flush();
                                }
                                height -= tileHeight;
                                destHeightCopy -= destTileHeight;
                            }
                            if (destHeightCopy > 0) {
                                destHeight -= destHeightCopy;
                            }
                        } else {
                            argbImage.resample(destHeight, destWidth, ImageResamplingMethod.kResampleBicubic);
                            Iterator imagesItr = argbImage.getBufferedImagesIterator();
                            BufferedImage tile = null;
                            int actualHeight = 0;
                            while (imagesItr.hasNext()) {
                                tile = (BufferedImage)imagesItr.next();
                                actualHeight += tile.getHeight();
                                downSampledData = ((DataBufferInt)tile.getRaster().getDataBuffer()).getData();
                                for (int i = 0; i < tile.getHeight(); ++i) {
                                    for (int j = 0; j < destWidth; ++j) {
                                        writer.write(downSampledData[i * destWidth + j]);
                                    }
                                    writer.flush();
                                }
                            }
                            destHeight = actualHeight;
                        }
                    }
                    finally {
                        downSampledData = null;
                        try {
                            if (bis != null) {
                                bis.close();
                            }
                        }
                        finally {
                            if (argbImage != null) {
                                argbImage.close();
                            }
                        }
                        if (os != null) {
                            InputStream is = null;
                            try {
                                try {
                                    byte[] data = os.toByteArray();
                                    os.close();
                                    is = new ByteArrayInputStream(data);
                                    image.setStreamData(is);
                                }
                                finally {
                                    if (is != null) {
                                        is.close();
                                    }
                                }
                            }
                            catch (IOException e) {
                                throw new PDFIOException((Throwable)e);
                            }
                        }
                    }
                }
                catch (IOException e) {
                    throw new PDFIOException((Throwable)e);
                }
                image.setHeight(destHeight);
                image.setWidth(destWidth);
                if (isImageMask) {
                    image.setColorSpace((PDFColorSpace)PDFColorSpaceDeviceGray.newInstance((PDFDocument)image.getPDFDocument()));
                    image.setBitsPerComponent(1);
                } else {
                    image.setColorSpace((PDFColorSpace)PDFColorSpaceDeviceRGB.newInstance((PDFDocument)image.getPDFDocument()));
                    image.setBitsPerComponent(8);
                }
                try {
                    image.setDecode(null);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            PDFDocument pdfDoc = image.getPDFDocument();
            CustomFilterRegistry filterRegistry = pdfDoc.getCosDocument().getOptions().getCustomFilterRegistry();
            PDFFilterList filters = null;
            if (info.doCompression && info.compressionAlgo != null) {
                filters = PDFFilterList.newInstance((PDFDocument)image.getPDFDocument());
                PDFFilter filter = null;
                if (this.isFilterSupported(filterRegistry, info.compressionAlgo)) {
                    PDFFilterParams params = PDFFilterParams.newInstance((PDFDocument)image.getPDFDocument());
                    int bpc = image.getBitsPerComponent();
                    if (cs == null && this.isJPXImage(image)) {
                        ImageFilterInterface.ImageInfo imageInfo = this.getJPXImageInfo(image);
                        cs = this.getPDFColorSpaceFromJPXImageInfo(imageInfo, image.getPDFDocument());
                        bpc = imageInfo.getBitDepth();
                    }
                    params.put("BitsPerComponent", bpc);
                    params.put(ASName.k_Columns.asString(), image.getWidth());
                    params.put("Rows", image.getHeight());
                    params.getCosDictionary().put(ASName.k_ColorSpace, this.getColorSpaceCloned(cs));
                    filter = PDFFilter.newInstance((PDFDocument)image.getPDFDocument(), (ASName)info.compressionAlgo, (PDFFilterParams)params);
                } else {
                    filter = handler.replaceImageCompressionFilter(image, info.compressionAlgo);
                }
                filters.add(filter);
                image.setOutputFilters(filters);
            }
            if ((image.getOutputFilters() == null || image.getOutputFilters().isEmpty()) && (image.getInputFilters() == null || image.getInputFilters().isEmpty()) && (long)(numBytes = image.getWidth() * image.getHeight() * image.getBitsPerComponent() * cs.getNumberOfComponents() / 8) > 15L) {
                image.setOutputFilter(ASName.k_FlateDecode);
            }
            if ((filters = image.getOutputFilters()) == null) {
                filters = image.getInputFilters();
            }
            if (!info.doDownsampling && info.doExifRemoval && filters != null && filters.contains(ASName.k_DCTDecode.asString())) {
                image.getCosStream().newDataDecoded(image.getCosStream().getStreamDecoded());
            }
            if (filters == null) continue;
            Iterator filtersItr = filters.iterator();
            PDFFilter filter = null;
            PDFFilterList newList = PDFFilterList.newInstance((PDFDocument)image.getPDFDocument());
            while (filtersItr.hasNext()) {
                filter = (PDFFilter)filtersItr.next();
                if (!this.isFilterSupported(filterRegistry, filter.getFilterName())) {
                    filter = handler.replaceImageCompressionFilter(image, filter.getFilterName());
                }
                newList.add(filter);
            }
            image.setOutputFilters(newList);
        }
    }

    private boolean isFilterSupported(CustomFilterRegistry filterRegistry, ASName filterName) {
        return filterRegistry != null && filterRegistry.isEncodeFilterRegistered(filterName) || supportedEncodingFilters.contains(filterName);
    }

    private CosObject getColorSpaceCloned(PDFColorSpace cs) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ASName name = cs.getName();
        CosCloneMgr cloneMgr = new CosCloneMgr(cs.getPDFDocument().getCosDocument());
        if (name == ASName.k_DeviceRGB) {
            this.clonedRGBColorspace = this.clonedRGBColorspace != null ? this.clonedRGBColorspace : cloneMgr.clone(cs.getCosObject());
            return this.clonedRGBColorspace;
        }
        if (name == ASName.k_DeviceGray) {
            this.clonedGrayColorspace = this.clonedGrayColorspace != null ? this.clonedGrayColorspace : cloneMgr.clone(cs.getCosObject());
            return this.clonedGrayColorspace;
        }
        if (name == ASName.k_DeviceCMYK) {
            this.clonedCMYKColorspace = this.clonedCMYKColorspace != null ? this.clonedCMYKColorspace : cloneMgr.clone(cs.getCosObject());
            return this.clonedCMYKColorspace;
        }
        CosObject clonedCS = this.clonedColorspaces.get(cs.getCosObject());
        if (clonedCS == null) {
            clonedCS = cloneMgr.clone(cs.getCosObject());
            this.clonedColorspaces.put(cs.getCosObject(), clonedCS);
        }
        return clonedCS;
    }

    static {
        supportedEncodingFilters.add(ASName.k_FlateDecode);
        supportedEncodingFilters.add(ASName.k_ASCII85Decode);
        supportedEncodingFilters.add(ASName.k_ASCIIHexDecode);
        supportedEncodingFilters.add(ASName.k_LZWDecode);
        supportedEncodingFilters.add(ASName.k_RunLengthDecode);
        supportedEncodingFilters.add(ASName.k_CCITTFaxDecode);
    }

    private static class OptimizationInfo {
        private double res;
        private double xRes;
        private double yRes;
        private boolean doDownsampling = true;
        private boolean doExifRemoval = false;
        private boolean doCompression = true;
        private ASName compressionAlgo = ASName.k_DCTDecode;

        private OptimizationInfo(double res, double xRes, double yRes, ASName compressionAlgo) {
            this.res = res;
            this.xRes = xRes;
            this.yRes = yRes;
        }
    }

    private static enum ColorSpaceType {
        Monochrome(300.0, 450.0, ASName.k_CCITTFaxDecode),
        Greyscale(150.0, 225.0, ASName.k_DCTDecode),
        Color(150.0, 225.0, ASName.k_DCTDecode);

        private double downSampleTo;
        private double downSampleAfter;
        private ASName compressionAlgo;

        private ColorSpaceType(double downSampleTo, double downSampleAfter, ASName compressionAlgo) {
            this.downSampleTo = downSampleTo;
            this.downSampleAfter = downSampleAfter;
            this.compressionAlgo = compressionAlgo;
        }
    }
}

