/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.sanitization.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFRuntimeException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASCoordinate;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.graphicsDOM.AbstractContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentImageItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentItemsList;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentPathItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentTextItem;
import com.adobe.internal.pdftoolkit.graphicsDOM.ContentType;
import com.adobe.internal.pdftoolkit.graphicsDOM.DisplayArea;
import com.adobe.internal.pdftoolkit.graphicsDOM.DocumentContext;
import com.adobe.internal.pdftoolkit.graphicsDOM.FactoryInterface;
import com.adobe.internal.pdftoolkit.graphicsDOM.Glyph;
import com.adobe.internal.pdftoolkit.graphicsDOM.GraphicsState;
import com.adobe.internal.pdftoolkit.graphicsDOM.PathPainting;
import com.adobe.internal.pdftoolkit.graphicsDOM.TextState;
import com.adobe.internal.pdftoolkit.graphicsDOM.TilingPattern;
import com.adobe.internal.pdftoolkit.graphicsDOM.Type3Glyph;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterCallBackInterface;
import com.adobe.internal.pdftoolkit.services.rasterizer.RasterizationOptions;
import com.adobe.internal.pdftoolkit.services.rasterizer.impl.RasterDocumentContext;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.OverlappingObjectsDetector;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.PixelInfo;
import com.adobe.internal.pdftoolkit.services.sanitization.impl.SanitizationContext;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class HiddenContentManager
implements RasterCallBackInterface {
    private PixelInfo[][] pixelInfos;
    private int[] contentItemTotalPixels = null;
    private double[] visibility = null;
    private DisplayArea graphicsDOM = null;
    private BufferedImage raster = null;
    private AffineTransform graphicsTransform = null;
    private FactoryInterface itemFactory = null;
    private int lastID = 0;
    private int resolution = 1;
    private PDFPage pdfPage;
    private OverlappingObjectsDetector overlappingProc;
    private SanitizationContext context;
    private boolean[][] objectsOverlappingInfo = null;

    public int getResolution() {
        return this.resolution;
    }

    public void setResolution(int resolution) {
        this.resolution = resolution;
    }

    public void drawnImage(AffineTransform transform, BufferedImage imageDrawn, ContentImageItem imageItem, BufferedImage bufferedImage) {
        this.raster = bufferedImage;
        if (this.overlappingProc.rasterFullPage() || this.objectsOverlappingInfo[imageItem.getID()][0] || !this.objectsOverlappingInfo[imageItem.getID()][1] || !this.overlappingProc.textRemainsNonOverlapped()) {
            return;
        }
        AffineTransform img2user = new AffineTransform(this.graphicsTransform);
        img2user.concatenate(transform);
        AffineTransformOp affineOp = new AffineTransformOp(img2user, null);
        Rectangle2D bounds = affineOp.getBounds2D(imageDrawn);
        int[] boundArray = new int[4];
        boundArray[0] = (int)Math.max(Math.floor(bounds.getMinX()), 0.0);
        boundArray[1] = (int)Math.max(Math.floor(bounds.getMinY()), 0.0);
        if (bounds.getWidth() <= 0.0 || bounds.getHeight() <= 0.0) {
            return;
        }
        boundArray[2] = (int)Math.ceil(bounds.getWidth());
        boundArray[3] = (int)Math.ceil(bounds.getHeight());
        img2user.setTransform(img2user.getScaleX(), img2user.getShearY(), img2user.getShearX(), img2user.getScaleY(), img2user.getTranslateX() - (double)boundArray[0], img2user.getTranslateY() - (double)boundArray[1]);
        BufferedImage tempImage = new BufferedImage(boundArray[2], boundArray[3], 2);
        Graphics2D temp2D = tempImage.createGraphics();
        temp2D.drawRenderedImage(imageDrawn, img2user);
        int[] item = ((DataBufferInt)tempImage.getRaster().getDataBuffer()).getData();
        this.updatePixelInfo(item, boundArray, imageItem.getID(), ContentType.Image, false);
    }

    public void drawnPath(AffineTransform transform, GeneralPath currentPath, ContentPathItem pathItem, HashMap<String, BufferedImage> patterns, BufferedImage bufferedImage) {
        this.raster = bufferedImage;
        if (this.overlappingProc.rasterFullPage() || this.objectsOverlappingInfo[pathItem.getID()][0] || !this.objectsOverlappingInfo[pathItem.getID()][1] || !this.overlappingProc.textRemainsNonOverlapped()) {
            return;
        }
        this.drawnPathOrTextGlyph(transform, currentPath, pathItem, ContentType.Path, patterns);
    }

    public void drawnText(AffineTransform transform, GeneralPath currentPath, ContentPathItem pathItem, HashMap<String, BufferedImage> patterns, BufferedImage bufferedImage) {
        this.raster = bufferedImage;
        if (this.overlappingProc.rasterFullPage() || !this.objectsOverlappingInfo[pathItem.getID()][1] || !this.overlappingProc.textRemainsNonOverlapped()) {
            return;
        }
        Rectangle2D rect = currentPath.getBounds2D();
        rect = new Rectangle2D.Double(rect.getMinX(), (double)this.raster.getHeight() - rect.getMaxY(), rect.getWidth(), rect.getHeight());
        try {
            PDFRectangle pageCropBox = this.pdfPage.getCropBox();
            Rectangle2D.Double pageRect = new Rectangle2D.Double(pageCropBox.llx(), pageCropBox.lly(), pageCropBox.width() * (double)this.resolution, pageCropBox.height() * (double)this.resolution);
            Rectangle2D.Double intersection = new Rectangle2D.Double();
            Rectangle2D.intersect(pageRect, rect, intersection);
            if (((RectangularShape)intersection).getWidth() < 0.5 * rect.getWidth() || ((RectangularShape)intersection).getHeight() < 0.5 * rect.getHeight()) {
                return;
            }
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException((PDFException)((Object)e));
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException((PDFException)((Object)e));
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException((PDFException)((Object)e));
        }
        this.drawnPathOrTextGlyph(transform, currentPath, pathItem, ContentType.Text, patterns);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void drawnPathOrTextGlyph(AffineTransform transform, GeneralPath currentPath, ContentPathItem pathItem, ContentType contentType, HashMap<String, BufferedImage> patterns) {
        GraphicsState graphicsState = pathItem.getGState();
        PathPainting pathPaintType = pathItem.getPathPaintingType();
        currentPath = new GeneralPath(currentPath);
        currentPath.transform(this.graphicsTransform);
        Rectangle2D bounds = new BasicStroke((float)graphicsState.getLineWidth(), graphicsState.getLineCap().getValue(), graphicsState.getLineJoin().getValue()).createStrokedShape(currentPath).getBounds2D();
        if (bounds.getWidth() == 0.0 || bounds.getHeight() == 0.0) {
            return;
        }
        int[] boundArray = new int[]{Math.max((int)Math.floor(bounds.getMinX()), 0), Math.max((int)Math.floor(bounds.getMinY()), 0), (int)Math.ceil(bounds.getWidth() + 1.0), (int)Math.ceil(bounds.getHeight() + 1.0)};
        RasterDocumentContext tempContext = new RasterDocumentContext();
        BufferedImage tempImage = new BufferedImage(boundArray[2], boundArray[3], 2);
        Graphics2D temp2D = tempImage.createGraphics();
        tempContext.setImage(tempImage);
        tempContext.setGraphics2d(temp2D);
        if (contentType == ContentType.Text) {
            temp2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        RasterizationOptions tempOptions = new RasterizationOptions();
        tempOptions.registerCallBackManager(null);
        tempContext.setOptions(tempOptions);
        if (patterns != null) {
            tempContext.getLoadedTilingPatternsTiles().putAll(patterns);
        }
        AffineTransform transformCopy = new AffineTransform();
        transformCopy.setTransform(transformCopy.getScaleX(), transformCopy.getShearY(), transformCopy.getShearX(), transformCopy.getScaleY(), transformCopy.getTranslateX() - (double)boundArray[0], transformCopy.getTranslateY() - (double)boundArray[1]);
        currentPath.transform(transformCopy);
        ContentPathItem newPathItem = this.itemFactory.createContentPathItem(graphicsState);
        newPathItem.setPath(currentPath, pathPaintType);
        Area origClipPath = graphicsState.getClipPath();
        double ns = graphicsState.getNonStrokeAlpha();
        double s = graphicsState.getStrokeAlpha();
        GraphicsState.BlendingMode bm = graphicsState.getBlendingMode();
        double[] fillTilingPhase = graphicsState.getFillTilingPatternName() != null ? ((TilingPattern)graphicsState.getLoadedTilingPatterns().get(graphicsState.getFillTilingPatternName())).getPhase() : null;
        double[] strokeTilingPhase = graphicsState.getStrokeTilingPatternName() != null ? ((TilingPattern)graphicsState.getLoadedTilingPatterns().get(graphicsState.getStrokeTilingPatternName())).getPhase() : null;
        try {
            graphicsState.setClipPath(null);
            graphicsState.setBlendingMode(null);
            graphicsState.setNonStrokeAlpha(1.0);
            graphicsState.setStrokeAlpha(1.0);
            if (graphicsState.getFillTilingPatternName() != null) {
                ((TilingPattern)graphicsState.getLoadedTilingPatterns().get(graphicsState.getFillTilingPatternName())).setPhase(new double[]{-boundArray[0], -boundArray[1]});
            }
            if (graphicsState.getStrokeTilingPatternName() != null) {
                ((TilingPattern)graphicsState.getLoadedTilingPatterns().get(graphicsState.getStrokeTilingPatternName())).setPhase(new double[]{-boundArray[0], -boundArray[1]});
            }
            newPathItem.writeToDisplayArea((DocumentContext)tempContext);
        }
        finally {
            graphicsState.setClipPath(origClipPath);
            graphicsState.setBlendingMode(bm);
            graphicsState.setNonStrokeAlpha(ns);
            graphicsState.setStrokeAlpha(s);
            if (graphicsState.getFillTilingPatternName() != null) {
                ((TilingPattern)graphicsState.getLoadedTilingPatterns().get(graphicsState.getFillTilingPatternName())).setPhase(fillTilingPhase);
            }
            if (graphicsState.getStrokeTilingPatternName() != null) {
                ((TilingPattern)graphicsState.getLoadedTilingPatterns().get(graphicsState.getStrokeTilingPatternName())).setPhase(strokeTilingPhase);
            }
            if (tempContext != null) {
                tempContext.destroy();
            }
        }
        int[] item = ((DataBufferInt)tempImage.getRaster().getDataBuffer()).getData();
        this.updatePixelInfo(item, boundArray, pathItem.getID(), contentType, pathPaintType.isFill() && graphicsState.getFillTilingPatternName() != null || pathPaintType.isStroke() && graphicsState.getStrokeTilingPatternName() != null);
    }

    private void updatePixelInfo(int[] separateItem, int[] boundingBox, int currentContentID, ContentType contentType, boolean considerBackGround) {
        int[] wholeImage = ((DataBufferInt)this.raster.getRaster().getDataBuffer()).getData();
        int imageWidth = this.raster.getWidth();
        PixelInfo pixelInfo = null;
        int minX = Math.max(boundingBox[0], 0);
        int maxX = Math.min(imageWidth, boundingBox[0] + boundingBox[2]);
        int minY = Math.max(boundingBox[1], 0);
        int maxY = Math.min(this.raster.getHeight(), boundingBox[1] + boundingBox[3]);
        int i = minY;
        int a = 0;
        while (i < maxY && i < this.pixelInfos.length) {
            int j = minX;
            int b = 0;
            while (j < maxX && j < this.pixelInfos[0].length) {
                int backGroundColor;
                int actualColor = wholeImage[i * imageWidth + j];
                pixelInfo = this.pixelInfos[i][j];
                int expectedColor = separateItem[a * boundingBox[2] + b];
                int n = backGroundColor = pixelInfo != null ? pixelInfo.backgroundColor : -1;
                if (!(expectedColor == 0 || considerBackGround && backGroundColor == expectedColor)) {
                    int n2 = currentContentID;
                    this.contentItemTotalPixels[n2] = this.contentItemTotalPixels[n2] + 1;
                    if (pixelInfo == null || actualColor != pixelInfo.currentColor) {
                        if (actualColor == expectedColor) {
                            if (this.pixelInfos[i][j] == null) {
                                this.pixelInfos[i][j] = new PixelInfo();
                            }
                            this.pixelInfos[i][j].put(actualColor, currentContentID, ContentEffect.Complete, contentType);
                        } else {
                            if (this.pixelInfos[i][j] == null) {
                                this.pixelInfos[i][j] = new PixelInfo();
                            }
                            this.pixelInfos[i][j].put(actualColor, currentContentID, ContentEffect.Mixed, contentType);
                        }
                    }
                }
                ++j;
                ++b;
            }
            ++i;
            ++a;
        }
    }

    private int colorWithoutAlpha(double alpha, int srcColor, int dstColor) {
        int srcRed = srcColor >> 16 & 0xFF;
        int srcBlue = srcColor >> 8 & 0xFF;
        int srcGreen = srcColor & 0xFF;
        int dstRed = dstColor >> 16 & 0xFF;
        int dstBlue = dstColor >> 8 & 0xFF;
        int dstGreen = dstColor & 0xFF;
        int finalRed = (int)(alpha * (double)srcRed + (1.0 - alpha) * (double)dstRed);
        int finalBlue = (int)(alpha * (double)srcBlue + (1.0 - alpha) * (double)dstBlue);
        int finalGreen = (int)(alpha * (double)srcGreen + (1.0 - alpha) * (double)dstGreen);
        return -16777216 + (finalRed << 16) + (finalBlue << 8) + finalGreen;
    }

    private boolean valuesNearlyEqual(int srcColor, int dstColor) {
        int srcRed = srcColor >> 16 & 0xFF;
        int srcBlue = srcColor >> 8 & 0xFF;
        int srcGreen = srcColor & 0xFF;
        int dstRed = dstColor >> 16 & 0xFF;
        int dstBlue = dstColor >> 8 & 0xFF;
        int dstGreen = dstColor & 0xFF;
        return Math.abs(srcRed - dstRed) < 5 && Math.abs(srcBlue - dstBlue) < 5 && Math.abs(srcGreen - dstGreen) < 5;
    }

    public void initialize(BufferedImage raster, Graphics2D graphics2D) {
        this.pixelInfos = new PixelInfo[raster.getHeight()][raster.getWidth()];
        this.contentItemTotalPixels = new int[this.lastID + 1];
        this.raster = raster;
        this.graphicsTransform = graphics2D.getTransform();
    }

    DisplayArea getGraphicsDOM() {
        return this.graphicsDOM;
    }

    int getLastID() {
        return this.lastID;
    }

    double[] getContentItemsVisibility() {
        int i;
        this.objectsOverlappingInfo = null;
        if (this.contentItemTotalPixels == null) {
            return null;
        }
        if (this.visibility != null) {
            return this.visibility;
        }
        int[] contentItemActualPixels = new int[this.contentItemTotalPixels.length];
        for (i = 0; i < this.pixelInfos.length; ++i) {
            for (int j = 0; j < this.pixelInfos[0].length; ++j) {
                if (this.pixelInfos[i][j] == null) continue;
                Iterator<Integer> itr = this.pixelInfos[i][j].contentItemsWithEffect.iterator();
                Integer key = null;
                while (itr.hasNext()) {
                    key = itr.next();
                    int n = key;
                    contentItemActualPixels[n] = contentItemActualPixels[n] + 1;
                }
            }
        }
        this.visibility = new double[this.contentItemTotalPixels.length];
        for (i = 0; i < contentItemActualPixels.length; ++i) {
            this.visibility[i] = this.contentItemTotalPixels[i] == 0 ? 0.0 : 1.0 * (double)contentItemActualPixels[i] / (double)this.contentItemTotalPixels[i];
        }
        this.contentItemTotalPixels = null;
        this.pixelInfos = null;
        return this.visibility;
    }

    PixelInfo[][] getPixelInfo() {
        return this.pixelInfos;
    }

    void destroy() {
        this.contentItemTotalPixels = null;
        this.visibility = null;
        this.pixelInfos = null;
        this.graphicsDOM = null;
        this.raster = null;
        this.itemFactory = null;
        this.overlappingProc = null;
        this.context = null;
        this.objectsOverlappingInfo = null;
    }

    public Throwable reportError(Throwable error) {
        return error;
    }

    HiddenContentManager(PDFPage pdfPage, SanitizationContext context) {
        this.pdfPage = pdfPage;
        this.context = context;
    }

    OverlappingObjectsDetector getOverlappingObjectsDetector() {
        return this.overlappingProc;
    }

    private void populateContentItems(ContentItemsList<GraphicsState, ContentItem<GraphicsState>> contentItemsList) {
        Iterator itr = contentItemsList.iterator();
        ContentItem item = null;
        while (itr.hasNext()) {
            item = (ContentItem)itr.next();
            if (item instanceof DisplayArea) {
                this.populateContentItems((ContentItemsList<GraphicsState, ContentItem<GraphicsState>>)((DisplayArea)item).getContentItems());
                continue;
            }
            if (item.getType() != ContentType.Text || !((ContentTextItem)item).isFontType3()) continue;
            List glyphs = ((ContentTextItem)item).getText();
            for (int i = 0; i < glyphs.size(); ++i) {
                this.populateContentItems((ContentItemsList<GraphicsState, ContentItem<GraphicsState>>)((Type3Glyph)glyphs.get(i)).getOutline());
            }
        }
    }

    public boolean start(DisplayArea graphicsDOM, FactoryInterface factory) {
        this.graphicsDOM = graphicsDOM;
        this.populateContentItems((ContentItemsList<GraphicsState, ContentItem<GraphicsState>>)graphicsDOM.getContentItems());
        this.lastID = factory.getCurrentID();
        this.itemFactory = factory;
        this.overlappingProc = new OverlappingObjectsDetector();
        try {
            Map<HashSet<Integer>, Rectangle2D> overlappingBounds = this.overlappingProc.scan(this.pdfPage, (DisplayArea<GraphicsState, TextState, ContentItem<GraphicsState>>)graphicsDOM, this.lastID);
            this.objectsOverlappingInfo = this.overlappingProc.objectsOverlappingInfo;
            this.overlappingProc.objectsOverlappingInfo = null;
            return this.overlappingProc.rasterFullPage() || !overlappingBounds.isEmpty() || this.overlappingProc.textRemainsNonOverlapped();
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFRuntimeException((PDFException)((Object)e));
        }
        catch (PDFIOException e) {
            throw new PDFRuntimeException((PDFException)((Object)e));
        }
        catch (PDFSecurityException e) {
            throw new PDFRuntimeException((PDFException)((Object)e));
        }
        catch (PDFFontException e) {
            throw new PDFRuntimeException((PDFException)((Object)e));
        }
        catch (PDFConfigurationException e) {
            throw new PDFRuntimeException((PDFException)((Object)e));
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFRuntimeException((PDFException)((Object)e));
        }
    }

    public boolean processImage(Graphics2D graphics2d, ContentImageItem image) {
        if (!(this.overlappingProc.rasterFullPage() || this.objectsOverlappingInfo[image.getID()][0] || this.objectsOverlappingInfo[image.getID()][1])) {
            return false;
        }
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        return true;
    }

    public boolean processPath(Graphics2D graphics2d, ContentPathItem path) {
        if (!(this.overlappingProc.rasterFullPage() || this.objectsOverlappingInfo[path.getID()][0] || this.objectsOverlappingInfo[path.getID()][1])) {
            return false;
        }
        this.preprocessPath(path);
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        return true;
    }

    public boolean processText(Graphics2D graphics2d, ContentTextItem text) {
        List glyphs = text.getText();
        Iterator listItr = glyphs.iterator();
        if (text.isFontType3()) {
            ContentItemsList contentItemsList = null;
            while (listItr.hasNext()) {
                contentItemsList = ((Type3Glyph)listItr.next()).getOutline();
                Iterator itr = contentItemsList.iterator();
                while (itr.hasNext()) {
                    int id = ((AbstractContentItem)itr.next()).getID();
                    this.objectsOverlappingInfo[id][0] = this.objectsOverlappingInfo[text.getID()][0];
                    this.objectsOverlappingInfo[id][1] = !this.objectsOverlappingInfo[text.getID()][0];
                }
            }
        } else {
            Glyph glyph = null;
            while (listItr.hasNext()) {
                glyph = (Glyph)listItr.next();
                this.objectsOverlappingInfo[glyph.getID()][1] = !this.objectsOverlappingInfo[text.getID()][0];
            }
        }
        graphics2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        return true;
    }

    public ASName getOCUsageAppEvent() {
        return this.context.getUserOptions().getHandler().getOCUsageAppEvent();
    }

    private void preprocessPath(ContentPathItem path) {
        GeneralPath genPath = path.getPath();
        genPath = path.getPathPaintingType().isFill() ? this.expandRectangle(genPath, new AffineTransform(path.getTransformationMatrix().getValues())) : null;
        if (genPath != null) {
            path.setPath(genPath, path.getPathPaintingType());
            path.setTransformationMatrix(null);
        }
    }

    private GeneralPath expandRectangle(GeneralPath genPath, AffineTransform transform) {
        double diagLength2;
        ASCoordinate centroid2;
        PathIterator pathItr = genPath.getPathIterator(transform);
        double[] coords = new double[6];
        ASCoordinate[] vertices = new ASCoordinate[5];
        int count = 0;
        boolean firstMove = true;
        while (!pathItr.isDone()) {
            int segType = pathItr.currentSegment(coords);
            switch (segType) {
                case 0: {
                    if (!firstMove) {
                        return null;
                    }
                    firstMove = false;
                    vertices[count++] = new ASCoordinate(coords[0], coords[1]);
                    break;
                }
                case 1: {
                    if (firstMove || count >= 4) {
                        return null;
                    }
                    vertices[count++] = new ASCoordinate(coords[0], coords[1]);
                    break;
                }
                case 2: {
                    return null;
                }
                case 3: {
                    return null;
                }
                case 4: {
                    if (count != 4) {
                        return null;
                    }
                    vertices[4] = vertices[0];
                }
            }
            pathItr.next();
        }
        if (count != 4 || vertices[0] != vertices[4]) {
            return null;
        }
        ASCoordinate centroid1 = new ASCoordinate((vertices[0].x() + vertices[2].x()) / 2.0, (vertices[0].y() + vertices[2].y()) / 2.0);
        if (centroid1.distanceTo(centroid2 = new ASCoordinate((vertices[1].x() + vertices[3].x()) / 2.0, (vertices[1].y() + vertices[3].y()) / 2.0)) > 0.001) {
            return null;
        }
        double diagLength1 = vertices[0].distanceTo(vertices[2]);
        if (Math.abs(diagLength1 - (diagLength2 = vertices[1].distanceTo(vertices[3]))) > 0.001) {
            return null;
        }
        GeneralPath newPath = new GeneralPath();
        double minx = Math.min(Math.min(vertices[0].x(), vertices[1].x()), Math.min(vertices[2].x(), vertices[3].x()));
        double miny = Math.min(Math.min(vertices[0].y(), vertices[1].y()), Math.min(vertices[2].y(), vertices[3].y()));
        double maxx = Math.max(Math.max(vertices[0].x(), vertices[1].x()), Math.max(vertices[2].x(), vertices[3].x()));
        double maxy = Math.max(Math.max(vertices[0].y(), vertices[1].y()), Math.max(vertices[2].y(), vertices[3].y()));
        int i = 0;
        for (i = 0; i < 4 && (vertices[i].x() != minx || vertices[i].y() != miny); ++i) {
        }
        if (i == 4) {
            return null;
        }
        newPath.moveTo((float)Math.floor(minx), (float)Math.floor(miny));
        newPath.lineTo((float)Math.floor(minx), (float)Math.ceil(maxy));
        newPath.lineTo((float)Math.ceil(maxx), (float)Math.ceil(maxy));
        newPath.lineTo((float)Math.ceil(maxx), (float)Math.floor(miny));
        newPath.closePath();
        newPath.setWindingRule(genPath.getWindingRule());
        return newPath;
    }

    public boolean removeRasterizedGraphicsItems() {
        return false;
    }

    public static enum ContentEffect {
        Nothing,
        Complete,
        Mixed;

    }
}

