/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionHandler;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionContentWriter;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionUtils;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

class TextStateHolder
implements Cloneable {
    private int pageNumber;
    public Map<ASName, Instruction> tStateInstructionMap = new LinkedHashMap<ASName, Instruction>();
    public Map<ASName, Instruction> tState = new HashMap<ASName, Instruction>();

    TextStateHolder(int pageNumber) {
        this.pageNumber = pageNumber;
    }

    public TextStateHolder clone() {
        TextStateHolder tState = new TextStateHolder(this.pageNumber);
        tState.tState = new HashMap<ASName, Instruction>(this.tState);
        tState.tStateInstructionMap = new LinkedHashMap<ASName, Instruction>(this.tStateInstructionMap);
        return tState;
    }

    void writeTState(RedactionContentWriter writer, RedactionHandler redactionHandler) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        for (Instruction ins : this.tStateInstructionMap.values()) {
            writer.write(ins);
            if (ins.getOperator() != ASName.k_Tf) continue;
            RedactionUtils.handleTfInstruction(writer.sourceResourceState, writer.pageResourcesState, writer.redactionState, ins, this.pageNumber, redactionHandler, false);
        }
        this.tStateInstructionMap.clear();
    }

    void updateTState(Instruction instruction) {
        ASName operator = instruction.getOperator();
        this.tState.put(operator, instruction);
        this.tStateInstructionMap.remove(operator);
        this.tStateInstructionMap.put(operator, instruction);
    }
}

