/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.fontengine.font.FontData;
import com.adobe.fontengine.font.FontLoadingException;
import com.adobe.fontengine.font.InvalidFontException;
import com.adobe.fontengine.font.OutlineConsumer;
import com.adobe.fontengine.font.UnsupportedFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASHexString;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.processor.GState;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextRun;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextState;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFCMapUtils;
import com.adobe.internal.pdftoolkit.services.fontresources.FontResources;
import com.adobe.internal.pdftoolkit.services.fontresources.PDFFontListener;
import com.adobe.internal.pdftoolkit.services.redaction.impl.GlyphOutlineConsumer;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionAdditionalInfo;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionContentWriter;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionTextRun;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionUtils;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ResourcesState;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class TextRedactor {
    private Area redactionArea;
    private ResourcesState pageResourcesState;
    private RedactionContentWriter writer;
    private RedactionAdditionalInfo additionalInfo;

    TextRedactor(Area redactionArea, ResourcesState pageResourcesState, RedactionContentWriter writer, RedactionAdditionalInfo additionalInfo) {
        this.redactionArea = redactionArea;
        this.pageResourcesState = pageResourcesState;
        this.writer = writer;
        this.additionalInfo = additionalInfo;
    }

    ASMatrix handleTd(ASMatrix currTextMatrix, ASMatrix currLineMatrix, double tx, double ty) throws PDFIOException {
        currTextMatrix = new ASMatrix(1.0, 0.0, 0.0, 1.0, tx, ty).concat(currLineMatrix);
        this.writer.handleTStateInstruction(InstructionFactory.newTextMatrix((double)currTextMatrix.geta(), (double)currTextMatrix.getb(), (double)currTextMatrix.getc(), (double)currTextMatrix.getd(), (double)currTextMatrix.getx(), (double)currTextMatrix.gety()));
        return currTextMatrix;
    }

    ASMatrix handleTStar(ASMatrix currTextMatrix, ASMatrix currLineMatrix) throws PDFInvalidContentException, PDFIOException {
        Instruction ins = this.writer.currentTStateHolder.tState.get(ASName.k_TL);
        double tL = 0.0;
        if (ins != null) {
            tL = ins.getOperands().peekNumber().doubleValue();
        }
        return this.handleTd(currTextMatrix, currLineMatrix, 0.0, -tL);
    }

    ASMatrix handleTj(ASMatrix currCTM, ASMatrix initialTextMatrix, ResourcesState currentResourceState, Instruction instruction) throws PDFInvalidContentException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        GeneralPath tjPath;
        ASMatrix currTextMatrix = initialTextMatrix;
        ASString tjString = instruction.getOperands().peekString();
        if (tjString.getBytes().length == 0) {
            return currTextMatrix;
        }
        RedactionTextRun tRun = this.getCurrentTextRun(currCTM, currentResourceState, currTextMatrix, (ASObject)tjString);
        PDFFont currentFont = tRun.getTextState().getFont();
        boolean isSubSetFont = FontResources.isFontCanBeSubsetted((PDFFont)currentFont);
        ASMatrix textSpaceToDeviceSpaceCTM = tRun.getTextSpaceToDeviceSpaceCTM();
        ASRectangle tjRectangle = tRun.getTextRunGlyphBounds();
        if (tjRectangle != null) {
            tjRectangle = tjRectangle.normalized();
        }
        if (tjRectangle != null && tjRectangle.hasNonZeroDimensions()) {
            tjPath = new GeneralPath(new Rectangle2D.Double(tjRectangle.left(), tjRectangle.bottom(), tjRectangle.width(), tjRectangle.height()));
        } else {
            tjRectangle = tRun.getRectangleForTextRun(true, false).normalized();
            tjPath = this.getTransformedPath(textSpaceToDeviceSpaceCTM, tjRectangle);
        }
        Area tjArea = new Area(tjPath);
        if (tjArea.isEmpty() || !this.redactionArea.contains(tjPath.getBounds2D()) || isSubSetFont) {
            if (!RedactionUtils.pathIntersectsArea(tjPath, this.redactionArea, tjArea)) {
                this.writer.write(instruction);
                this.additionalInfo.setStreamContainsText(true);
                if (isSubSetFont) {
                    RedactionUtils.updateUnredactedCharCodes(currentFont, tjString);
                }
                return this.updateTextMatrixFromTextRun(null, initialTextMatrix, tRun);
            }
            this.writeRedactedTextInstructions(currCTM, new ArrayList<Instruction>(), initialTextMatrix, currTextMatrix, tRun, textSpaceToDeviceSpaceCTM, 0, tRun.getCharCodesFromFont(tjString.getBytes(), false), this.writer, isSubSetFont, currentFont);
        }
        return this.updateTextMatrixFromTextRun(this.writer, initialTextMatrix, tRun);
    }

    private GeneralPath getTransformedPath(ASMatrix textSpaceToDeviceSpaceCTM, ASRectangle tjRectangle) {
        GeneralPath tjPath = new GeneralPath(new Rectangle2D.Double(tjRectangle.left(), tjRectangle.bottom(), tjRectangle.width(), tjRectangle.height()));
        tjPath.transform(new AffineTransform(textSpaceToDeviceSpaceCTM.getValues()));
        return tjPath;
    }

    ASMatrix handleTJ(ASMatrix currCTM, ASMatrix initialTextMatrix, ResourcesState currentResourceState, Instruction instruction) throws PDFInvalidContentException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        GeneralPath tjPath;
        ASArray tjArray = instruction.getOperands().peekArray();
        ASMatrix currTextMatrix = initialTextMatrix;
        RedactionTextRun tRun = this.getCurrentTextRun(currCTM, currentResourceState, currTextMatrix, (ASObject)tjArray);
        Iterator iter = tjArray.iterator();
        boolean containsString = false;
        while (iter.hasNext()) {
            if (!(iter.next() instanceof ASString)) continue;
            containsString = true;
            break;
        }
        if (!containsString) {
            this.writer.write(instruction);
            return this.updateTextMatrixFromTextRun(null, initialTextMatrix, tRun);
        }
        ASMatrix textSpaceToDeviceSpaceCTM = tRun.getTextSpaceToDeviceSpaceCTM();
        PDFFont currentFont = tRun.getTextState().getFont();
        boolean isSubSetFont = FontResources.isFontCanBeSubsetted((PDFFont)currentFont);
        ASRectangle tjRectangle = tRun.getTextRunGlyphBounds();
        if (tjRectangle != null) {
            tjRectangle = tjRectangle.normalized();
        }
        if (tjRectangle != null && tjRectangle.hasNonZeroDimensions()) {
            tjPath = new GeneralPath(new Rectangle2D.Double(tjRectangle.left(), tjRectangle.bottom(), tjRectangle.width(), tjRectangle.height()));
        } else {
            tjRectangle = tRun.getRectangleForTextRun(false, false).normalized();
            tjPath = this.getTransformedPath(textSpaceToDeviceSpaceCTM, tjRectangle);
        }
        Area tjArea = new Area(tjPath);
        int currTRunCharCodeIndex = 0;
        if (tjArea.isEmpty() || !this.redactionArea.contains(tjPath.getBounds2D()) || isSubSetFont) {
            if (!RedactionUtils.pathIntersectsArea(tjPath, this.redactionArea, tjArea)) {
                this.writer.write(instruction);
                this.additionalInfo.setStreamContainsText(true);
                if (isSubSetFont) {
                    for (ASObject obj : tjArray) {
                        if (!(obj instanceof ASString)) continue;
                        RedactionUtils.updateUnredactedCharCodes(currentFont, (ASString)obj);
                    }
                }
                return this.updateTextMatrixFromTextRun(null, initialTextMatrix, tRun);
            }
            ArrayList<Instruction> instrList = new ArrayList<Instruction>();
            ASMatrix tempMatrix = currTextMatrix;
            double scaledFontSize = tRun.getTextState().getFontSize();
            if (tRun.isHorizontalWritingMode()) {
                scaledFontSize *= tRun.getTextState().getHorizScaling() / 100.0;
            }
            for (int i = 0; i < tjArray.size(); ++i) {
                ASObject obj = tjArray.get(i);
                if (!(obj instanceof ASString)) {
                    double tj = ((ASNumber)obj).doubleValue();
                    currTextMatrix = tRun.isHorizontalWritingMode() ? tempMatrix.preMultiply(-tj / 1000.0 * scaledFontSize, 0.0) : tempMatrix.preMultiply(0.0, -tj / 1000.0 * scaledFontSize);
                    tempMatrix = currTextMatrix;
                    instrList.add(InstructionFactory.newTextMatrix((double)currTextMatrix.geta(), (double)currTextMatrix.getb(), (double)currTextMatrix.getc(), (double)currTextMatrix.getd(), (double)currTextMatrix.getx(), (double)currTextMatrix.gety()));
                    continue;
                }
                ASString stringValue = (ASString)obj;
                List charCodes = tRun.getCharCodesFromFont(stringValue.getBytes(), false);
                tempMatrix = currTextMatrix = this.writeRedactedTextInstructions(currCTM, instrList, initialTextMatrix, currTextMatrix, tRun, textSpaceToDeviceSpaceCTM, currTRunCharCodeIndex, charCodes, this.writer, isSubSetFont, currentFont);
                currTRunCharCodeIndex += charCodes.size();
            }
        }
        return this.updateTextMatrixFromTextRun(this.writer, initialTextMatrix, tRun);
    }

    private ASMatrix writeRedactedTextInstructions(ASMatrix currCTM, List<Instruction> instructionsToBeWritten, ASMatrix initialTextMatrix, ASMatrix currTextMatrix, TextRun tRun, ASMatrix textSpaceToDeviceSpaceCTM, int currTRunCharCodeIndex, List<ArrayList> charCodesInTj, RedactionContentWriter writer, boolean isSubsetFont, PDFFont currentFont) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        ArrayList<Byte> unredactedCharCodes = new ArrayList<Byte>();
        ASMatrix tempMatrix = currTextMatrix;
        for (int charCodeIndex = 0; charCodeIndex < charCodesInTj.size(); ++charCodeIndex) {
            ASRectangle currentCharacterRectangle = tRun.getRectangleForCharCodeIndex(currTRunCharCodeIndex).normalized();
            GeneralPath characterPath = this.getTransformedPath(textSpaceToDeviceSpaceCTM, currentCharacterRectangle);
            byte[] currentCharCode = (byte[])((List)charCodesInTj.get(charCodeIndex)).get(0);
            if (this.isCharCodeRedacted(characterPath, tRun.getTextState(), tempMatrix, currCTM, (byte[])((List)charCodesInTj.get(charCodeIndex)).get(0), tRun.isHorizontalWritingMode())) {
                this.writeUnredactedCharCodes(instructionsToBeWritten, unredactedCharCodes);
                currTextMatrix = tRun.isHorizontalWritingMode() ? initialTextMatrix.preMultiply(((Double)tRun.getSpacingEnds().get(currTRunCharCodeIndex)).doubleValue(), 0.0) : initialTextMatrix.preMultiply(0.0, ((Double)tRun.getSpacingEnds().get(currTRunCharCodeIndex)).doubleValue());
                tempMatrix = currTextMatrix;
                instructionsToBeWritten.add(InstructionFactory.newTextMatrix((double)currTextMatrix.geta(), (double)currTextMatrix.getb(), (double)currTextMatrix.getc(), (double)currTextMatrix.getd(), (double)currTextMatrix.getx(), (double)currTextMatrix.gety()));
            } else {
                if (isSubsetFont) {
                    PDFFontListener fontListener = PDFFontListener.getFontListener((PDFDocument)currentFont.getPDFDocument());
                    fontListener.addToFontCache(currentFont, (int)PDFCMapUtils.getCharCode((byte[])currentCharCode), currentCharCode.length);
                }
                byte[] charCodeBytes = (byte[])((List)charCodesInTj.get(charCodeIndex)).get(0);
                for (int r = 0; r < charCodeBytes.length; ++r) {
                    unredactedCharCodes.add(charCodeBytes[r]);
                }
                tempMatrix = tRun.isHorizontalWritingMode() ? initialTextMatrix.preMultiply(((Double)tRun.getSpacingEnds().get(currTRunCharCodeIndex)).doubleValue(), 0.0) : initialTextMatrix.preMultiply(0.0, ((Double)tRun.getSpacingEnds().get(currTRunCharCodeIndex)).doubleValue());
            }
            ++currTRunCharCodeIndex;
        }
        this.writeUnredactedCharCodes(instructionsToBeWritten, unredactedCharCodes);
        for (int i = 0; i < instructionsToBeWritten.size(); ++i) {
            if (instructionsToBeWritten.get(i).getOperator() == ASName.k_Tm) {
                writer.handleTStateInstruction(instructionsToBeWritten.get(i));
                continue;
            }
            writer.write(instructionsToBeWritten.get(i));
        }
        instructionsToBeWritten.clear();
        return tempMatrix;
    }

    private void writeUnredactedCharCodes(List<Instruction> instructionsToBeWritten, List<Byte> unredactedCharCodes) {
        if (!unredactedCharCodes.isEmpty()) {
            byte[] unredcatedCharCodesBytes = new byte[unredactedCharCodes.size()];
            for (int m = 0; m < unredcatedCharCodesBytes.length; ++m) {
                unredcatedCharCodesBytes[m] = unredactedCharCodes.get(m);
            }
            unredactedCharCodes.clear();
            ASHexString hexS = new ASHexString(unredcatedCharCodesBytes);
            instructionsToBeWritten.add(InstructionFactory.newShowText((ASHexString)hexS));
            this.additionalInfo.setStreamContainsText(true);
        }
    }

    private RedactionTextRun getCurrentTextRun(ASMatrix currCTM, ResourcesState currentResourceState, ASMatrix currTextMatrix, ASObject textObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        GState currentGState = new GState();
        currentGState.setCTM(currCTM);
        TextState currentTextState = this.writer.getCurrentTextState(currentResourceState == null ? null : currentResourceState.getResources(), this.pageResourcesState.getResources());
        currentGState.setTextState(currentTextState);
        if (textObject instanceof ASString) {
            return new RedactionTextRun((ASString)textObject, currTextMatrix, currentGState, this.pageResourcesState.getResources().getPDFDocument());
        }
        if (textObject instanceof ASArray) {
            return new RedactionTextRun((ASArray)textObject, currTextMatrix, currentGState, this.pageResourcesState.getResources().getPDFDocument());
        }
        throw new IllegalArgumentException("ASArray or ASString expected, instead found : " + textObject);
    }

    private ASMatrix updateTextMatrixFromTextRun(RedactionContentWriter writer, ASMatrix initialTextMatrix, TextRun tRun) throws PDFIOException {
        ASMatrix currTextMatrix = initialTextMatrix.preMultiply(tRun.getTotalXShift(), tRun.getTotalYShift());
        if (writer != null) {
            writer.handleTStateInstruction(InstructionFactory.newTextMatrix((double)currTextMatrix.geta(), (double)currTextMatrix.getb(), (double)currTextMatrix.getc(), (double)currTextMatrix.getd(), (double)currTextMatrix.getx(), (double)currTextMatrix.gety()));
        }
        return currTextMatrix;
    }

    private boolean isCharCodeRedacted(GeneralPath charBoundingPath, TextState textState, ASMatrix currTextMatrix, ASMatrix currCTM, byte[] charCodes, boolean horizontalMode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException {
        if (this.redactionArea.contains(charBoundingPath.getBounds2D())) {
            return true;
        }
        if (RedactionUtils.pathIntersectsArea(charBoundingPath, this.redactionArea, new Area(charBoundingPath))) {
            if (horizontalMode) {
                PDFFont font = textState.getFont();
                FontData afeFontData = null;
                try {
                    if (font.getAFEFont() != null) {
                        afeFontData = font.getAFEFontData();
                    }
                    if (afeFontData != null) {
                        ASMatrix glyphSpaceToDeviceSpaceMatrix = new ASMatrix(textState.getFontSize(), 0.0, 0.0, textState.getFontSize(), 0.0, 0.0);
                        glyphSpaceToDeviceSpaceMatrix = glyphSpaceToDeviceSpaceMatrix.concat(currTextMatrix);
                        glyphSpaceToDeviceSpaceMatrix = glyphSpaceToDeviceSpaceMatrix.concat(currCTM);
                        int gid = textState.getFont().charCode2gid((int)PDFCMapUtils.getCharCode((byte[])charCodes));
                        if (gid <= 0) {
                            return true;
                        }
                        GlyphOutlineConsumer glyphOutline = new GlyphOutlineConsumer(glyphSpaceToDeviceSpaceMatrix);
                        afeFontData.getGlyphOutline(gid, (OutlineConsumer)glyphOutline);
                        GeneralPath glyphPath = glyphOutline.getGlyphPath();
                        if (glyphPath.getPathIterator(null).isDone()) {
                            return true;
                        }
                        return RedactionUtils.pathIntersectsArea(glyphPath, this.redactionArea, new Area(glyphPath));
                    }
                }
                catch (FontLoadingException e) {
                    throw new PDFFontException((Throwable)e);
                }
                catch (InvalidFontException e) {
                    throw new PDFFontException((Throwable)e);
                }
                catch (UnsupportedFontException e) {
                    throw new PDFFontException((Throwable)e);
                }
            }
            return true;
        }
        return false;
    }
}

