/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionaryMap;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.PDFVersion;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionHandler;
import com.adobe.internal.pdftoolkit.services.redaction.handler.RedactedResourceInfo;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionAdditionalInfo;
import java.util.HashSet;
import java.util.Set;

class ResourcesState {
    private PDFResources pdfResources;
    private RedactionHandler redactionHandler;
    private int pageNumber;
    Set<ASName> unusedXObjKeys = new HashSet<ASName>();
    Set<ASName> unusedFontKeys = new HashSet<ASName>();
    Set<ASName> unusedShadingKeys = new HashSet<ASName>();
    Set<ASName> unusedColourSpaceKeys = new HashSet<ASName>();
    Set<ASName> unusedPatternKeys = new HashSet<ASName>();
    Set<ASName> unusedExtGStateKeys = new HashSet<ASName>();
    Set<ASName> unusedPropertiesKeys = new HashSet<ASName>();

    void removeFont(ASName fontId) {
        this.unusedFontKeys.remove(fontId);
    }

    void removeXObj(ASName XobjId) {
        this.unusedXObjKeys.remove(XobjId);
    }

    void removeShading(ASName shadingId) {
        this.unusedShadingKeys.remove(shadingId);
    }

    void removeColour(ASName colorId) {
        this.unusedColourSpaceKeys.remove(colorId);
    }

    void removePattern(ASName patternId) {
        this.unusedPatternKeys.remove(patternId);
    }

    void removeExtGState(ASName extGStateId) {
        this.unusedExtGStateKeys.remove(extGStateId);
    }

    void removeProperties(ASName propertyId) {
        this.unusedPropertiesKeys.remove(propertyId);
    }

    PDFResources getResources() {
        return this.pdfResources;
    }

    ResourcesState(PDFResources pdfResources, RedactionHandler redactionHandler, int pageNumber) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfResources = pdfResources;
        this.redactionHandler = redactionHandler;
        this.pageNumber = pageNumber;
        this.updateResourcesMap((PDFCosDictionaryMap)pdfResources.getXObjectMap(), this.unusedXObjKeys);
        this.updateResourcesMap((PDFCosDictionaryMap)pdfResources.getFontMap(), this.unusedFontKeys);
        this.updateResourcesMap((PDFCosDictionaryMap)pdfResources.getShadingMap(), this.unusedShadingKeys);
        this.updateResourcesMap((PDFCosDictionaryMap)pdfResources.getColorSpaceMap(), this.unusedColourSpaceKeys);
        this.updateResourcesMap((PDFCosDictionaryMap)pdfResources.getPatternMap(), this.unusedPatternKeys);
        this.updateResourcesMap((PDFCosDictionaryMap)pdfResources.getExtGStateMap(), this.unusedExtGStateKeys);
        this.updateResourcesMap((PDFCosDictionaryMap)pdfResources.getMCPropertyMap(), this.unusedPropertiesKeys);
    }

    void cleanResources(RedactionAdditionalInfo additionalInfo) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.cleanupResourcesMap((PDFCosDictionaryMap)this.pdfResources.getXObjectMap(), this.unusedXObjKeys);
        if (this.pdfResources.getXObjectMap() != null && this.pdfResources.getXObjectMap().isEmpty()) {
            this.pdfResources.removeXObjectMap();
        }
        this.cleanupResourcesMap((PDFCosDictionaryMap)this.pdfResources.getFontMap(), this.unusedFontKeys);
        if (this.pdfResources.getFontMap() != null && this.pdfResources.getFontMap().isEmpty()) {
            this.pdfResources.removeFontMap();
        }
        this.cleanupResourcesMap((PDFCosDictionaryMap)this.pdfResources.getShadingMap(), this.unusedShadingKeys);
        if (this.pdfResources.getShadingMap() != null && this.pdfResources.getShadingMap().isEmpty()) {
            this.pdfResources.removeShadingMap();
        }
        this.cleanupResourcesMap((PDFCosDictionaryMap)this.pdfResources.getColorSpaceMap(), this.unusedColourSpaceKeys);
        if (this.pdfResources.getColorSpaceMap() != null && this.pdfResources.getColorSpaceMap().isEmpty()) {
            this.pdfResources.removeColorSpaceMap();
        }
        this.cleanupResourcesMap((PDFCosDictionaryMap)this.pdfResources.getPatternMap(), this.unusedPatternKeys);
        if (this.pdfResources.getPatternMap() != null && this.pdfResources.getPatternMap().isEmpty()) {
            this.pdfResources.removePatternMap();
        }
        this.cleanupResourcesMap((PDFCosDictionaryMap)this.pdfResources.getExtGStateMap(), this.unusedExtGStateKeys);
        if (this.pdfResources.getExtGStateMap() != null && this.pdfResources.getExtGStateMap().isEmpty()) {
            this.pdfResources.removeExtGStateMap();
        }
        this.cleanupResourcesMap((PDFCosDictionaryMap)this.pdfResources.getMCPropertyMap(), this.unusedPropertiesKeys);
        if (this.pdfResources.getMCPropertyMap() != null && this.pdfResources.getMCPropertyMap().isEmpty()) {
            this.pdfResources.removeMCPropertyMap();
        }
        if (this.pdfResources.getProcSetList() != null) {
            PDFVersion saveVersion = this.pdfResources.getPDFDocument().getToSaveVersion();
            if (saveVersion != null && saveVersion.greaterThan(PDFVersion.v1_3)) {
                this.pdfResources.setProcSetList(null);
            } else if (additionalInfo != null && !additionalInfo.isStreamContainsText()) {
                ASName[] originalProcSet = this.pdfResources.getProcSetList();
                boolean containsTextEntry = false;
                boolean containsPDFEntry = false;
                for (int i = 0; i < originalProcSet.length; ++i) {
                    if (originalProcSet[i] == ASName.k_PDF) {
                        containsPDFEntry = true;
                        continue;
                    }
                    if (originalProcSet[i] != ASName.k_Text) continue;
                    containsTextEntry = true;
                }
                if (containsTextEntry && containsPDFEntry) {
                    this.pdfResources.setProcSetList(new ASName[]{ASName.k_PDF});
                }
            }
        }
    }

    private void updateResourcesMap(PDFCosDictionaryMap dictionaryMap, Set<ASName> set) {
        if (dictionaryMap != null && !dictionaryMap.isEmpty()) {
            Set xObjs = dictionaryMap.keySet();
            for (ASName name : xObjs) {
                if (name == null) continue;
                set.add(name);
            }
        }
    }

    private void cleanupResourcesMap(PDFCosDictionaryMap dictionaryMap, Set<ASName> set) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        if (set != null && !set.isEmpty()) {
            for (ASName key : set) {
                PDFCosObjectContainer pdfCosObjContainer = dictionaryMap.remove((Object)key);
                RedactedResourceInfo redactedResourceInfo = RedactedResourceInfo.getInstance(pdfCosObjContainer, this.pageNumber);
                if (redactedResourceInfo == null) continue;
                this.redactionHandler.objectRedacted(redactedResourceInfo);
            }
        }
    }
}

