/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.fontset.PDFFontSet;
import com.adobe.internal.pdftoolkit.core.fontset.impl.PDFFontSetImpl;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationRedaction;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.ap.AppearanceAttributes;
import com.adobe.internal.pdftoolkit.services.ap.StyleAttributes;
import com.adobe.internal.pdftoolkit.services.ap.TextFormatterImpl;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.DefaultFont;
import com.adobe.internal.pdftoolkit.services.ap.impl.TextAppearance;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOverflowMode;
import com.adobe.internal.pdftoolkit.services.rcg.RCGWrapOption;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionOptions;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionContentWriter;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionUtils;
import java.awt.geom.GeneralPath;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RedactionXObjectWriter {
    static void removeRedactionAnnotations(PDFDocument pdfDoc, RedactionContentWriter writer, Map<Integer, Set<GeneralPath>> quadPointsRedactionPaths, int pageNumber, RedactionOptions redactionOptions, PDFAnnotationList redactionAnnotationList, Map<PDFXObjectForm, Map<ASMatrix, ASRectangle>> xObjsToInitialMatricesMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        ASMatrix currCTM = ASMatrix.createIdentityMatrix();
        PDFPage currentPage = pdfDoc.requirePages().getPage(pageNumber);
        PDFAnnotationList annotationList = currentPage.getAnnotationList();
        if (redactionAnnotationList != null && !redactionAnnotationList.isEmpty()) {
            PDFAnnotationIterator annotationListIterator = redactionAnnotationList.iterator();
            Integer count = 0;
            String name = "Fm";
            while (annotationListIterator.hasNext()) {
                PDFAnnotationPopup annotationPopup;
                PDFAnnotation parentAnnotation;
                PDFAnnotation annotation = annotationListIterator.next();
                if (annotation instanceof PDFAnnotationRedaction) {
                    RedactionXObjectWriter.applyRedactionXobjectForm((PDFAnnotationRedaction)annotation, name.concat(count.toString()), currCTM, pdfDoc, writer, quadPointsRedactionPaths, redactionOptions, null);
                    Integer n = count;
                    Integer n2 = count = Integer.valueOf(count + 1);
                    if (xObjsToInitialMatricesMap != null && !xObjsToInitialMatricesMap.isEmpty()) {
                        ASRectangle annotRect = RedactionXObjectWriter.getRedactionAnnotationRectangle((PDFAnnotationRedaction)annotation, quadPointsRedactionPaths).normalized();
                        for (PDFXObjectForm currentXObject : xObjsToInitialMatricesMap.keySet()) {
                            ContentWriter xObjWriter = ContentWriter.newInstance((ModifiableContent)ModifiableContent.newInstance((PDFXObjectForm)currentXObject));
                            if (currentXObject.getResources() == null) {
                                currentXObject.setResources(PDFResources.newInstance((PDFDocument)pdfDoc));
                                currentXObject.getResources().procureXObjectMap();
                            }
                            Map<ASMatrix, ASRectangle> matrixList = xObjsToInitialMatricesMap.get(currentXObject);
                            for (Map.Entry<ASMatrix, ASRectangle> currEntry : matrixList.entrySet()) {
                                ASMatrix currMatrix = currEntry.getKey();
                                ASRectangle xObjRect = currEntry.getValue();
                                if (!RedactionXObjectWriter.rectanglesIntersect(annotRect, xObjRect)) continue;
                                RedactionXObjectWriter.applyRedactionXobjectForm((PDFAnnotationRedaction)annotation, name.concat(count.toString()), currMatrix, pdfDoc, xObjWriter, quadPointsRedactionPaths, redactionOptions, currentXObject.getResources());
                                Integer n3 = count;
                                Integer n4 = count = Integer.valueOf(count + 1);
                            }
                            currentXObject.setContents(xObjWriter.close().getContents());
                        }
                    }
                    annotationList.remove(annotation);
                    annotationListIterator.remove();
                    continue;
                }
                if (!(annotation instanceof PDFAnnotationPopup) || !((parentAnnotation = (annotationPopup = (PDFAnnotationPopup)annotation).getParent()) instanceof PDFAnnotationRedaction)) continue;
                annotationList.remove((PDFAnnotation)annotationPopup);
                annotationListIterator.remove();
            }
        }
        if (annotationList == null || annotationList.isEmpty()) {
            currentPage.setAnnotationList(null);
        }
    }

    private static boolean rectanglesIntersect(ASRectangle rect1, ASRectangle rect2) {
        Rectangle2D.Double r1 = new Rectangle2D.Double(rect1.left(), rect1.bottom(), rect1.width(), rect1.height());
        Rectangle2D.Double r2 = new Rectangle2D.Double(rect2.left(), rect2.bottom(), rect2.width(), rect2.height());
        return r1.intersects(r2);
    }

    private static ASRectangle getRedactionAnnotationRectangle(PDFAnnotationRedaction annotationRedaction, Map<Integer, Set<GeneralPath>> quadPointsRedactionPaths) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double[] quadPoints = annotationRedaction.getQuadPoints();
        PDFRectangle rectangle = null;
        rectangle = quadPoints != null && quadPoints.length > 0 && quadPoints.length % 8 == 0 ? annotationRedaction.getRedactionAreaBBox() : annotationRedaction.getRect();
        return rectangle.getRectangle();
    }

    private static void applyRedactionXobjectForm(PDFAnnotationRedaction annotationRedaction, String name, ASMatrix currCTM, PDFDocument pdfDoc, ContentWriter writer, Map<Integer, Set<GeneralPath>> quadPointsRedactionPaths, RedactionOptions redactionOptions, PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFFontException {
        PDFXObjectForm formXObject = annotationRedaction.getRO();
        PDFPage page = annotationRedaction.getPage();
        if (resources == null && (resources = page.getResources()) == null) {
            resources = PDFResources.newInstance((PDFDocument)pdfDoc);
            page.setResources(resources);
        }
        ASMatrix initialCTM = currCTM;
        writer.write(RedactionUtils.GSAVE_INSTRUCTION);
        PDFXObjectMap xObjectMap = resources.getXObjectMap();
        if (xObjectMap == null) {
            xObjectMap = PDFXObjectMap.newInstance((PDFDocument)pdfDoc);
            resources.setXObjectMap(xObjectMap);
        }
        double[] interiorColor = null;
        if (annotationRedaction.hasInteriorColor()) {
            interiorColor = annotationRedaction.getInteriorColor();
        }
        if (interiorColor == null) {
            writer.write(RedactionUtils.GRESTORE_INSTRUCTION);
            return;
        }
        double[] quadPoints = annotationRedaction.getQuadPoints();
        if (quadPoints != null && quadPoints.length > 0 && quadPoints.length % 8 == 0) {
            Set<GeneralPath> paths = quadPointsRedactionPaths.get(annotationRedaction.getCosObject().getObjNum());
            if (paths != null && !paths.isEmpty()) {
                for (GeneralPath path : paths) {
                    RedactionUtils.strokePath(writer, currCTM, path);
                }
                writer.write(RedactionUtils.CLIP_PATH_INSTRUCTION);
                writer.write(RedactionUtils.END_PATH_NO_OP_INSTRUCTION);
            }
            PDFRectangle rectangle = annotationRedaction.getRedactionAreaBBox();
            RedactionXObjectWriter.writeRedactionXObjectsToStream(annotationRedaction, name, pdfDoc, writer, redactionOptions, formXObject, initialCTM, xObjectMap, interiorColor, rectangle);
        } else {
            PDFRectangle rectangle = annotationRedaction.getRect();
            RedactionXObjectWriter.writeRedactionXObjectsToStream(annotationRedaction, name, pdfDoc, writer, redactionOptions, formXObject, initialCTM, xObjectMap, interiorColor, rectangle);
        }
        writer.write(RedactionUtils.GRESTORE_INSTRUCTION);
    }

    private static void writeRedactionXObjectsToStream(PDFAnnotationRedaction annotationRedaction, String name, PDFDocument pdfDoc, ContentWriter writer, RedactionOptions redactionOptions, PDFXObjectForm formXObject, ASMatrix initialCTM, PDFXObjectMap xObjectMap, double[] interiorColor, PDFRectangle rectangle) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        if (formXObject == null) {
            formXObject = RedactionXObjectWriter.getObjectForm(initialCTM, interiorColor, rectangle, pdfDoc);
            PDFXObjectForm textObjectForm = RedactionXObjectWriter.getObjectFormForText(annotationRedaction, rectangle, pdfDoc, redactionOptions);
            RedactionXObjectWriter.writeXobject(initialCTM, name, xObjectMap, formXObject, writer);
            if (textObjectForm != null) {
                ASName key = RedactionXObjectWriter.getNewKey(name, xObjectMap);
                xObjectMap.put(key, (PDFCosObjectContainer)textObjectForm);
                if (writer instanceof RedactionContentWriter) {
                    ((RedactionContentWriter)writer).writeInstructionDirectly(InstructionFactory.newInvokeNamedXObject((ASName)key));
                } else {
                    writer.write(InstructionFactory.newInvokeNamedXObject((ASName)key));
                }
            }
        } else {
            RedactionXObjectWriter.writeXobject(initialCTM, name, xObjectMap, formXObject, writer);
        }
    }

    private static PDFXObjectForm getObjectForm(ASMatrix initialCTM, double[] interiorColor, PDFRectangle redactionRectangle, PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        Instruction colorInstruction = InstructionFactory.newDeviceRGBFill((double)interiorColor[0], (double)interiorColor[1], (double)interiorColor[2]);
        ASRectangle rect = redactionRectangle.getRectangle();
        ContentWriter writer = ContentWriter.newInstance((PDFDocument)pdfDoc);
        writer.write(colorInstruction);
        writer.write(InstructionFactory.newConcatMatrix((double)initialCTM.geta(), (double)initialCTM.getb(), (double)initialCTM.getc(), (double)initialCTM.getd(), (double)initialCTM.getx(), (double)initialCTM.gety()));
        writer.write(InstructionFactory.newRectangle((double)rect.left(), (double)rect.bottom(), (double)rect.width(), (double)rect.height()));
        writer.write(RedactionUtils.FILL_INSTRUCTION);
        Content content = writer.close();
        PDFXObjectForm formXObject = PDFXObjectForm.newInstance((PDFDocument)pdfDoc);
        formXObject.setBBox(redactionRectangle);
        double[] matrixValues = new double[]{1.0, 0.0, 0.0, 1.0, -rect.left(), -rect.bottom()};
        formXObject.setMatrix(matrixValues);
        formXObject.setOutputFilter(ASName.k_FlateDecode);
        formXObject.setContents(content.getContents());
        return formXObject;
    }

    private static PDFXObjectForm getObjectFormForText(PDFAnnotationRedaction annotationRedaction, PDFRectangle rectangle, PDFDocument pdfDoc, RedactionOptions redactionOptions) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFFontException, PDFInvalidParameterException {
        double fontSize;
        String text = annotationRedaction.getOverlayText();
        boolean isMultiLine = false;
        int quadding = 0;
        boolean autoSize = false;
        if (annotationRedaction.hasJustification()) {
            quadding = annotationRedaction.getJustification();
        }
        PDFResources acroformResources = null;
        if (pdfDoc.getInteractiveForm() != null) {
            acroformResources = pdfDoc.getInteractiveForm().getResources();
        }
        StyleAttributes defaultStyleAttr = null;
        if (annotationRedaction.hasRepeat() && annotationRedaction.getRepeat() || (annotationRedaction.getFlags() & 0x1000) != 0) {
            isMultiLine = true;
        }
        RCGOptions options = RedactionXObjectWriter.getOptions(annotationRedaction, (fontSize = (defaultStyleAttr = AppearanceUtils.makeStyle(pdfDoc, defaultStyleAttr, annotationRedaction.getDA(), quadding, acroformResources, PDFDocument.ROOT_LOCALE)).getFontSize()) == 0.0, isMultiLine, rectangle);
        double lineheight = 0.0;
        if (fontSize == 0.0) {
            autoSize = true;
            fontSize = RedactionXObjectWriter.setFontSize(options);
        }
        lineheight = 1.2 * fontSize;
        defaultStyleAttr.setFontSize(fontSize);
        defaultStyleAttr.setLineHeight(String.valueOf(lineheight));
        if (isMultiLine) {
            text = RedactionXObjectWriter.getRepeatedString(text, rectangle, fontSize);
        }
        AppearanceAttributes appearanceAttributes = new AppearanceAttributes(defaultStyleAttr, options);
        appearanceAttributes.setAutoSize(autoSize);
        appearanceAttributes.setRichText(false);
        appearanceAttributes.setMultiLine(isMultiLine);
        double[] paddingArray = new double[]{options.getPaddingLeft(), options.getPaddingBottom(), options.getPaddingRight(), options.getPaddingTop()};
        appearanceAttributes.setClipPadding(paddingArray);
        ArrayList<String> simpleStrings = new ArrayList<String>();
        simpleStrings.add(text);
        if (text == null || text.isEmpty()) {
            return null;
        }
        String xmlText = RichTextHandler.convertString2RichText(simpleStrings);
        appearanceAttributes.getStyleAttributes().setLineHeightPrecedenceOverride("use-font-size");
        try {
            PDFFontSet fontSetImpl = redactionOptions.getFontSet();
            if (fontSetImpl == null && (fontSetImpl = pdfDoc.getCosDocument().getOptions().getFontSet()) == null) {
                fontSetImpl = new PDFFontSetImpl();
            }
            appearanceAttributes.setTextValue(xmlText);
            return TextAppearance.buildTextAppearance(pdfDoc, fontSetImpl, (PDFAnnotation)annotationRedaction, null, new HashMap(), appearanceAttributes, new TextFormatterImpl(pdfDoc));
        }
        catch (PDFConfigurationException e) {
            throw new PDFInvalidParameterException("Parser Configuration Exception ", (Throwable)e);
        }
    }

    private static double setFontSize(RCGOptions options) {
        double lineHeight = 0.0;
        double fontSize = 0.0;
        double bboxHeight = options.getTargetRegion().getHeight();
        double topPadding = options.getPaddingTop();
        double bottomPadding = options.getPaddingBottom();
        if (bboxHeight == 0.0) {
            options.setOverflow(RCGOverflowMode.Auto);
            return 0.1;
        }
        lineHeight = bottomPadding == 0.0 && topPadding == 0.0 ? (bboxHeight > 2.0 ? bboxHeight - 2.0 : bboxHeight) : (lineHeight > bottomPadding + topPadding ? bboxHeight - bottomPadding - topPadding : bboxHeight);
        fontSize = lineHeight / 1.2;
        fontSize = Math.min(fontSize, DefaultFont.getDefaultSize(PDFDocument.ROOT_LOCALE));
        return fontSize;
    }

    private static RCGOptions getOptions(PDFAnnotationRedaction annot, boolean autoSize, boolean isMultiLine, PDFRectangle annotRect) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle targetRect = null;
        boolean isRichTextValue = false;
        targetRect = PDFRectangle.newInstance((PDFDocument)annot.getPDFDocument(), (double)0.0, (double)0.0, (double)annotRect.width(), (double)annotRect.height());
        RCGOptions options = new RCGOptions(targetRect.width(), targetRect.height());
        double borderWidth = AppearanceUtils.getBorderWidth((PDFAnnotation)annot);
        options.setVerticalAlignment(RCGAlignment.Top);
        options.setWrap(RCGWrapOption.SoftWrap);
        if (autoSize && !isMultiLine && !isRichTextValue) {
            options.setOverflow(RCGOverflowMode.ShrinkToFit);
        } else {
            options.setOverflow(RCGOverflowMode.Auto);
        }
        double paddingLeft = borderWidth * 2.0;
        double paddingRight = borderWidth * 2.0;
        double paddingTop = borderWidth;
        double paddingBottom = borderWidth;
        if (isMultiLine) {
            paddingTop *= 2.0;
            if (autoSize && !isRichTextValue) {
                paddingBottom *= 2.0;
            }
        }
        try {
            if (targetRect.width() - paddingLeft - paddingRight > 0.0) {
                options.setPaddingLeft(paddingLeft);
                options.setPaddingRight(paddingRight);
            } else {
                options.setPaddingLeft(0.0);
                options.setPaddingRight(0.0);
            }
            if (targetRect.height() - paddingTop - paddingBottom > 0.0) {
                options.setPaddingTop(paddingTop);
                options.setPaddingBottom(paddingBottom);
            } else {
                options.setPaddingTop(0.0);
                options.setPaddingBottom(0.0);
            }
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Cannot set RCGOptions.", (Throwable)e);
        }
        return options;
    }

    private static String getRepeatedString(String input, PDFRectangle rectangle, double currentFontSize) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        int length = (int)(rectangle.width() * rectangle.height() / (currentFontSize * currentFontSize * (double)input.length()));
        length *= 2;
        StringBuilder stringBuilder = new StringBuilder(input);
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(input);
        }
        return stringBuilder.toString();
    }

    private static ASName getNewKey(String name, PDFXObjectMap xObjectMap) {
        ASName key = ASName.create((String)name);
        while (xObjectMap.containsKey((Object)key)) {
            name = name.concat("1");
            key = ASName.create((String)name);
        }
        return key;
    }

    private static void writeXobject(ASMatrix initialCTM, String name, PDFXObjectMap xObjectMap, PDFXObjectForm formXObject, ContentWriter writer) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASMatrix transformMatrix = initialCTM.concat(new ASMatrix(formXObject.getMatrix()));
        transformMatrix = transformMatrix.getInverse();
        ASName key = RedactionXObjectWriter.getNewKey(name, xObjectMap);
        xObjectMap.put(key, (PDFCosObjectContainer)formXObject);
        writer.write(InstructionFactory.newConcatMatrix((double)transformMatrix.geta(), (double)transformMatrix.getb(), (double)transformMatrix.getc(), (double)transformMatrix.getd(), (double)transformMatrix.getx(), (double)transformMatrix.gety()));
        if (writer instanceof RedactionContentWriter) {
            ((RedactionContentWriter)writer).writeInstructionDirectly(InstructionFactory.newInvokeNamedXObject((ASName)key));
        } else {
            writer.write(InstructionFactory.newInvokeNamedXObject((ASName)key));
        }
    }
}

