/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.processor.TextState;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionHandler;
import com.adobe.internal.pdftoolkit.services.redaction.impl.GStateHolder;
import com.adobe.internal.pdftoolkit.services.redaction.impl.OCRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionUtils;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ResourcesState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.TextStateHolder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Stack;

class RedactionContentWriter
extends ContentWriter {
    static Set<ASName> graphicStateOperators = new HashSet<ASName>();
    static Set<ASName> colorOperators = new HashSet<ASName>();
    ResourcesState sourceResourceState;
    ResourcesState pageResourcesState;
    RedactionState redactionState;
    RedactionHandler redactionHandler;
    OCRedactor ocRedactor;
    private Stack<GStateHolder> graphicState = new Stack();
    private Stack<TextStateHolder> tStateStack = new Stack();
    private GStateHolder currentGStateHolder;
    public TextStateHolder currentTStateHolder;
    private Instruction pendingBTInstruction;
    private Instruction pendingBXInstruction;
    private List<Instruction> markedContentStartInstructionsList = new LinkedList<Instruction>();
    private List<Instruction> inlineImageInstructionsList = new ArrayList<Instruction>();
    private Stack<Instruction> pendingqInstruction = new Stack();
    private int pageNumber;

    static boolean operatorRequireMC(ASName operator) {
        return operator == ASName.k_m || operator == ASName.k_Do || operator == ASName.k_BT || operator == ASName.k_MP || operator == ASName.k_DP || operator == ASName.k_BI || operator == ASName.k_Tj || operator == ASName.k_TJ;
    }

    static boolean operatorRequireGState(ASName operator) {
        return operator == ASName.k_m || operator == ASName.k_Do || operator == ASName.k_re || operator == ASName.k_BI || operator == ASName.k_sh || operator == ASName.k_Tm || operator == ASName.k_Tj || operator == ASName.k_TJ;
    }

    static boolean isTextStateOperator(ASName operator) {
        return operator == ASName.k_Tm || operator == ASName.k_Tc || operator == ASName.k_Tw || operator == ASName.k_Tz || operator == ASName.k_TL || operator == ASName.k_Tr || operator == ASName.k_Ts || operator == ASName.k_Tf;
    }

    private RedactionContentWriter(ModifiableContent content, ResourcesState sourceResourcesState, ResourcesState pageResourcesState, RedactionState redactionState, int pageNumber, OCRedactor ocRedactor) throws PDFIOException {
        super(content);
        this.currentGStateHolder = new GStateHolder();
        this.currentTStateHolder = new TextStateHolder(pageNumber);
        this.sourceResourceState = sourceResourcesState;
        this.pageResourcesState = pageResourcesState;
        this.redactionState = redactionState;
        this.pageNumber = pageNumber;
        this.ocRedactor = ocRedactor;
    }

    public static RedactionContentWriter newInstance(PDFDocument pdfDocument, ResourcesState sourceResourcesState, ResourcesState pageResourcesState, RedactionState redactionState, int pageNumber, OCRedactor ocRedactor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return new RedactionContentWriter(ModifiableContent.newInstance((PDFDocument)pdfDocument), sourceResourcesState, pageResourcesState, redactionState, pageNumber, ocRedactor);
    }

    void handleBTInstruction(Instruction instruction) throws PDFIOException {
        this.pendingBTInstruction = instruction;
    }

    void handleBXInstruction(Instruction instruction) throws PDFIOException {
        this.pendingBXInstruction = instruction;
    }

    void handleETInstruction(Instruction instruction) throws PDFIOException {
        if (this.pendingBTInstruction == null) {
            this.writeInstructionDirectly(instruction);
        }
    }

    void handleEXInstruction(Instruction instruction) throws PDFIOException {
        if (this.pendingBXInstruction == null) {
            this.writeInstructionDirectly(instruction);
        }
    }

    void handleBMCBDCInstruction(Instruction instruction) {
        this.markedContentStartInstructionsList.add(instruction);
    }

    void handleEMCInstruction(Instruction instruction) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        int size = this.markedContentStartInstructionsList.size();
        if (size == 0) {
            this.writeInstructionDirectly(instruction);
        } else {
            this.markedContentStartInstructionsList.remove(size - 1);
        }
    }

    void handleGStateInstruction(Instruction instruction) throws PDFIOException {
        this.currentGStateHolder.updateGState(instruction);
    }

    void handleTStateInstruction(Instruction instruction) throws PDFIOException {
        this.currentTStateHolder.updateTState(instruction);
    }

    void writeGSaveInstruction(Instruction instruction) throws PDFIOException {
        this.graphicState.push(this.currentGStateHolder.clone());
        this.tStateStack.push(this.currentTStateHolder.clone());
        this.pendingqInstruction.push(instruction);
    }

    void writeGRestoreInstruction(Instruction instruction) throws PDFIOException {
        this.currentGStateHolder = this.graphicState.pop();
        this.currentTStateHolder = this.tStateStack.pop();
        if (this.pendingqInstruction.isEmpty()) {
            super.write(instruction);
        } else {
            this.pendingqInstruction.pop();
        }
    }

    long getPosition() throws PDFIOException {
        try {
            return this.contentStream.getPosition();
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    void writeInstructionDirectly(Instruction instruction) throws PDFIOException {
        while (!this.pendingqInstruction.isEmpty()) {
            super.write(this.pendingqInstruction.pop());
        }
        super.write(instruction);
    }

    public void write(Instruction instruction) throws PDFIOException {
        ASName operator = instruction.getOperator();
        if (this.pendingBXInstruction != null) {
            this.writeInstructionDirectly(this.pendingBXInstruction);
            this.pendingBXInstruction = null;
        }
        if (RedactionContentWriter.operatorRequireMC(operator)) {
            while (!this.markedContentStartInstructionsList.isEmpty()) {
                Instruction mcInstruction = this.markedContentStartInstructionsList.remove(0);
                try {
                    if (mcInstruction.getOperator() == ASName.k_BDC) {
                        RedactionUtils.handleBDCDPInstruction(this.sourceResourceState, this.redactionState, mcInstruction, this.pageNumber, this.ocRedactor);
                    }
                }
                catch (PDFInvalidDocumentException e) {
                    throw new PDFIOException((Throwable)e);
                }
                catch (PDFSecurityException e) {
                    throw new PDFIOException((Throwable)e);
                }
                this.writeInstructionDirectly(mcInstruction);
            }
        }
        if (RedactionContentWriter.operatorRequireGState(operator)) {
            this.currentGStateHolder.writeGState(this);
        }
        if (operator == ASName.k_Tj || operator == ASName.k_TJ) {
            if (this.pendingBTInstruction != null) {
                this.writeInstructionDirectly(this.pendingBTInstruction);
                this.pendingBTInstruction = null;
            }
            try {
                this.currentTStateHolder.writeTState(this, this.redactionHandler);
            }
            catch (PDFInvalidContentException e) {
                throw new PDFIOException((Throwable)e);
            }
            catch (PDFInvalidDocumentException e) {
                throw new PDFIOException((Throwable)e);
            }
            catch (PDFSecurityException e) {
                throw new PDFIOException((Throwable)e);
            }
            catch (PDFFontException e) {
                throw new PDFIOException((Throwable)e);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
        this.writeInstructionDirectly(instruction);
    }

    TextState getCurrentTextState(PDFResources resources, PDFResources pageResources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        TextState textState = new TextState();
        Instruction instruction = this.currentTStateHolder.tState.get(ASName.k_Tf);
        OperandStack opStack = instruction.getOperands();
        double fontSize = opStack.popNumber().doubleValue();
        ASName fontName = opStack.popName();
        opStack.pushName(fontName);
        opStack.pushASNumber(new ASNumber(fontSize));
        textState.setFontName(fontName);
        textState.setFontSize(fontSize);
        PDFFont font = null;
        PDFFontMap fontMap = null;
        if (resources != null) {
            fontMap = resources.getFontMap();
        } else if (pageResources != null) {
            fontMap = pageResources.getFontMap();
        }
        if (fontMap != null) {
            font = fontMap.get(fontName);
        }
        if (font == null) {
            throw new PDFInvalidDocumentException("Font with key " + fontName + "not found both in current resource and page resource");
        }
        textState.setFont(font);
        instruction = this.currentTStateHolder.tState.get(ASName.k_Tc);
        if (instruction != null) {
            textState.setCharSpacing(instruction.getOperands().peekNumber().doubleValue());
        }
        if ((instruction = this.currentTStateHolder.tState.get(ASName.k_Tw)) != null) {
            textState.setWordSpacing(instruction.getOperands().peekNumber().doubleValue());
        }
        if ((instruction = this.currentTStateHolder.tState.get(ASName.k_TL)) != null) {
            textState.setLeading(instruction.getOperands().peekNumber().doubleValue());
        }
        if ((instruction = this.currentTStateHolder.tState.get(ASName.k_Tz)) != null) {
            textState.setHorizScaling(instruction.getOperands().peekNumber().doubleValue());
        }
        if ((instruction = this.currentTStateHolder.tState.get(ASName.k_Ts)) != null) {
            textState.setRise(instruction.getOperands().peekNumber().doubleValue());
        }
        if ((instruction = this.currentTStateHolder.tState.get(ASName.k_Tr)) != null) {
            textState.setRenderingMode(instruction.getOperands().peekNumber().intValue());
        }
        return textState;
    }

    void handleInlineImageInstruction(Instruction instruction, int choice) throws PDFIOException {
        switch (choice) {
            case 0: {
                this.inlineImageInstructionsList.clear();
                this.inlineImageInstructionsList.add(instruction);
                break;
            }
            case 1: {
                this.inlineImageInstructionsList.add(instruction);
                break;
            }
            case 2: {
                int size = this.inlineImageInstructionsList.size();
                if (size != 2) break;
                this.write(this.inlineImageInstructionsList.get(0));
                this.write(this.inlineImageInstructionsList.get(1));
                this.write(instruction);
                break;
            }
        }
    }

    static {
        graphicStateOperators.add(ASName.k_w);
        graphicStateOperators.add(ASName.k_j);
        graphicStateOperators.add(ASName.k_J);
        graphicStateOperators.add(ASName.k_i);
        graphicStateOperators.add(ASName.k_M);
        graphicStateOperators.add(ASName.k_d);
        graphicStateOperators.add(ASName.k_ri);
        graphicStateOperators.add(ASName.k_gs);
        colorOperators.add(ASName.k_rg);
        colorOperators.add(ASName.k_RG);
        colorOperators.add(ASName.k_CS);
        colorOperators.add(ASName.k_cs);
        colorOperators.add(ASName.k_SC);
        colorOperators.add(ASName.k_SCN);
        colorOperators.add(ASName.k_sc);
        colorOperators.add(ASName.k_scn);
        colorOperators.add(ASName.k_G);
        colorOperators.add(ASName.k_g);
        colorOperators.add(ASName.k_K);
        colorOperators.add(ASName.k_k);
        graphicStateOperators.addAll(colorOperators);
    }
}

