/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidContentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnsupportedFeatureException;
import com.adobe.internal.pdftoolkit.core.types.ASArray;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.content.OperandStack;
import com.adobe.internal.pdftoolkit.pdf.content.StatefulOperatorHandler;
import com.adobe.internal.pdftoolkit.pdf.content.XObjectsCycleDetector;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentModifier;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObjectContainer;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFDashPattern;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineCap;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFLineJoin;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFColorSpaceMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.colorspaces.PDFRenderingIntent;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImage;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectImageMask;
import com.adobe.internal.pdftoolkit.pdf.inlineimage.InlineImage;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionHandler;
import com.adobe.internal.pdftoolkit.services.redaction.RedactionOptions;
import com.adobe.internal.pdftoolkit.services.redaction.handler.RedactedResourceXObjectInfo;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ClipPathState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ContentStreamRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ContentStreamState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ImageRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.OCRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionAdditionalInfo;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionContentWriter;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.RedactionUtils;
import com.adobe.internal.pdftoolkit.services.redaction.impl.ResourcesState;
import com.adobe.internal.pdftoolkit.services.redaction.impl.TextRedactor;
import com.adobe.internal.pdftoolkit.services.redaction.impl.XObjectsNumberWrapper;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class RedactionContentStreamHandler
extends StatefulOperatorHandler {
    private static final String NEW_XOBJECT_NAME = "FmXObj";
    private static final String NEW_IMAGE_XOBJECT_NAME = "ImXObj";
    private PDFDocument pdfDocument;
    private Area redactionArea;
    private OCRedactor ocRedactor;
    private ResourcesState pageResourcesState;
    private RedactionOptions redactionOptions;
    private XObjectsCycleDetector cycleDetector;
    private RedactionHandler redactionHandler;
    private RedactionState redactionState;
    private int pageNumber;
    private XObjectsNumberWrapper xObjectsNumberWrapper;
    private Content content;
    private RedactionContentWriter writer;
    private ASMatrix currCTM;
    private ResourcesState currentResourceState;
    private Map<PDFXObjectForm, Map<ASMatrix, ASRectangle>> xObjsToInitialMatricesMap;
    private GeneralPath completePath;
    private ClipPathState clipPathState;
    private Stack<ContentStreamState> state;
    private ASMatrix currTextMatrix;
    private ASMatrix currLineMatrix;
    private TextRedactor textRedactor;
    private ImageRedactor imageRedactor;
    private boolean pathInitialised;
    private Point2D.Double tempPoint1 = new Point2D.Double();
    private Point2D.Double tempPoint2 = new Point2D.Double();
    private Point2D.Double tempPoint3 = new Point2D.Double();

    public RedactionContentStreamHandler(PDFDocument pdfDocument, Area redactionArea, ResourcesState pageResourcesState, RedactionOptions redactionOptions, RedactionHandler redactionHandler, RedactionState redactionState, int pageNumber, OCRedactor ocRedactor, Content content, RedactionContentWriter writer, ASMatrix currCTM, ResourcesState currentResourceState, RedactionAdditionalInfo additionalInfo, Map<PDFXObjectForm, Map<ASMatrix, ASRectangle>> xObjsToInitialMatricesMap, XObjectsNumberWrapper xObjectsNumberWrapper) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pdfDocument = pdfDocument;
        this.redactionArea = redactionArea;
        this.pageResourcesState = pageResourcesState;
        this.redactionOptions = redactionOptions;
        this.cycleDetector = XObjectsCycleDetector.getInstance((PDFDocument)pdfDocument);
        this.redactionHandler = redactionHandler;
        this.redactionState = redactionState;
        this.pageNumber = pageNumber;
        this.ocRedactor = ocRedactor;
        this.content = content;
        this.writer = writer;
        this.currCTM = currCTM;
        this.currentResourceState = currentResourceState;
        this.xObjsToInitialMatricesMap = xObjsToInitialMatricesMap;
        this.completePath = new GeneralPath();
        this.pathInitialised = false;
        this.clipPathState = new ClipPathState();
        this.state = new Stack();
        this.currLineMatrix = this.currTextMatrix = ASMatrix.createIdentityMatrix();
        this.textRedactor = new TextRedactor(redactionArea, pageResourcesState, writer, additionalInfo);
        this.imageRedactor = new ImageRedactor(pdfDocument, redactionHandler);
        this.xObjectsNumberWrapper = xObjectsNumberWrapper;
    }

    public void m(double x, double y, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.handleMInstr(this.currCTM, this.completePath, (float)y, (float)x);
    }

    public void l(double x, double y, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.handleLInstr(this.currCTM, this.completePath, (float)y, (float)x);
    }

    public void c(double x1, double y1, double x2, double y2, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.handleCurveInstruction(this.currCTM, this.completePath, (float)y3, (float)x3, (float)y2, (float)x2, (float)y1, (float)x1, true);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void v(double x2, double y2, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Point2D currentPoint = this.completePath.getCurrentPoint();
        try {
            this.handleCurveInstruction(this.currCTM, this.completePath, (float)y3, (float)x3, (float)y2, (float)x2, (float)currentPoint.getY(), (float)currentPoint.getX(), false);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void y(double x1, double y1, double x3, double y3, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.handleCurveInstruction(this.currCTM, this.completePath, (float)y3, (float)x3, (float)y3, (float)x3, (float)y1, (float)x1, true);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void re(double x, double y, double width, double height, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.handleMInstr(this.currCTM, this.completePath, (float)y, (float)x);
        this.handleLInstr(this.currCTM, this.completePath, (float)y, (float)x + (float)width);
        this.handleLInstr(this.currCTM, this.completePath, (float)y + (float)height, (float)x + (float)width);
        this.handleLInstr(this.currCTM, this.completePath, (float)y + (float)height, (float)x);
        this.completePath.closePath();
    }

    public void h(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pathInitialised) {
            this.completePath.closePath();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void S(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        block5: {
            try {
                if (this.clipPathState.clipPathRedacted) break block5;
                try {
                    this.handleSInstr(this.writer, this.currCTM, this.completePath, this.clipPathState);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            finally {
                this.clipPathState.resetClipPathState();
                this.resetPath();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void s(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        block5: {
            try {
                if (this.clipPathState.clipPathRedacted) break block5;
                this.completePath.closePath();
                try {
                    this.handleSInstr(this.writer, this.currCTM, this.completePath, this.clipPathState);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            finally {
                this.clipPathState.resetClipPathState();
                this.resetPath();
            }
        }
    }

    public void F(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.handleFillInstruction(instruction);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void f(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.handleFillInstruction(instruction);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void fStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.handleFillInstruction(instruction);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void b(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.bStar(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        block5: {
            try {
                if (this.clipPathState.clipPathRedacted) break block5;
                this.completePath.closePath();
                try {
                    this.handleBInstr(this.writer, this.currCTM, this.completePath, this.clipPathState);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            finally {
                this.clipPathState.resetClipPathState();
                this.resetPath();
            }
        }
    }

    public void B(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.BStar(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void BStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        block5: {
            try {
                if (this.clipPathState.clipPathRedacted) break block5;
                try {
                    this.handleBInstr(this.writer, this.currCTM, this.completePath, this.clipPathState);
                }
                catch (PDFInvalidParameterException e) {
                    throw new PDFInvalidDocumentException((Throwable)e);
                }
            }
            finally {
                this.clipPathState.resetClipPathState();
                this.resetPath();
            }
        }
    }

    public void cm(double a, double b, double c, double d, double e, double f, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
        ASMatrix matrix = ContentModifier.getMatrixFromOperands((OperandStack)instruction.getOperands());
        this.currCTM = matrix.concat(this.currCTM);
    }

    public void q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.pushGState();
        if (this.currCTM == null) {
            throw new IllegalStateException("Current CTM can not be null");
        }
        this.handleqInstr(this.writer, this.currCTM, this.clipPathState, this.state, this.currTextMatrix, instruction);
    }

    public void Q(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.popGState();
        if (this.state.isEmpty()) {
            throw new IllegalStateException("State Stack should not be empty when Q(Restore) instruction is called");
        }
        ContentStreamState streamState = this.state.pop();
        this.currCTM = streamState.currCTM;
        this.currTextMatrix = streamState.currTM;
        this.clipPathState.clipPathRedacted = streamState.clipPathRedacted;
        this.writer.writeGRestoreInstruction(instruction);
    }

    public void BT(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currLineMatrix = this.currTextMatrix = ASMatrix.createIdentityMatrix();
        this.writer.handleBTInstruction(instruction);
    }

    public void BX(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleBXInstruction(instruction);
    }

    public void EX(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleEXInstruction(instruction);
    }

    public void ET(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleETInstruction(instruction);
    }

    public void Td(double tx, double ty, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currLineMatrix = this.currTextMatrix = this.textRedactor.handleTd(this.currTextMatrix, this.currLineMatrix, tx, ty);
    }

    public void TD(double tx, double ty, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleTStateInstruction(InstructionFactory.newTextLeading((double)(-ty)));
        this.currLineMatrix = this.currTextMatrix = this.textRedactor.handleTd(this.currTextMatrix, this.currLineMatrix, tx, ty);
    }

    public void TStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currLineMatrix = this.currTextMatrix = this.textRedactor.handleTStar(this.currTextMatrix, this.currLineMatrix);
    }

    public void SingleQuote(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currLineMatrix = this.currTextMatrix = this.textRedactor.handleTStar(this.currTextMatrix, this.currLineMatrix);
        Instruction tjInstruction = InstructionFactory.newShowText((byte[])string.getBytes());
        try {
            this.currTextMatrix = this.textRedactor.handleTj(this.currCTM, this.currTextMatrix, this.currentResourceState, tjInstruction);
        }
        catch (PDFFontException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void DoubleQuote(double tw, double tc, ASString charCodeString, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleTStateInstruction(InstructionFactory.newWordSpacing((double)tw));
        this.writer.handleTStateInstruction(InstructionFactory.newCharactorSpacing((double)tc));
        this.currLineMatrix = this.currTextMatrix = this.textRedactor.handleTStar(this.currTextMatrix, this.currLineMatrix);
        Instruction tjInstruction = InstructionFactory.newShowText((byte[])charCodeString.getBytes());
        try {
            this.currTextMatrix = this.textRedactor.handleTj(this.currCTM, this.currTextMatrix, this.currentResourceState, tjInstruction);
        }
        catch (PDFFontException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void Tm(double a, double b, double c, double d, double e, double f, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.currLineMatrix = this.currTextMatrix = new ASMatrix(a, b, c, d, e, f);
        this.writer.handleTStateInstruction(instruction);
    }

    public void Tc(double charSpacing, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleTStateInstruction(instruction);
    }

    public void Tw(double wordSpacing, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleTStateInstruction(instruction);
    }

    public void Tz(double scaling, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleTStateInstruction(instruction);
    }

    public void TL(double leading, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleTStateInstruction(instruction);
    }

    public void Tr(int renderMode, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleTStateInstruction(instruction);
    }

    public void Ts(double textRise, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleTStateInstruction(instruction);
    }

    public void Tf(ASName fontName, double fontSize, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleTStateInstruction(instruction);
    }

    public void Tj(ASString string, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.currTextMatrix = this.textRedactor.handleTj(this.currCTM, this.currTextMatrix, this.currentResourceState, instruction);
        }
        catch (PDFFontException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void TJ(ASArray tjArray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            this.currTextMatrix = this.textRedactor.handleTJ(this.currCTM, this.currTextMatrix, this.currentResourceState, instruction);
        }
        catch (PDFFontException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    public void W(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.clipPathState.WOccured = true;
    }

    public void WStar(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.clipPathState.WStarOccured = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void n(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            boolean handled = this.handlePathPaintingInstructionNormally(instruction, this.completePath, this.clipPathState, this.redactionArea, this.writer, this.currCTM);
            if (!handled && this.clipPathState.isClipPathDefined()) {
                boolean updated = RedactionUtils.writeRedactedPathArea(this.writer, this.currCTM, this.redactionArea, this.completePath);
                if (updated) {
                    this.writeClipPathInstr(this.writer, this.clipPathState);
                    this.writer.write(RedactionUtils.END_PATH_NO_OP_INSTRUCTION);
                } else {
                    this.clipPathState.clipPathRedacted = true;
                }
            }
        }
        finally {
            this.clipPathState.resetClipPathState();
            this.resetPath();
        }
    }

    public void sh(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.clipPathState.clipPathRedacted) {
            this.writer.write(instruction);
            ResourcesState sourceResourcesState = this.currentResourceState == null ? this.pageResourcesState : this.currentResourceState;
            OperandStack operands = instruction.getOperands();
            ASName sname = ContentModifier.getObjectName((OperandStack)operands);
            sourceResourcesState.removeShading(sname);
        }
    }

    public void Do(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.clipPathState.clipPathRedacted) {
            try {
                this.handleXObjectRedaction(this.writer, this.currCTM, this.currentResourceState, instruction, this.imageRedactor, this.xObjsToInitialMatricesMap);
            }
            catch (PDFInvalidParameterException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
            catch (PDFFontException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
        }
    }

    public void EMC(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleEMCInstruction(instruction);
    }

    public void BDC(ASName tag, ASDictionary properties, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleBMCBDCInstruction(instruction);
    }

    public void BMC(ASName tag, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleBMCBDCInstruction(instruction);
    }

    public void MP(ASName tag, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.handleMPDPInstruction(tag, instruction);
    }

    public void DP(ASName tag, ASDictionary properties, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.handleMPDPInstruction(tag, instruction);
    }

    public void DP(ASName tag, ASName properties, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.handleMPDPInstruction(tag, instruction);
    }

    public void BI(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.clipPathState.clipPathRedacted) {
            this.writer.handleInlineImageInstruction(instruction, 0);
        }
    }

    public void ID(ASDictionary imageParams, InputByteStream imageData, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (!this.clipPathState.clipPathRedacted) {
            this.handleInlineImage(this.writer, instruction, this.content, this.currCTM, this.currentResourceState, this.imageRedactor);
        }
    }

    public void EI(Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.clipPathState.clipPathRedacted) {
            this.writer.handleInlineImageInstruction(instruction, 2);
        }
    }

    private void handleMInstr(ASMatrix currCTM, GeneralPath completePath, float y, float x) {
        RedactionUtils.getTransformedCoordinates(currCTM, this.tempPoint1, x, y);
        completePath.moveTo((float)this.tempPoint1.x, (float)this.tempPoint1.y);
        this.pathInitialised = true;
    }

    private void handleLInstr(ASMatrix currCTM, GeneralPath completePath, float y, float x) {
        RedactionUtils.getTransformedCoordinates(currCTM, this.tempPoint1, x, y);
        if (this.pathInitialised) {
            completePath.lineTo((float)this.tempPoint1.x, (float)this.tempPoint1.y);
        }
    }

    private void handleSInstr(RedactionContentWriter writer, ASMatrix currCTM, GeneralPath completePath, ClipPathState clipPathState) throws PDFInvalidParameterException, PDFIOException, PDFInvalidContentException {
        boolean handled = this.handlePathPaintingInstructionNormally(RedactionUtils.STROKE_INSTRUCTION, completePath, clipPathState, this.redactionArea, writer, currCTM);
        if (!handled) {
            this.handleClipPath(writer, currCTM, completePath, clipPathState);
            long currentPosition = writer.getPosition();
            RedactionUtils.strokePath(writer, currCTM, this.redactionArea, completePath);
            if (writer.getPosition() > currentPosition) {
                writer.write(RedactionUtils.STROKE_INSTRUCTION);
            }
        }
    }

    private boolean handlePathPaintingInstructionNormally(Instruction instruction, GeneralPath path, ClipPathState clipPathState, Area redactionArea, ContentWriter writer, ASMatrix ctm) throws PDFInvalidParameterException, PDFIOException {
        Rectangle2D pathBounds = path.getBounds2D();
        if (pathBounds.isEmpty()) {
            return false;
        }
        if (redactionArea.contains(pathBounds)) {
            if (clipPathState.isClipPathDefined()) {
                clipPathState.clipPathRedacted = true;
            }
            return true;
        }
        if (!redactionArea.intersects(pathBounds)) {
            boolean updated = RedactionUtils.writePath(writer, ctm, path.getPathIterator(null));
            if (updated) {
                if (clipPathState.isClipPathDefined()) {
                    this.writeClipPathInstr(writer, clipPathState);
                }
                writer.write(instruction);
            }
            return true;
        }
        return false;
    }

    private void writeClipPathInstr(ContentWriter writer, ClipPathState clipPathState) throws PDFIOException {
        if (clipPathState.WOccured) {
            writer.write(RedactionUtils.CLIP_PATH_INSTRUCTION);
        } else {
            writer.write(RedactionUtils.CLIP_PATH_STAR_INSTRUCTION);
        }
    }

    private void handleClipPath(ContentWriter writer, ASMatrix currCTM, GeneralPath completePath, ClipPathState clipPathState) throws PDFIOException, PDFInvalidParameterException {
        if (clipPathState.isClipPathDefined()) {
            boolean updated = RedactionUtils.writeRedactedPathArea(writer, currCTM, this.redactionArea, completePath);
            if (updated) {
                this.writeClipPathInstr(writer, clipPathState);
            } else {
                clipPathState.clipPathRedacted = true;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleFillInstruction(Instruction instruction) throws PDFInvalidParameterException, PDFIOException {
        try {
            boolean updated;
            boolean handled;
            if (!this.clipPathState.clipPathRedacted && !(handled = this.handlePathPaintingInstructionNormally(instruction, this.completePath, this.clipPathState, this.redactionArea, this.writer, this.currCTM)) && (updated = RedactionUtils.writeRedactedPathArea(this.writer, this.currCTM, this.redactionArea, this.completePath))) {
                if (this.clipPathState.isClipPathDefined()) {
                    this.writeClipPathInstr(this.writer, this.clipPathState);
                }
                this.writer.write(instruction);
            }
        }
        finally {
            this.clipPathState.resetClipPathState();
            this.resetPath();
        }
    }

    private void resetPath() {
        this.completePath.reset();
        this.pathInitialised = false;
    }

    private void handleqInstr(RedactionContentWriter writer, ASMatrix currCTM, ClipPathState clipPathState, Stack<ContentStreamState> state, ASMatrix currTextMatrix, Instruction instruction) throws PDFIOException {
        ContentStreamState streamState = new ContentStreamState();
        streamState.currCTM = currCTM;
        streamState.currTM = currTextMatrix;
        streamState.clipPathRedacted = clipPathState.clipPathRedacted;
        state.push(streamState);
        writer.writeGSaveInstruction(instruction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleXObjectRedaction(ContentWriter writer, ASMatrix currCTM, ResourcesState currentResourceState, Instruction instruction, ImageRedactor imageRedactor, Map<PDFXObjectForm, Map<ASMatrix, ASRectangle>> xObjsToInitialMatricesMap) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidContentException, PDFInvalidParameterException, PDFFontException {
        OperandStack operands = instruction.getOperands();
        ASName name = ContentModifier.getObjectName((OperandStack)operands);
        ResourcesState sourceResourcesState = currentResourceState == null ? this.pageResourcesState : currentResourceState;
        PDFXObject originalXObject = sourceResourcesState.getResources().getXObject(name);
        if (originalXObject instanceof PDFXObjectForm) {
            Rectangle2D.Double xObjectRectangle;
            PDFXObjectForm originalFormXObject = (PDFXObjectForm)originalXObject;
            ASMatrix initialMatrix = currCTM;
            double[] matrix = originalFormXObject.getMatrix();
            if (matrix != null) {
                initialMatrix = currCTM.concat(new ASMatrix(matrix));
            }
            if (!this.redactionArea.contains(xObjectRectangle = this.getXObjectRectangle(originalFormXObject, initialMatrix))) {
                if (this.redactionArea.intersects(xObjectRectangle)) {
                    this.redactionHandler.objectRedacted(new RedactedResourceXObjectInfo(originalFormXObject.getSubtype(), this.pageNumber, false, originalFormXObject.getCosObject().getObjNum()));
                    PDFResources clonedXObjResources = null;
                    ResourcesState resourceStateForCurrentXObject = null;
                    if (originalFormXObject.getResources() != null) {
                        clonedXObjResources = RedactionUtils.cloneResources(originalFormXObject.getResources());
                        resourceStateForCurrentXObject = new ResourcesState(clonedXObjResources, this.redactionHandler, this.pageNumber);
                    }
                    PDFXObjectForm xObjToBeModified = originalFormXObject;
                    if (!this.redactionOptions.isRedactAllOccurencesOfFormXObject()) {
                        xObjToBeModified = PDFXObjectForm.getInstance((CosObject)RedactionUtils.createClonedStream(originalFormXObject.getCosStream(), this.pdfDocument));
                        this.updateInstructionWithClonedXObject(sourceResourcesState, instruction, (PDFXObject)xObjToBeModified);
                    } else {
                        sourceResourcesState.removeXObj(name);
                    }
                    xObjToBeModified.setResources(clonedXObjResources);
                    RedactionContentWriter xFormWriter = RedactionContentWriter.newInstance(this.pdfDocument, resourceStateForCurrentXObject != null ? resourceStateForCurrentXObject : this.pageResourcesState, this.pageResourcesState, this.redactionState, this.pageNumber, this.ocRedactor);
                    if (this.cycleDetector.cycleDetected((PDFXObject)originalFormXObject)) {
                        throw new PDFInvalidDocumentException("Cyclic dependency found while processing xobjects.");
                    }
                    this.cycleDetector.push((PDFXObject)originalFormXObject);
                    RedactionAdditionalInfo additionalInfoForXObjStream = new RedactionAdditionalInfo();
                    try {
                        ContentStreamRedactor contentStreamRedactor = new ContentStreamRedactor(this.pdfDocument, this.redactionArea, this.pageResourcesState, this.redactionOptions, this.redactionHandler, this.redactionState, this.pageNumber, this.ocRedactor);
                        contentStreamRedactor.redactContentStream(Content.newInstance((PDFXObjectForm)originalFormXObject), xFormWriter, initialMatrix, resourceStateForCurrentXObject, additionalInfoForXObjStream, xObjsToInitialMatricesMap, this.xObjectsNumberWrapper);
                    }
                    finally {
                        this.cycleDetector.pop();
                    }
                    PDFContents redactedContents = PDFContents.newInstance((PDFDocument)this.pdfDocument);
                    redactedContents.setContents(xFormWriter.close().getContentStream());
                    xObjToBeModified.setContents(redactedContents);
                    if (resourceStateForCurrentXObject != null) {
                        resourceStateForCurrentXObject.cleanResources(additionalInfoForXObjStream);
                    }
                    if (this.ocRedactor != null) {
                        this.ocRedactor.scanXObjectForOCG((PDFXObject)originalFormXObject);
                    }
                    if (this.redactionOptions.isRedactAllOccurencesOfFormXObject() && this.redactionOptions.isApplyRedactionMarksOverAllOccurencesOfXObject()) {
                        if (!xObjsToInitialMatricesMap.containsKey(xObjToBeModified)) {
                            xObjsToInitialMatricesMap.put(xObjToBeModified, new LinkedHashMap());
                        }
                        xObjsToInitialMatricesMap.get(xObjToBeModified).put(initialMatrix, xObjToBeModified.getBBox().getRectangle().normalized().transform(initialMatrix).normalized());
                    }
                } else {
                    RedactionUtils.parseForResourcesInfo(Content.newInstance((PDFXObjectForm)originalFormXObject), originalFormXObject.getResources() == null ? this.pageResourcesState : new ResourcesState(originalFormXObject.getResources(), this.redactionHandler, this.pageNumber), this.pageResourcesState, this.redactionState, originalFormXObject.getResources() == null, this.pageNumber, this.redactionHandler, this.ocRedactor, false);
                    sourceResourcesState.removeXObj(name);
                    if (this.ocRedactor != null) {
                        this.ocRedactor.scanXObjectForOCG((PDFXObject)originalFormXObject);
                    }
                }
                writer.write(instruction);
                return;
            }
            if (this.redactionOptions.isRedactAllOccurencesOfFormXObject()) {
                originalFormXObject.setContents(PDFContents.newInstance((PDFDocument)this.pdfDocument));
                originalFormXObject.setResources(null);
                originalFormXObject.removeValue(ASName.k_OC);
                originalFormXObject.removeValue(ASName.k_StructParent);
                if (this.redactionOptions.isApplyRedactionMarksOverAllOccurencesOfXObject()) {
                    if (!xObjsToInitialMatricesMap.containsKey(originalFormXObject)) {
                        xObjsToInitialMatricesMap.put(originalFormXObject, new LinkedHashMap());
                    }
                    xObjsToInitialMatricesMap.get(originalFormXObject).put(initialMatrix, originalFormXObject.getBBox().getRectangle().normalized().transform(initialMatrix).normalized());
                }
            }
            this.redactionHandler.objectRedacted(new RedactedResourceXObjectInfo(originalFormXObject.getSubtype(), this.pageNumber, true, originalFormXObject.getCosObject().getObjNum()));
            return;
        }
        if (originalXObject instanceof PDFXObjectImage) {
            PDFXObjectImage originalSoftMask;
            PDFXObjectImage originalImage;
            PDFXObjectImage imageToBeModified = originalImage = (PDFXObjectImage)originalXObject;
            PDFXObjectImage softMaskToBeModified = originalSoftMask = originalImage.getSMask();
            PDFXObjectImageMask imageMask = originalImage.getMask();
            PDFXObjectImage originalImageMask = null;
            if (imageMask != null) {
                originalImageMask = imageMask.getImageMask();
            }
            PDFXObjectImage imageMaskToBeModified = originalImageMask;
            Rectangle2D.Double xObjectRectangle = this.getXObjectRectangle(PDFRectangle.newInstance((PDFDocument)this.pdfDocument, (ASRectangle)new ASRectangle(0.0, 0.0, 1.0, 1.0)), currCTM);
            if (!this.redactionArea.contains(xObjectRectangle)) {
                if (this.redactionArea.intersects(xObjectRectangle)) {
                    try {
                        if (!this.redactionOptions.isRedactAllOccurencesOfXObjectImage()) {
                            imageToBeModified = this.getClonedImage(originalImage);
                            if (softMaskToBeModified != null) {
                                softMaskToBeModified = this.getClonedImage(softMaskToBeModified);
                            }
                            if (imageMaskToBeModified != null) {
                                imageMaskToBeModified = this.getClonedImage(imageMaskToBeModified);
                            }
                        }
                        softMaskToBeModified = this.handleMask(currCTM, imageRedactor, originalSoftMask, softMaskToBeModified);
                        imageMaskToBeModified = this.handleMask(currCTM, imageRedactor, originalImageMask, imageMaskToBeModified);
                        boolean unsupportedFilterFoundForMainImage = imageRedactor.redactXObjectImage(currCTM, imageToBeModified, this.redactionArea);
                        if (unsupportedFilterFoundForMainImage) {
                            imageToBeModified = originalImage;
                            if (!this.redactionOptions.getRedactWholeImageForUnsupportedFilter()) throw new PDFUnsupportedFeatureException("Unsupported filter found in ImageXObject, Object Number: " + originalImage.getCosObject().getObjNum());
                            if (this.redactionOptions.isRedactAllOccurencesOfXObjectImage()) {
                                ImageRedactor.setXobjectImageWhite(imageToBeModified);
                                this.redactionHandler.objectRedacted(new RedactedResourceXObjectInfo(imageToBeModified.getSubType(), this.pageNumber, true, imageToBeModified.getCosObject().getObjNum()));
                            }
                        } else {
                            this.redactionHandler.objectRedacted(new RedactedResourceXObjectInfo(imageToBeModified.getSubType(), this.pageNumber, false, imageToBeModified.getCosObject().getObjNum()));
                            if (this.redactionOptions.isRedactAllOccurencesOfXObjectImage()) {
                                sourceResourcesState.removeXObj(name);
                            } else {
                                this.updateInstructionWithClonedXObject(sourceResourcesState, instruction, (PDFXObject)imageToBeModified);
                            }
                            writer.write(instruction);
                            if (this.ocRedactor != null) {
                                this.ocRedactor.scanXObjectForOCG((PDFXObject)imageToBeModified);
                            }
                        }
                        imageToBeModified.setSMask(softMaskToBeModified);
                        if (imageMaskToBeModified != null) {
                            imageToBeModified.setMaskImage(imageMaskToBeModified);
                        } else {
                            imageToBeModified.setMask(null);
                        }
                        if (this.redactionOptions.isRedactAllOccurencesOfXObjectImage() && this.redactionOptions.isApplyRedactionMarksOverAllOccurencesOfXObject()) {
                            RedactionUtils.wrapImageInFormXObject(originalImage, name);
                            PDFXObjectForm xObjForm = PDFXObjectForm.getInstance((CosObject)originalImage.getCosObject());
                            if (unsupportedFilterFoundForMainImage) {
                                this.paintPathInWrapperXObject(instruction, xObjForm);
                                this.paintPathInMainStream(writer, currCTM, xObjectRectangle);
                                return;
                            }
                            if (!xObjsToInitialMatricesMap.containsKey(xObjForm)) {
                                xObjsToInitialMatricesMap.put(xObjForm, new LinkedHashMap());
                            }
                            xObjsToInitialMatricesMap.get(xObjForm).put(currCTM, xObjForm.getBBox().getRectangle().normalized().transform(currCTM).normalized());
                            return;
                        }
                        if (!unsupportedFilterFoundForMainImage) return;
                        this.paintPathInMainStream(writer, currCTM, xObjectRectangle);
                        return;
                    }
                    catch (IOException e) {
                        throw new PDFIOException("exception occured while redacting " + name + " image", (Throwable)e);
                    }
                } else {
                    writer.write(instruction);
                    sourceResourcesState.removeXObj(name);
                    if (this.ocRedactor == null) return;
                    this.ocRedactor.scanXObjectForOCG((PDFXObject)imageToBeModified);
                }
                return;
            } else {
                this.redactionHandler.objectRedacted(new RedactedResourceXObjectInfo(imageToBeModified.getSubType(), this.pageNumber, true, imageToBeModified.getCosObject().getObjNum()));
                if (!this.redactionOptions.isRedactAllOccurencesOfXObjectImage()) return;
                try {
                    ImageRedactor.setXobjectImageWhite(imageToBeModified);
                    if (softMaskToBeModified != null) {
                        ImageRedactor.setXobjectImageWhite(softMaskToBeModified);
                    }
                    if (imageMaskToBeModified != null) {
                        ImageRedactor.setXobjectImageWhite(imageMaskToBeModified);
                    }
                    if (!this.redactionOptions.isApplyRedactionMarksOverAllOccurencesOfXObject()) return;
                    RedactionUtils.wrapImageInFormXObject(originalImage, name);
                    PDFXObjectForm xObjForm = PDFXObjectForm.getInstance((CosObject)originalImage.getCosObject());
                    if (!xObjsToInitialMatricesMap.containsKey(xObjForm)) {
                        xObjsToInitialMatricesMap.put(xObjForm, new LinkedHashMap());
                    }
                    xObjsToInitialMatricesMap.get(xObjForm).put(currCTM, xObjForm.getBBox().getRectangle().normalized().transform(currCTM).normalized());
                    return;
                }
                catch (IOException e) {
                    throw new PDFIOException("exception occured while redacting " + name + " image", (Throwable)e);
                }
            }
        } else {
            sourceResourcesState.removeXObj(name);
            writer.write(instruction);
        }
    }

    private void paintPathInMainStream(ContentWriter writer, ASMatrix currCTM, Rectangle2D.Double xObjectRectangle) throws PDFIOException, PDFInvalidParameterException {
        double[] unsupportedFilterImageRedactedColor = this.redactionOptions.getUnsupportedFilterImageRedactedColor();
        writer.write(RedactionUtils.GSAVE_INSTRUCTION);
        ASMatrix currCTMInverse = currCTM.getInverse();
        writer.write(InstructionFactory.newConcatMatrix((double)currCTMInverse.geta(), (double)currCTMInverse.getb(), (double)currCTMInverse.getc(), (double)currCTMInverse.getd(), (double)currCTMInverse.getx(), (double)currCTMInverse.gety()));
        writer.write(InstructionFactory.newDeviceRGBFill((double)unsupportedFilterImageRedactedColor[0], (double)unsupportedFilterImageRedactedColor[1], (double)unsupportedFilterImageRedactedColor[2]));
        writer.write(InstructionFactory.newRectangle((double)xObjectRectangle.getMinX(), (double)xObjectRectangle.getMinY(), (double)xObjectRectangle.width, (double)xObjectRectangle.height));
        writer.write(RedactionUtils.FILL_INSTRUCTION);
        writer.write(RedactionUtils.GRESTORE_INSTRUCTION);
    }

    private void paintPathInWrapperXObject(Instruction instruction, PDFXObjectForm xObjForm) throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException {
        double[] unsupportedFilterImageRedactedColor = this.redactionOptions.getUnsupportedFilterImageRedactedColor();
        ContentWriter xObjFormWriter = ContentWriter.newInstance((ModifiableContent)ModifiableContent.newInstance((PDFXObjectForm)xObjForm));
        xObjFormWriter.write(InstructionFactory.newDeviceRGBFill((double)unsupportedFilterImageRedactedColor[0], (double)unsupportedFilterImageRedactedColor[1], (double)unsupportedFilterImageRedactedColor[2]));
        xObjFormWriter.write(InstructionFactory.newRectangle((double)0.0, (double)0.0, (double)1.0, (double)1.0));
        xObjFormWriter.write(RedactionUtils.FILL_INSTRUCTION);
        xObjForm.setContents(xObjFormWriter.close().getContents());
    }

    private PDFXObjectImage handleMask(ASMatrix currCTM, ImageRedactor imageRedactor, PDFXObjectImage originalMask, PDFXObjectImage maskToBeModified) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException, IOException {
        boolean unsupportedFilterFoundForMask;
        if (maskToBeModified != null && (unsupportedFilterFoundForMask = imageRedactor.redactXObjectImage(currCTM, maskToBeModified, this.redactionArea)) && this.redactionOptions.getRedactWholeImageForUnsupportedFilter()) {
            if (this.redactionOptions.isRedactAllOccurencesOfXObjectImage()) {
                maskToBeModified = originalMask;
                ImageRedactor.setXobjectImageWhite(maskToBeModified);
            } else {
                maskToBeModified = null;
            }
        }
        return maskToBeModified;
    }

    private PDFXObjectImage getClonedImage(PDFXObjectImage originalImage) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFCosParseException {
        PDFXObjectImage imageToBeModified = PDFXObjectImage.getInstance((CosObject)RedactionUtils.createClonedStream(originalImage.getCosStream(), this.pdfDocument));
        imageToBeModified.getCosStream().newDataEncoded(originalImage.getCosStream().getStreamEncoded());
        return imageToBeModified;
    }

    private Rectangle2D.Double getXObjectRectangle(PDFXObjectForm xForm, ASMatrix initialMatrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFRectangle xObjBBox = xForm.getBBox();
        ASRectangle xObjectLocation = xObjBBox.getRectangle().normalized().transform(initialMatrix).normalized();
        Rectangle2D.Double xObjectRectangle = new Rectangle2D.Double(xObjectLocation.left(), xObjectLocation.bottom(), xObjectLocation.width(), xObjectLocation.height());
        return xObjectRectangle;
    }

    private void updateInstructionWithClonedXObject(ResourcesState sourceResourceState, Instruction instruction, PDFXObject xObjToBeModified) throws PDFInvalidContentException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASName newName = null;
        newName = xObjToBeModified instanceof PDFXObjectImage ? ASName.create((String)(NEW_IMAGE_XOBJECT_NAME + this.xObjectsNumberWrapper.getAndIncrementNewImgNameSuffix())) : ASName.create((String)(NEW_XOBJECT_NAME + this.xObjectsNumberWrapper.getAndIncrementNewXObjNameSuffix()));
        OperandStack operands = instruction.getOperands();
        operands.popName();
        operands.pushName(newName);
        if (xObjToBeModified.dictionaryContains(ASName.k_Name)) {
            xObjToBeModified.setDictionaryNameValue(ASName.k_Name, newName);
        }
        sourceResourceState.getResources().getXObjectMap().put(newName, (PDFCosObjectContainer)xObjToBeModified);
    }

    private void handleBInstr(RedactionContentWriter writer, ASMatrix currCTM, GeneralPath completePath, ClipPathState clipPathState) throws PDFInvalidParameterException, PDFIOException, PDFInvalidContentException {
        boolean handled = this.handlePathPaintingInstructionNormally(RedactionUtils.FILL_AND_STROKE_INSTRUCTION, completePath, clipPathState, this.redactionArea, writer, currCTM);
        if (!handled) {
            boolean updated = RedactionUtils.writeRedactedPathArea(writer, currCTM, this.redactionArea, completePath);
            if (updated) {
                if (clipPathState.isClipPathDefined()) {
                    this.writeClipPathInstr(writer, clipPathState);
                }
                writer.write(RedactionUtils.FILL_INSTRUCTION);
            }
            clipPathState.resetClipPathState();
            long currentPosition = writer.getPosition();
            RedactionUtils.strokePath(writer, currCTM, this.redactionArea, completePath);
            if (writer.getPosition() > currentPosition) {
                writer.write(RedactionUtils.STROKE_INSTRUCTION);
            }
        }
    }

    private void handleCurveInstruction(ASMatrix currCTM, GeneralPath completePath, float y3, float x3, float y2, float x2, float y1, float x1, boolean transformP1) throws PDFInvalidParameterException {
        if (this.pathInitialised) {
            if (transformP1) {
                RedactionUtils.getTransformedCoordinates(currCTM, this.tempPoint1, x1, y1);
            } else {
                this.tempPoint1.setLocation(x1, y1);
            }
            RedactionUtils.getTransformedCoordinates(currCTM, this.tempPoint2, x2, y2);
            RedactionUtils.getTransformedCoordinates(currCTM, this.tempPoint3, x3, y3);
            if (RedactionUtils.equalPoints(completePath.getCurrentPoint(), this.tempPoint1) && RedactionUtils.equalPoints(this.tempPoint2, this.tempPoint3)) {
                completePath.lineTo((float)this.tempPoint2.x, (float)this.tempPoint2.y);
            } else {
                completePath.curveTo((float)this.tempPoint1.x, (float)this.tempPoint1.y, (float)this.tempPoint2.x, (float)this.tempPoint2.y, (float)this.tempPoint3.x, (float)this.tempPoint3.y);
            }
        }
    }

    private Rectangle2D.Double getXObjectRectangle(PDFRectangle xObjBBox, ASMatrix initialMatrix) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASRectangle xObjectLocation = xObjBBox.getRectangle().normalized().transform(initialMatrix).normalized();
        Rectangle2D.Double xObjectRectangle = new Rectangle2D.Double(xObjectLocation.left(), xObjectLocation.bottom(), xObjectLocation.width(), xObjectLocation.height());
        return xObjectRectangle;
    }

    private void handleInlineImage(RedactionContentWriter writer, Instruction instruction, Content content, ASMatrix currCTM, ResourcesState currentResourceState, ImageRedactor imageRedactor) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        OperandStack operands = instruction.getOperands();
        ResourcesState sourceResourcesState = currentResourceState == null ? this.pageResourcesState : currentResourceState;
        Rectangle2D.Double xObjectRectangle = this.getXObjectRectangle(PDFRectangle.newInstance((PDFDocument)this.pdfDocument, (ASRectangle)new ASRectangle(0.0, 0.0, 1.0, 1.0)), currCTM);
        if (!this.redactionArea.contains(xObjectRectangle)) {
            boolean isImageRedacted = false;
            InputByteStream imageData = operands.peekInputByteStream();
            ASDictionary imageDict = operands.stackToImageDictionary();
            InlineImage inlineImage = InlineImage.newInstance((Content)content, (ASDictionary)imageDict, (InputByteStream)imageData);
            if (this.redactionArea.intersects(xObjectRectangle)) {
                PDFResources resources = sourceResourcesState.getResources();
                PDFColorSpaceMap colorSpaceMap = null;
                if (resources != null) {
                    colorSpaceMap = resources.getColorSpaceMap();
                }
                try {
                    ImageRedactor.InlineImageContainer inlineImageContainer = imageRedactor.redactInlineImage(inlineImage, currCTM, this.redactionArea, colorSpaceMap, imageDict, imageData);
                    instruction = InstructionFactory.newInlineImageDict((ASDictionary)inlineImageContainer.getInlineImageDictionary(), (InputByteStream)inlineImageContainer.getImage().getEncodedImageData(content));
                    isImageRedacted = inlineImageContainer.getIsInlineImageRedacted();
                }
                catch (IOException e) {
                    throw new PDFIOException("exception occured while redacting inline image", (Throwable)e);
                }
            }
            if (!isImageRedacted || !this.redactionOptions.getRedactWholeImageForUnsupportedFilter()) {
                writer.handleInlineImageInstruction(instruction, 1);
                if (inlineImage.getColorSpace() != null) {
                    sourceResourcesState.removeColour(inlineImage.getColorSpace().getExistingResourceColorSpaceName());
                }
            }
        }
    }

    private void handleMPDPInstruction(ASName operator, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (!this.redactionOptions.isRemoveAllMPDP()) {
            if (operator == ASName.k_DP) {
                RedactionUtils.handleBDCDPInstruction(this.currentResourceState == null ? this.pageResourcesState : this.currentResourceState, this.redactionState, instruction, this.pageNumber, this.ocRedactor);
            }
            this.writer.write(instruction);
        }
    }

    public void w(double lineWidth, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void i(double flatness, Instruction instruction) throws PDFIOException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void d0(double wx, double wy, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.write(instruction);
    }

    public void d1(double wx, double wy, double llx, double lly, double urx, double ury, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.write(instruction);
    }

    public void CS(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void cs(ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void SC(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void SCN(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void SCN(float[] colors, ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void sc(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void scn(float[] colors, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void scn(float[] colors, ASName name, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void G(float gray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void g(float gray, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void RG(float r, float g, float b, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void rg(float r, float g, float b, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void K(float c, float m, float y, float k, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void k(float c, float m, float y, float k, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void gs(ASName extGStateName, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void J(PDFLineCap lineCap, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void j(PDFLineJoin lineJoin, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void M(double miterLimit, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void d(PDFDashPattern dashPattern, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void ri(PDFRenderingIntent intent, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleGStateInstruction(instruction);
    }

    public void BDC(ASName tag, ASName properties, Instruction instruction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.writer.handleBMCBDCInstruction(instruction);
    }
}

