/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.redaction.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfig;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCConfigList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroup;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupArray;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCGroupList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCMembership;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCOrderListContent;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCProperties;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCRGBGroupsList;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsageApp;
import com.adobe.internal.pdftoolkit.pdf.graphics.optionalcontent.PDFOCUsageAppList;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCProperty;
import com.adobe.internal.pdftoolkit.pdf.interactive.markedcontent.PDFMCPropertyMap;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

class OCRedactor {
    private PDFDocument pdfDocument;
    private Set<Integer> usedOCGs = new HashSet<Integer>();
    private Set<Integer> processedXObjs = new HashSet<Integer>();

    OCRedactor(PDFDocument pdfDocument) {
        this.pdfDocument = pdfDocument;
    }

    void cleanOC(Set<Integer> pagesSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.populateUsedOCGs(pagesSet);
        this.processOCProperties();
    }

    private void populateUsedOCGs(Set<Integer> pagesSet) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources acroFormResources;
        PDFPageTree pageTree = this.pdfDocument.requirePages();
        Iterator<Integer> pageIterator = pagesSet.iterator();
        while (pageIterator.hasNext()) {
            PDFPage currentPage = pageTree.getPage(pageIterator.next().intValue());
            if (currentPage == null) continue;
            this.scanPageForOCG(currentPage);
        }
        PDFInteractiveForm pdfInteractiveForm = this.pdfDocument.getInteractiveForm();
        if (pdfInteractiveForm != null && (acroFormResources = pdfInteractiveForm.getResources()) != null) {
            this.scanResourcesForOCG(acroFormResources);
        }
    }

    private void scanPageForOCG(PDFPage page) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFAnnotationList annotList;
        PDFResources pageResources = page.getResources();
        if (pageResources != null) {
            this.scanResourcesForOCG(pageResources);
        }
        if ((annotList = page.getAnnotationList()) != null) {
            for (PDFAnnotation currentAnnotation : annotList) {
                this.scanAnnotationForOCG(currentAnnotation);
            }
        }
    }

    void scanAnnotationForOCG(PDFAnnotation annotation) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCObject ocObject = PDFOCObject.getOC((PDFAnnotation)annotation);
        this.processPDFOCObject(ocObject);
        PDFAppearance annotAppearance = annotation.getAppearance();
        if (annotAppearance != null) {
            List rolloverAppearanceStates;
            List downAppearanceStates;
            List normalAppearanceStates = annotAppearance.getNormalAppearanceStates();
            if (normalAppearanceStates != null && !normalAppearanceStates.isEmpty()) {
                for (int i = 0; i < normalAppearanceStates.size(); ++i) {
                    PDFXObjectForm xObject = annotAppearance.getNormalAppearance((ASName)normalAppearanceStates.get(i));
                    this.scanXObjectForOCG((PDFXObject)xObject);
                }
            } else {
                PDFXObjectForm normalAppearance = annotAppearance.getNormalAppearance();
                if (normalAppearance != null) {
                    this.scanXObjectForOCG((PDFXObject)normalAppearance);
                }
            }
            if ((downAppearanceStates = annotAppearance.getDownAppearanceStates()) != null && !downAppearanceStates.isEmpty()) {
                for (int i = 0; i < downAppearanceStates.size(); ++i) {
                    PDFXObjectForm xObject = annotAppearance.getDownAppearance((ASName)downAppearanceStates.get(i));
                    this.scanXObjectForOCG((PDFXObject)xObject);
                }
            } else {
                PDFXObjectForm downAppearance = annotAppearance.getDownAppearance();
                if (downAppearance != null) {
                    this.scanXObjectForOCG((PDFXObject)downAppearance);
                }
            }
            if ((rolloverAppearanceStates = annotAppearance.getRolloverAppearanceStates()) != null && !rolloverAppearanceStates.isEmpty()) {
                for (int i = 0; i < rolloverAppearanceStates.size(); ++i) {
                    PDFXObjectForm xObject = annotAppearance.getRolloverAppearance((ASName)rolloverAppearanceStates.get(i));
                    this.scanXObjectForOCG((PDFXObject)xObject);
                }
            } else {
                PDFXObjectForm rollOverAppearance = annotAppearance.getRolloverAppearance();
                if (rollOverAppearance != null) {
                    this.scanXObjectForOCG((PDFXObject)rollOverAppearance);
                }
            }
        }
    }

    private void scanResourcesForOCG(PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectMap xObjMap;
        PDFMCPropertyMap mcPropertyMap = resources.getMCPropertyMap();
        if (mcPropertyMap != null) {
            Collection mcPropertiesCollection = mcPropertyMap.values();
            for (PDFMCProperty currentMCProperty : mcPropertiesCollection) {
                this.processPDFOCObject(PDFOCObject.getInstance((CosObject)currentMCProperty.getCosObject()));
            }
        }
        if ((xObjMap = resources.getXObjectMap()) != null) {
            Collection xObjsCollection = xObjMap.values();
            for (PDFXObject currentXObj : xObjsCollection) {
                this.scanXObjectForOCG(currentXObj);
            }
        }
    }

    void scanXObjectForOCG(PDFXObject xObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFResources resources;
        if (this.processedXObjs.contains(xObject.getCosObject().getObjNum())) {
            return;
        }
        this.processedXObjs.add(xObject.getCosObject().getObjNum());
        PDFOCObject pdfOCObject = PDFOCObject.getOC((PDFXObject)xObject);
        this.processPDFOCObject(pdfOCObject);
        if (xObject instanceof PDFXObjectForm && (resources = ((PDFXObjectForm)xObject).getResources()) != null) {
            this.scanResourcesForOCG(resources);
        }
    }

    void processPDFOCObject(PDFOCObject pdfOCObject) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfOCObject instanceof PDFOCGroup) {
            this.usedOCGs.add(pdfOCObject.getCosObject().getObjNum());
        } else if (pdfOCObject instanceof PDFOCMembership) {
            this.getUsedOCGsFromOCMembershipDictionary((PDFOCMembership)pdfOCObject);
        }
    }

    private void getUsedOCGsFromOCMembershipDictionary(PDFOCMembership dict) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCGroupList ocGroupList = dict.getOCGs();
        if (ocGroupList != null) {
            for (PDFOCGroup currentOCGroup : ocGroupList) {
                this.usedOCGs.add(currentOCGroup.getCosObject().getObjNum());
            }
        }
    }

    private void processOCProperties() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCProperties ocProperties = this.pdfDocument.requireCatalog().getOCProperties();
        if (ocProperties != null) {
            PDFOCConfigList ocConfigList;
            PDFOCConfig defaultOCConfig;
            PDFOCGroupArray ocgs = ocProperties.getOCGs();
            if (ocgs != null) {
                this.cleanPDFOCGroupArray(ocgs);
                if (ocgs.isEmpty()) {
                    this.pdfDocument.requireCatalog().setOCProperties(null);
                    return;
                }
            }
            if ((defaultOCConfig = ocProperties.getDefaultOCConfigDict()) != null) {
                this.processOptionalContentConfigurationDictionary(defaultOCConfig);
            }
            if ((ocConfigList = ocProperties.getOCConfigsArray()) != null) {
                for (PDFOCConfig currentOCConfig : ocConfigList) {
                    this.processOptionalContentConfigurationDictionary(currentOCConfig);
                }
            }
        }
    }

    private void processOptionalContentConfigurationDictionary(PDFOCConfig configDictionary) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFOCUsageAppList ocUsageAppList;
        PDFOCRGBGroupsList ocRBGroupsList;
        PDFOCGroupArray lockedOcGroupArray;
        PDFOCOrderList orderList;
        PDFOCGroupArray offOcGroupArray;
        PDFOCGroupArray onOcGroupArray = configDictionary.getONList();
        if (onOcGroupArray != null) {
            this.cleanPDFOCGroupArray(onOcGroupArray);
            if (onOcGroupArray.isEmpty()) {
                configDictionary.setONList(null);
            }
        }
        if ((offOcGroupArray = configDictionary.getOFFList()) != null) {
            this.cleanPDFOCGroupArray(offOcGroupArray);
            if (offOcGroupArray.isEmpty()) {
                configDictionary.setOFFList(null);
            }
        }
        if ((orderList = configDictionary.getOrderList()) != null && this.cleanPDFOCOrderList(orderList)) {
            configDictionary.setOrderList(null);
        }
        if ((lockedOcGroupArray = configDictionary.getLocked()) != null) {
            this.cleanPDFOCGroupArray(lockedOcGroupArray);
            if (lockedOcGroupArray.isEmpty()) {
                configDictionary.setLocked(null);
            }
        }
        if ((ocRBGroupsList = configDictionary.getRBGroups()) != null) {
            Iterator ocGroupsIterator = ocRBGroupsList.iterator();
            while (ocGroupsIterator.hasNext()) {
                PDFOCGroupArray currentOCGroupArray = (PDFOCGroupArray)ocGroupsIterator.next();
                this.cleanPDFOCGroupArray(currentOCGroupArray);
                if (!currentOCGroupArray.isEmpty()) continue;
                ocGroupsIterator.remove();
            }
            if (ocRBGroupsList.isEmpty()) {
                configDictionary.setRBGroups(null);
            }
        }
        if ((ocUsageAppList = configDictionary.getASList()) != null) {
            for (PDFOCUsageApp currentOCUsageApp : ocUsageAppList) {
                PDFOCGroupArray ocgs = currentOCUsageApp.getOCGs();
                if (ocgs == null) continue;
                this.cleanPDFOCGroupArray(ocgs);
                if (!ocgs.isEmpty()) continue;
                currentOCUsageApp.setOCGs(null);
            }
        }
    }

    private void cleanPDFOCGroupArray(PDFOCGroupArray ocGroupArray) {
        Iterator ocGroupIterator = ocGroupArray.iterator();
        while (ocGroupIterator.hasNext()) {
            PDFOCGroup currentOCGroup = (PDFOCGroup)ocGroupIterator.next();
            if (currentOCGroup == null || this.usedOCGs.contains(currentOCGroup.getCosObject().getObjNum())) continue;
            ocGroupIterator.remove();
        }
    }

    private boolean cleanPDFOCOrderList(PDFOCOrderList orderList) {
        Iterator orderListIterator = orderList.iterator();
        boolean onlyLabels = true;
        while (orderListIterator.hasNext()) {
            PDFOCOrderListContent currentContent = (PDFOCOrderListContent)orderListIterator.next();
            if (currentContent instanceof PDFOCOrderList) {
                if (this.cleanPDFOCOrderList((PDFOCOrderList)currentContent)) {
                    orderListIterator.remove();
                    continue;
                }
                onlyLabels = false;
                continue;
            }
            if (!(currentContent instanceof PDFOCGroup)) continue;
            if (!this.usedOCGs.contains(currentContent.getPDFCosObject().getCosObject().getObjNum())) {
                orderListIterator.remove();
                continue;
            }
            onlyLabels = false;
        }
        return onlyLabels;
    }
}

