/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.pdfport.impl;

import com.adobe.internal.agm.AGMColor;
import com.adobe.internal.agm.AGMColorSpace;
import com.adobe.internal.agm.AGMGState;
import com.adobe.internal.agm.AGMLineCapStyle;
import com.adobe.internal.agm.AGMLineDashPattern;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFParseException;
import com.adobe.internal.pdftoolkit.pdf.content.Instruction;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;

public class PDFPortGState {
    void setGState(ContentWriter portContentWriter, AGMGState agmGState) throws PDFIOException, PDFParseException {
        double[] colorants;
        AGMColorSpace colorSpace;
        AGMColor agmColor;
        if (agmGState.hasFillColor()) {
            agmColor = agmGState.getFillColor();
            colorSpace = agmColor.getColorSpace();
            colorants = agmColor.getColorants();
            if (colorSpace == AGMColorSpace.DeviceGray) {
                Instruction g = InstructionFactory.newDeviceGrayFill((double)colorants[0]);
                portContentWriter.write(g);
            } else if (colorSpace == AGMColorSpace.DeviceRGB) {
                Instruction rg = InstructionFactory.newDeviceRGBFill((double)colorants[0], (double)colorants[1], (double)colorants[2]);
                portContentWriter.write(rg);
            } else if (colorSpace == AGMColorSpace.DeviceCMYK) {
                Instruction k = InstructionFactory.newDeviceCMYKFill((double)colorants[0], (double)colorants[1], (double)colorants[2], (double)colorants[3]);
                portContentWriter.write(k);
            } else {
                throw new PDFParseException("Invalid Fill Color Space: " + (Object)((Object)colorSpace));
            }
        }
        if (agmGState.hasStrokeColor()) {
            agmColor = agmGState.getStrokeColor();
            colorSpace = agmColor.getColorSpace();
            colorants = agmColor.getColorants();
            if (colorSpace == AGMColorSpace.DeviceGray) {
                Instruction G = InstructionFactory.newDeviceGrayStroke((double)colorants[0]);
                portContentWriter.write(G);
            } else if (colorSpace == AGMColorSpace.DeviceRGB) {
                Instruction RG = InstructionFactory.newDeviceRGBStroke((double)colorants[0], (double)colorants[1], (double)colorants[2]);
                portContentWriter.write(RG);
            } else if (colorSpace == AGMColorSpace.DeviceCMYK) {
                Instruction K = InstructionFactory.newDeviceCMYKStroke((double)colorants[0], (double)colorants[1], (double)colorants[2], (double)colorants[3]);
                portContentWriter.write(K);
            } else {
                throw new PDFParseException("Invalid Stroke Color Space: " + (Object)((Object)colorSpace));
            }
        }
        if (agmGState.hasLineWidth()) {
            double lineWidth = agmGState.getLineWidth();
            Instruction w = InstructionFactory.newLineWidth((double)lineWidth);
            portContentWriter.write(w);
        }
        if (agmGState.hasLineCapStyle()) {
            AGMLineCapStyle lineCapStyle = agmGState.getLineCapStyle();
            Instruction J = InstructionFactory.newLineCapStyle((int)lineCapStyle.getValue());
            portContentWriter.write(J);
        }
        if (agmGState.hasLineDashPattern()) {
            AGMLineDashPattern lineDashPattern = agmGState.getLineDashPattern();
            Instruction d = InstructionFactory.newLineDashPattern((double[])lineDashPattern.getPattern(), (int)lineDashPattern.getPhase());
            portContentWriter.write(d);
        }
    }
}

