/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosUtils;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFText;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFAppearanceRef;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFDocumentImpl;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFIconFit;
import java.util.ArrayList;
import java.util.List;

public final class FDFField
extends PDFField {
    public static final ASName k_ClrF = ASName.create((String)"ClrF");
    public static final ASName k_ClrFf = ASName.create((String)"ClrFf");
    public static final ASName k_SetF = ASName.create((String)"SetF");
    public static final ASName k_SetFf = ASName.create((String)"SetFf");
    public static final ASName k_APRef = ASName.create((String)"APRef");
    public static final ASName k_IF = ASName.create((String)"IF");

    private FDFField(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static FDFField getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject((CosObject)cosObject) == null) {
            return null;
        }
        FDFField pdfObject = (FDFField)PDFCosObject.getCachedInstance((CosObject)cosObject, FDFField.class);
        if (pdfObject == null) {
            pdfObject = new FDFField(cosObject);
        }
        return pdfObject;
    }

    public static FDFField getInstance(PDFField field) throws PDFInvalidDocumentException {
        if (field == null) {
            return null;
        }
        return FDFField.getInstance(field.getCosObject());
    }

    public boolean isTerminalField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return !this.dictionaryContains(ASName.k_Kids);
    }

    public PDFFieldList getChildren() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldList.getInstance((CosObject)this.getDictionaryCosObjectValue(ASName.k_Kids));
    }

    public boolean hasSetFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCosUtils.containsInheritableKey((ASName)k_SetFf, (ASName)ASName.k_Parent, (PDFCosDictionary)this);
    }

    public int getSetFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number flags = this.getDictionaryNumericValue(k_SetFf);
        return flags == null ? 0 : flags.intValue();
    }

    void setSetFlags(Number flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_SetFf, flags.longValue());
    }

    public boolean hasClearFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFCosUtils.containsInheritableKey((ASName)k_ClrFf, (ASName)ASName.k_Parent, (PDFCosDictionary)this);
    }

    public int getClearFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number flags = this.getDictionaryNumericValue(k_ClrFf);
        return flags == null ? -1 : flags.intValue();
    }

    void setClearFlags(Number flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_ClrFf, flags.longValue());
    }

    public boolean hasWidgetFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.dictionaryContains(ASName.k_F);
    }

    public int getWidgetFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number flags = this.getDictionaryNumericValue(ASName.k_F);
        return flags == null ? 0 : flags.intValue();
    }

    void setWidgetFlags(Number flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(ASName.k_F, flags.longValue());
    }

    public int getSetWidgetFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number flags = this.getDictionaryNumericValue(k_SetF);
        return flags == null ? 0 : flags.intValue();
    }

    void setSetWidgetFlags(Number flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_SetF, flags.longValue());
    }

    public int getClearWidgetFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        Number flags = this.getDictionaryNumericValue(k_ClrF);
        return flags == null ? -1 : flags.intValue();
    }

    void setClearWidgetFlags(Number flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryIntValue(k_ClrF, flags.longValue());
    }

    PDFAppearance getAppearance() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAppearance.getInstance((CosObject)this.getDictionaryCosObjectValue(ASName.k_AP));
    }

    void setAppearance(PDFAppearance appearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_AP, (PDFCosObject)appearance);
    }

    FDFAppearanceRef getAppearanceRef() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return FDFAppearanceRef.getInstance(this.getDictionaryCosObjectValue(k_APRef));
    }

    void setAppearanceRef(FDFAppearanceRef appearance) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_APRef, (PDFCosObject)appearance);
    }

    public FDFIconFit getIconFit() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return FDFIconFit.getInstance(this.getDictionaryCosObjectValue(k_IF));
    }

    void setIconFit(FDFIconFit fit) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(k_IF, (PDFCosObject)fit);
    }

    public PDFAction getAction() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFActionFactory.getInstance((CosObject)this.getDictionaryDictionaryValue(ASName.k_A));
    }

    void setAction(PDFAction action) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryValue(ASName.k_A, (PDFCosObject)action);
    }

    public PDFFieldNode getParent() {
        return null;
    }

    public void setParent(PDFFieldNode parent) {
    }

    public void removeFieldEntries() {
    }

    public static FDFField newInstance(FDFDocumentImpl fdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary((PDFDocument)fdfDocument);
        FDFField pdfObject = new FDFField((CosObject)cosObject);
        return pdfObject;
    }

    public PDFAnnotationIterator getAnnotationsIterator() {
        return null;
    }

    public PDFAnnotationList getAnnotations() {
        return null;
    }

    public void setAnnotations(PDFAnnotationList annots) {
    }

    public void addAnnotation(PDFAnnotation widget) {
    }

    public PDFAdditionalActions getAdditionalActions() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (PDFAdditionalActions.getInstance((CosObject)this.getDictionaryDictionaryValue(ASName.k_AA), null) == null && this.isAcrobatAnnotation()) {
            return PDFAdditionalActions.getInstance((CosObject)this.getParent().getDictionaryDictionaryValue(ASName.k_AA), null);
        }
        return PDFAdditionalActions.getInstance((CosObject)this.getDictionaryDictionaryValue(ASName.k_AA), null);
    }

    public void setAdditionalActions(PDFAdditionalActions additionalActions) {
    }

    public List<Object> getDefaultValueList() {
        return null;
    }

    public String getMappingName() {
        return null;
    }

    public ASName getType() {
        return null;
    }

    public boolean hasOptionList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return super.getCosDictionary().get(ASName.k_Opt) != null;
    }

    public ArrayList<Object> getOptionList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosObject options = this.getOptionValue();
        if (options == null) {
            return null;
        }
        return this.addOptionsItem(null, options);
    }

    public CosObject getOptionValue() throws PDFCosParseException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFFieldNode parent;
        CosObject options = this.getDictionaryCosObjectValue(ASName.k_Opt);
        if (options == null && this.isAcrobatAnnotation() && (parent = this.getParent()) != null) {
            options = parent.getDictionaryCosObjectValue(ASName.k_Opt);
        }
        return options;
    }

    private ArrayList<Object> addOptionsItem(ArrayList<Object> optionList, CosObject cosItem) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (cosItem.getType() == 4) {
            PDFText text = PDFText.getInstance((CosObject)cosItem);
            if (optionList == null) {
                optionList = new ArrayList();
            }
            optionList.add(text.stringValue());
        } else if (cosItem.getType() == 5) {
            CosArray cosArray = (CosArray)cosItem;
            ArrayList<Object> arrayVal = new ArrayList<Object>(2);
            for (int arrayInd = 0; arrayInd < cosArray.size(); ++arrayInd) {
                CosObject arrayItem = cosArray.get(arrayInd);
                this.addOptionsItem(arrayVal, arrayItem);
            }
            if (optionList == null) {
                optionList = arrayVal;
            } else {
                optionList.add(arrayVal);
            }
        }
        return optionList;
    }
}

