/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf.impl;

import com.adobe.internal.io.ByteReader;
import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosSaveParams;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.securityframework.SecurityKey;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocumentInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryption;
import com.adobe.internal.pdftoolkit.pdf.document.PDFEncryptionType;
import com.adobe.internal.pdftoolkit.pdf.document.PDFOpenOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveFullOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveIncrementalOptions;
import com.adobe.internal.pdftoolkit.pdf.interactive.PDFViewerPreferences;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFCatalog;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFContent;
import java.io.InputStream;
import java.util.Map;

public final class FDFDocumentImpl
extends PDFDocument {
    public static final String FDFHeader = "%FDF-1.2\r\n";

    public FDFDocumentImpl(ByteReader src, PDFOpenOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(src, options);
        this.mCosDocument.setFDFDocument((Object)this);
    }

    public FDFDocumentImpl(PDFOpenOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        super(options);
        this.mCosDocument.setFDFDocument((Object)this);
    }

    public static FDFDocumentImpl newFDFInstance(PDFOpenOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        FDFDocumentImpl fdfDoc = new FDFDocumentImpl(options);
        fdfDoc.requireFDFCatalog().procureContent();
        return fdfDoc;
    }

    public static FDFDocumentImpl getFDFDocument(CosObject cosObject) {
        return (FDFDocumentImpl)((Object)cosObject.getDocument().getFdfDocument());
    }

    public FDFCatalog requireFDFCatalog() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            return FDFCatalog.requireInstance((CosObject)this.mCosDocument.getRoot());
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Unable to get catalog.", (Throwable)e);
        }
    }

    public FDFContent requireContent() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.requireFDFCatalog().requireContent();
    }

    public PDFFieldList getFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.requireContent().getFields();
    }

    public void save(ByteWriter byteWriter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosSaveParams cosParams = new CosSaveParams(2);
        cosParams.setHeader(FDFHeader);
        try {
            this.getCosDocument().save(byteWriter, cosParams);
        }
        catch (PDFInvalidParameterException e) {
            throw new RuntimeException("Inconsistent parameters during FDF save.", e);
        }
    }

    public PDFDocumentInfo getDocumentInfo() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public PDFPageTree requirePages() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public PDFInteractiveForm getInteractiveForm() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public void setInteractiveForm(PDFInteractiveForm pdfInteractiveForm) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public InputStream exportXMP() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public void importXMP(InputStream metadata) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public PDFViewerPreferences getViewerPreferences() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public void setViewerPreferences(PDFViewerPreferences pdfViewerPreferences) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public PDFViewerPreferences procureViewerPreferences() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public void incrementalSave(ByteWriter byteWriter) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public InputStream incrementalSave() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public void fullSave(ByteWriter byteWriter) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public InputStream fullSave() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public InputStream saveFull() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public InputStream saveFull(PDFSaveFullOptions options) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public void saveFull(ByteWriter byteWriter) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public void saveFull(ByteWriter byteWriter, PDFSaveFullOptions options) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public InputStream saveIncremental() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public InputStream saveIncremental(PDFSaveIncrementalOptions options) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public void saveIncremental(ByteWriter byteWriter) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public void saveIncremental(ByteWriter byteWriter, PDFSaveIncrementalOptions options) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public boolean unlock(SecurityKey key) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public boolean isEncrypted() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public PDFEncryptionType getEncryptionType() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public PDFEncryption getEncryption() {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public PDFEncryption setEncryption(Map encryptParams) {
        throw new UnsupportedOperationException("Illegal operation");
    }

    public boolean authenticateDecryption() {
        throw new UnsupportedOperationException("Illegal operation");
    }
}

