/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.fdf.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFFileSpecification;
import com.adobe.internal.pdftoolkit.pdf.document.PDFTextEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFDocumentImpl;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFFieldList;
import com.adobe.internal.pdftoolkit.services.fdf.impl.FDFJavaScript;
import java.util.ArrayList;

public final class FDFContent
extends PDFCosDictionary {
    public static final ASName k_Status = ASName.create((String)"Status");
    public static final ASName k_Target = ASName.create((String)"Target");

    private FDFContent(CosObject cosObject) throws PDFInvalidDocumentException {
        super(cosObject);
    }

    public static FDFContent getInstance(CosObject cosObject) throws PDFInvalidDocumentException {
        if (PDFCosObject.checkNullCosObject((CosObject)cosObject) == null) {
            return null;
        }
        FDFContent pdfObject = (FDFContent)PDFCosObject.getCachedInstance((CosObject)cosObject, FDFContent.class);
        if (pdfObject == null) {
            pdfObject = new FDFContent(cosObject);
        }
        return pdfObject;
    }

    static FDFContent requireInstance(CosObject cosObject) throws PDFInvalidParameterException, PDFInvalidDocumentException {
        FDFContent pdfObject = FDFContent.getInstance(cosObject);
        if (pdfObject == null) {
            throw new PDFInvalidParameterException("Required instance unable to be constructed.");
        }
        return pdfObject;
    }

    static FDFContent newInstance(FDFDocumentImpl fdfDocument) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        CosDictionary cosObject = PDFCosObject.newCosDictionary((PDFDocument)fdfDocument);
        FDFContent pdfObject = new FDFContent((CosObject)cosObject);
        return pdfObject;
    }

    PDFFileSpecification getFileSpecification() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFileSpecification.getInstance((CosObject)this.getDictionaryDictionaryValue(ASName.k_F));
    }

    public void setFileSpecification(PDFFileSpecification file) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        ASString filename = file.getFilename();
        if (filename == null) {
            filename = file.getDOSFilename();
        }
        if (filename == null) {
            filename = file.getUnixFilename();
        }
        if (filename == null) {
            filename = file.getMacFilename();
        }
        if (filename != null) {
            this.setDictionaryASStringValue(ASName.k_F, filename);
        }
    }

    CosArray getID() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryArrayValue(ASName.k_ID);
    }

    public void setID(CosArray id) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_ID, id);
    }

    void setID(ArrayList<Object> id) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_ID, id);
    }

    public PDFFieldList getFields() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFFieldList.getInstance((CosObject)this.getDictionaryArrayValue(ASName.k_Fields));
    }

    public void setFields(FDFFieldList fields) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Fields, fields.getCosArray());
    }

    String getStatus() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_Status);
    }

    void setStatus(String status) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Status, status);
    }

    void setStatus(String status, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Status, status, unicode);
    }

    String getEncoding() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryNameValue(ASName.k_Encoding).asString(true);
    }

    void setEncoding(String encoding) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryNameValue(ASName.k_Encoding, encoding);
    }

    public PDFAnnotationList getAnnotationList() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return PDFAnnotationList.getInstance((CosObject)this.getDictionaryCosObjectValue(ASName.k_Annots));
    }

    public void setAnnotationList(PDFAnnotationList annots) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryArrayValue(ASName.k_Annots, annots.getCosArray());
    }

    String getTarget() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getDictionaryTextStringValue(k_Target);
    }

    void setTarget(String status) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Target, status);
    }

    void setTarget(String status, PDFTextEncoding unicode) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.setDictionaryStringValue(k_Target, status, unicode);
    }

    public FDFJavaScript getFDFJavaScript() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return FDFJavaScript.getInstance((CosObject)this.getDictionaryDictionaryValue(ASName.k_JavaScript));
    }
}

