/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.filter.Base64Engine;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.digsig.SigCertificateSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.SigSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureSeedValueInterface;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFAInternalUtils;
import com.adobe.internal.pdftoolkit.services.xfa.template.XFASeedValue;
import com.adobe.xfa.form.FormField;
import com.adobe.xfa.template.containers.Field;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class SignatureSeedValueXFA
implements SignatureSeedValueInterface {
    private XFASeedValue xfaSeedValue;
    private static final String MDP_AUTHOR_SIG = "author";
    private static final String MDP_FILLER_SIG = "filler";
    private static final int Base64_Encoding_Line_Size = 76;
    private static final String lineEnd = "\r\n";

    public SignatureSeedValueXFA(PDFDocument pdfDoc, Field xfaField) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (xfaField == null) {
            throw new PDFInvalidParameterException("XFA Field can't be null");
        }
        if (pdfDoc == null) {
            throw new PDFInvalidParameterException("PDF Document can't be null");
        }
        Field field = null;
        if (xfaField instanceof FormField) {
            field = (Field)xfaField.getProto();
        }
        if (field == null) {
            field = xfaField;
        }
        this.xfaSeedValue = new XFASeedValue(pdfDoc, field);
    }

    @Override
    public List<String> getDigestMethod() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List<String> digestMethods = this.xfaSeedValue.getDigestMethod();
        if (digestMethods == null || digestMethods.isEmpty()) {
            return null;
        }
        return digestMethods;
    }

    @Override
    public ASName getFilter() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String filter = this.xfaSeedValue.getFilter();
        if (filter == null) {
            return null;
        }
        return ASName.create((String)filter);
    }

    @Override
    public Integer getFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int flags = this.xfaSeedValue.getFlags();
        return flags;
    }

    @Override
    public ASName getLockDocument() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String lockDocument = this.xfaSeedValue.getLockDocument();
        if (lockDocument == null) {
            return null;
        }
        return ASName.create((String)lockDocument);
    }

    @Override
    public Integer getMDP() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int mdp = this.xfaSeedValue.getMDP();
        if (mdp == -1) {
            return null;
        }
        return mdp;
    }

    @Override
    public List<String> getReasons() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        List<String> reasons = this.xfaSeedValue.getReasons();
        if (reasons == null || reasons.isEmpty()) {
            return null;
        }
        return reasons;
    }

    @Override
    public boolean getAddRevInfo() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.xfaSeedValue.getAddRevInfo();
    }

    @Override
    public List<ASName> getSubFilters() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        List<ASName> subFilters = this.xfaSeedValue.getSubFilters();
        if (subFilters == null || subFilters.isEmpty()) {
            return null;
        }
        return subFilters;
    }

    @Override
    public String getTimeStampServerURL() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String time = this.xfaSeedValue.getTimeStampURL();
        if (time == null || time.length() == 0) {
            return null;
        }
        return time;
    }

    @Override
    public boolean getTimeStampFlag() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.xfaSeedValue.getTimeStampFlag();
    }

    @Override
    public Double getVersion() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String sVersion = this.xfaSeedValue.getVersion();
        if (sVersion == null || sVersion.length() == 0) {
            return null;
        }
        return Double.valueOf(sVersion);
    }

    @Override
    public String getAppearanceFilter() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String appFilter = this.xfaSeedValue.getAppearanceFilter();
        if (appFilter == null || appFilter.length() == 0) {
            return null;
        }
        return appFilter;
    }

    @Override
    public String[] getLegalAttestations() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] attestations = this.xfaSeedValue.getLegalAttestations();
        if (attestations == null || attestations.length == 0) {
            return null;
        }
        return attestations;
    }

    @Override
    public void setDigestMethod(List<String> digestList) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.xfaSeedValue.setDigestMethod(digestList, false);
    }

    @Override
    public void setFilter(ASName filter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        if (filter != null) {
            String filterValue = filter.asString();
            this.xfaSeedValue.setFilter(filterValue, false);
        } else {
            this.xfaSeedValue.setFilter(null, false);
        }
    }

    @Override
    public void setFlags(Integer flags) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.xfaSeedValue.setFlags(flags);
    }

    @Override
    public void setLockDocument(ASName value) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFInvalidXMLException {
        if (value != null) {
            this.xfaSeedValue.setLockDocument(value.asString(), false);
        } else {
            this.xfaSeedValue.setLockDocument(null, false);
        }
    }

    @Override
    public void setMDP(Integer mdpValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFInvalidXMLException {
        if (mdpValue != null) {
            int mdpVal = mdpValue;
            if (mdpVal == 0) {
                this.xfaSeedValue.setMDP(mdpVal, MDP_FILLER_SIG);
            } else {
                this.xfaSeedValue.setMDP(mdpVal, MDP_AUTHOR_SIG);
            }
        } else {
            this.xfaSeedValue.setMDP(-1, MDP_AUTHOR_SIG);
        }
    }

    @Override
    public void setReasons(List<String> reasons) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.xfaSeedValue.setReasons(reasons, false);
    }

    @Override
    public void setAddRevInfo(boolean value) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        this.xfaSeedValue.setAddRevInfo(value);
    }

    @Override
    public void setSubFilters(List<ASName> subFilters) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.xfaSeedValue.setSubFilters(subFilters, false);
    }

    @Override
    public void setTimeStampServerURL(String timeStampValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException, PDFUnableToCompleteOperationException {
        this.xfaSeedValue.setTimeStampUrl(timeStampValue, false);
    }

    @Override
    public void setTimeStampFlag(boolean timeFlag) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.xfaSeedValue.setTimeStampFlag(timeFlag);
    }

    @Override
    public void setVersion(Double version) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        if (version != null) {
            this.xfaSeedValue.setVersion(version.toString());
        } else {
            this.xfaSeedValue.setVersion(null);
        }
    }

    @Override
    public void setAppearanceFilter(String appearanceFilter) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        this.xfaSeedValue.setAppearanceFilter(appearanceFilter, false);
    }

    @Override
    public void setLegalAttestations(String[] legalAttestations) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.xfaSeedValue.setLegalAttestations(legalAttestations);
    }

    @Override
    public void setSeedValue(SigSeedValue seedValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        try {
            if (seedValue != null) {
                if (seedValue.getFilter() != this.getFilter()) {
                    this.setFilter(seedValue.getFilter());
                }
                if (seedValue.getLockDocument() != this.getLockDocument()) {
                    this.setLockDocument(seedValue.getLockDocument());
                }
                if (seedValue.getMDP() != null && !seedValue.getMDP().equals(this.getMDP())) {
                    this.setMDP(seedValue.getMDP());
                } else if (this.getMDP() != null) {
                    this.setMDP(null);
                }
                if (seedValue.getRevInfo() != this.getAddRevInfo()) {
                    this.setAddRevInfo(seedValue.getRevInfo());
                }
                if (seedValue.getVersion() != null) {
                    if (!seedValue.getVersion().equals(this.getVersion())) {
                        this.setVersion(seedValue.getVersion());
                    }
                } else if (this.getVersion() != null) {
                    this.setVersion(null);
                }
                if (seedValue.getAppearanceFilter() != null) {
                    if (!seedValue.getAppearanceFilter().equalsIgnoreCase(this.getAppearanceFilter())) {
                        this.setAppearanceFilter(seedValue.getAppearanceFilter());
                    }
                } else if (this.getAppearanceFilter() != null) {
                    this.setAppearanceFilter(null);
                }
                List<String> existingList = this.getDigestMethod();
                List<String> newList = seedValue.getDigestMethod();
                if (newList != null && !newList.isEmpty()) {
                    if (existingList != null && !existingList.isEmpty()) {
                        Collections.sort(newList);
                        Collections.sort(existingList);
                        if (!newList.equals(existingList)) {
                            this.setDigestMethod(newList);
                        }
                    } else {
                        this.setDigestMethod(newList);
                    }
                } else if (existingList != null && !existingList.isEmpty()) {
                    this.setDigestMethod(null);
                }
                List<ASName> existingASNameList = this.getSubFilters();
                List<ASName> newASNameList = seedValue.getSubFilters();
                if (newASNameList != null && !newASNameList.isEmpty()) {
                    if (existingASNameList != null && !existingASNameList.isEmpty()) {
                        Collections.sort(newASNameList);
                        Collections.sort(existingASNameList);
                        if (!newASNameList.equals(existingASNameList)) {
                            this.setSubFilters(newASNameList);
                        }
                    } else {
                        this.setSubFilters(newASNameList);
                    }
                } else if (existingASNameList != null && !existingASNameList.isEmpty()) {
                    this.setSubFilters(null);
                }
                newList = seedValue.getReasons();
                existingList = this.getReasons();
                if (newList != null && !newList.isEmpty()) {
                    if (existingList != null && !existingList.isEmpty()) {
                        Collections.sort(newList);
                        Collections.sort(existingList);
                        if (!newList.equals(existingList)) {
                            this.setReasons(newList);
                        }
                    } else {
                        this.setReasons(newList);
                    }
                } else if (existingList != null && !existingList.isEmpty()) {
                    this.setReasons(null);
                }
                if (seedValue.getTimeStampURL() != null && !seedValue.getTimeStampURL().equalsIgnoreCase(this.getTimeStampServerURL())) {
                    this.setTimeStampServerURL(seedValue.getTimeStampURL());
                }
                if (seedValue.getTimeStampFlag() != this.getTimeStampFlag()) {
                    this.setTimeStampFlag(seedValue.getTimeStampFlag());
                }
                this.setCertificateSeedValue(seedValue.getCertificateSeedValue());
                if (seedValue.getFlags() == null && this.getFlags() != null) {
                    this.setFlags(null);
                } else if (!seedValue.getFlags().equals(this.getFlags())) {
                    this.setFlags(seedValue.getFlags());
                }
            } else {
                this.setDigestMethod(null);
                this.setFilter(null);
                this.setLockDocument(null);
                this.setMDP(null);
                this.setAddRevInfo(false);
                this.setSubFilters(null);
                this.setTimeStampServerURL(null);
                this.setVersion(null);
                this.setReasons(null);
                this.setAppearanceFilter(null);
                this.setFlags(null);
                this.setCertificateSeedValue(null);
            }
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFInvalidParameterException((Throwable)e);
        }
    }

    @Override
    public SigSeedValue getSeedValue() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SigSeedValue seedValue = new SigSeedValue();
        seedValue.setDigestMethod(this.getDigestMethod());
        seedValue.setFilter(this.getFilter());
        seedValue.setLockDocument(this.getLockDocument());
        seedValue.setAppearanceFilter(this.getAppearanceFilter());
        seedValue.setLegalAttestations(this.getLegalAttestations());
        seedValue.setMDP(this.getMDP());
        seedValue.setReasons(this.getReasons());
        seedValue.setRevInfo(this.getAddRevInfo());
        seedValue.setSubFilters(this.getSubFilters());
        seedValue.setTimeStampUrl(this.getTimeStampServerURL());
        seedValue.setTimeStampFlag(this.getTimeStampFlag());
        seedValue.setVersion(this.getVersion());
        seedValue.setFlags(this.getFlags());
        seedValue.setCertificateSeedValue(this.getCertificateSeedValue());
        if (seedValue.getFilter() != null || seedValue.getFlags() != 0 || seedValue.getLockDocument() != null || seedValue.getMDP() != null || seedValue.getAppearanceFilter() != null || seedValue.getLegalAttestations() != null || seedValue.getVersion() != null || seedValue.getDigestMethod() != null || seedValue.getReasons() != null || seedValue.getSubFilters() != null || seedValue.getTimeStampURL() != null || seedValue.getCertificateSeedValue() != null) {
            return seedValue;
        }
        return null;
    }

    private String getURL() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String url = this.xfaSeedValue.getURL();
        if (url == null || url.length() == 0) {
            return null;
        }
        return url;
    }

    private ASName getURLType() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String urlType = this.xfaSeedValue.getURLPolicy();
        if (urlType == null || urlType.length() == 0) {
            return null;
        }
        return ASName.create((String)urlType);
    }

    private Integer getCertificateFlags() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        int certificateFlags = this.xfaSeedValue.getCertificateSeedValueFlags();
        return certificateFlags;
    }

    private String[] getOIDS() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        List oids = this.xfaSeedValue.getOIDS();
        if (oids == null || oids.isEmpty()) {
            return null;
        }
        return oids.toArray(new String[oids.size()]);
    }

    private String[] getKeyUsage() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        String keyUsage = this.xfaSeedValue.getKeyUsages();
        if (keyUsage == null || keyUsage.length() == 0) {
            return null;
        }
        return new String[]{keyUsage};
    }

    private byte[][] getIssuers() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        List<String> issuers = this.xfaSeedValue.getIssuerCertificates();
        if (issuers == null || issuers.isEmpty()) {
            return null;
        }
        byte[][] issuersList = new byte[issuers.size()][];
        for (int i = 0; i < issuersList.length; ++i) {
            try {
                issuersList[i] = XFAInternalUtils.getDecodedBase64DERCert(issuers.get(i).getBytes("UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding exception when extracting the bytes of the signing certificate", e);
            }
        }
        return issuersList;
    }

    private byte[][] getSubjects() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        List<String> subjects = this.xfaSeedValue.getSigningCertificates();
        if (subjects == null || subjects.isEmpty()) {
            return null;
        }
        byte[][] subjectsList = new byte[subjects.size()][];
        for (int i = 0; i < subjectsList.length; ++i) {
            try {
                subjectsList[i] = XFAInternalUtils.getDecodedBase64DERCert(subjects.get(i).getBytes("UTF-8"));
                continue;
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Encoding exception when extracting the bytes of the signing certificate", e);
            }
        }
        return subjectsList;
    }

    private List<Map> getSubjectDN() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        List<String> subjectDNList = this.xfaSeedValue.getSubjectDNS();
        if (subjectDNList != null && !subjectDNList.isEmpty()) {
            ArrayList<Map> subjectDNS = new ArrayList<Map>();
            for (int i = 0; i < subjectDNList.size(); ++i) {
                HashMap subjectMap = this.parseSubjectDN(subjectDNList.get(i), ";");
                subjectDNS.add(subjectMap);
            }
            return subjectDNS;
        }
        return null;
    }

    private HashMap parseSubjectDN(String dnValue, String delimiter) {
        StringTokenizer tokenizer = new StringTokenizer(dnValue, delimiter);
        int numTokens = tokenizer.countTokens();
        HashMap<String, String> dnAttrMap = new HashMap<String, String>(numTokens);
        while (tokenizer.hasMoreTokens()) {
            String dn = tokenizer.nextToken();
            int delimPosition = dn.indexOf(61);
            if (delimPosition != -1) {
                dnAttrMap.put(dn.substring(0, delimPosition), dn.substring(++delimPosition));
                continue;
            }
            dnAttrMap.put(dn, "");
        }
        return dnAttrMap;
    }

    private void setSubject(byte[][] signingCerts) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (signingCerts != null) {
            ArrayList<String> signingCertList = new ArrayList<String>(signingCerts.length);
            for (int i = 0; i < signingCerts.length; ++i) {
                signingCertList.add(SignatureSeedValueXFA.getBase64EncodedCert(signingCerts[i]));
            }
            this.xfaSeedValue.setSigningCertificates(signingCertList, false);
        } else {
            this.xfaSeedValue.setSigningCertificates(null, false);
        }
    }

    private void setIssuers(byte[][] issuerCerts) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (issuerCerts != null) {
            ArrayList<String> issuerCertList = new ArrayList<String>(issuerCerts.length);
            for (int i = 0; i < issuerCerts.length; ++i) {
                issuerCertList.add(SignatureSeedValueXFA.getBase64EncodedCert(issuerCerts[i]));
            }
            this.xfaSeedValue.setIssuerCertificates(issuerCertList, false);
        } else {
            this.xfaSeedValue.setIssuerCertificates(null, false);
        }
    }

    private static String getBase64EncodedCert(byte[] cert) throws PDFInvalidParameterException {
        if (cert == null || cert.length == 0) {
            return null;
        }
        char[] base64Encoded = Base64Engine.encode((byte[])cert, (int)0, (int)cert.length);
        StringBuilder base64EncodedStr = new StringBuilder();
        for (int i = 0; i < base64Encoded.length; i += 76) {
            int length = Math.min(base64Encoded.length - i, 76);
            base64EncodedStr.append(base64Encoded, i, length);
            if (length != 76) continue;
            base64EncodedStr.append(lineEnd);
        }
        return base64EncodedStr.toString();
    }

    private void setOIDS(String[] oids) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (oids != null) {
            ArrayList<String> oidList = new ArrayList<String>();
            for (int i = 0; i < oids.length; ++i) {
                oidList.add(oids[i]);
            }
            this.xfaSeedValue.setOIDS(oidList, false);
        } else {
            this.xfaSeedValue.setOIDS(null, false);
        }
    }

    private void setKeyUsages(String[] keyUsages) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (keyUsages != null) {
                this.xfaSeedValue.setKeyUsages(keyUsages[0].toCharArray(), false);
            } else {
                this.xfaSeedValue.setKeyUsages(null, false);
            }
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFInvalidParameterException("Exception when setting XFA Key Usages Seed", (Throwable)e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException("Exception when setting XFA Key Usages Seed", (Throwable)e);
        }
    }

    private void setURL(String url, ASName urlType) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            String urlTypeStr = null;
            if (urlType != null) {
                urlTypeStr = urlType.asString(true);
            }
            this.xfaSeedValue.setURL(url, urlTypeStr, false);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFInvalidParameterException("Exception when setting XFA URL, URLType Seed", (Throwable)e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidParameterException("Exception when setting XFA URL, URLType Seed", (Throwable)e);
        }
    }

    private void setSubjectDN(List<Map> subjectDNList) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (subjectDNList != null) {
            Iterator<Map> subjectDNIter = subjectDNList.iterator();
            if (subjectDNIter != null) {
                ArrayList<String> subjectDNS = new ArrayList<String>();
                StringBuilder dnBuffer = new StringBuilder();
                while (subjectDNIter.hasNext()) {
                    Map dnMap = subjectDNIter.next();
                    Iterator iter = dnMap.entrySet().iterator();
                    while (iter.hasNext()) {
                        Map.Entry entry = iter.next();
                        dnBuffer.append((String)entry.getKey()).append('=').append((String)entry.getValue());
                        if (!iter.hasNext()) continue;
                        dnBuffer.append(';');
                    }
                    subjectDNS.add(dnBuffer.toString());
                    dnBuffer.delete(0, dnBuffer.length());
                }
                this.xfaSeedValue.setSubjectDNS(subjectDNS, ";", false);
            }
        } else {
            this.xfaSeedValue.setSubjectDNS(null, null, false);
        }
    }

    private void setCertificateFlags(Integer flags) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this.xfaSeedValue.setCertificateSeedValueFlags(flags);
    }

    @Override
    public SigCertificateSeedValue getCertificateSeedValue() throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SigCertificateSeedValue certificateSeedValue = new SigCertificateSeedValue();
        certificateSeedValue.setIssuers(this.getIssuers());
        certificateSeedValue.setKeyUsages(this.getKeyUsage());
        certificateSeedValue.setOIDS(this.getOIDS());
        certificateSeedValue.setSubjectDN(this.getSubjectDN());
        certificateSeedValue.setSubjects(this.getSubjects());
        certificateSeedValue.setURL(this.getURL());
        certificateSeedValue.setURLType(this.getURLType());
        certificateSeedValue.setFlags(this.getCertificateFlags());
        if (certificateSeedValue.getIssuers() != null || certificateSeedValue.getKeyUsages() != null || certificateSeedValue.getOIDS() != null || certificateSeedValue.getSubjectDN() != null || certificateSeedValue.getURL() != null || certificateSeedValue.getFlags() != 0) {
            return certificateSeedValue;
        }
        return null;
    }

    @Override
    public void setCertificateSeedValue(SigCertificateSeedValue certificateSeedValue) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidXMLException {
        if (certificateSeedValue != null) {
            byte[][] newIssuers = certificateSeedValue.getIssuers();
            byte[][] currentIssuers = this.getIssuers();
            if (newIssuers != null && newIssuers.length > 0) {
                if (currentIssuers != null && currentIssuers.length > 0) {
                    if (currentIssuers.length == newIssuers.length) {
                        for (int i = 0; i < currentIssuers.length; ++i) {
                            if (Arrays.equals(currentIssuers[i], newIssuers[i])) continue;
                            this.setIssuers(newIssuers);
                            break;
                        }
                    } else {
                        this.setIssuers(newIssuers);
                    }
                } else {
                    this.setIssuers(newIssuers);
                }
            } else if (currentIssuers != null && currentIssuers.length > 0) {
                this.setIssuers(null);
            }
            Object[] newList = certificateSeedValue.getKeyUsages();
            Object[] existingList = this.getKeyUsage();
            if (newList != null && newList.length > 0) {
                if (existingList != null && newList.length > 0) {
                    Arrays.sort(newList);
                    Arrays.sort(existingList);
                    if (!Arrays.equals(newList, existingList)) {
                        this.setKeyUsages((String[])newList);
                    }
                } else {
                    this.setKeyUsages((String[])newList);
                }
            } else if (existingList != null && existingList.length > 0) {
                this.setKeyUsages(null);
            }
            newList = certificateSeedValue.getOIDS();
            existingList = this.getOIDS();
            if (newList != null && newList.length > 0) {
                if (existingList != null && existingList.length > 0) {
                    Arrays.sort(newList);
                    Arrays.sort(existingList);
                    if (!Arrays.equals(newList, existingList)) {
                        this.setOIDS((String[])newList);
                    }
                } else {
                    this.setOIDS((String[])newList);
                }
            } else if (existingList != null && existingList.length > 0) {
                this.setOIDS(null);
            }
            if (certificateSeedValue.getSubjectDN() != null) {
                if (!certificateSeedValue.getSubjectDN().equals(this.getSubjectDN())) {
                    this.setSubjectDN(certificateSeedValue.getSubjectDN());
                }
            } else if (this.getSubjectDN() != null) {
                this.setSubjectDN(null);
            }
            byte[][] newSubjects = certificateSeedValue.getSubjects();
            byte[][] currentSubjects = this.getSubjects();
            if (newSubjects != null && newSubjects.length > 0) {
                if (currentSubjects != null && currentSubjects.length > 0) {
                    if (currentSubjects.length == newSubjects.length) {
                        for (int i = 0; i < currentSubjects.length; ++i) {
                            if (Arrays.equals(currentSubjects[i], newSubjects[i])) continue;
                            this.setSubject(newSubjects);
                            break;
                        }
                    } else {
                        this.setSubject(newSubjects);
                    }
                } else {
                    this.setSubject(newSubjects);
                }
            } else if (currentSubjects != null && currentSubjects.length > 0) {
                this.setSubject(null);
            }
            if (certificateSeedValue.getURL() != null) {
                if (!certificateSeedValue.getURL().equalsIgnoreCase(this.getURL()) || certificateSeedValue.getURLType() != this.getURLType()) {
                    this.setURL(certificateSeedValue.getURL(), certificateSeedValue.getURLType());
                }
            } else if (this.getURL() != null) {
                this.setURL(null, null);
            }
            if (certificateSeedValue.getFlags() == null && this.getCertificateFlags() != null) {
                this.setCertificateFlags(null);
            } else if (!certificateSeedValue.getFlags().equals(this.getCertificateFlags())) {
                this.setCertificateFlags(certificateSeedValue.getFlags());
            }
        } else if (this.getCertificateSeedValue() != null) {
            this.setIssuers(null);
            this.setKeyUsages(null);
            this.setOIDS(null);
            this.setSubjectDN(null);
            this.setSubject(null);
            this.setURL(null, null);
            this.setFlags(null);
        }
    }
}

