/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.io.ByteWriter;
import com.adobe.internal.pdftoolkit.core.cos.CosCloneMgr;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocumentProxy;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedXFAImages;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveIncrementalOptions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFSaveOptions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsDocMDP;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsLeanDoc;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.XFADigSigWorkFlow;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SigningUtils;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.impl.PDFFormSupport;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFAInternalUtils;
import java.util.Iterator;

class SignatureDocumentProxy
extends PDFDocumentProxy {
    SignatureDocumentProxy(PDFDocument pdfDocument) {
        super(pdfDocument);
    }

    protected void preSave(SignatureOptions sigOptions, XFADigSigWorkFlow workFlow) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException, PDFUnableToCompleteOperationException {
        workFlow.handleLeanDocGeneration(sigOptions instanceof SignatureOptionsLeanDoc ? (SignatureOptionsLeanDoc)sigOptions : null);
        if (sigOptions.getSaveOptions() instanceof PDFSaveIncrementalOptions) {
            XFAInternalUtils.enableMergeIncrSectionsDuringLeanDocGeneration(this.pdfDocument);
        }
        super.preSave(sigOptions.getSaveOptions());
        if (workFlow.isFormModelWorkFlow() && SignatureDocumentProxy.shouldSnapshotBeAdded(this.pdfDocument, sigOptions)) {
            try (PDFDocument pdfDocSnapshot = null;){
                PDFNamedXFAImages xfaImages = null;
                PDFNameDictionary nameDict = this.pdfDocument.requireCatalog().getNameDictionary();
                if (nameDict != null) {
                    xfaImages = nameDict.getNamedXFAImages();
                }
                pdfDocSnapshot = sigOptions.getSnapshotGenerator().generate(PDFFormSupport.getFullXFAStream(this.pdfDocument.getInteractiveForm()).toInputStream(), true, xfaImages);
                SignatureDocumentProxy.syncSavedDocWithSnapshotDoc(pdfDocSnapshot, this.pdfDocument);
                this.pdfDocument.requireCatalog().removeValue(ASName.k_NeedsRendering);
            }
        }
    }

    private static void syncSavedDocWithSnapshotDoc(PDFDocument pdfDocSnapshot, PDFDocument currentSavedDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (pdfDocSnapshot == null) {
            throw new PDFInvalidParameterException("Snapshot document generated is either null or invalid.");
        }
        PDFPageTree pdfDocSnapshotPageTree = pdfDocSnapshot.requirePages();
        CosCloneMgr cloneMgr = new CosCloneMgr(currentSavedDoc.getCosDocument());
        PDFPageTree newCurrentSavedDocPageTree = PDFPageTree.getInstance((CosObject)cloneMgr.clone(pdfDocSnapshotPageTree.getCosObject()));
        currentSavedDoc.requireCatalog().setDictionaryValue(ASName.k_Pages, (PDFCosObject)newCurrentSavedDocPageTree);
        PDFAnnotationList annotsList = null;
        PDFPage page = null;
        PDFAnnotation annot = null;
        PDFFieldSignature sigField = null;
        PDFAnnotationIterator annotItr = null;
        Iterator pageItr = currentSavedDoc.requirePages().iterator();
        PDFAnnotationWidget nodeAnnot = null;
        while (pageItr.hasNext()) {
            page = (PDFPage)pageItr.next();
            annotsList = page.getAnnotationList();
            if (annotsList == null) continue;
            annotItr = annotsList.iterator();
            while (annotItr.hasNext()) {
                PDFFieldNode node;
                annot = annotItr.next();
                sigField = PDFFieldSignature.getInstance((CosObject)annot.getCosObject());
                PDFFieldNode parent = SignatureDocumentProxy.procureParent(sigField);
                PDFFieldNode pDFFieldNode = node = parent.getChildren() != null ? parent.getChildren().getFieldNamed(sigField.getPartialName()) : null;
                if (node != null && new SignatureFieldPDF((PDFFieldSignature)node).isSigned()) {
                    if (annot.getCosObject() == node.getCosObject()) continue;
                    annotItr.remove();
                    nodeAnnot = ((PDFFieldSignature)node).getAnnotation();
                    annotsList.add((PDFAnnotation)nodeAnnot);
                    nodeAnnot.setPage(page);
                    nodeAnnot.setRect(sigField.getAnnotation().getRect().llx(), sigField.getAnnotation().getRect().lly(), sigField.getAnnotation().getRect().urx(), sigField.getAnnotation().getRect().ury());
                    continue;
                }
                if (node != null) {
                    parent.removeChild(node);
                }
                parent.addChild((PDFFieldNode)sigField);
            }
        }
    }

    private static PDFFieldNode procureParent(PDFFieldSignature sigField) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm currentField = sigField.getPDFDocument().getInteractiveForm();
        PDFFieldList currentFieldChildren = null;
        String[] partialNames = sigField.getQualifiedName().split("\\.");
        PDFFieldNode createdNode = null;
        for (int i = 0; i < partialNames.length - 1; ++i) {
            currentFieldChildren = currentField.getChildren();
            if (currentFieldChildren == null || (createdNode = currentFieldChildren.getFieldNamed(partialNames[i])) == null) {
                createdNode = PDFFieldNode.newInstance((PDFDocument)sigField.getPDFDocument());
                createdNode.setPartialName(partialNames[i]);
                currentField.addChild(createdNode);
            }
            currentField = createdNode;
        }
        return currentField;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean shouldSnapshotBeAdded(PDFDocument pdfDoc, SignatureOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (!options.getSnapshotGenerationEnabled()) {
            return false;
        }
        if (XFAService.getDocumentType(pdfDoc).isDynamic() && SigningUtils.isCertification(options)) {
            if (((SignatureOptionsDocMDP)options).leanDocumentGenerationEnabled()) return false;
            if (options.getSnapshotGenerator() != null) {
                return true;
            }
            if (XFAService.getDocumentType(pdfDoc) == PDFDocument.PDFDocumentType.DynamicShellXFA) {
                throw new PDFInvalidParameterException("Document is dynamic shell but neither lean document generation is enabled nor snapshot generator is provided.");
            }
        } else if (XFAService.getDocumentType(pdfDoc) == PDFDocument.PDFDocumentType.StaticShellXFA && options.getSnapshotGenerator() == null) {
            throw new PDFInvalidParameterException("Document is static shell but snapshot generator is not provided.");
        }
        if (!XFAService.getDocumentType(pdfDoc).isDynamic() || options.getSigningType() == SigningUtils.SigningType.UsageRights) {
            if (XFAService.getDocumentType(pdfDoc) != PDFDocument.PDFDocumentType.StaticShellXFA) return false;
        }
        if (options.getSnapshotGenerator() == null) return false;
        return true;
    }

    protected void doSave(ByteWriter byteWriter, PDFSaveOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        super.doSave(byteWriter, options);
    }

    protected void postSave(PDFSaveOptions options) throws PDFInvalidDocumentException, PDFIOException, PDFInvalidParameterException, PDFSecurityException {
        super.postSave(options);
    }
}

