/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.impl;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASDate;
import com.adobe.internal.pdftoolkit.core.types.ASMatrix;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASRectangle;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRotation;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObject;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectForm;
import com.adobe.internal.pdftoolkit.pdf.graphics.xobject.PDFXObjectMap;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAppearanceCharacteristics;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFBorderStyle;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFVariableText;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.ap.StyleAttributes;
import com.adobe.internal.pdftoolkit.services.ap.impl.AppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.BorderAppearanceUtils;
import com.adobe.internal.pdftoolkit.services.ap.impl.DefaultFont;
import com.adobe.internal.pdftoolkit.services.ap.impl.TextAppearance;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureAppearanceDirectionality;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureAppearanceDisplayItemsSet;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureAppearanceOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.impl.DNUtils;
import com.adobe.internal.pdftoolkit.services.rcg.RCGAlignment;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOptions;
import com.adobe.internal.pdftoolkit.services.rcg.RCGOverflowMode;
import com.adobe.internal.pdftoolkit.services.rcg.RCGWrapOption;
import com.adobe.internal.pdftoolkit.services.rcg.impl.RichTextHandler;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xobjhandler.PageContentXObject;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectApplyOptions;
import com.adobe.internal.pdftoolkit.services.xobjhandler.XObjectUseOptions;
import com.rsa.certj.cert.X509Certificate;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public final class SignatureAppearance {
    private static final ASName k_DefaultFont = ASName.create((String)"Helv");
    private static final ASName k_n0 = ASName.create((String)"n0");
    private static final ASName k_n2 = ASName.create((String)"n2");
    private static final int k_TextAlignmentRight = 2;
    private static final String DIGITALLY_SIGNED_BY = "DigitallySignedBy";
    private static final String DISTINGUISHED_NAME = "DistinguishedName";
    private static final String REASON = "Reason";
    private static final String LOCATION = "Location";
    private static final String DATE = "Date";

    private SignatureAppearance() {
    }

    public static void createSignatureAppearance(SignatureFieldInterface sigField, X509Certificate signerCertificate, SignatureAppearanceOptions appearanceOptions, ASRectangle dynXFAFieldBBox) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException {
        String signerName = DNUtils.getSignerName(signerCertificate);
        String displayName = DNUtils.getDisplayDN(signerCertificate);
        SignatureAppearance.generateSignatureAppearance(sigField, appearanceOptions, dynXFAFieldBBox, signerName, displayName);
    }

    private static void generateSignatureAppearance(SignatureFieldInterface sigField, SignatureAppearanceOptions appearanceOptions, ASRectangle dynXFAFieldBBox, String signerName, String displayName) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFCosParseException, PDFConfigurationException, PDFFontException {
        PDFSignature signature = sigField.getPDFField().getPDFFieldSignature().getSignature();
        if (signerName == null || signerName.trim().equals("")) {
            signerName = signature.getName();
        }
        boolean directionalityLTR = SignatureAppearance.isDirectionalityLTR(signerName, displayName, appearanceOptions, sigField.getPDFField().getPDFFieldSignature().getSignature());
        ASName[] pdfProcSet = new ASName[1];
        PDFDocument pdfDoc = sigField.getPDFDocument();
        PDFAnnotationWidget annot = sigField.getPDFField().getPDFFieldSignature().getAnnotation();
        PDFRectangle annotRect = annot.getRect();
        ASRectangle appearanceRect = dynXFAFieldBBox != null ? dynXFAFieldBBox : (annotRect.hasNonZeroDimensions() ? new ASRectangle(annotRect.getValues()) : appearanceOptions.getInvisibleAppearanceSize());
        SignatureAppearance.configureInteractiveFormResources(pdfDoc);
        PDFXObjectForm n2Form = SignatureAppearance.createN2Form(sigField, appearanceRect, appearanceOptions, signerName, displayName, directionalityLTR);
        PDFRectangle xObjBBox = PDFRectangle.newInstance((PDFDocument)pdfDoc, (double)0.0, (double)0.0, (double)appearanceRect.width(), (double)appearanceRect.height());
        ASName[] textProcSet = new ASName[]{ASName.k_Text};
        PDFResources resources = PDFResources.newInstance((PDFDocument)pdfDoc);
        resources.setProcSetList(textProcSet);
        PDFXObjectForm n0Form = null;
        n0Form = SignatureAppearance.createN0Form(pdfDoc, xObjBBox, annot, sigField, resources);
        PDFXObjectForm secondLevelForm = PDFXObjectForm.newInstance((PDFDocument)pdfDoc);
        secondLevelForm.setBBox(xObjBBox);
        PDFResources secondLevelResources = PDFResources.newInstance((PDFDocument)pdfDoc);
        pdfProcSet[0] = ASName.k_PDF;
        secondLevelResources.setProcSetList(pdfProcSet);
        PDFXObjectMap secondLevelXObjMap = PDFXObjectMap.newInstance((PDFDocument)pdfDoc);
        if (n0Form != null) {
            secondLevelXObjMap.set(k_n0, (PDFXObject)n0Form);
        }
        secondLevelXObjMap.set(k_n2, (PDFXObject)n2Form);
        secondLevelResources.setXObjectMap(secondLevelXObjMap);
        secondLevelForm.setResources(secondLevelResources);
        secondLevelForm.setMatrix(ASMatrix.createIdentityMatrix().getValues());
        String secondLevelStr = "q 1 0 0 1 0 0 cm /" + k_n0.asString(true) + " Do Q\r" + "q 1 0 0 1 0 0 cm /" + k_n2.asString(true) + " Do Q\r";
        try {
            secondLevelForm.setStream(sigField.getPDFDocument().getStreamManager().getInputByteStream(secondLevelStr.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF8 encoding is not supported.", e);
        }
        catch (IOException e) {
            throw new PDFIOException("IO exception encountered when creating signature appearances", (Throwable)e);
        }
        PDFXObjectForm topForm = PDFXObjectForm.newInstance((PDFDocument)pdfDoc);
        topForm.setBBox(xObjBBox);
        PDFResources topResources = PDFResources.newInstance((PDFDocument)pdfDoc);
        topResources.setProcSetList(pdfProcSet);
        PDFXObjectMap topXObjMap = PDFXObjectMap.newInstance((PDFDocument)pdfDoc);
        topXObjMap.set(ASName.create((String)"FRM"), (PDFXObject)secondLevelForm);
        topResources.setXObjectMap(topXObjMap);
        topForm.setResources(topResources);
        String topStr = "q 1 0 0 1 0 0 cm /FRM Do Q\r";
        try {
            topForm.setStream(sigField.getPDFDocument().getStreamManager().getInputByteStream(topStr.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Encoding exception encountered when creating signature appearances", e);
        }
        catch (PDFIOException e) {
            throw new PDFIOException("IO exception encountered when creating signature appearances", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException("IO exception encountered when creating signature appearances", (Throwable)e);
        }
        PDFAppearance annotAppearance = PDFAppearance.newInstance((PDFDocument)pdfDoc);
        annotAppearance = annotAppearance.setNormalStateAppearance(annot.getAppearanceState(), topForm);
        annot.setAppearance(annotAppearance);
    }

    private static PDFXObjectForm createN2Form(SignatureFieldInterface sigField, ASRectangle appearanceRect, SignatureAppearanceOptions signatureAppearanceOptions, String signerName, String displayName, boolean directionalityLTR) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException {
        XObjectUseOptions useOptions;
        double oneSideMarginY;
        double pictureheight;
        double picturewidth;
        double hPictureScale;
        PDFXObjectForm pictureXobject;
        PDFAppearanceCharacteristics apCharact;
        PDFDocument pdfDoc = sigField.getPDFDocument();
        PDFAnnotationWidget annot = sigField.getPDFField().getPDFFieldSignature().getAnnotation();
        double appearanceWidth = appearanceRect.width();
        double appearanceHeight = appearanceRect.height();
        double appearanceX = 0.0;
        double appearanceY = 0.0;
        PDFXObjectForm n2Form = PDFXObjectForm.newInstance((PDFDocument)pdfDoc);
        PDFRotation widgetRotation = PDFRotation.ROTATE_0;
        if (annot.hasAppearanceCharacteristics() && (apCharact = annot.getAppearanceCharacteristics()).getRotation() != null) {
            widgetRotation = apCharact.getRotation();
        }
        if (widgetRotation.equals((Object)PDFRotation.ROTATE_90) || widgetRotation.equals((Object)PDFRotation.ROTATE_270)) {
            double temp = appearanceWidth;
            appearanceWidth = appearanceHeight;
            appearanceHeight = temp;
        }
        PDFRectangle xObjectFormBBox = PDFRectangle.newInstance((PDFDocument)pdfDoc, (double)appearanceX, (double)appearanceY, (double)appearanceWidth, (double)appearanceHeight);
        n2Form.setBBox(xObjectFormBBox);
        boolean bLandScape = appearanceWidth >= appearanceHeight;
        double sigDataWidth = 0.0;
        double sigDataHeight = 0.0;
        double xPicture = 0.0;
        double yPicture = 0.0;
        double xSigData = 0.0;
        double ySigData = 0.0;
        XObjectApplyOptions applyOptions = new XObjectApplyOptions();
        xSigData = 0.0;
        ySigData = 0.0;
        sigDataWidth = appearanceWidth;
        sigDataHeight = appearanceHeight;
        if (!signatureAppearanceOptions.hasDisplayItems()) {
            SignatureAppearanceDisplayItemsSet defaultDisplayItems = SignatureAppearanceDisplayItemsSet.newInstance(SignatureAppearanceDisplayItemsSet.kShowAll);
            signatureAppearanceOptions.setDisplayItems(defaultDisplayItems);
            signatureAppearanceOptions.setGraphicName();
        }
        if (SignatureAppearance.displayGraphicOnly(signatureAppearanceOptions)) {
            double oneSideMarginX;
            xPicture = 0.0;
            xPicture = 0.0;
            pictureXobject = SignatureAppearance.getPictureXobject(signatureAppearanceOptions, pdfDoc);
            double vPictureScale = 1.0;
            hPictureScale = 1.0;
            picturewidth = pictureXobject.getBBox().width();
            pictureheight = pictureXobject.getBBox().height();
            vPictureScale = appearanceHeight / pictureheight;
            if (vPictureScale > (hPictureScale = appearanceWidth / picturewidth)) {
                vPictureScale = hPictureScale;
            } else {
                hPictureScale = vPictureScale;
            }
            xPicture = oneSideMarginX = (appearanceWidth - picturewidth * hPictureScale) / 2.0;
            yPicture = oneSideMarginY = (appearanceHeight - pictureheight * vPictureScale) / 2.0;
            applyOptions.setHScale(hPictureScale);
            applyOptions.setVScale(vPictureScale);
            applyOptions.setOpacity(signatureAppearanceOptions.getGraphicsOpacity());
            applyOptions.setPosition(xPicture, yPicture);
            useOptions = new XObjectUseOptions();
            useOptions.makeForeground();
            applyOptions.applyXObjectForm(n2Form, (PDFXObject)pictureXobject, useOptions);
        } else {
            XObjectUseOptions useOptions2;
            if (SignatureAppearance.hasDisplayItems(signatureAppearanceOptions) && signatureAppearanceOptions.hasGraphic()) {
                xPicture = 0.0;
                ySigData = 0.0;
                if (bLandScape) {
                    yPicture = 0.0;
                    xSigData = appearanceWidth / 2.0;
                } else {
                    yPicture = appearanceHeight / 2.0;
                    xSigData = 0.0;
                }
                if (bLandScape) {
                    sigDataWidth /= 2.0;
                } else {
                    sigDataHeight /= 2.0;
                }
                if (signatureAppearanceOptions.hasGraphicImage() && !signatureAppearanceOptions.hasGraphicName()) {
                    double oneSideMarginX;
                    pictureXobject = SignatureAppearance.getPictureXobject(signatureAppearanceOptions, pdfDoc);
                    double vPictureScale = 1.0;
                    hPictureScale = 1.0;
                    picturewidth = pictureXobject.getBBox().width();
                    pictureheight = pictureXobject.getBBox().height();
                    vPictureScale = appearanceHeight / pictureheight;
                    hPictureScale = appearanceWidth / picturewidth;
                    if (bLandScape) {
                        if (vPictureScale > (hPictureScale /= 2.0)) {
                            vPictureScale = hPictureScale;
                        } else {
                            hPictureScale = vPictureScale;
                        }
                        xPicture = oneSideMarginX = (appearanceWidth / 2.0 - picturewidth * hPictureScale) / 2.0;
                        yPicture = oneSideMarginY = (appearanceHeight - pictureheight * vPictureScale) / 2.0;
                    } else {
                        if ((vPictureScale /= 2.0) > hPictureScale) {
                            vPictureScale = hPictureScale;
                        } else {
                            hPictureScale = vPictureScale;
                        }
                        xPicture = oneSideMarginX = (appearanceWidth - picturewidth * hPictureScale) / 2.0;
                        oneSideMarginY = (appearanceHeight / 2.0 - pictureheight * vPictureScale) / 2.0;
                        yPicture = appearanceHeight / 2.0 + oneSideMarginY;
                    }
                    if (!directionalityLTR && bLandScape) {
                        double temp1 = xPicture;
                        double temp2 = yPicture;
                        xPicture = xSigData + temp1;
                        yPicture = ySigData + temp2;
                        xSigData = 0.0;
                        ySigData = 0.0;
                    }
                    applyOptions.setHScale(hPictureScale);
                    applyOptions.setVScale(vPictureScale);
                    applyOptions.setOpacity(signatureAppearanceOptions.getGraphicsOpacity());
                    applyOptions.setPosition(xPicture, yPicture);
                    XObjectUseOptions useOptions3 = new XObjectUseOptions();
                    useOptions3.makeForeground();
                    applyOptions.applyXObjectForm(n2Form, (PDFXObject)pictureXobject, useOptions3);
                }
                if (signatureAppearanceOptions.hasGraphicName()) {
                    PDFXObjectForm nameXobject = SignatureAppearance.getNameXobject(sigField, signerName, signatureAppearanceOptions, pdfDoc, sigDataWidth, sigDataHeight, directionalityLTR);
                    PDFRectangle nameXobjectBBox = PDFRectangle.newInstance((PDFDocument)pdfDoc, (double)0.5, (double)0.5, (double)sigDataWidth, (double)sigDataHeight);
                    nameXobject.setBBox(nameXobjectBBox);
                    if (!directionalityLTR && bLandScape) {
                        double temp1 = xPicture;
                        double temp2 = yPicture;
                        xPicture = xSigData + temp1;
                        yPicture = ySigData + temp2;
                        xSigData = 0.0;
                        ySigData = 0.0;
                    }
                    applyOptions.setPosition(xPicture, yPicture);
                    applyOptions.setHScale(1.0);
                    applyOptions.setVScale(1.0);
                    applyOptions.setOpacity(1.0);
                    useOptions2 = new XObjectUseOptions();
                    useOptions2.makeForeground();
                    applyOptions.applyXObjectForm(n2Form, (PDFXObject)nameXobject, useOptions2);
                }
            }
            applyOptions = null;
            applyOptions = new XObjectApplyOptions();
            applyOptions.setPosition(xSigData, ySigData);
            applyOptions.setHScale(1.0);
            applyOptions.setVScale(1.0);
            applyOptions.setOpacity(1.0);
            PDFXObjectForm rtfXobject = SignatureAppearance.getRTFXObject(sigField, signatureAppearanceOptions, pdfDoc, sigDataWidth, sigDataHeight, signerName, displayName, directionalityLTR);
            if (rtfXobject != null) {
                PDFRectangle rtfXobjectBBox = PDFRectangle.newInstance((PDFDocument)pdfDoc, (double)0.5, (double)0.5, (double)sigDataWidth, (double)sigDataHeight);
                rtfXobject.setBBox(rtfXobjectBBox);
                useOptions2 = new XObjectUseOptions();
                useOptions2.makeForeground();
                applyOptions.applyXObjectForm(n2Form, (PDFXObject)rtfXobject, useOptions2);
            }
        }
        applyOptions = null;
        applyOptions = new XObjectApplyOptions();
        if (signatureAppearanceOptions.hasLogo()) {
            PDFXObjectForm logoXobject = SignatureAppearance.getLogoXObjectBbox(signatureAppearanceOptions, pdfDoc);
            double logoWidth = logoXobject.getBBox().width();
            double logoHeight = logoXobject.getBBox().height();
            double vLogoScale = 1.0;
            double hLogoScale = 1.0;
            double xLogo = 0.0;
            double yLogo = 0.0;
            vLogoScale = appearanceHeight / logoHeight;
            hLogoScale = appearanceWidth / logoWidth;
            if (vLogoScale > hLogoScale) {
                vLogoScale = hLogoScale;
                yLogo = (appearanceHeight - vLogoScale * logoHeight) / 2.0;
            } else {
                hLogoScale = vLogoScale;
                xLogo = (appearanceWidth - hLogoScale * logoWidth) / 2.0;
            }
            applyOptions.setPosition(xLogo, yLogo);
            applyOptions.setHScale(hLogoScale);
            applyOptions.setVScale(vLogoScale);
            applyOptions.setOpacity(signatureAppearanceOptions.getLogoOpacity());
            useOptions = new XObjectUseOptions();
            useOptions.makeBackground();
            applyOptions.applyXObjectForm(n2Form, (PDFXObject)logoXobject, useOptions);
        }
        if (!widgetRotation.equals((Object)PDFRotation.ROTATE_0)) {
            double[] xobjMatrix = n2Form.getMatrix();
            ASMatrix matrix = xobjMatrix == null ? ASMatrix.createIdentityMatrix() : new ASMatrix(xobjMatrix);
            PDFRectangle bBoxRect = AppearanceUtils.getBBoxRectangle(annot);
            matrix = matrix.translate(-(bBoxRect.left() + bBoxRect.right()) / 2.0, -(bBoxRect.bottom() + bBoxRect.top()) / 2.0);
            matrix = matrix.rotate(Math.toRadians(widgetRotation.getValue()));
            matrix = widgetRotation == PDFRotation.ROTATE_180 ? matrix.translate((bBoxRect.left() + bBoxRect.right()) / 2.0, (bBoxRect.bottom() + bBoxRect.top()) / 2.0) : matrix.translate((bBoxRect.bottom() + bBoxRect.top()) / 2.0, (bBoxRect.left() + bBoxRect.right()) / 2.0);
            matrix = matrix.translate(-bBoxRect.left(), -bBoxRect.bottom());
            n2Form.setMatrix(matrix.getValues());
        }
        return n2Form;
    }

    private static PDFXObjectForm getLogoXObjectBbox(SignatureAppearanceOptions signatureAppearanceOptions, PDFDocument pDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFXObjectForm logoXobject = null;
        if (signatureAppearanceOptions.hasLogo()) {
            PDFPage pdfPage = signatureAppearanceOptions.getLogo();
            logoXobject = PageContentXObject.generateContentXObject((PDFDocument)pDoc, (PDFPage)pdfPage, null);
        }
        return logoXobject;
    }

    private static PDFXObjectForm getPictureXobject(SignatureAppearanceOptions signatureAppearanceOptions, PDFDocument pDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFPage pdfPage = signatureAppearanceOptions.getGraphicImage();
        return PageContentXObject.generateContentXObject((PDFDocument)pDoc, (PDFPage)pdfPage, null);
    }

    private static PDFXObjectForm getRTFXObject(SignatureFieldInterface sigField, SignatureAppearanceOptions signatureAppearanceOptions, PDFDocument pdfDoc, double width, double height, String name, String dn, boolean directionalityLTR) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException {
        Locale curLocale = new Locale("en", "US");
        boolean displayGraphicOnly = SignatureAppearance.displayGraphicOnly(signatureAppearanceOptions);
        if (displayGraphicOnly) {
            return null;
        }
        List<Object> valueList = new ArrayList<String>();
        PDFSignature signature = sigField.getPDFField().getPDFFieldSignature().getSignature();
        String reason = null;
        String location = null;
        String date = null;
        if (name == null) {
            name = "<none>";
        }
        reason = signature.getReason();
        location = signature.getLocation();
        ASDate asDate = null;
        asDate = signature.getDate();
        if (asDate != null) {
            date = signatureAppearanceOptions.hasDateFormat() ? signatureAppearanceOptions.getDateFormat().getFormattedDate(asDate) : SignatureAppearance.getFormattedDate(asDate);
        }
        SignatureAppearanceDisplayItemsSet displayItems = signatureAppearanceOptions.getDisplayItems();
        if (!SignatureAppearance.hasDisplayItems(signatureAppearanceOptions) && !SignatureAppearance.displayGraphicOnly(signatureAppearanceOptions)) {
            if (signatureAppearanceOptions.hasGraphicName()) {
                displayItems = SignatureAppearanceDisplayItemsSet.newInstance(null);
                displayItems.enable(SignatureAppearanceDisplayItemsSet.kShowName);
            } else {
                displayItems = SignatureAppearanceDisplayItemsSet.newInstance(null);
                displayItems.enable(SignatureAppearanceDisplayItemsSet.kShowName);
                displayItems.enable(SignatureAppearanceDisplayItemsSet.kShowLabels);
            }
        }
        if (signatureAppearanceOptions.getLocale() != null) {
            curLocale = signatureAppearanceOptions.getLocale();
        }
        String BUNDLE_NAME = "com.adobe.internal.pdftoolkit.core.localiseddisplaystrings.SignatureString";
        if (displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowLabels)) {
            valueList = SignatureAppearance.buildSignatureMessageForDisplay(name, dn, reason, location, date, curLocale, BUNDLE_NAME, displayItems);
        }
        if (valueList.isEmpty() && !displayGraphicOnly) {
            if (SignatureAppearance.hasDisplayItems(signatureAppearanceOptions) && !displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowLabels)) {
                name = SignatureAppearance.getValueForLocaleFromBundle(DIGITALLY_SIGNED_BY, curLocale, BUNDLE_NAME) + " : " + name;
                valueList.add(name);
            } else {
                valueList.add(dn);
            }
        }
        PDFXObjectForm appearance = SignatureAppearance.getAppearanceXObjectForm(sigField, signatureAppearanceOptions, pdfDoc, width, height, valueList, directionalityLTR);
        return appearance;
    }

    private static boolean validateStringParam(String test) {
        return test != null && test.length() > 0;
    }

    private static List<String> buildSignatureMessageForDisplay(String name, String dn, String reason, String location, String date, Locale curLocale, String bundleName, SignatureAppearanceDisplayItemsSet displayItems) {
        ArrayList<String> keys = new ArrayList<String>(10);
        keys.add(DIGITALLY_SIGNED_BY);
        keys.add(DISTINGUISHED_NAME);
        keys.add(REASON);
        keys.add(LOCATION);
        keys.add(DATE);
        HashMap<String, String> map = SignatureAppearance.fetchValuesFromBundleForLocale(keys, curLocale, bundleName);
        ArrayList<String> valueList = new ArrayList<String>(10);
        if (displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowName) && SignatureAppearance.validateStringParam(name)) {
            valueList.add(map.get(DIGITALLY_SIGNED_BY) + " " + name);
        }
        if (displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowDN) && SignatureAppearance.validateStringParam(dn)) {
            valueList.add(map.get(DISTINGUISHED_NAME) + " " + dn);
        }
        if (displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowReason) && SignatureAppearance.validateStringParam(reason)) {
            valueList.add(map.get(REASON) + " " + reason);
        }
        if (displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowLocation) && SignatureAppearance.validateStringParam(location)) {
            valueList.add(map.get(LOCATION) + " " + location);
        }
        if (displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowDate) && SignatureAppearance.validateStringParam(date)) {
            valueList.add(map.get(DATE) + " " + date);
        }
        return valueList;
    }

    private static HashMap<String, String> fetchValuesFromBundleForLocale(List<String> keys, Locale locale, String bundleName) {
        ResourceBundle bundle = ResourceBundle.getBundle(bundleName, locale);
        if (bundle == null) {
            return null;
        }
        HashMap<String, String> values = new HashMap<String, String>(keys.size());
        try {
            for (String key : keys) {
                String value = new String(bundle.getString(key).getBytes("ISO-8859-1"), "UTF-8");
                values.put(key, value);
            }
        }
        catch (UnsupportedEncodingException e) {
            bundle = ResourceBundle.getBundle(bundleName, Locale.US);
            for (String key : keys) {
                String value = new String(bundle.getString(key));
                values.put(key, value);
            }
        }
        return values;
    }

    private static String getValueForLocaleFromBundle(String key, Locale curLocale, String bundleName) {
        ResourceBundle bundle;
        if (bundleName == null || key == null) {
            return null;
        }
        if (curLocale == null) {
            curLocale = Locale.US;
        }
        if ((bundle = ResourceBundle.getBundle(bundleName, curLocale)) == null) {
            return null;
        }
        String value = null;
        try {
            value = new String(bundle.getString(key).getBytes("ISO-8859-1"), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            bundle = ResourceBundle.getBundle(bundleName, Locale.US);
            value = new String(bundle.getString(key));
        }
        return value;
    }

    private static String getFormattedDate(ASDate asDate) {
        String dateTimeFormat = "yyyy.MM.dd HH:mm:ss Z";
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateTimeFormat);
        simpleDateFormat.setTimeZone(asDate.getTimeZone());
        String date = SignatureAppearance.formatDate(simpleDateFormat.format(asDate.toDate()));
        return date;
    }

    private static PDFXObjectForm getNameXobject(SignatureFieldInterface sigField, String signerName, SignatureAppearanceOptions signatureAppearanceOptions, PDFDocument pdfDoc, double width, double height, boolean directionalityLTR) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException {
        PDFXObjectForm appearance = null;
        if (signerName == null) {
            signerName = "<none>";
        }
        ArrayList<String> valueList = new ArrayList<String>();
        valueList.add(signerName);
        appearance = SignatureAppearance.getAppearanceXObjectForm(sigField, signatureAppearanceOptions, pdfDoc, width, height, valueList, directionalityLTR);
        return appearance;
    }

    private static void configureInteractiveFormResources(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException {
        PDFInteractiveForm iform = pdfDoc.requireCatalog().procureInteractiveForm();
        PDFResources resources = iform.procureResources();
        PDFFontMap drFontMap = resources.procureFontMap();
        if (!drFontMap.containsKey((Object)k_DefaultFont)) {
            PDFFontSimple defaultFont = PDFFontSimple.newInstance((PDFDocument)pdfDoc, (ASName)ASName.k_Helvetica, (ASName)ASName.k_Type1);
            drFontMap.set(k_DefaultFont, (PDFFont)defaultFont);
        } else {
            PDFFont helvFont = drFontMap.get(ASName.create((String)"Helv"));
            CosDictionary helvFontDict = helvFont.getCosDictionary();
            if (helvFontDict.containsKey((Object)ASName.k_Name)) {
                try {
                    helvFontDict.remove(ASName.k_Name);
                }
                catch (PDFCosParseException e) {
                    throw new PDFInvalidDocumentException("Invalid PDF document encountered when creating signature appearances", (Throwable)e);
                }
                catch (PDFIOException e) {
                    throw new PDFIOException("IO exception encountered when creating signature appearances", (Throwable)e);
                }
                catch (PDFSecurityException e) {
                    throw new PDFSecurityException("Security exception encountered when creating signature appearances", (Throwable)e);
                }
            }
        }
    }

    private static PDFXObjectForm createBlankForm(PDFDocument pdfDoc, PDFRectangle xObjBBox, PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            PDFXObjectForm blankForm = PDFXObjectForm.newInstance((PDFDocument)pdfDoc);
            blankForm.setBBox(xObjBBox);
            blankForm.setResources(resources);
            blankForm.setMatrix(ASMatrix.createIdentityMatrix().getValues());
            String dsBlankStr = "% DSBlank";
            blankForm.setStream(pdfDoc.getStreamManager().getInputByteStream(dsBlankStr.getBytes("UTF-8")));
            return blankForm;
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("UTF-8 encoding not supported.", e);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    private static PDFXObjectForm createN0Form(PDFDocument pdfDoc, PDFRectangle xObjBBox, PDFAnnotationWidget annot, SignatureFieldInterface sigField, PDFResources resources) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException {
        PDFXObjectForm n0Form = PDFXObjectForm.newInstance((PDFDocument)pdfDoc);
        n0Form.setBBox(xObjBBox);
        n0Form.setResources(resources);
        n0Form.setMatrix(ASMatrix.createIdentityMatrix().getValues());
        PDFRectangle annotRect = annot.getRect();
        PDFAppearanceCharacteristics apCharact = annot.getAppearanceCharacteristics();
        if (annot.hasAppearanceCharacteristics() && (apCharact.hasBackgroundColor() || apCharact.hasBorderColor() || annot.hasBorderStyle())) {
            double annotationWidth = annotRect.width();
            double annotationHeight = annotRect.height();
            PDFRectangle xObjectFormBBox = PDFRectangle.newInstance((PDFDocument)pdfDoc, (double)0.0, (double)0.0, (double)annotationWidth, (double)annotationHeight);
            PDFBorderStyle bs = annot.getBorderStyle();
            try {
                OutputByteStream xobjextContents = pdfDoc.getStreamManager().getOutputByteStreamClearDocument(ByteWriterFactory.Fixed.GROWABLE, -1L);
                ContentWriter xobjectContentWriter = ContentWriter.newInstance((PDFDocument)pdfDoc, (OutputByteStream)xobjextContents);
                if (!XFAService.getDocumentType(pdfDoc).isDynamic()) {
                    double padding = SignatureAppearance.getPadding(annot);
                    RCGOptions options = new RCGOptions(0.0, 0.0);
                    options.setPaddingAll(padding);
                    TextAppearance.buildAppearanceCharacteristics(apCharact, xObjectFormBBox, bs, (PDFField)sigField.getPDFField().getPDFFieldSignature(), options, xobjectContentWriter);
                } else {
                    BorderAppearanceUtils.writeAppearance(xobjectContentWriter, false, false, false, annot);
                }
                InputByteStream streamData = xobjextContents.closeAndConvert();
                xobjextContents = null;
                if (streamData.length() == 0L) {
                    return null;
                }
                n0Form.setStream(streamData);
                streamData = null;
            }
            catch (PDFIOException e) {
                throw new PDFIOException("IO exception encountered when creating signature appearances", (Throwable)e);
            }
            catch (IOException e) {
                throw new PDFIOException("IO exception encountered when creating signature appearances", (Throwable)e);
            }
        } else {
            n0Form = SignatureAppearance.createBlankForm(pdfDoc, xObjBBox, resources);
        }
        return n0Form;
    }

    private static RCGOptions getRCGOptions(double width, double height, PDFAnnotationWidget annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        RCGOptions options = new RCGOptions(width, height);
        options.setOverflow(RCGOverflowMode.ShrinkToFit);
        options.setVerticalAlignment(RCGAlignment.Top);
        options.setWrap(RCGWrapOption.SoftWrap);
        double padding = SignatureAppearance.getPadding(annot);
        if (width - padding * 2.0 > 0.0) {
            options.setPaddingLeft(padding);
            options.setPaddingRight(padding);
        } else {
            options.setPaddingLeft(0.0);
            options.setPaddingRight(0.0);
        }
        if (height - padding * 2.0 > 0.0) {
            options.setPaddingTop(padding);
            options.setPaddingBottom(padding);
        } else {
            options.setPaddingTop(0.0);
            options.setPaddingBottom(0.0);
        }
        return options;
    }

    private static double getPadding(PDFAnnotationWidget annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        double padding = AppearanceUtils.getBorderWidth((PDFAnnotation)annot) * 2.0;
        return padding;
    }

    private static String getDefaultAppearance(Locale locale) {
        return "/" + DefaultFont.getDefaultFontName() + " " + DefaultFont.getDefaultSize(locale) + " Tf " + DefaultFont.getDefaultColor() + " g";
    }

    private static double getDefaultFontSize(Locale locale) {
        return DefaultFont.getDefaultSize(locale);
    }

    private static PDFXObjectForm getAppearanceXObjectForm(SignatureFieldInterface sigField, SignatureAppearanceOptions signatureAppearanceOptions, PDFDocument pdfDoc, double width, double height, List valueList, boolean directionalityLTR) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFFontException, PDFSecurityException, PDFConfigurationException {
        if (valueList == null || valueList.isEmpty()) {
            return PDFXObjectForm.newInstance((PDFDocument)sigField.getPDFDocument());
        }
        boolean emptyText = true;
        for (int i = 0; i < valueList.size(); ++i) {
            if (((String)valueList.get(i)).equals("")) continue;
            emptyText = false;
            break;
        }
        if (emptyText) {
            return PDFXObjectForm.newInstance((PDFDocument)sigField.getPDFDocument());
        }
        String textString = RichTextHandler.convertString2RichText(valueList);
        PDFXObjectForm appearance = null;
        RCGOptions options = SignatureAppearance.getRCGOptions(width, height, sigField.getPDFField().getPDFFieldSignature().getAnnotation());
        StyleAttributes styleAttr = null;
        String defaultAppearance = null;
        PDFVariableText variableText = sigField.getPDFField().getPDFFieldSignature().getVariableText();
        if (variableText != null && variableText.getDefaultAppearance() != null) {
            if (variableText.getDefaultAppearance() != null) {
                defaultAppearance = variableText.getDefaultAppearance().asString();
            }
        } else {
            defaultAppearance = pdfDoc.getInteractiveForm() != null && pdfDoc.getInteractiveForm().getDefaultAppearance() != null ? pdfDoc.getInteractiveForm().getDefaultAppearance() : SignatureAppearance.getDefaultAppearance(signatureAppearanceOptions.getLocale());
        }
        if ((styleAttr = AppearanceUtils.makeStyle(pdfDoc, null, defaultAppearance, 0, pdfDoc.getInteractiveForm().getResources(), signatureAppearanceOptions.getLocale())).getFontSize() == 0.0) {
            styleAttr.setFontSize(SignatureAppearance.getDefaultFontSize(signatureAppearanceOptions.getLocale()));
        }
        if (!directionalityLTR) {
            styleAttr.setTextAlignment(2);
        }
        HashMap afePDFFontMap = new HashMap();
        boolean buildFontSet = true;
        boolean isRichText = false;
        boolean isMultiLine = true;
        boolean autoSize = true;
        appearance = AppearanceUtils.generateTextLayout(pdfDoc, signatureAppearanceOptions.getFontSet(), options, styleAttr, textString, signatureAppearanceOptions.getLocale(), isRichText, buildFontSet, afePDFFontMap, isMultiLine, autoSize, null);
        return appearance;
    }

    private static String formatDate(String date) {
        StringBuilder dateBuffer = new StringBuilder();
        dateBuffer.append(date.substring(0, date.length() - 2));
        dateBuffer.append('\'');
        dateBuffer.append(date.substring(date.length() - 2));
        dateBuffer.append('\'');
        return dateBuffer.toString();
    }

    private static boolean displayGraphicOnly(SignatureAppearanceOptions signatureAppearanceOptions) {
        return !SignatureAppearance.hasDisplayItems(signatureAppearanceOptions) && signatureAppearanceOptions.hasGraphic() && !signatureAppearanceOptions.hasGraphicName();
    }

    private static boolean hasDisplayItems(SignatureAppearanceOptions signatureAppearanceOptions) {
        SignatureAppearanceDisplayItemsSet displayItems = signatureAppearanceOptions.getDisplayItems();
        return displayItems != null && (displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowName) || displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowDN) || displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowReason) || displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowLocation) || displayItems.contains(SignatureAppearanceDisplayItemsSet.kShowDate));
    }

    private static boolean isDirectionalityLTR(String signerName, String displayName, SignatureAppearanceOptions appearanceOptions, PDFSignature signature) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SignatureAppearanceDirectionality directionality = appearanceOptions.getDirectionality();
        boolean directionalityLTR = true;
        switch (directionality) {
            case LTR: {
                break;
            }
            case RTL: {
                directionalityLTR = false;
                break;
            }
            case Auto: {
                if (appearanceOptions.getDisplayItems() == null) {
                    DirectionalityType dirType = SignatureAppearance.getDirectionality(signerName);
                    if (dirType != DirectionalityType.RTL) break;
                    directionalityLTR = false;
                    break;
                }
                if (appearanceOptions.hasGraphicName()) {
                    DirectionalityType dirType = SignatureAppearance.getDirectionality(signerName);
                    if (dirType != DirectionalityType.RTL) break;
                    directionalityLTR = false;
                    break;
                }
                SignatureAppearanceDisplayItemsSet displayItemsSet = appearanceOptions.getDisplayItems();
                if (displayItemsSet.contains(SignatureAppearanceDisplayItemsSet.kShowLabels)) break;
                DirectionalityType dirType = null;
                if (displayItemsSet.contains(SignatureAppearanceDisplayItemsSet.kShowName)) {
                    dirType = SignatureAppearance.getDirectionality(signerName);
                    if (dirType == DirectionalityType.LTR) {
                        return true;
                    }
                    if (dirType == DirectionalityType.RTL) {
                        return false;
                    }
                }
                if (displayItemsSet.contains(SignatureAppearanceDisplayItemsSet.kShowDN)) {
                    dirType = SignatureAppearance.getDirectionality(displayName);
                    if (dirType == DirectionalityType.LTR) {
                        return true;
                    }
                    if (dirType == DirectionalityType.RTL) {
                        return false;
                    }
                }
                if (displayItemsSet.contains(SignatureAppearanceDisplayItemsSet.kShowReason)) {
                    String reason = signature.getReason();
                    if (reason != null) {
                        dirType = SignatureAppearance.getDirectionality(reason);
                    }
                    if (dirType == DirectionalityType.LTR) {
                        return true;
                    }
                    if (dirType == DirectionalityType.RTL) {
                        return false;
                    }
                }
                if (displayItemsSet.contains(SignatureAppearanceDisplayItemsSet.kShowLocation)) {
                    String location = signature.getLocation();
                    if (location != null) {
                        dirType = SignatureAppearance.getDirectionality(location);
                    }
                    if (dirType == DirectionalityType.LTR) {
                        return true;
                    }
                    if (dirType == DirectionalityType.RTL) {
                        return false;
                    }
                }
                if (!displayItemsSet.contains(SignatureAppearanceDisplayItemsSet.kShowDate)) break;
                ASDate date = signature.getDate();
                if (date != null) {
                    String formattedDate = null;
                    formattedDate = appearanceOptions.hasDateFormat() ? (appearanceOptions.getLocale() != null ? appearanceOptions.getDateFormat().getFormattedDate(date, appearanceOptions.getLocale()) : appearanceOptions.getDateFormat().getFormattedDate(date)) : SignatureAppearance.getFormattedDate(date);
                    dirType = SignatureAppearance.getDirectionality(formattedDate);
                }
                if (dirType == DirectionalityType.LTR) {
                    return true;
                }
                if (dirType != DirectionalityType.RTL) break;
                return false;
            }
        }
        return directionalityLTR;
    }

    private static DirectionalityType getDirectionality(String text) {
        DirectionalityType directionality = null;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            switch (Character.getDirectionality(c)) {
                case 0: 
                case 14: 
                case 15: {
                    directionality = DirectionalityType.LTR;
                    break;
                }
                case 1: 
                case 2: 
                case 16: 
                case 17: {
                    directionality = DirectionalityType.RTL;
                }
            }
            if (directionality == null) continue;
            return directionality;
        }
        return DirectionalityType.NONE;
    }

    private static enum DirectionalityType {
        LTR,
        RTL,
        NONE;

    }
}

