/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl;

import com.adobe.internal.io.ByteWriterFactory;
import com.adobe.internal.io.stream.IO;
import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.io.stream.OutputByteStream;
import com.adobe.internal.io.stream.StreamManager;
import com.adobe.internal.pdftoolkit.core.cos.CosArray;
import com.adobe.internal.pdftoolkit.core.cos.CosContainer;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosName;
import com.adobe.internal.pdftoolkit.core.cos.CosNull;
import com.adobe.internal.pdftoolkit.core.cos.CosNumeric;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectID;
import com.adobe.internal.pdftoolkit.core.cos.CosScalar;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASString;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerParams;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModList;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModStack;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModStackItem;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl.DocModUtils;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.PDFFormSupport;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFACanonicalizer;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public final class DocModStatusA9 {
    private CosDocument mCurCosDoc = null;
    private CosDocument mRbCosDoc = null;
    private DocModList mModList = null;
    private CosList mCurAnnotList = null;
    private CosList mCurFieldList = null;
    private CosList mCurPagesList = null;
    private CosList mRbAnnotList = null;
    private CosList mRbFieldList = null;
    private CosList mRbPagesList = null;
    private boolean mFieldMDP = false;

    public DocModStatusA9(CosDocument curCosDoc, CosDocument rbCosDoc, DocModList modList, DocModAnalyzerParams params) {
        this.mCurCosDoc = curCosDoc;
        this.mRbCosDoc = rbCosDoc;
        this.mModList = modList;
        this.mFieldMDP = params.getMode() == DocModAnalyzerParams.DocModAnalysisMode.MDPFieldMode;
    }

    public void setLists(CosList curAnnotList, CosList curFieldList, CosList curPagesList, CosList rbAnnotList, CosList rbFieldList, CosList rbPagesList) {
        this.mCurAnnotList = curAnnotList;
        this.mCurFieldList = curFieldList;
        this.mCurPagesList = curPagesList;
        this.mRbAnnotList = rbAnnotList;
        this.mRbFieldList = rbFieldList;
        this.mRbPagesList = rbPagesList;
    }

    public boolean getModStatusA9() throws PDFIOException, PDFInvalidDocumentException, PDFSecurityException, PDFInvalidParameterException {
        try {
            CosDictionary mCurCatalog = this.mCurCosDoc.getRoot();
            CosDictionary mRbCatalog = this.mRbCosDoc.getRoot();
            if (DocModUtils.isDocDynamic(this.mCurCosDoc)) {
                return this.compareXFA(DocModUtils.safeGetDict(mCurCatalog, ASName.k_AcroForm), DocModUtils.safeGetDict(mRbCatalog, ASName.k_AcroForm));
            }
            if (!this.compareCatalogs(mCurCatalog, mRbCatalog)) {
                return this.badReturn();
            }
            if (!this.compareNamesDicts(DocModUtils.safeGetDict(mCurCatalog, ASName.k_Names), DocModUtils.safeGetDict(mRbCatalog, ASName.k_Names))) {
                return this.badReturn();
            }
            if (!this.compareAcroFormDicts(DocModUtils.safeGetDict(mCurCatalog, ASName.k_AcroForm), DocModUtils.safeGetDict(mRbCatalog, ASName.k_AcroForm))) {
                return this.badReturn();
            }
            if (!this.compareXFA(DocModUtils.safeGetDict(mCurCatalog, ASName.k_AcroForm), DocModUtils.safeGetDict(mRbCatalog, ASName.k_AcroForm))) {
                return this.badReturn();
            }
            CosList rbNonTemplatedPages = null;
            int rbNumPages = DocModUtils.getNumPages(this.mRbCosDoc);
            rbNonTemplatedPages = new CosList();
            for (int i = 0; i < rbNumPages; ++i) {
                CosDictionary rbPage = DocModUtils.getPage(this.mRbCosDoc, i);
                if (DocModUtils.safeGetName(rbPage, ASName.k_TemplateInstantiated) != null) continue;
                rbNonTemplatedPages.add(rbPage.getObjNum(), (Object)rbPage);
            }
            CosDictionary rbNames = DocModUtils.safeGetDict(mRbCatalog, ASName.k_Names);
            HashMap<ASString, CosObject> rbTemplatesMap = new HashMap<ASString, CosObject>();
            if (rbNames != null) {
                DocModUtils.nameTreeToMapRecur(DocModUtils.safeGetDict(rbNames, ASName.k_Pages), rbTemplatesMap);
                DocModUtils.nameTreeToMapRecur(DocModUtils.safeGetDict(rbNames, ASName.k_Templates), rbTemplatesMap);
            }
            int curNumPages = DocModUtils.getNumPages(this.mCurCosDoc);
            for (int i = 0; i < curNumPages; ++i) {
                CosDictionary rbPage;
                CosDictionary rbAnnot;
                int rbNumAnnots;
                int curNumAnnots;
                CosArray rbAnnotsArray;
                CosArray curAnnotsArray;
                CosDictionary curPage = DocModUtils.getPage(this.mCurCosDoc, i);
                ASName pageName = DocModUtils.safeGetName(curPage, ASName.k_TemplateInstantiated);
                if (pageName != null) {
                    CosObject rbTemplate = (CosObject)rbTemplatesMap.get(new ASString(pageName.asString(true)));
                    if (!(rbTemplate instanceof CosDictionary)) {
                        return this.badReturn();
                    }
                    int pageObjNum = curPage.getObjNum();
                    if (this.mModList.isAdded(pageObjNum)) {
                        return this.badReturn();
                    }
                    if (!this.compareSpawnedPgWithTemplate(curPage, (CosDictionary)rbTemplate)) {
                        return this.badReturn();
                    }
                    curAnnotsArray = DocModUtils.safeGetArray(curPage, ASName.k_Annots);
                    rbAnnotsArray = DocModUtils.safeGetArray((CosDictionary)rbTemplate, ASName.k_Annots);
                    curNumAnnots = curAnnotsArray != null ? curAnnotsArray.size() : 0;
                    rbNumAnnots = rbAnnotsArray != null ? rbAnnotsArray.size() : 0;
                    int rbAnnotIdx = 0;
                    for (int curAnnotN = 0; curAnnotN < curNumAnnots; ++curAnnotN) {
                        CosDictionary curAnnot = (CosDictionary)curAnnotsArray.get(curAnnotN);
                        CosDictionary rbMatchAnnot = null;
                        if (DocModUtils.safeGetName(curAnnot, ASName.k_Subtype) == ASName.k_Widget) {
                            int rbAnnotN;
                            String curFullName = DocModUtils.getFullName(curAnnot);
                            for (rbAnnotN = rbAnnotIdx; rbAnnotN < rbNumAnnots; ++rbAnnotN) {
                                rbAnnot = (CosDictionary)rbAnnotsArray.get(rbAnnotN);
                                if (!curFullName.equals(DocModUtils.getFullName(rbAnnot))) continue;
                                rbMatchAnnot = rbAnnot;
                                rbAnnotIdx = rbAnnotN;
                                break;
                            }
                            if (rbMatchAnnot == null) {
                                String curPartialName = DocModUtils.getPartialName(curAnnot);
                                for (int rbAnnotN2 = rbAnnotIdx; rbAnnotN2 < rbNumAnnots; ++rbAnnotN2) {
                                    CosDictionary rbAnnot2 = (CosDictionary)rbAnnotsArray.get(rbAnnotN2);
                                    if (!curPartialName.equals(DocModUtils.getPartialName(rbAnnot2))) continue;
                                    rbMatchAnnot = rbAnnot2;
                                    rbAnnotIdx = rbAnnotN2;
                                    break;
                                }
                            }
                            if (rbMatchAnnot != null) {
                                for (rbAnnotN = rbAnnotIdx; rbAnnotN < rbNumAnnots; ++rbAnnotN) {
                                    rbAnnot = (CosDictionary)rbAnnotsArray.get(rbAnnotN);
                                    if (!this.compareWidgets(curAnnot, rbAnnot, false)) continue;
                                    rbMatchAnnot = rbAnnot;
                                    rbAnnotIdx = rbAnnotN + 1;
                                    break;
                                }
                            }
                        } else {
                            for (int rbAnnotN = rbAnnotIdx; rbAnnotN < rbNumAnnots; ++rbAnnotN) {
                                CosDictionary rbAnnot3 = (CosDictionary)rbAnnotsArray.get(rbAnnotIdx);
                                if (!this.compareAnnots(curAnnot, rbAnnot3, false)) continue;
                                rbMatchAnnot = rbAnnot3;
                                rbAnnotIdx = rbAnnotN + 1;
                                break;
                            }
                        }
                        if (rbMatchAnnot != null) continue;
                        return this.badReturn();
                    }
                    continue;
                }
                int pageObjNum = curPage.getObjNum();
                CosDictionary cosDictionary = rbPage = this.mModList.isAdded(pageObjNum) ? null : (CosDictionary)this.mRbCosDoc.getIndirectObjectByNumber(pageObjNum);
                if (rbPage == null) {
                    return this.badReturn();
                }
                if (!this.comparePages(curPage, rbPage)) {
                    return false;
                }
                rbNonTemplatedPages.delete(pageObjNum);
                curAnnotsArray = DocModUtils.safeGetArray(curPage, ASName.k_Annots);
                rbAnnotsArray = DocModUtils.safeGetArray(rbPage, ASName.k_Annots);
                curNumAnnots = curAnnotsArray != null ? curAnnotsArray.size() : 0;
                rbNumAnnots = rbAnnotsArray != null ? rbAnnotsArray.size() : 0;
                CosList rbWidgetAnnots = new CosList();
                CosList rbNonWidgetAnnots = new CosList();
                for (int rbAnnotN = 0; rbAnnotN < rbNumAnnots; ++rbAnnotN) {
                    CosDictionary rbAnnot4 = (CosDictionary)rbAnnotsArray.get(rbAnnotN);
                    if (DocModUtils.safeGetName(rbAnnot4, ASName.k_Subtype) == ASName.k_Widget) {
                        rbWidgetAnnots.add(rbAnnot4.getObjNum(), (Object)rbAnnot4);
                        continue;
                    }
                    rbNonWidgetAnnots.add(rbAnnot4.getObjNum(), (Object)rbAnnot4);
                }
                for (int curAnnotN = 0; curAnnotN < curNumAnnots; ++curAnnotN) {
                    CosDictionary curAnnot = (CosDictionary)curAnnotsArray.get(curAnnotN);
                    int curObjNum = curAnnot.getObjNum();
                    ASName curAnnotType = DocModUtils.safeGetName(curAnnot, ASName.k_Subtype);
                    if (curAnnotType == ASName.k_Popup) continue;
                    if (curAnnotType == ASName.k_Widget) {
                        if (this.mFieldMDP) continue;
                        rbAnnot = (CosDictionary)rbWidgetAnnots.get(curObjNum);
                        if (this.mModList.isAdded(curObjNum)) {
                            CosObject cosFieldType = DocModUtils.getInheritedValue(curAnnot, ASName.k_FT);
                            if (!(cosFieldType instanceof CosName)) {
                                return this.badReturn();
                            }
                            if (((CosName)cosFieldType).nameValue() == ASName.k_Sig) continue;
                            return this.badReturn();
                        }
                        if (!this.compareWidgets(curAnnot, rbAnnot, true)) {
                            return this.badReturn();
                        }
                        rbWidgetAnnots.delete(curObjNum);
                        continue;
                    }
                    rbAnnot = (CosDictionary)rbNonWidgetAnnots.get(curObjNum);
                    if (this.mModList.isAdded(curObjNum)) {
                        return this.badReturn();
                    }
                    if (!this.compareAnnots(curAnnot, rbAnnot, true)) {
                        return this.badReturn();
                    }
                    rbNonWidgetAnnots.delete(curObjNum);
                }
                if (!this.mFieldMDP && !rbWidgetAnnots.isEmpty()) {
                    return this.badReturn();
                }
                if (rbNonWidgetAnnots.isEmpty()) continue;
                for (CosDictionary rbAnnot4 : rbNonWidgetAnnots) {
                    if (DocModUtils.safeGetName(rbAnnot4, ASName.k_Subtype) == ASName.k_Popup) continue;
                    return this.badReturn();
                }
            }
            if (!rbNonTemplatedPages.isEmpty()) {
                return this.badReturn();
            }
            CosList curDocList = new CosList();
            CosList rbDocList = new CosList();
            for (CosObjectID id : this.mModList.getList()) {
                if (this.mModList.isAddedOrModified(id.getObjNum())) {
                    curDocList.add(id.getObjNum(), (Object)id);
                }
                if (!this.mModList.isDeleted(id.getObjNum())) continue;
                rbDocList.add(id.getObjNum(), (Object)id);
            }
            ASName[] rootExclusions = new ASName[]{ASName.k_StructTreeRoot, ASName.k_AcroForm, ASName.k_Metadata, ASName.create((String)"DSS")};
            if (!this.visitDocument(this.mCurCosDoc, curDocList, rootExclusions, false)) {
                return this.badReturn();
            }
            if (!this.visitDocument(this.mRbCosDoc, rbDocList, rootExclusions, true)) {
                return this.badReturn();
            }
        }
        catch (PDFCosParseException e) {
            throw new PDFInvalidDocumentException("Invalid document encountered during modification analysis", (Throwable)e);
        }
        catch (PDFIOException e) {
            throw new PDFIOException("IO exception encountered during modification analysis", (Throwable)e);
        }
        catch (PDFSecurityException e) {
            throw new PDFSecurityException("Security exception encountered during modification analysis", (Throwable)e);
        }
        return true;
    }

    private boolean visitDocument(CosDocument cosDoc, CosList visitorList, ASName[] subtreeExclusions, boolean visitParents) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (visitorList.isEmpty()) {
            return true;
        }
        CosList seenObjects = new CosList();
        DocModStack stack = new DocModStack();
        CosDictionary container = cosDoc.getRoot();
        List containerKeys = container.getKeys();
        Iterator containerIter = containerKeys.iterator();
        ASName containerKey = null;
        CosObject containerItem = null;
        seenObjects.add(container.getObjNum(), (Object)new CosObjectID(container.getObjNum(), container.getObjGen()));
        boolean pushState = false;
        while (true) {
            if (containerIter.hasNext()) {
                if (container instanceof CosArray) {
                    containerItem = (CosObject)containerIter.next();
                } else {
                    containerKey = (ASName)containerIter.next();
                    if (!visitParents && (containerKey == ASName.k_Parent || containerKey == ASName.k_P)) continue;
                    containerItem = container.get(containerKey);
                    if (stack.isEmpty()) {
                        int i;
                        for (i = 0; i < subtreeExclusions.length && containerKey != subtreeExclusions[i]; ++i) {
                        }
                        if (i != subtreeExclusions.length) continue;
                    }
                }
                if (containerItem == null) continue;
                int objNum = containerItem.getObjNum();
                if (objNum != 0) {
                    if (seenObjects.containsIndex(objNum)) continue;
                    seenObjects.add(objNum, (Object)new CosObjectID(objNum, containerItem.getObjGen()));
                }
                if (containerItem instanceof CosContainer) {
                    pushState = true;
                } else {
                    if (objNum == 0 || !visitorList.containsIndex(objNum)) continue;
                    Boolean reVisit = false;
                    stack.push(new DocModStackItem((CosContainer)container, containerIter, containerKey, containerItem));
                    boolean objOk = this.visitObject(containerItem, stack);
                    if (!objOk) {
                        return this.badReturn();
                    }
                    if (reVisit.booleanValue()) {
                        seenObjects.delete(objNum);
                    }
                    stack.popAndFlush();
                    continue;
                }
            }
            if (pushState) {
                stack.push(new DocModStackItem((CosContainer)container, containerIter, containerKey, containerItem));
                container = (CosContainer)containerItem;
                if (container instanceof CosArray) {
                    containerKey = null;
                    containerKeys = null;
                    containerIter = ((CosArray)container).iterator();
                } else {
                    containerKeys = container.getKeys();
                    containerIter = containerKeys.iterator();
                }
                pushState = false;
                continue;
            }
            if (stack.isEmpty()) {
                return true;
            }
            DocModStackItem item = stack.popAndGet();
            containerItem = item.getContainerItem();
            containerKey = item.getContainerKey();
            container = item.getContainer();
            containerIter = item.getContainerIter();
            int objNum = containerItem == null ? 0 : containerItem.getObjNum();
            if (objNum == 0 || !visitorList.containsIndex(objNum)) continue;
            Boolean reVisit = false;
            stack.push(new DocModStackItem((CosContainer)container, containerIter, containerKey, containerItem));
            boolean objOk = this.visitObject(containerItem, stack);
            if (!objOk) {
                return this.badReturn();
            }
            if (reVisit.booleanValue()) {
                seenObjects.delete(objNum);
            }
            stack.popAndFlush();
        }
    }

    private boolean visitObject(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        DocModStackItem item;
        int objNum = obj.getObjNum();
        CosObjectID id = this.mModList.getObjID(objNum);
        if (id == null || obj instanceof CosNull) {
            return true;
        }
        ASName pdfObjType = null;
        ASName pdfSubType = null;
        ASName subTree = curStack.getKeyAtLevel(0);
        if (obj instanceof CosDictionary) {
            pdfObjType = DocModUtils.safeGetName((CosDictionary)obj, ASName.k_Type);
            pdfSubType = DocModUtils.safeGetName((CosDictionary)obj, ASName.k_Subtype);
        }
        if (pdfObjType == null && !curStack.isEmpty()) {
            pdfObjType = curStack.getKeyAtLevel(curStack.size() - 1);
        }
        if (pdfObjType == null && curStack.size() >= 2) {
            pdfObjType = curStack.getKeyAtLevel(curStack.size() - 2);
        }
        if (obj.getDocument() == this.mRbCosDoc && (pdfObjType == ASName.k_Thumb || DocModUtils.isFontRelatedObject(obj, curStack))) {
            return true;
        }
        if (this.getContainerField(obj, curStack) != null) {
            return true;
        }
        if (pdfObjType == ASName.k_Annots && obj instanceof CosArray) {
            return true;
        }
        if (this.getContainerAnnot(obj, curStack) != null) {
            return this.badReturn();
        }
        CosDictionary containerPage = this.getContainerPage(obj, curStack);
        if (containerPage != null && containerPage != obj) {
            return this.badReturn();
        }
        if (subTree == ASName.k_Names) {
            return this.badReturn();
        }
        if (subTree == ASName.k_Perms && curStack.getKeyAtLevel(1) != ASName.k_DocMDP) {
            return this.badReturn();
        }
        if (pdfSubType == ASName.k_Form) {
            return this.badReturn();
        }
        if (pdfObjType == ASName.k_ExtGState) {
            return this.badReturn();
        }
        if (DocModUtils.isPagesNode(obj, curStack)) {
            return this.badReturn();
        }
        if (pdfObjType == ASName.k_Length && !curStack.isEmpty() && (item = curStack.get(curStack.size() - 1)).getContainer() instanceof CosStream) {
            return true;
        }
        return true;
    }

    private void buildAnnotList(boolean rollBack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosList theAnnotList;
        CosList cosList = theAnnotList = rollBack ? this.mRbAnnotList : this.mCurAnnotList;
        if (theAnnotList != null) {
            return;
        }
        theAnnotList = new CosList();
        if (rollBack) {
            this.mRbAnnotList = theAnnotList;
        } else {
            this.mCurAnnotList = theAnnotList;
        }
        this.buildPagesList(rollBack);
        CosList thePagesList = rollBack ? this.mRbPagesList : this.mCurPagesList;
        for (CosDictionary curPage : thePagesList) {
            CosArray pageAnnots = DocModUtils.safeGetArray(curPage, ASName.k_Annots);
            if (pageAnnots == null) continue;
            for (CosObject annot : pageAnnots) {
                theAnnotList.add(annot.getObjNum(), (Object)annot);
            }
        }
        theAnnotList.delete(0);
    }

    private void buildFieldList(boolean rollBack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosList theFieldList;
        CosList cosList = theFieldList = rollBack ? this.mRbFieldList : this.mCurFieldList;
        if (theFieldList != null) {
            return;
        }
        theFieldList = new CosList();
        if (rollBack) {
            this.mRbFieldList = theFieldList;
        } else {
            this.mCurFieldList = theFieldList;
        }
        this.buildAnnotList(rollBack);
        CosList theAnnotList = rollBack ? this.mRbAnnotList : this.mCurAnnotList;
        for (CosDictionary annot : theAnnotList) {
            if (DocModUtils.safeGetName(annot, ASName.k_Subtype) != ASName.k_Widget) continue;
            theFieldList.add(annot.getObjNum(), (Object)annot);
            CosDictionary field = annot;
            while ((field = DocModUtils.safeGetDict(field, ASName.k_Parent)) != null) {
                theFieldList.add(field.getObjNum(), (Object)field);
            }
        }
        theFieldList.delete(0);
    }

    private void buildPagesList(boolean rollBack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosList thePagesList;
        CosList cosList = thePagesList = rollBack ? this.mRbPagesList : this.mCurPagesList;
        if (thePagesList != null) {
            return;
        }
        thePagesList = new CosList();
        if (rollBack) {
            this.mRbPagesList = thePagesList;
        } else {
            this.mCurPagesList = thePagesList;
        }
        CosDocument theCosDoc = rollBack ? this.mRbCosDoc : this.mCurCosDoc;
        int curNumPages = DocModUtils.getNumPages(theCosDoc);
        for (int i = 0; i < curNumPages; ++i) {
            CosDictionary curPage = DocModUtils.getPage(theCosDoc, i);
            thePagesList.add(curPage.getObjNum(), (Object)curPage);
        }
        thePagesList.delete(0);
    }

    private CosDictionary getContainerAnnot(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        boolean rollBack = obj.getDocument() == this.mRbCosDoc;
        this.buildAnnotList(rollBack);
        return DocModUtils.getContainerItem(obj, curStack, rollBack ? this.mRbAnnotList : this.mCurAnnotList);
    }

    private CosDictionary getContainerField(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        boolean rollBack = obj.getDocument() == this.mRbCosDoc;
        this.buildFieldList(rollBack);
        return DocModUtils.getContainerItem(obj, curStack, rollBack ? this.mRbFieldList : this.mCurFieldList);
    }

    private CosDictionary getContainerPage(CosObject obj, DocModStack curStack) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        boolean rollBack = obj.getDocument() == this.mRbCosDoc;
        this.buildPagesList(rollBack);
        return DocModUtils.getContainerItem(obj, curStack, rollBack ? this.mRbPagesList : this.mCurPagesList);
    }

    private boolean comparePages(CosDictionary curPage, CosDictionary rbPage) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        int curContObjNum;
        CosObject curCont = curPage.get(ASName.k_Contents);
        int n = curContObjNum = curCont == null ? 0 : curCont.getObjNum();
        if (this.mModList.isAddedOrModified(curContObjNum)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curPage.get(ASName.k_AA), rbPage.get(ASName.k_AA), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curPage.get(ASName.k_CropBox), rbPage.get(ASName.k_CropBox), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curPage.get(ASName.k_MediaBox), rbPage.get(ASName.k_MediaBox), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curPage.get(ASName.k_Resources), rbPage.get(ASName.k_Resources), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curPage.get(ASName.k_Rotate), rbPage.get(ASName.k_Rotate), null, false)) {
            return this.badReturn();
        }
        return true;
    }

    private boolean compareCatalogs(CosDictionary curCat, CosDictionary rbCat) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        return true;
    }

    private boolean compareNamesDicts(CosDictionary curNamesDict, CosDictionary rbNamesDict) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (curNamesDict == null && rbNamesDict == null) {
            return true;
        }
        ArrayList<ASName> excludeKeys = new ArrayList<ASName>();
        excludeKeys.add(ASName.k_AP);
        excludeKeys.add(ASName.k_JavaScript);
        CosDictionary curEmbeddedFiles = null;
        CosDictionary curJavaScriptTree = null;
        if (curNamesDict != null) {
            curEmbeddedFiles = DocModUtils.safeGetDict(curNamesDict, ASName.k_EmbeddedFiles);
            curJavaScriptTree = DocModUtils.safeGetDict(curNamesDict, ASName.k_JavaScript);
        }
        CosDictionary rbEmbeddedFiles = null;
        CosDictionary rbJavaScriptTree = null;
        if (rbNamesDict != null) {
            rbEmbeddedFiles = DocModUtils.safeGetDict(rbNamesDict, ASName.k_EmbeddedFiles);
            rbJavaScriptTree = DocModUtils.safeGetDict(rbNamesDict, ASName.k_JavaScript);
        }
        if (!this.compareEmbeddedFiles(curEmbeddedFiles, rbEmbeddedFiles)) {
            return this.badReturn();
        }
        if (!this.compareJavaScripts(curJavaScriptTree, rbJavaScriptTree)) {
            return this.badReturn();
        }
        return this.compareObjects((CosObject)curNamesDict, (CosObject)rbNamesDict, excludeKeys, false);
    }

    private boolean compareEmbeddedFiles(CosDictionary curEmbeddedFiles, CosDictionary rbEmbeddedFiles) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        CosArray rbEFArray;
        if (curEmbeddedFiles == null && rbEmbeddedFiles == null) {
            return true;
        }
        if (!this.compareObjects((CosObject)curEmbeddedFiles, (CosObject)rbEmbeddedFiles, null, false)) {
            return this.badReturn();
        }
        CosArray curEFArray = DocModUtils.safeGetArray(curEmbeddedFiles, ASName.k_Names);
        if (!this.compareObjects((CosObject)curEFArray, (CosObject)(rbEFArray = DocModUtils.safeGetArray(rbEmbeddedFiles, ASName.k_Names)), null, false)) {
            return this.badReturn();
        }
        if (curEFArray != null) {
            for (int i = 0; i < curEFArray.size(); ++i) {
                int curFObjNum;
                CosDictionary rbF;
                CosDictionary rbEF;
                CosObject curEFElement = curEFArray.get(i);
                CosObject rbEFElement = rbEFArray.get(i);
                if (!(curEFElement instanceof CosDictionary) || !(rbEFElement instanceof CosDictionary)) continue;
                CosDictionary curEF = DocModUtils.safeGetDict((CosDictionary)curEFElement, ASName.k_EF);
                if (!this.compareObjects((CosObject)curEF, (CosObject)(rbEF = DocModUtils.safeGetDict((CosDictionary)rbEFElement, ASName.k_EF)), null, false)) {
                    return this.badReturn();
                }
                if (curEF == null) continue;
                CosDictionary curF = DocModUtils.safeGetDict(curEF, ASName.k_F);
                if (!this.compareObjects((CosObject)curF, (CosObject)(rbF = DocModUtils.safeGetDict(rbEF, ASName.k_F)), null, false)) {
                    return this.badReturn();
                }
                int n = curFObjNum = curF == null ? 0 : curF.getObjNum();
                if (!this.mModList.isAddedOrModified(curFObjNum)) continue;
                return this.badReturn();
            }
        }
        return true;
    }

    private boolean compareJavaScripts(CosDictionary curJavaScriptTree, CosDictionary rbJavaScriptTree) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            Map<ASString, CosObject> curJSMap = DocModUtils.nameTreeToMap(curJavaScriptTree);
            Map<ASString, CosObject> rbJSMap = DocModUtils.nameTreeToMap(rbJavaScriptTree);
            if (curJSMap.isEmpty() && rbJSMap.isEmpty()) {
                return true;
            }
            if (curJSMap.isEmpty() || rbJSMap.isEmpty()) {
                return this.badReturn();
            }
            if (curJSMap.size() != rbJSMap.size()) {
                return this.badReturn();
            }
            Iterator<Map.Entry<ASString, CosObject>> iter = curJSMap.entrySet().iterator();
            ArrayList<ASName> excludeKeys = new ArrayList<ASName>();
            excludeKeys.add(ASName.k_JS);
            while (iter.hasNext()) {
                CosObject rbJSItem;
                Map.Entry<ASString, CosObject> entry = iter.next();
                ASString jsName = entry.getKey();
                CosObject curJSObj = entry.getValue();
                CosObject rbJSObj = rbJSMap.get(jsName);
                if (!(curJSObj instanceof CosDictionary) || !(rbJSObj instanceof CosDictionary)) {
                    return this.badReturn();
                }
                CosObject curJSItem = ((CosDictionary)curJSObj).get(ASName.k_JS);
                if (!this.compareStreams(curJSItem, rbJSItem = ((CosDictionary)rbJSObj).get(ASName.k_JS))) {
                    return this.badReturn();
                }
                if (!this.compareObjects(curJSItem, rbJSItem, null, false)) {
                    return this.badReturn();
                }
                if (this.compareObjects(curJSObj, rbJSObj, excludeKeys, false)) continue;
                return this.badReturn();
            }
            return true;
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    private boolean compareAcroFormDicts(CosDictionary curAcroFormDict, CosDictionary rbAcroFormDict) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ArrayList<ASName> excludeKeys = new ArrayList<ASName>();
        ASString curAFString = curAcroFormDict == null ? null : DocModUtils.safeGetString(curAcroFormDict, ASName.k_DA);
        ASString rbAFString = rbAcroFormDict == null ? null : DocModUtils.safeGetString(rbAcroFormDict, ASName.k_DA);
        ASString oneAFString = null;
        if (curAFString != null && rbAFString == null) {
            oneAFString = curAFString;
        } else if (rbAFString != null && curAFString == null) {
            oneAFString = rbAFString;
        }
        if (oneAFString != null && oneAFString.asString().compareTo("/Helv 0 Tf 0 g ") == 0) {
            excludeKeys.add(ASName.k_DA);
        }
        excludeKeys.add(ASName.k_DR);
        excludeKeys.add(ASName.k_Fields);
        excludeKeys.add(ASName.k_CO);
        excludeKeys.add(ASName.k_XFA);
        excludeKeys.add(ASName.k_SigFlags);
        return this.compareObjects((CosObject)curAcroFormDict, (CosObject)rbAcroFormDict, excludeKeys, false);
    }

    private boolean compareXFA(CosDictionary curAcroFormDict, CosDictionary rbAcroFormDict) throws PDFCosParseException, PDFSecurityException, PDFInvalidParameterException, PDFIOException {
        if (curAcroFormDict == null && rbAcroFormDict == null) {
            return true;
        }
        if (curAcroFormDict == null || rbAcroFormDict == null) {
            return this.badReturn();
        }
        CosObject curXFA = curAcroFormDict.get(ASName.k_XFA);
        CosObject rbXFA = rbAcroFormDict.get(ASName.k_XFA);
        return this.compareXFAVersions(curXFA, rbXFA);
    }

    private boolean compareXFAVersions(CosObject curXFA, CosObject rbXFA) throws PDFCosParseException, PDFSecurityException, PDFInvalidParameterException, PDFIOException {
        if (curXFA == null && rbXFA == null) {
            return true;
        }
        if (curXFA == null || rbXFA == null) {
            return this.badReturn();
        }
        InputByteStream curXFAIBS = null;
        InputByteStream rbXFAIBS = null;
        try {
            curXFAIBS = this.getCanonicalXFAData(curXFA);
            rbXFAIBS = this.getCanonicalXFAData(rbXFA);
            int cmp_result = IO.compareInputByteStreams((InputByteStream)curXFAIBS, (InputByteStream)rbXFAIBS);
            if (curXFAIBS == null && rbXFAIBS == null) {
                boolean bl = true;
                return bl;
            }
            if (curXFAIBS == null || rbXFAIBS == null) {
                boolean bl = this.badReturn();
                return bl;
            }
            if (curXFAIBS.length() != rbXFAIBS.length()) {
                boolean bl = this.badReturn();
                return bl;
            }
            if (cmp_result != 0) {
                boolean bl = this.badReturn();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            PDFIOException e = null;
            if (curXFAIBS != null) {
                try {
                    curXFAIBS.close();
                }
                catch (IOException f) {
                    e = new PDFIOException((Throwable)f);
                }
            }
            if (rbXFAIBS != null) {
                try {
                    rbXFAIBS.close();
                }
                catch (IOException f) {
                    e = new PDFIOException((Throwable)f);
                }
            }
            if (e != null) {
                throw e;
            }
        }
    }

    private InputByteStream getCanonicalXFAData(CosObject xfaCosObj) throws PDFCosParseException, PDFSecurityException, PDFInvalidParameterException, PDFIOException {
        StreamManager streamManager = xfaCosObj.getStreamManager();
        OutputByteStream canonicalOBS = null;
        InputByteStream xfaStream = null;
        try {
            xfaStream = PDFFormSupport.getStream(xfaCosObj);
            canonicalOBS = streamManager.getOutputByteStreamClearTemp(ByteWriterFactory.Fixed.GROWABLE, xfaStream.length());
            XFACanonicalizer.canonicalizeXFA(xfaStream, canonicalOBS, XFAUtils.g_packets_CommentsAndDefault);
            InputByteStream canonicalIBS = canonicalOBS.closeAndConvert();
            canonicalOBS = null;
            InputByteStream inputByteStream = canonicalIBS;
            return inputByteStream;
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFInvalidParameterException("Invalid xml exception encountered when canonicalizing the xfa data", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
        finally {
            PDFIOException e = null;
            if (canonicalOBS != null) {
                try {
                    canonicalOBS.close();
                }
                catch (IOException f) {
                    e = new PDFIOException((Throwable)f);
                }
            }
            if (xfaStream != null) {
                try {
                    xfaStream.close();
                }
                catch (IOException f) {
                    e = new PDFIOException((Throwable)f);
                }
            }
            if (e != null) {
                throw e;
            }
        }
    }

    private boolean compareSpawnedPgWithTemplate(CosDictionary curPage, CosDictionary rbTemplate) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        try {
            ASName templateName = DocModUtils.safeGetName(curPage, ASName.k_TemplateInstantiated);
            if (templateName == null) {
                return this.badReturn();
            }
            CosObject curResDict = DocModUtils.getInheritedValue(curPage, ASName.k_Resources);
            if (!(curResDict instanceof CosDictionary)) {
                return this.badReturn();
            }
            CosDictionary curXObjects = DocModUtils.safeGetDict((CosDictionary)curResDict, ASName.k_XObject);
            if (curXObjects == null) {
                return this.badReturn();
            }
            CosDictionary curFormXObject = DocModUtils.safeGetDict(curXObjects, templateName);
            if (curFormXObject == null) {
                return this.badReturn();
            }
            ASName formType = DocModUtils.safeGetName(curFormXObject, ASName.k_Subtype);
            if (formType != ASName.k_Form) {
                return this.badReturn();
            }
            CosObject rbContentsStm = rbTemplate.get(ASName.k_Contents);
            if (!(curFormXObject instanceof CosStream)) {
                return this.badReturn();
            }
            InputStream curData = this.getContents((CosObject)curFormXObject);
            InputStream rbData = null;
            if (rbContentsStm == null) {
                rbData = new ByteArrayInputStream(new byte[0]);
            } else if (rbContentsStm instanceof CosStream || rbContentsStm instanceof CosArray) {
                rbData = this.getContents(rbContentsStm);
            } else {
                return this.badReturn();
            }
            if (curData.read() != 113) {
                return this.badReturn();
            }
            if (curData.read() != 10) {
                return this.badReturn();
            }
            long length = rbData.available();
            for (long i = 0L; i < length; ++i) {
                if (curData.read() == rbData.read()) continue;
                return this.badReturn();
            }
            int nextChar = curData.read();
            if (nextChar == 10) {
                nextChar = curData.read();
            }
            if (nextChar != 81) {
                return this.badReturn();
            }
            if (curData.read() != 10) {
                return this.badReturn();
            }
            return true;
        }
        catch (IOException e) {
            throw new PDFIOException((Throwable)e);
        }
    }

    private InputStream getContents(CosObject cosContents) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        if (cosContents instanceof CosStream) {
            return ((CosStream)cosContents).getStreamDecoded().toInputStream();
        }
        if (cosContents instanceof CosArray) {
            CosArray cosArray = (CosArray)cosContents;
            ArrayList<InputByteStream> workStmArray = new ArrayList<InputByteStream>();
            for (int i = 0; i < cosArray.size(); ++i) {
                CosObject item = cosArray.get(i);
                if (!(item instanceof CosStream)) {
                    throw new PDFCosParseException("Bad stream array");
                }
                InputByteStream itemStm = ((CosStream)item).getStreamDecoded();
                workStmArray.add(itemStm);
                if (i == cosArray.size() - 1) continue;
                itemStm.seek(itemStm.length() - 1L);
                int lastByte = itemStm.read();
                if (lastByte == 48 || lastByte == 10) continue;
                byte[] padding = new byte[]{10};
                InputByteStream padStm = cosContents.getDocument().getStreamManager().getInputByteStream(padding);
                workStmArray.add(padStm);
            }
            InputByteStream[] stmArray = new InputByteStream[workStmArray.size()];
            for (int i = 0; i < workStmArray.size(); ++i) {
                stmArray[i] = (InputByteStream)workStmArray.get(i);
            }
            return cosContents.getDocument().getStreamManager().getInputByteStream(stmArray).toInputStream();
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    private boolean compareStreams(CosObject curStmObj, CosObject rbStmObj) throws PDFCosParseException, PDFIOException, PDFSecurityException, IOException {
        long rbStmLen;
        int i;
        InputByteStream[] stmArray;
        InputByteStream padStm;
        byte[] padding;
        int lastByte;
        InputByteStream itemStm;
        ArrayList<InputByteStream> workStmArray;
        CosArray cosArray;
        int curStmObjNum;
        if (curStmObj == null && rbStmObj == null) {
            return true;
        }
        int n = curStmObjNum = curStmObj == null ? 0 : curStmObj.getObjNum();
        if (!this.mModList.isAddedOrModified(curStmObjNum)) {
            return true;
        }
        InputByteStream curInStm = null;
        InputByteStream rbInStm = null;
        if (curStmObj instanceof CosStream) {
            curInStm = ((CosStream)curStmObj).getStreamDecoded();
        } else if (curStmObj instanceof CosArray) {
            cosArray = (CosArray)curStmObj;
            workStmArray = new ArrayList<InputByteStream>();
            for (int i2 = 0; i2 < cosArray.size(); ++i2) {
                CosObject item = cosArray.get(i2);
                if (!(item instanceof CosStream)) {
                    throw new PDFCosParseException("Bad stream array");
                }
                itemStm = ((CosStream)item).getStreamDecoded();
                workStmArray.add(itemStm);
                if (i2 == cosArray.size() - 1) continue;
                itemStm.seek(itemStm.length() - 1L);
                lastByte = itemStm.read();
                if (lastByte == 48 || lastByte == 10) continue;
                padding = new byte[]{10};
                padStm = curStmObj.getDocument().getStreamManager().getInputByteStream(padding);
                workStmArray.add(padStm);
            }
            stmArray = new InputByteStream[workStmArray.size()];
            for (i = 0; i < workStmArray.size(); ++i) {
                stmArray[i] = (InputByteStream)workStmArray.get(i);
            }
            curInStm = curStmObj.getDocument().getStreamManager().getInputByteStream(stmArray);
        } else {
            return this.badReturn();
        }
        if (rbStmObj instanceof CosStream) {
            rbInStm = ((CosStream)rbStmObj).getStreamDecoded();
        } else if (rbStmObj instanceof CosArray) {
            cosArray = (CosArray)rbStmObj;
            workStmArray = new ArrayList();
            for (int i3 = 0; i3 < cosArray.size(); ++i3) {
                CosObject item = cosArray.get(i3);
                if (!(item instanceof CosStream)) {
                    throw new PDFCosParseException("Bad stream array");
                }
                itemStm = ((CosStream)item).getStreamDecoded();
                workStmArray.add(itemStm);
                if (i3 == cosArray.size() - 1) continue;
                itemStm.seek(itemStm.length() - 1L);
                lastByte = itemStm.read();
                if (lastByte == 48 || lastByte == 10) continue;
                padding = new byte[]{10};
                padStm = rbStmObj.getDocument().getStreamManager().getInputByteStream(padding);
                workStmArray.add(padStm);
            }
            stmArray = new InputByteStream[workStmArray.size()];
            for (i = 0; i < workStmArray.size(); ++i) {
                stmArray[i] = (InputByteStream)workStmArray.get(i);
            }
            rbInStm = rbStmObj.getDocument().getStreamManager().getInputByteStream(stmArray);
        } else {
            return this.badReturn();
        }
        long curStmLen = curInStm == null ? 0L : curInStm.length();
        long l = rbStmLen = rbInStm == null ? 0L : rbInStm.length();
        if (curStmLen != rbStmLen) {
            return this.badReturn();
        }
        if (curStmLen == 0L) {
            return true;
        }
        int i4 = 0;
        while ((long)i4 < curStmLen) {
            if (curInStm.read() != rbInStm.read()) {
                return this.badReturn();
            }
            ++i4;
        }
        return true;
    }

    private boolean compareWidgets(CosDictionary curAnnot, CosDictionary rbAnnot, boolean compareRects) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        boolean modified = false;
        CosDictionary node = curAnnot;
        while (node != null) {
            if (this.mModList.isAddedOrModified(node.getObjNum())) {
                modified = true;
                break;
            }
            node = DocModUtils.safeGetDict(node, ASName.k_Parent);
        }
        if (!modified) {
            return true;
        }
        CosObject cosObj = DocModUtils.getInheritedValue(curAnnot, ASName.k_FT);
        if (!(cosObj instanceof CosName)) {
            return this.badReturn();
        }
        ASName curFieldType = ((CosName)cosObj).nameValue();
        int curFieldFlags = 0;
        cosObj = DocModUtils.getInheritedValue(curAnnot, ASName.k_Ff);
        if (cosObj instanceof CosNumeric) {
            curFieldFlags = ((CosNumeric)cosObj).intValue();
        }
        int rbFieldFlags = 0;
        cosObj = DocModUtils.getInheritedValue(rbAnnot, ASName.k_Ff);
        if (cosObj instanceof CosNumeric) {
            rbFieldFlags = ((CosNumeric)cosObj).intValue();
        }
        if ((curFieldFlags & 0xFFFFFFFE) != (rbFieldFlags & 0xFFFFFFFE)) {
            return this.badReturn();
        }
        int curAnnotFlags = 0;
        cosObj = DocModUtils.getInheritedValue(curAnnot, ASName.k_F);
        if (cosObj instanceof CosNumeric) {
            curAnnotFlags = ((CosNumeric)cosObj).intValue();
        }
        int rbAnnotFlags = 0;
        cosObj = DocModUtils.getInheritedValue(rbAnnot, ASName.k_F);
        if (cosObj instanceof CosNumeric) {
            rbAnnotFlags = ((CosNumeric)cosObj).intValue();
        }
        if ((curAnnotFlags & 0xFFFFFF3F) != (rbAnnotFlags & 0xFFFFFF3F)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_DV), DocModUtils.getInheritedValue(rbAnnot, ASName.k_DV), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_A), DocModUtils.getInheritedValue(rbAnnot, ASName.k_A), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_Opt), DocModUtils.getInheritedValue(rbAnnot, ASName.k_Opt), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_Q), DocModUtils.getInheritedValue(rbAnnot, ASName.k_Q), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_TU), rbAnnot.get(ASName.k_TU), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_Border), rbAnnot.get(ASName.k_Border), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_MaxLen), DocModUtils.getInheritedValue(rbAnnot, ASName.k_MaxLen), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_DA), DocModUtils.getInheritedValue(rbAnnot, ASName.k_DA), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_DS), DocModUtils.getInheritedValue(rbAnnot, ASName.k_DS), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_H), rbAnnot.get(ASName.k_H), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_I), rbAnnot.get(ASName.k_I), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_TI), rbAnnot.get(ASName.k_TI), null, false)) {
            return this.badReturn();
        }
        cosObj = DocModUtils.getInheritedValue(rbAnnot, ASName.k_FT);
        if (!(cosObj instanceof CosName) || ((CosName)cosObj).nameValue() != curFieldType) {
            return this.badReturn();
        }
        CosObject curValue = curAnnot.get((curFieldFlags & 0x2000000) != 0 ? ASName.k_RV : ASName.k_V);
        CosObject rbValue = rbAnnot.get((rbFieldFlags & 0x2000000) != 0 ? ASName.k_RV : ASName.k_V);
        boolean valuesMatch = this.compareObjects(curValue, rbValue, null, false);
        if (curFieldType == ASName.k_Btn && !valuesMatch) {
            boolean bl = valuesMatch = DocModUtils.buttonOff(curValue) && DocModUtils.buttonOff(rbValue);
        }
        if (curFieldType != ASName.k_Sig && !valuesMatch) {
            return this.badReturn();
        }
        CosDictionary curMk = DocModUtils.safeGetDict(curAnnot, ASName.k_MK);
        CosDictionary rbMk = DocModUtils.safeGetDict(rbAnnot, ASName.k_MK);
        CosObject curBc = null;
        CosObject curBg = null;
        CosObject curR = null;
        CosObject curCa = null;
        if (curMk != null) {
            curBc = curMk.get(ASName.k_BC);
            curBg = curMk.get(ASName.k_BG);
            curR = curMk.get(ASName.k_R);
            curCa = curMk.get(ASName.k_CA);
        }
        CosObject rbBc = null;
        CosObject rbBg = null;
        CosObject rbR = null;
        CosObject rbCa = null;
        if (rbMk != null) {
            rbBc = rbMk.get(ASName.k_BC);
            rbBg = rbMk.get(ASName.k_BG);
            rbR = rbMk.get(ASName.k_R);
            rbCa = rbMk.get(ASName.k_CA);
        }
        if (rbBc != null && !this.compareObjects(curBc, rbBc, null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curBg, rbBg, null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curR, rbR, null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curCa, rbCa, null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_T), DocModUtils.getInheritedValue(rbAnnot, ASName.k_T), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_SV), DocModUtils.getInheritedValue(rbAnnot, ASName.k_SV), null, false)) {
            return this.badReturn();
        }
        if (!this.compareAnnotsCommon(curAnnot, rbAnnot, compareRects)) {
            return this.badReturn();
        }
        return true;
    }

    private boolean compareAnnots(CosDictionary curAnnot, CosDictionary rbAnnot, boolean compareRects) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        ASName rbType;
        if (!this.mModList.isAddedOrModified(curAnnot.getObjNum())) {
            return true;
        }
        ASName curType = DocModUtils.safeGetName(curAnnot, ASName.k_Subtype);
        if (curType != (rbType = DocModUtils.safeGetName(rbAnnot, ASName.k_Subtype))) {
            return this.badReturn();
        }
        if (curType == ASName.k_Popup) {
            return true;
        }
        if (curAnnot.get(ASName.k_Rect) == null || rbAnnot.get(ASName.k_Rect) == null) {
            return true;
        }
        ASString curContents = DocModUtils.safeGetString(curAnnot, ASName.k_Contents);
        ASString rbContents = DocModUtils.safeGetString(rbAnnot, ASName.k_Contents);
        if (curContents != null && rbContents != null) {
            if (!this.compareObjects(curAnnot.get(ASName.k_Contents), rbAnnot.get(ASName.k_Contents), null, false)) {
                return this.badReturn();
            }
        } else if (curContents != null || rbContents != null) {
            byte[] cont = null;
            cont = curContents != null ? curContents.getBytes() : rbContents.getBytes();
            if (cont.length != 0 && (cont.length != 2 || cont[0] != 40 || cont[1] != 41)) {
                return this.badReturn();
            }
        }
        if (curType == ASName.k_Stamp) {
            CosDictionary curAppearance = DocModUtils.safeGetDict(curAnnot, ASName.k_AP);
            CosDictionary rbAppearance = DocModUtils.safeGetDict(rbAnnot, ASName.k_AP);
            if (curAppearance != null || rbAppearance != null) {
                if (curAppearance == null || rbAppearance == null) {
                    return this.badReturn();
                }
                if (!this.compareObjects(curAppearance.get(ASName.k_F), rbAppearance.get(ASName.k_F), null, false)) {
                    return this.badReturn();
                }
                if (!this.compareObjects(curAppearance.get(ASName.k_Poster), rbAppearance.get(ASName.k_Poster), null, false)) {
                    return this.badReturn();
                }
            }
        }
        if (curType == ASName.k_Movie) {
            CosDictionary curMovie = DocModUtils.safeGetDict(curAnnot, ASName.k_Movie);
            CosDictionary rbMovie = DocModUtils.safeGetDict(rbAnnot, ASName.k_Movie);
            if (curMovie == null || rbMovie == null) {
                return this.badReturn();
            }
            if (!this.compareObjects(curMovie.get(ASName.k_F), rbMovie.get(ASName.k_F), null, false)) {
                return this.badReturn();
            }
            if (!this.compareObjects(curMovie.get(ASName.k_Poster), rbMovie.get(ASName.k_Poster), null, false)) {
                return this.badReturn();
            }
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_F), rbAnnot.get(ASName.k_F), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_FS), rbAnnot.get(ASName.k_FS), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_T), rbAnnot.get(ASName.k_T), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_Dest), rbAnnot.get(ASName.k_Dest), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_InkList), rbAnnot.get(ASName.k_InkList), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_Name), rbAnnot.get(ASName.k_Name), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_QuadPoints), rbAnnot.get(ASName.k_QuadPoints), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(curAnnot.get(ASName.k_Sound), rbAnnot.get(ASName.k_Sound), null, false)) {
            return this.badReturn();
        }
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_A), DocModUtils.getInheritedValue(rbAnnot, ASName.k_A), null, false)) {
            return this.badReturn();
        }
        if (!this.compareAnnotsCommon(curAnnot, rbAnnot, compareRects)) {
            return this.badReturn();
        }
        return true;
    }

    private boolean compareAnnotsCommon(CosDictionary curAnnot, CosDictionary rbAnnot, boolean compareRects) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (!this.compareObjects(DocModUtils.getInheritedValue(curAnnot, ASName.k_AA), DocModUtils.getInheritedValue(rbAnnot, ASName.k_AA), null, false)) {
            return this.badReturn();
        }
        CosDictionary curBS = DocModUtils.safeGetDict(curAnnot, ASName.k_BS);
        CosDictionary rbBS = DocModUtils.safeGetDict(rbAnnot, ASName.k_BS);
        if (curBS != null || rbBS != null) {
            if (curBS == null || rbBS == null) {
                return this.badReturn();
            }
            CosObject curW = curBS.get(ASName.k_W);
            double curWVal = 1.0;
            if (curW instanceof CosNumeric) {
                curWVal = ((CosNumeric)curW).doubleValue();
            }
            CosObject rbW = rbBS.get(ASName.k_W);
            double rbWVal = 1.0;
            if (rbW instanceof CosNumeric) {
                rbWVal = ((CosNumeric)rbW).doubleValue();
            }
            if (curWVal != rbWVal) {
                return this.badReturn();
            }
            CosObject curS = curBS.get(ASName.k_S);
            ASName curSVal = ASName.k_S;
            if (curS instanceof CosName) {
                curSVal = ((CosName)curS).nameValue();
            }
            CosObject rbS = rbBS.get(ASName.k_S);
            ASName rbSVal = ASName.k_S;
            if (rbS instanceof CosName) {
                rbSVal = ((CosName)rbS).nameValue();
            }
            if (curSVal != rbSVal) {
                return this.badReturn();
            }
        }
        if (compareRects) {
            CosArray curRect = DocModUtils.safeGetArray(curAnnot, ASName.k_Rect);
            CosArray rbRect = DocModUtils.safeGetArray(rbAnnot, ASName.k_Rect);
            if (curRect != null || rbRect != null) {
                if (curRect == null || rbRect == null) {
                    return this.badReturn();
                }
                if (curRect.size() != 4 || rbRect.size() != 4) {
                    return this.badReturn();
                }
                for (int i = 0; i < 4; ++i) {
                    CosObject curObj = curRect.get(i);
                    if (!(curObj instanceof CosNumeric)) {
                        return this.badReturn();
                    }
                    double curVal = ((CosNumeric)curObj).doubleValue();
                    CosObject rbObj = rbRect.get(i);
                    if (!(rbObj instanceof CosNumeric)) {
                        return this.badReturn();
                    }
                    double rbVal = ((CosNumeric)rbObj).doubleValue();
                    if (!(Math.abs(curVal - rbVal) > 2.33)) continue;
                    return this.badReturn();
                }
            }
        }
        return true;
    }

    private boolean compareObjects(CosObject obj1, CosObject obj2, ArrayList<ASName> keyList, boolean include) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        if (obj1 == null && obj2 == null) {
            return true;
        }
        if (obj1 == null || obj2 == null) {
            if (obj1 == null) {
                obj1 = obj2;
            }
            if (obj1 instanceof CosArray) {
                if (((CosArray)obj1).size() == 0) {
                    return true;
                }
                return this.badReturn();
            }
            if (obj1 instanceof CosDictionary) {
                Iterator iter = ((CosDictionary)obj1).keyIterator();
                while (iter.hasNext()) {
                    ASName key = (ASName)iter.next();
                    if (!(keyList != null && keyList.contains(key) ? include : !include)) continue;
                    return this.badReturn();
                }
                return true;
            }
            return this.badReturn();
        }
        if (obj1.getClass() != obj2.getClass()) {
            return this.badReturn();
        }
        if (obj1.getObjNum() == 0 != (obj1.getObjNum() == 0) || obj1 instanceof CosScalar) {
            if (DocModUtils.compareScalars(obj1, obj2)) {
                return true;
            }
            return this.badReturn();
        }
        if (obj1 instanceof CosArray) {
            int count = ((CosArray)obj1).size();
            if (((CosArray)obj2).size() != count) {
                return this.badReturn();
            }
            for (int i = 0; i < count; ++i) {
                CosObject arrayObj1 = ((CosArray)obj1).get(i);
                CosObject arrayObj2 = ((CosArray)obj2).get(i);
                if (!(arrayObj1.getObjNum() == 0 || arrayObj2.getObjNum() == 0 ? !this.compareObjects(arrayObj1, arrayObj2, null, false) : arrayObj1.getObjNum() != arrayObj2.getObjNum() || arrayObj1.getObjGen() != arrayObj2.getObjGen())) continue;
                return this.badReturn();
            }
            return true;
        }
        if (obj1 instanceof CosDictionary) {
            CosObject val2;
            CosObject val1;
            ASName key;
            if (obj1 instanceof CosStream) {
                try {
                    if (((CosStream)obj1).getStreamEncoded().length() != ((CosStream)obj2).getStreamEncoded().length()) {
                        return this.badReturn();
                    }
                }
                catch (IOException e) {
                    throw new PDFIOException((Throwable)e);
                }
                keyList = new ArrayList();
                keyList.add(ASName.k_Filter);
                keyList.add(ASName.k_FFilter);
                keyList.add(ASName.k_DecodeParms);
                keyList.add(ASName.k_FDecodeParms);
                include = true;
            }
            Iterator iter = ((CosDictionary)obj1).keyIterator();
            while (iter.hasNext()) {
                key = (ASName)iter.next();
                if (include ? keyList == null || !keyList.contains(key) : keyList != null && keyList.contains(key)) continue;
                val1 = ((CosDictionary)obj1).get(key);
                val2 = ((CosDictionary)obj2).get(key);
                if (val2 == null) {
                    return this.badReturn();
                }
                if (!(val1.getObjNum() == 0 || val2.getObjNum() == 0 ? !this.compareObjects(val1, val2, null, false) : val1.getObjNum() != val2.getObjNum() || val1.getObjGen() != val2.getObjGen())) continue;
                return this.badReturn();
            }
            if (keyList != null && !keyList.isEmpty() || !include && ((CosDictionary)obj1).size() != ((CosDictionary)obj2).size()) {
                iter = ((CosDictionary)obj2).keyIterator();
                while (iter.hasNext()) {
                    key = (ASName)iter.next();
                    if (!include ? keyList != null && keyList.contains(key) : keyList == null || !keyList.contains(key)) continue;
                    val1 = ((CosDictionary)obj1).get(key);
                    if (val1 == null) {
                        return this.badReturn();
                    }
                    val2 = ((CosDictionary)obj2).get(key);
                    if (!(val1.getObjNum() == 0 || val2.getObjNum() == 0 ? !this.compareObjects(val1, val2, null, false) : val1.getObjNum() != val2.getObjNum() || val1.getObjGen() != val2.getObjGen())) continue;
                    return this.badReturn();
                }
            }
            return true;
        }
        return this.badReturn();
    }

    private boolean badReturn() {
        return false;
    }
}

