/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.impl;

import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosList;
import com.adobe.internal.pdftoolkit.core.cos.CosListInt;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectID;
import com.adobe.internal.pdftoolkit.core.cos.CosObjectInfo;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;

public final class DocModList {
    private static final int ADDED = 1;
    private static final int MODIFIED = 2;
    private static final int DELETED = 4;
    private CosDocument mRbCosDoc;
    private CosList mModList;
    private CosListInt mStatus;

    public DocModList(CosDocument curCosDoc, CosDocument rbCosDoc, long rbEOF) throws PDFCosParseException, PDFIOException, PDFSecurityException {
        this.mRbCosDoc = rbCosDoc;
        this.mModList = curCosDoc.getChangedObjects(rbEOF);
        if (!this.mModList.isEmpty()) {
            this.mStatus = new CosListInt();
            for (CosObjectID id : this.mModList) {
                int objNum = id.getObjNum();
                int curObjGen = id.getObjGen();
                if (curObjGen < 0) {
                    this.mStatus.add(objNum, 4);
                    continue;
                }
                CosObjectInfo rbInfo = this.mRbCosDoc.getIndirectObjectInfoByNumber(objNum);
                if (rbInfo == null) {
                    this.mStatus.add(objNum, 1);
                    continue;
                }
                if (rbInfo.getObjGen() == curObjGen) {
                    this.mStatus.add(objNum, 2);
                    continue;
                }
                this.mStatus.add(objNum, 5);
            }
        }
    }

    public CosDocument getRbCosDoc() {
        return this.mRbCosDoc;
    }

    public boolean isAdded(int objNum) {
        int status = this.mStatus.get(objNum);
        return (status & 1) != 0;
    }

    public boolean isModified(int objNum) {
        int status = this.mStatus.get(objNum);
        return (status & 2) != 0;
    }

    public boolean isAddedOrModified(int objNum) {
        int status = this.mStatus.get(objNum);
        return (status & 3) != 0;
    }

    public boolean isDeleted(int objNum) {
        int status = this.mStatus.get(objNum);
        return (status & 4) != 0;
    }

    public CosObjectID getObjID(int objNum) {
        return (CosObjectID)this.mModList.get(objNum);
    }

    public CosList getList() {
        return this.mModList;
    }
}

