/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaClip;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFMediaClipData;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRendition;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRenditionMedia;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRenditionSelector;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.util.HashMap;

public final class RenditionDigester
extends ObjectDigester {
    private PDFRendition rendition;

    public RenditionDigester(PDFDocument pdfDoc, PDFRendition rendition, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        super(pdfDoc, digesterFactory, digestCache, selector, sigField);
        this.rendition = rendition;
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        byte[] digest;
        CosDictionary rendDict = this.rendition.getCosDictionary();
        if (!this.isDigestCached((CosObject)rendDict)) {
            if (this.rendition instanceof PDFRenditionMedia) {
                PDFRenditionMedia mr = (PDFRenditionMedia)this.rendition;
                if (mr.hasMediaClip()) {
                    this.update(mr.getMediaClip());
                }
            } else if (this.rendition instanceof PDFRenditionSelector) {
                PDFRenditionSelector sr = (PDFRenditionSelector)this.rendition;
                for (PDFRendition nextRend : sr) {
                    RenditionDigester nextRendDigester = new RenditionDigester(this.pdfDoc, nextRend, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                    byte[] nextRendDigest = nextRendDigester.digest();
                    this.update(nextRendDigest);
                }
            }
            digest = super.digest();
            this.cacheDigest((CosObject)rendDict, digest);
        } else {
            digest = this.getCachedDigest((CosObject)rendDict);
        }
        return digest;
    }

    private void update(PDFMediaClip mediaClip) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (mediaClip instanceof PDFMediaClipData) {
            this.update(mediaClip.getCosObject());
        }
    }
}

