/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.agl.text.CollationKey;
import com.adobe.agl.text.Collator;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.impl.AnnotationID;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationPopup;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationWidget;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.utils.PDFUtil;
import java.util.Map;

public final class LocaleAwareAnnotationID
extends AnnotationID {
    private CollationKey mKey;

    public LocaleAwareAnnotationID(PDFAnnotation annot) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        this(annot, null, null);
    }

    public static LocaleAwareAnnotationID getID(PDFAnnotation annot, Map map, Collator collator) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (map == null) {
            return new LocaleAwareAnnotationID(annot);
        }
        LocaleAwareAnnotationID id = (LocaleAwareAnnotationID)((Object)map.get(annot));
        if (id == null) {
            id = new LocaleAwareAnnotationID(annot, map, collator);
            map.put(annot, id);
            return id;
        }
        return id;
    }

    private LocaleAwareAnnotationID(PDFAnnotation annot, Map map, Collator collator) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (annot instanceof PDFAnnotationWidget && ((PDFAnnotationWidget)annot).isField()) {
            PDFField field = ((PDFAnnotationWidget)annot).getField();
            this.appendQualifiedName((PDFFieldNode)field);
            if (!field.getCosDictionary().containsKey((Object)ASName.k_T)) {
                int index = 0;
                for (PDFFieldNode kid : field.getParent()) {
                    if (kid instanceof PDFField && PDFUtil.isPDFCosObjectRefEqual((PDFCosObject)kid, (PDFCosObject)field)) {
                        this.append(46);
                        if (index <= 0) {
                            this.append(48);
                        } else {
                            int value = index;
                            for (int divisor = 1000000000; divisor != 0; divisor /= 10) {
                                if (index < divisor) continue;
                                this.append(value / divisor + 48);
                                value -= value / divisor * divisor;
                            }
                        }
                        break;
                    }
                    ++index;
                }
            }
        } else if (annot.hasName()) {
            this.appendStringValue((PDFCosDictionary)annot, ASName.k_NM);
        } else if (annot instanceof PDFAnnotationPopup && annot.dictionaryContains(ASName.k_Parent)) {
            PDFAnnotation parentAnnot = PDFAnnotationFactory.getInstance((CosObject)annot.getCosDictionary().get(ASName.k_Parent));
            this.append(LocaleAwareAnnotationID.getID(parentAnnot, map, collator));
            this.append(46);
            this.append(48);
        } else {
            this.append(85);
            this.append(110);
            this.append(107);
            this.append(110);
            this.append(111);
            this.append(119);
            this.append(110);
        }
        if (collator != null) {
            this.mKey = collator.getCollationKey(new String(this.mBuffer, 0, this.mCount));
        }
    }

    public int compareTo(Object obj) {
        LocaleAwareAnnotationID id = (LocaleAwareAnnotationID)((Object)obj);
        return this.mKey.compareTo(id.mKey);
    }
}

