/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocumentInfo;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNameDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFNamedEmbeddedFiles;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationList;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedJavaScripts;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedPages;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFNamedTemplates;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.CatalogDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.DocumentInfoDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.NamedEmbeddedFilesDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.NamedJavaScriptsDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.NamedTemplatesDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.PageDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.XFATemplateDigester;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.util.HashMap;

public final class DocumentDigester
extends ObjectDigester {
    public DocumentDigester(PDFDocument pdfDoc, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        super(pdfDoc, digesterFactory, digestCache, selector, sigField);
        this.sigField = sigField;
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFNamedJavaScripts namedJavaScripts;
        PDFNamedEmbeddedFiles namedEmbeddedFiles;
        PDFNamedPages namedPages;
        PDFCatalog catalog = this.pdfDoc.requireCatalog();
        if (this.selector.shouldDigestCatalog()) {
            CatalogDigester catDigester = new CatalogDigester(this.pdfDoc, catalog, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            byte[] catDigest = catDigester.digest();
            this.digester.update(catDigest);
        }
        PDFDocumentInfo docInfo = this.pdfDoc.getDocumentInfo();
        if (this.selector.shouldDigestDocInfo()) {
            DocumentInfoDigester docInfoDigester = new DocumentInfoDigester(this.pdfDoc, docInfo, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            byte[] docInfoDigest = docInfoDigester.digest();
            this.digester.update(docInfoDigest);
        }
        if (this.selector.shouldDigestXFA()) {
            XFATemplateDigester xfaTemplateDigester = new XFATemplateDigester(this.pdfDoc, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            byte[] xfaTemplateDigest = xfaTemplateDigester.digest();
            this.digester.update(xfaTemplateDigest);
        }
        this.update(this.pdfDoc.requirePages());
        PDFNameDictionary names = catalog.getNameDictionary();
        PDFNamedTemplates namedTemplates = names == null ? null : names.getNamedTemplates();
        PDFNamedPages pDFNamedPages = namedPages = names == null ? null : names.getNamedPages();
        if (this.selector.shouldDigestTemplate(false)) {
            NamedTemplatesDigester templatesDigester = new NamedTemplatesDigester(this.pdfDoc, namedTemplates, namedPages, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            byte[] templatesDigest = templatesDigester.digest();
            this.digester.update(templatesDigest);
        }
        PDFNamedEmbeddedFiles pDFNamedEmbeddedFiles = namedEmbeddedFiles = names == null ? null : names.getNamedEmbeddedFiles();
        if (this.selector.shouldDigestEmbeddedFile()) {
            NamedEmbeddedFilesDigester embeddedFilesDigester = new NamedEmbeddedFilesDigester(this.pdfDoc, namedEmbeddedFiles, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            byte[] embeddedFilesDigest = embeddedFilesDigester.digest();
            this.digester.update(embeddedFilesDigest);
        }
        PDFNamedJavaScripts pDFNamedJavaScripts = namedJavaScripts = names == null ? null : names.getNamedJavaScripts();
        if (this.selector.shouldDigestJavaScript()) {
            NamedJavaScriptsDigester javaScriptsDigester = new NamedJavaScriptsDigester(this.pdfDoc, namedJavaScripts, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            byte[] javaScriptsDigest = javaScriptsDigester.digest();
            this.digester.update(javaScriptsDigest);
        }
        byte[] digest = super.digest();
        return digest;
    }

    private void update(PDFPageTree pages) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        for (PDFPage page : pages) {
            boolean shouldDigest = false;
            boolean shouldDigestContent = false;
            if (page.wasTemplateInstantiated()) {
                shouldDigest = this.selector.shouldDigestPageFromTemplate(false);
                shouldDigestContent = this.selector.shouldDigestTemplate(true);
            } else {
                shouldDigest = this.selector.shouldDigestPage(false);
                shouldDigestContent = this.selector.shouldDigestPage(true);
            }
            if (!shouldDigest) continue;
            if (shouldDigestContent) {
                PageDigester pageDigester = new PageDigester(this.pdfDoc, page, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                byte[] pageDigest = pageDigester.digest();
                this.digester.update(pageDigest);
            }
            PDFAnnotationList annots = page.getAnnotationList();
            this.update(annots);
        }
    }
}

