/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFLegalAttestation;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionFactory;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActionsDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.AdditionalActionsDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.util.HashMap;

public final class CatalogDigester
extends ObjectDigester {
    private static final ASName k_DC = ASName.create((String)"DC");
    private static final ASName k_WS = ASName.create((String)"WS");
    private static final ASName k_DS = ASName.create((String)"DS");
    private static final ASName k_WP = ASName.create((String)"WP");
    private static final ASName k_DP = ASName.create((String)"DP");
    private PDFCatalog catalog;

    public CatalogDigester(PDFDocument pdfDoc, PDFCatalog catalog, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        super(pdfDoc, digesterFactory, digestCache, selector, sigField);
        this.catalog = catalog;
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        byte[] digest;
        CosDictionary catalogDict = this.catalog.getCosDictionary();
        if (!this.isDigestCached((CosObject)catalogDict)) {
            PDFPermissions perms;
            PDFLegalAttestation legal;
            PDFAdditionalActionsDocument actions = this.catalog.getAdditionalActions();
            if (actions != null && CatalogDigester.docAdditionalActionIsValid((PDFAdditionalActions)actions)) {
                AdditionalActionsDigester actionsDigester = new AdditionalActionsDigester(this.pdfDoc, (PDFAdditionalActions)actions, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                byte[] actionsDigest = actionsDigester.digest();
                this.digester.update(actionsDigest);
            }
            if ((legal = this.catalog.getLegalAttestation()) != null && this.selector.shouldDigestLegalAttestation()) {
                this.update((CosObject)legal.getCosDictionary());
            }
            if ((perms = this.catalog.getPermissions()) != null) {
                this.updateKeysOnly(perms.getCosDictionary(), null);
            }
            digest = super.digest();
            this.cacheDigest((CosObject)catalogDict, digest);
        } else {
            digest = this.getCachedDigest((CosObject)catalogDict);
        }
        return digest;
    }

    private static boolean docAdditionalActionIsValid(PDFAdditionalActions aa) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        boolean isValid;
        block17: {
            isValid = false;
            CosObject cosObj = aa.getCosObject();
            isValid = cosObj.getType() == 6;
            try {
                PDFAction action;
                CosDictionary cosDict;
                if (isValid) {
                    cosDict = (CosDictionary)cosObj;
                    if (cosDict.containsKey((Object)k_DC)) {
                        action = PDFActionFactory.getInstance((CosObject)cosDict.get(k_DC));
                        isValid = action.isValid();
                    } else {
                        return false;
                    }
                }
                if (isValid) {
                    cosDict = (CosDictionary)cosObj;
                    if (cosDict.containsKey((Object)k_WS)) {
                        action = PDFActionFactory.getInstance((CosObject)cosDict.get(k_WS));
                        isValid = action.isValid();
                    } else {
                        return false;
                    }
                }
                if (isValid) {
                    cosDict = (CosDictionary)cosObj;
                    if (cosDict.containsKey((Object)k_DS)) {
                        action = PDFActionFactory.getInstance((CosObject)cosDict.get(k_DS));
                        isValid = action.isValid();
                    } else {
                        return false;
                    }
                }
                if (isValid) {
                    cosDict = (CosDictionary)cosObj;
                    if (cosDict.containsKey((Object)k_WP)) {
                        action = PDFActionFactory.getInstance((CosObject)cosDict.get(k_WP));
                        isValid = action.isValid();
                    } else {
                        return false;
                    }
                }
                if (!isValid) break block17;
                cosDict = (CosDictionary)cosObj;
                if (cosDict.containsKey((Object)k_DP)) {
                    action = PDFActionFactory.getInstance((CosObject)cosDict.get(k_DP));
                    isValid = action.isValid();
                    break block17;
                }
                return false;
            }
            catch (PDFCosParseException e) {
                isValid = false;
            }
            catch (PDFIOException e) {
                isValid = false;
            }
            catch (PDFSecurityException e) {
                isValid = false;
            }
        }
        return isValid;
    }
}

