/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAdditionalActions;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationStamp;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ActionsDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.AdditionalActionsDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.util.HashMap;

public final class AnnotationDigester
extends ObjectDigester {
    private PDFAnnotation annot;

    public AnnotationDigester(PDFDocument pdfDoc, PDFAnnotation annot, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        super(pdfDoc, digesterFactory, digestCache, selector, sigField);
        this.annot = annot;
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        byte[] digest;
        CosDictionary annotDict = this.annot.getCosDictionary();
        if (!this.isDigestCached((CosObject)annotDict)) {
            try {
                CosDictionary apDict;
                PDFAdditionalActions aa;
                String contents = this.annot.getContents();
                if (contents != null && contents.length() == 2 && contents.equals("()")) {
                    this.update(annotDict.get(ASName.k_Contents));
                }
                if (annotDict.containsKey((Object)ASName.k_T)) {
                    this.update(annotDict.get(ASName.k_T));
                }
                this.update(this.annot.getFlags());
                PDFAction action = this.annot.getAction();
                if (action != null) {
                    ActionsDigester actionsDigester = new ActionsDigester(this.pdfDoc, action, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                    this.update(actionsDigester.digest());
                }
                if ((aa = this.annot.getAdditionalActions()) != null) {
                    AdditionalActionsDigester aaDigester = new AdditionalActionsDigester(this.pdfDoc, aa, this.digesterFactory, this.digestCache, this.selector, this.sigField);
                    this.update(aaDigester.digest());
                }
                ASName[] keys = new ASName[]{ASName.k_Dest, ASName.k_QuadPoints, ASName.k_InkList, ASName.k_Name, ASName.k_FS, ASName.k_Sound};
                this.updateValuesOnly(annotDict, keys);
                if (annotDict.containsKey((Object)ASName.k_Movie)) {
                    CosDictionary movie = annotDict.getCosDictionary(ASName.k_Movie);
                    if (movie.containsKey((Object)ASName.k_F)) {
                        this.update(movie.get(ASName.k_F));
                    }
                    if (movie.containsKey((Object)ASName.k_Poster)) {
                        this.update(movie.get(ASName.k_Poster));
                    }
                }
                if (this.annot instanceof PDFAnnotationStamp && annotDict.containsKey((Object)ASName.k_AP) && (apDict = annotDict.getCosDictionary(ASName.k_AP)).containsKey((Object)ASName.k_N)) {
                    ASName asName;
                    CosStream nCosStm = apDict.getCosStream(ASName.k_N);
                    if (annotDict.containsKey((Object)ASName.k_AS) && nCosStm.containsKey((Object)(asName = annotDict.getName(ASName.k_AS)))) {
                        this.update(nCosStm.get(asName));
                    }
                    this.update((CosObject)nCosStm);
                }
            }
            catch (PDFCosParseException e) {
                throw new PDFInvalidDocumentException("The PDF document used is invalid ", (Throwable)e);
            }
            catch (PDFIOException e) {
                throw new PDFIOException("IO exception when when computing the digest", (Throwable)e);
            }
            catch (PDFSecurityException e) {
                throw new PDFSecurityException("Security exception encountered when computing digest", (Throwable)e);
            }
            digest = super.digest();
            this.cacheDigest((CosObject)annotDict, digest);
        } else {
            digest = this.getCachedDigest((CosObject)annotDict);
        }
        return digest;
    }
}

