/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest;

import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFAction;
import com.adobe.internal.pdftoolkit.pdf.interactive.action.PDFActionRendition;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.multimedia.PDFRendition;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectDigester;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.ObjectSelector;
import com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl.objectdigest.RenditionDigester;
import com.adobe.internal.pdftoolkit.services.digsig.impl.MessageDigestFactory;
import java.util.HashMap;

public final class ActionsDigester
extends ObjectDigester {
    private PDFAction action;
    private final ASName k_Base = ASName.create((String)"Base");
    private final ASName k_Volume = ASName.create((String)"Volume");

    public ActionsDigester(PDFDocument pdfDoc, PDFAction action, MessageDigestFactory digesterFactory, HashMap digestCache, ObjectSelector selector, PDFFieldSignature sigField) throws PDFInvalidParameterException {
        super(pdfDoc, digesterFactory, digestCache, selector, sigField);
        this.action = action;
    }

    @Override
    public byte[] digest() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        byte[] digest;
        CosDictionary actionDict = this.action.getCosDictionary();
        if (!this.isDigestCached((CosObject)actionDict)) {
            if (this.action instanceof PDFActionRendition) {
                this.update((PDFActionRendition)this.action);
            } else {
                ASName[] keys = new ASName[]{ASName.k_S, ASName.k_D, ASName.k_F, ASName.k_NewWindow, ASName.k_O, ASName.k_P, ASName.k_B, this.k_Base, ASName.k_Sound, this.k_Volume, ASName.k_Annot, ASName.k_T, ASName.k_H, ASName.k_N, ASName.k_JS, ASName.k_URI};
                this.updateValuesOnly(actionDict, keys, true);
            }
            digest = super.digest();
            this.cacheDigest((CosObject)actionDict, digest);
        } else {
            digest = this.getCachedDigest((CosObject)actionDict);
        }
        return digest;
    }

    private void update(PDFActionRendition renditionAction) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (renditionAction.hasRendition()) {
            PDFRendition rendition = (PDFRendition)renditionAction.getRendition();
            RenditionDigester rendDigester = new RenditionDigester(this.pdfDoc, rendition, this.digesterFactory, this.digestCache, this.selector, this.sigField);
            byte[] rendDigest = rendDigester.digest();
            this.update(rendDigest);
        }
    }
}

