/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import com.adobe.internal.io.stream.InputByteStream;
import com.adobe.internal.pdftoolkit.core.cos.CosDictionary;
import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.CosObject;
import com.adobe.internal.pdftoolkit.core.cos.CosStream;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.types.ASDictionary;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.core.types.ASNumber;
import com.adobe.internal.pdftoolkit.core.types.ASObject;
import com.adobe.internal.pdftoolkit.pdf.content.Content;
import com.adobe.internal.pdftoolkit.pdf.content.InstructionFactory;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ContentWriter;
import com.adobe.internal.pdftoolkit.pdf.contentmodify.ModifiableContent;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFContents;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosDictionary;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCosObject;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFPermissions;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontSimple;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFSimpleFontEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.CharSetEncoding;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.encodings.WinAnsiEncoding;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFField;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAArray;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAPacket;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFXFAStream;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFMarkInfo;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentArray;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureContentInterface;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureElement;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureMCID;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureNode;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRole;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoleMap;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureRoot;
import com.adobe.internal.pdftoolkit.pdf.interchange.structure.PDFStructureUtils;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPageTree;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;

public class LeanDocGenerator {
    static final ASName DefaultFontName = ASName.create((String)"T1_0");
    private static final String BoilerPlatePgMsg1Acro81 = "To view the full contents of this document, you need a later version of  the PDF viewer. You can upgrade";
    private static final String BoilerPlateMsg2Acro81 = "to the latest version of Adobe Reader from www.adobe.com/products/acrobat/readstep2.html";
    private static final String BoilerPlateMsg3Acro81 = "For further support, go to www.adobe.com/support/products/acrreader.html";

    private static void mergeIncrementalSections(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (pdfDoc.getNumRevisions() > 1) {
            PDFSignature ur;
            long lastSignedEOF = -1L;
            PDFSignature lastSignatureApplied = null;
            PDFPermissions perms = pdfDoc.requireCatalog().getPermissions();
            if (perms != null && (ur = perms.getUR()) != null) {
                lastSignatureApplied = ur;
                lastSignedEOF = pdfDoc.getCosDocument().getObjEOF(ur.getCosObject());
            }
            SignatureManager sigMgr = SignatureManager.newInstance(pdfDoc);
            Iterator<SignatureFieldInterface> itr = sigMgr.getPDFSignatureFieldIterator();
            SignatureFieldInterface sigField = null;
            PDFSignature signature = null;
            long eof = -1L;
            while (itr.hasNext()) {
                sigField = itr.next();
                if (!sigField.isSigned()) continue;
                signature = sigField.getPDFField().getPDFFieldSignature().getSignature();
                eof = pdfDoc.getCosDocument().getObjEOF(signature.getCosObject());
                if (eof <= lastSignedEOF) continue;
                lastSignedEOF = eof;
                lastSignatureApplied = signature;
            }
            if (lastSignatureApplied == null || lastSignedEOF <= 0L) {
                return;
            }
            LeanDocGenerator.markRequiredObjectsDirty(pdfDoc);
            pdfDoc.getCosDocument().setNextIncrementalSectionOffset(lastSignedEOF);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void markRequiredObjectsDirty(PDFDocument pdfDoc) throws PDFIOException, PDFSecurityException, PDFInvalidDocumentException {
        block10: {
            try {
                PDFXFAStream xfaStream;
                PDFInteractiveForm iForm;
                CosDocument currentDoc = pdfDoc.getCosDocument();
                CosDictionary currentCatalog = currentDoc.getRoot();
                CosObject metadata = currentCatalog.get(ASName.k_Metadata);
                if (metadata instanceof CosStream && !metadata.isDirty()) {
                    ((CosStream)metadata).newDataDecoded(((CosStream)metadata).getStreamDecoded());
                }
                if ((iForm = pdfDoc.requireCatalog().getInteractiveForm()) == null) {
                    return;
                }
                if (iForm.xfaIsArray()) {
                    PDFXFAArray xfaArray = iForm.getXFAAsArray();
                    Iterator itr = xfaArray.iterator();
                    PDFXFAPacket xfaPacket = null;
                    while (itr.hasNext()) {
                        xfaPacket = (PDFXFAPacket)itr.next();
                        InputByteStream ibs = xfaPacket.getDataStream().getCosStream().getStreamDecoded();
                        try {
                            xfaArray.update(xfaPacket.getPacketName(), ibs.toInputStream());
                        }
                        finally {
                            if (ibs == null) continue;
                            ibs.close();
                        }
                    }
                    break block10;
                }
                if (iForm.xfaIsStream() && (xfaStream = iForm.getXFAAsStream()) != null) {
                    xfaStream.getCosStream().newDataDecoded(xfaStream.getCosStream().getStreamDecoded());
                }
            }
            catch (IOException e) {
                throw new PDFIOException((Throwable)e);
            }
        }
    }

    public static void generateLeanDocument(PDFDocument pdfDoc, boolean mergeIncrementalSections) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFSignatureException, PDFInvalidParameterException {
        if (XFAService.getDocumentType(pdfDoc).isDynamic()) {
            if (mergeIncrementalSections) {
                LeanDocGenerator.mergeIncrementalSections(pdfDoc);
            }
            try {
                LeanDocGenerator.generateNewPageAndStructure(pdfDoc);
            }
            catch (UnsupportedEncodingException e) {
                throw new PDFSignatureException("Unsupported Encoding exception caught while creating boiler plate page for lean document generation.", (Throwable)e);
            }
            PDFPage page = pdfDoc.requirePages().getPage(0);
            PDFInteractiveForm iForm = pdfDoc.getInteractiveForm();
            Iterator itr = iForm.iterator();
            PDFField field = null;
            while (itr.hasNext()) {
                field = (PDFField)itr.next();
                if (!(field instanceof PDFFieldSignature) || !new SignatureFieldPDF((PDFFieldSignature)field).isSigned()) {
                    itr.remove();
                    continue;
                }
                page.addAnnotation((PDFAnnotation)((PDFFieldSignature)field).getAnnotation());
            }
            pdfDoc.requireCatalog().setNeedsRendering(true);
            LeanDocGenerator.ensureAcroformDAEntry(pdfDoc);
        }
    }

    private static void generateNewPageAndStructure(PDFDocument bloatedDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFSignatureException, UnsupportedEncodingException, PDFInvalidParameterException {
        PDFRectangle mediaBox = PDFRectangle.newInstance((PDFDocument)bloatedDoc, (double)0.0, (double)0.0, (double)612.0, (double)792.0);
        PDFPage emptyPage = PDFPage.newInstance((PDFDocument)bloatedDoc, (PDFRectangle)mediaBox);
        PDFPageTree.newInstance((PDFDocument)bloatedDoc, (PDFPage)emptyPage);
        LeanDocGenerator.generatePageContent(emptyPage);
    }

    private static void ensureAcroformDAEntry(PDFDocument pdfDoc) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFInteractiveForm iform = pdfDoc.getInteractiveForm();
        String defaultAP = iform.getDefaultAppearance();
        if (defaultAP == null || defaultAP.trim().length() == 0) {
            iform.setDictionaryStringValue(ASName.k_DA, "/Helv 0 Tf 0 g");
        }
    }

    private static void generatePageContent(PDFPage oPage) throws PDFSignatureException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, UnsupportedEncodingException, PDFInvalidParameterException {
        if (oPage == null) {
            throw new PDFSignatureException("Null page. Cannot generate page content");
        }
        PDFContents oPDEPageContent = PDFContents.newInstance((PDFDocument)oPage.getPDFDocument());
        PDFResources resources = PDFResources.newInstance((PDFDocument)oPage.getPDFDocument());
        PDFSimpleFontEncoding fontEncoding = PDFSimpleFontEncoding.newInstance((PDFDocument)oPage.getPDFDocument(), (CharSetEncoding)WinAnsiEncoding.getEncoding());
        PDFFontSimple defaultFont = PDFFontSimple.newInstance((PDFDocument)oPage.getPDFDocument(), (ASName)ASName.k_Helvetica, (ASName)ASName.k_Type1);
        defaultFont.setEncoding(fontEncoding);
        PDFFontMap drFontMap = PDFFontMap.newInstance((PDFDocument)oPage.getPDFDocument());
        drFontMap.set(DefaultFontName, (PDFFont)defaultFont);
        resources.setFontMap(drFontMap);
        resources.setProcSetList(new ASName[]{ASName.k_PDF, ASName.k_Text});
        oPage.setResources(resources);
        ContentWriter contentWriter = ContentWriter.newInstance((ModifiableContent)ModifiableContent.newInstance((PDFContents)oPDEPageContent, (PDFResources)resources));
        contentWriter.write(InstructionFactory.newBeginText());
        ASDictionary mParams = new ASDictionary();
        mParams.put(ASName.k_MCID, (ASObject)new ASNumber(0));
        contentWriter.write(InstructionFactory.newBeginMarkedContent((ASName)ASName.create((String)"Content"), (ASDictionary)mParams));
        contentWriter.write(InstructionFactory.newDeviceRGBFill((double)0.0, (double)0.0, (double)0.0));
        contentWriter.write(InstructionFactory.newRelativeColorimetric());
        contentWriter.write(InstructionFactory.newTextFont((ASName)DefaultFontName, (double)1.0));
        contentWriter.write(InstructionFactory.newTextMatrix((double)10.0, (double)0.0, (double)0.0, (double)10.0, (double)72.0, (double)712.104));
        contentWriter.write(InstructionFactory.newShowText((byte[])BoilerPlatePgMsg1Acro81.getBytes("UTF-8")));
        contentWriter.write(InstructionFactory.newTextPositionAndLeading((double)0.0, (double)-1.2));
        contentWriter.write(InstructionFactory.newShowText((byte[])BoilerPlateMsg2Acro81.getBytes("UTF-8")));
        contentWriter.write(InstructionFactory.newTextNextLine());
        contentWriter.write(InstructionFactory.newShowText((byte[])"".getBytes("UTF-8")));
        contentWriter.write(InstructionFactory.newTextNextLine());
        contentWriter.write(InstructionFactory.newShowText((byte[])BoilerPlateMsg3Acro81.getBytes("UTF-8")));
        contentWriter.write(InstructionFactory.newEndMarkedContent());
        contentWriter.write(InstructionFactory.newEndText());
        Content newContent = contentWriter.close();
        oPage.setContents(newContent.getContents());
        LeanDocGenerator.generateStructure(oPage);
    }

    private static void generateStructure(PDFPage oPage) throws PDFSignatureException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        PDFCatalog catalog = oPage.getPDFDocument().requireCatalog();
        PDFMarkInfo markInfo = PDFMarkInfo.newInstance((PDFDocument)oPage.getPDFDocument());
        markInfo.setMarked(Boolean.valueOf(true));
        catalog.setMarkInfo(markInfo);
        catalog.removeValue(ASName.k_StructTreeRoot);
        PDFStructureRoot structRoot = PDFStructureRoot.newInstance((PDFDocument)oPage.getPDFDocument());
        PDFStructureElement docElem = PDFStructureElement.newInstance((PDFDocument)oPage.getPDFDocument(), (ASName)PDFStructureRole.k_Document, (PDFStructureNode)structRoot);
        structRoot.setDictionaryValue(ASName.k_K, (PDFCosObject)docElem);
        PDFStructureElement pageElem = PDFStructureElement.newInstance((PDFDocument)oPage.getPDFDocument(), (ASName)PDFStructureRole.k_P, (PDFStructureNode)docElem);
        PDFStructureElement divElem = PDFStructureElement.newInstance((PDFDocument)oPage.getPDFDocument(), (ASName)PDFStructureRole.k_Div, (PDFStructureNode)docElem);
        divElem.setDictionaryValue(ASName.k_K, (PDFCosObject)PDFStructureElement.newInstance((PDFDocument)oPage.getPDFDocument(), (ASName)PDFStructureRole.k_P, (PDFStructureNode)divElem));
        pageElem.setDictionaryValue(ASName.k_Pg, (PDFCosObject)oPage);
        divElem.setDictionaryValue(ASName.k_K, (PDFCosObject)pageElem);
        docElem.setDictionaryValue(ASName.k_K, (PDFCosObject)divElem);
        PDFStructureRoleMap roleMap = PDFStructureRoleMap.newInstance((PDFDocument)oPage.getPDFDocument());
        roleMap.addRole(ASName.create((String)"Draw"), PDFStructureRole.k_Div);
        roleMap.addRole(ASName.create((String)"Field"), PDFStructureRole.k_Div);
        roleMap.addRole(ASName.create((String)"Subform"), PDFStructureRole.k_Sect);
        roleMap.addRole(ASName.k_Page, PDFStructureRole.k_Part);
        structRoot.setRoleMap(roleMap);
        PDFStructureContentArray pdfStructArray = PDFStructureContentArray.newInstance((PDFDocument)oPage.getPDFDocument(), (PDFStructureContentInterface)pageElem);
        pageElem.addContent((PDFStructureContentInterface)PDFStructureMCID.newInstance((PDFDocument)oPage.getPDFDocument(), (int)0));
        PDFStructureUtils.setStructParentsInTree((PDFStructureContentArray)pdfStructArray, (PDFCosDictionary)oPage);
    }
}

