/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework.impl;

import java.net.JarURLConnection;
import java.net.URL;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class JarManifestLoader {
    private String revNumber = "0.0";
    private String date = null;

    public String getRevNumber() {
        return this.revNumber;
    }

    public String getDate() {
        return this.date;
    }

    public static JarManifestLoader getInstance() {
        return JarManifestLoaderHolder.INSTANCE;
    }

    private JarManifestLoader() {
        this.loadManifest();
    }

    private void loadManifest() {
        Attributes attributes = this.getManifestAttributes();
        if (attributes != null) {
            for (Map.Entry<Object, Object> entry : attributes.entrySet()) {
                Attributes.Name name = (Attributes.Name)entry.getKey();
                if (name.toString().equals("Implementation-Version")) {
                    this.revNumber = (String)entry.getValue();
                }
                if (!name.toString().equals("BuildDate")) continue;
                this.date = (String)entry.getValue();
            }
        }
    }

    private Attributes getManifestAttributes() {
        try {
            URL jarURL = this.getClass().getResource("/com/adobe/internal/pdftoolkit/services/digsig/digsigframework/impl/SignatureHandlerPPKLite.class");
            if (jarURL.toString().startsWith("jar")) {
                JarURLConnection jurlConn = (JarURLConnection)jarURL.openConnection();
                Manifest mf = jurlConn.getManifest();
                Map<String, Attributes> jarmap = mf.getEntries();
                Attributes attr = null;
                attr = jarmap.get("pdfservices.jar");
                if (attr == null) {
                    attr = jarmap.get("pdfservices_security.jar");
                }
                return attr;
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    private static class JarManifestLoaderHolder {
        private static final JarManifestLoader INSTANCE = new JarManifestLoader();

        private JarManifestLoaderHolder() {
        }
    }
}

