/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.digsigframework;

import com.adobe.internal.pdftoolkit.core.cos.CosDocument;
import com.adobe.internal.pdftoolkit.core.cos.PDFCore;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFCosParseException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.docmodanalysis.DocModAnalyzerParams;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptException;
import com.adobe.internal.pdftoolkit.services.javascript.JavaScriptHandler;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOM;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAProcessingOptions;
import com.adobe.xfa.Document;

public class XFAValidationContext {
    PDFDocument currentPDFDoc;
    PDFDocument rollbackPDFDoc;
    CosDocument rollbackCosDoc;
    SignatureOptions sigValidateOptions;
    XFAProcessingOptions xfaProcessingOptions;
    Document currentXFADocument;
    Document rollbackXFADocument;

    public XFAValidationContext(SignatureFieldInterface sigField, SignatureOptions sigOptions, DocModAnalyzerParams.DocModAnalysisMode fieldMDPMode, boolean forceRecreate) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (sigOptions == null) {
            sigOptions = SignatureOptions.newInstance();
        }
        this.initContext(sigField.getPDFDocument(), sigField.getPDFField().getPDFFieldSignature().getSignature().generateRollBackDocument(), sigOptions, fieldMDPMode, forceRecreate);
    }

    public XFAValidationContext(PDFDocument currentPDFDocument, CosDocument rollbackCosDocument, SignatureOptions sigOptions, DocModAnalyzerParams.DocModAnalysisMode fieldMDPMode, boolean forceRecreate) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (sigOptions == null) {
            sigOptions = SignatureOptions.newInstance();
        }
        this.initContext(currentPDFDocument, rollbackCosDocument, sigOptions, fieldMDPMode, forceRecreate);
    }

    public XFAValidationContext(PDFSignature signature, SignatureOptions sigOptions, DocModAnalyzerParams.DocModAnalysisMode fieldMDPMode, boolean forceRecreate) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        if (sigOptions == null) {
            sigOptions = SignatureOptions.newInstance();
        }
        this.initContext(signature.getPDFDocument(), signature.generateRollBackDocument(), sigOptions, fieldMDPMode, forceRecreate);
    }

    public Document getCurrentXFADocument() {
        return this.currentXFADocument;
    }

    public Document getRollbackXFADocument() {
        return this.rollbackXFADocument;
    }

    public PDFDocument getCurrentPDFDoc() {
        return this.currentPDFDoc;
    }

    public PDFDocument getRollbackPDFDoc() {
        return this.rollbackPDFDoc;
    }

    public CosDocument getRollbackCosDoc() {
        return this.rollbackCosDoc;
    }

    public SignatureOptions getSigValidateOptions() {
        return this.sigValidateOptions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initContext(PDFDocument currentPDFDoc, CosDocument rollbackCosDoc, SignatureOptions sigOptions, DocModAnalyzerParams.DocModAnalysisMode fieldMDPMode, boolean forceRecreate) throws PDFCosParseException, PDFIOException, PDFSecurityException, PDFInvalidDocumentException, PDFInvalidParameterException {
        this.currentPDFDoc = currentPDFDoc;
        this.rollbackCosDoc = rollbackCosDoc;
        this.rollbackPDFDoc = PDFDocument.newInstance((PDFCore)new PDFCoreDigsig(rollbackCosDoc));
        this.sigValidateOptions = sigOptions;
        this.xfaProcessingOptions = XFADOMService.getXFAProcessingOptions(currentPDFDoc);
        XFADOM xfaDOM = XFADOMService.getXFADOM(this.currentPDFDoc, this.xfaProcessingOptions, false, true);
        this.loadExistingValidationDocuments(fieldMDPMode, xfaDOM, forceRecreate);
        try {
            JavaScriptHandler currJSHandler;
            XFAProcessingOptions rollbackOptions = new XFAProcessingOptions(XFADOMService.getXFAProcessingOptions(currentPDFDoc));
            JavaScriptHandler rollbackJSHandler = JavaScriptHandler.getRegisteredInstance(this.rollbackPDFDoc);
            if (rollbackJSHandler == null && (currJSHandler = JavaScriptHandler.getRegisteredInstance(currentPDFDoc)) != null) {
                try {
                    rollbackJSHandler = JavaScriptHandler.getInstance(this.rollbackPDFDoc, currJSHandler.getExternalJavaScriptFile(), currJSHandler.getSecurityPermissions(), currJSHandler.getPermissionsManager(), currJSHandler.isTrustedMode(), currJSHandler.isUseConsole(), currJSHandler.getExtensionOptions(), currJSHandler.getExecutionOptions());
                }
                catch (PDFUnableToCompleteOperationException e) {
                    throw new PDFInvalidParameterException((Throwable)e);
                }
                catch (JavaScriptException e) {
                    throw new PDFInvalidParameterException((Throwable)e);
                }
            }
            rollbackOptions.registerJavaScriptHandler(rollbackJSHandler);
            XFADOM rollbackDOM = XFADOMService.getXFADOM(this.rollbackPDFDoc, rollbackOptions, true, fieldMDPMode, false);
            this.rollbackXFADocument = rollbackDOM.getAppModel().getDocument();
        }
        finally {
            XFADOMService.releaseCachedXFADOM(this.rollbackPDFDoc);
        }
    }

    private void loadExistingValidationDocuments(DocModAnalyzerParams.DocModAnalysisMode fieldMDPMode, XFADOM xfaDOM, boolean forceRecreate) throws PDFInvalidParameterException, PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (forceRecreate) {
            xfaDOM = XFADOMService.getXFADOM(this.currentPDFDoc, XFADOMService.getXFAProcessingOptions(this.currentPDFDoc), false, fieldMDPMode, false);
        }
        this.currentXFADocument = xfaDOM.getXFADocument();
    }

    protected static final class PDFCoreDigsig
    extends PDFCore {
        public PDFCoreDigsig(CosDocument cosDoc) {
            super(cosDoc);
        }
    }
}

