/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Verifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAVerifyUtils;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.jsafe.JSAFE_InputException;
import com.rsa.jsafe.JSAFE_InvalidKeyException;
import com.rsa.jsafe.JSAFE_InvalidParameterException;
import com.rsa.jsafe.JSAFE_InvalidUseException;
import com.rsa.jsafe.JSAFE_PaddingException;
import com.rsa.jsafe.JSAFE_Signature;
import com.rsa.jsafe.JSAFE_UnimplementedException;
import java.io.IOException;
import java.io.InputStream;
import java.security.NoSuchAlgorithmException;

public final class RSAPKCS1Verifier
extends Verifier {
    private JSAFE_Signature jsafeVerifier;

    public RSAPKCS1Verifier(byte[][] certChain) throws PDFSignatureException {
        try {
            this.init(certChain);
        }
        catch (java.security.cert.CertificateException e) {
            throw new PDFSignatureException("Certificate exception when initializing the RSA PKCS1 verifier", (Throwable)e);
        }
        catch (PDFConfigurationException e) {
            throw new PDFSignatureException("Exception when initializing the RSA PKCS1 verifier", (Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFSignatureException("Exception when initializing the RSA PKCS1 verifier", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new PDFSignatureException("Exception when initializing the RSA PKCS1 verifier", (Throwable)e);
        }
    }

    void init(byte[][] derCertChain) throws java.security.cert.CertificateException, CertificateException, PDFConfigurationException, PDFInvalidParameterException, PDFSignatureException {
        if (derCertChain == null) {
            throw new PDFSignatureException("No signing certificates have been provided. Use PKCS1Verifier.setSigningCertificates(byte[][] derCertificates) to set up the certs");
        }
        X509Certificate rsaCert = null;
        for (int i = 0; i < derCertChain.length; ++i) {
            if (derCertChain[i] == null) continue;
            rsaCert = new X509Certificate(derCertChain[i], 0, 0);
            break;
        }
        this.initJSAFESignature(rsaCert);
    }

    @Override
    public boolean verify(InputStream is, byte[] signaturePacketData) throws PDFSignatureException {
        try {
            byte[] buffer = new byte[8192];
            int count = 0;
            while ((count = is.read(buffer)) > 0) {
                this.jsafeVerifier.verifyUpdate(buffer, 0, count);
            }
            return this.verify(this.jsafeVerifier, signaturePacketData);
        }
        catch (PDFInvalidDocumentException e) {
            throw new PDFSignatureException("Exception when validating PKCS1 signature using RSA", (Throwable)e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFSignatureException("Exception when validating PKCS1 signature using RSA", (Throwable)e);
        }
        catch (JSAFE_InvalidUseException e) {
            throw new PDFSignatureException("Exception when validating PKCS1 signature using RSA", (Throwable)e);
        }
        catch (JSAFE_InputException e) {
            throw new PDFSignatureException("Exception when validating PKCS1 signature using RSA", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFSignatureException("Exception when validating PKCS1 signature using RSA", (Throwable)e);
        }
    }

    private boolean verify(JSAFE_Signature signature, byte[] contents) throws PDFInvalidDocumentException, PDFUnableToCompleteOperationException {
        boolean verified = false;
        try {
            byte[] sigBytes = RSAVerifyUtils.getSignatureBytes(contents);
            boolean bl = verified = signature.verifyFinal(sigBytes, 0, sigBytes.length);
            return bl;
        }
        catch (JSAFE_InvalidUseException e) {
            throw new PDFUnableToCompleteOperationException("Verification error.", (Throwable)e);
        }
        catch (JSAFE_InputException e) {
            throw new PDFUnableToCompleteOperationException("Verification error", (Throwable)e);
        }
        catch (JSAFE_PaddingException e) {
            throw new PDFInvalidDocumentException("Possible invalid document. Verification error.", (Throwable)e);
        }
        finally {
            if (signature != null) {
                signature.clearSensitiveData();
            }
        }
    }

    private void initJSAFESignature(X509Certificate certificate) throws PDFConfigurationException, PDFInvalidParameterException {
        String keyAlg = null;
        try {
            keyAlg = this.getKeyAlgorithm(certificate);
            this.jsafeVerifier = this.createJSAFESignature(keyAlg);
            this.jsafeVerifier.verifyInit(certificate.getSubjectPublicKey("Java"), null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new PDFConfigurationException("The key algorithm" + keyAlg + " is not available", (Throwable)e);
        }
        catch (JSAFE_UnimplementedException e) {
            throw new PDFInvalidParameterException("Could not initialize the JSAFE Verifier", (Throwable)e);
        }
        catch (JSAFE_InvalidParameterException e) {
            throw new PDFInvalidParameterException("Could not initialize the JSAFE Verifier. The parameters provided are invalid", (Throwable)e);
        }
        catch (JSAFE_InvalidUseException e) {
            throw new PDFInvalidParameterException("Could not initialize the JSAFE Verifier", (Throwable)e);
        }
        catch (JSAFE_InvalidKeyException e) {
            throw new PDFInvalidParameterException("Could not initialize the JSAFE Verifier. The private key is invalid", (Throwable)e);
        }
        catch (CertificateException e) {
            throw new PDFInvalidParameterException("Certificate exception when initializing the JSAFE Verifier", (Throwable)e);
        }
    }

    private String getKeyAlgorithm(X509Certificate certificate) throws CertificateException {
        return certificate.getSubjectPublicKey("Java").getAlgorithm();
    }

    private JSAFE_Signature createJSAFESignature(String algorithmName) throws NoSuchAlgorithmException, JSAFE_UnimplementedException, JSAFE_InvalidParameterException {
        if (algorithmName.equalsIgnoreCase("RSA")) {
            return JSAFE_Signature.getInstance((String)"SHA1/RSA/PKCS1Block01Pad", (String)"Java");
        }
        if (algorithmName.equalsIgnoreCase("DSA")) {
            return JSAFE_Signature.getInstance((String)"SHA1/DSA", (String)"Java");
        }
        return null;
    }
}

