/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.OctetStringContainer;

public final class RSAPKCS1PacketBuilder {
    public byte[] buildPacket(byte[] signatureBytes, CryptoContext cryptoContext, boolean isDummyDigest) throws PDFSignatureException {
        byte[] pkcs1Bytes = null;
        try {
            OctetStringContainer octetContainer = new OctetStringContainer(0, true, 0, signatureBytes, 0, signatureBytes.length);
            ASN1Container[] asn1Def = new ASN1Container[]{octetContainer};
            pkcs1Bytes = ASN1.derEncode((ASN1Container[])asn1Def);
        }
        catch (ASN_Exception e) {
            throw new PDFSignatureException("Could not build a pkcs#1 object.", (Throwable)e);
        }
        return pkcs1Bytes;
    }
}

