/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCECredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X509Certificate;
import java.security.cert.CertificateEncodingException;

public class RSACredentialUtils {
    public static X509Certificate getRSACertificate(Credentials credentials) throws PDFSignatureException {
        X509Certificate rsaCert = null;
        if (credentials instanceof JCECredentials) {
            try {
                rsaCert = new X509Certificate(((JCECredentials)credentials).getCertificate().getEncoded(), 0, 0);
            }
            catch (CertificateEncodingException e) {
                throw new PDFSignatureException("Unable to convert JCE certificate into RSA Certificate", (Throwable)e);
            }
            catch (CertificateException e) {
                throw new PDFSignatureException("Unable to convert JCE certificate into RSA Certificate", (Throwable)e);
            }
        } else {
            rsaCert = ((RSACredentials)credentials).getRSAX509Cert();
        }
        return rsaCert;
    }
}

