/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.rsa.asn1.ASN1;
import com.rsa.asn1.ASN1Container;
import com.rsa.asn1.ASN1Lengths;
import com.rsa.asn1.ASN1Template;
import com.rsa.asn1.ASN_Exception;
import com.rsa.asn1.EncodedContainer;
import com.rsa.asn1.EndContainer;
import com.rsa.asn1.IntegerContainer;
import com.rsa.asn1.OIDContainer;
import com.rsa.asn1.OctetStringContainer;
import com.rsa.asn1.SequenceContainer;
import com.rsa.certj.CertJ;
import com.rsa.certj.CertJUtils;
import com.rsa.certj.InvalidUseException;
import com.rsa.certj.NoServiceException;
import com.rsa.certj.ProviderManagementException;
import com.rsa.certj.cert.AttributeException;
import com.rsa.certj.cert.CertificateException;
import com.rsa.certj.cert.X501Attributes;
import com.rsa.certj.cert.X509Certificate;
import com.rsa.certj.cert.attributes.ContentType;
import com.rsa.certj.cert.attributes.MessageDigest;
import com.rsa.certj.cert.attributes.X501Attribute;
import com.rsa.certj.pkcs7.PKCS7Exception;
import com.rsa.certj.pkcs7.SignedData;
import com.rsa.certj.pkcs7.SignerInfo;
import com.rsa.certj.spi.random.RandomException;
import com.rsa.jsafe.JSAFE_AsymmetricCipher;
import com.rsa.jsafe.JSAFE_Exception;
import com.rsa.jsafe.JSAFE_MessageDigest;
import com.rsa.jsafe.JSAFE_PublicKey;
import com.rsa.jsafe.JSAFE_SecureRandom;
import com.rsa.jsafe.JSAFE_Signature;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;

final class RSACMSVerifier {
    SignedData pkcs7;
    private CertJ theCertJ;
    private List<SignerInfo> failSigners = new ArrayList<SignerInfo>();
    private List<byte[]> digests = new ArrayList<byte[]>();
    private boolean preDigestFlag = false;
    private Set<String> digestNames = new HashSet<String>();
    private List<byte[]> digestIDs = new ArrayList<byte[]>();
    byte[] contentEncoding = null;
    private List<SignerInfo> failedPathSigners = null;
    private List<SignerInfo> notFoundCertSigners = null;
    static final String java = "Java";
    static final byte[] p7OID = new byte[]{42, -122, 72, -122, -9, 13, 1, 7, 0};
    static final int p7OIDLen = 9;
    private static final int DSA_BLOCK_SIZE = 20;
    private static final int DECODE = 1;
    private static final int ENCODE = 0;

    RSACMSVerifier(SignedData pkcs7SignedData) throws PDFSignatureException {
        this.pkcs7 = pkcs7SignedData;
    }

    boolean verifySignature() throws PDFSignatureException, PKCS7Exception {
        if (this.pkcs7.getSignerInfos().size() == 0) {
            return false;
        }
        try {
            this.digestContentData();
        }
        catch (PKCS7Exception e1) {
            throw new PDFSignatureException("Could not digest the content data present in the pkcs7", (Throwable)e1);
        }
        if (this.theCertJ == null) {
            try {
                this.theCertJ = new CertJ();
            }
            catch (ProviderManagementException e) {
                throw new PDFSignatureException(e.getMessage(), (Throwable)e);
            }
            catch (InvalidUseException e) {
                throw new PDFSignatureException(e.getMessage(), (Throwable)e);
            }
        }
        try {
            if (this.pkcs7.getCertificates().size() == 0) {
                throw new PDFSignatureException("Cannot get a certificate for all signers.");
            }
        }
        catch (PKCS7Exception e1) {
            throw new PDFSignatureException("Could not extract the certificates from the SignedData object", (Throwable)e1);
        }
        for (int signerIndex = 0; signerIndex < this.pkcs7.getSignerInfos().size(); ++signerIndex) {
            Object pkcs7Signer = this.pkcs7.getSignerInfos().elementAt(signerIndex);
            SignerInfo signer = (SignerInfo)pkcs7Signer;
            JSAFE_PublicKey publicKey = null;
            X509Certificate cert = null;
            Vector certs = this.pkcs7.getCertificates();
            for (int i = 0; i < certs.size(); ++i) {
                if (signer.getIssuerName() == null || signer.getSerialNumber() == null) {
                    throw new PDFSignatureException("Signer's name or serial number is not set.");
                }
                if (!signer.getIssuerName().equals((Object)((X509Certificate)certs.elementAt(i)).getIssuerName()) || !CertJUtils.byteArraysEqual((byte[])signer.getSerialNumber(), (byte[])((X509Certificate)certs.elementAt(i)).getSerialNumber())) continue;
                cert = (X509Certificate)certs.elementAt(i);
                break;
            }
            if (cert == null) {
                if (this.notFoundCertSigners == null) {
                    this.notFoundCertSigners = new ArrayList<SignerInfo>();
                }
                this.notFoundCertSigners.add(signer);
                continue;
            }
            if (this.failedPathSigners == null) {
                this.failedPathSigners = new ArrayList<SignerInfo>();
            }
            this.failedPathSigners.add(signer);
            try {
                publicKey = cert.getSubjectPublicKey(java);
            }
            catch (CertificateException e) {
                throw new PDFSignatureException("Could not extract the subject public key from the certificate", (Throwable)e);
            }
            try {
                byte[] finalDigest = this.getSignerDigest(signer, 1);
                byte[] digestOID = signer.getDigestAlgorithmOID();
                if (digestOID == null) {
                    this.failSigners.add(signer);
                    publicKey.clearSensitiveData();
                    continue;
                }
                byte[] digestInfo = this.getDigestInfoBER(digestOID, finalDigest);
                byte[] verifyOID = signer.getEncryptionAlgorithmOID();
                if (verifyOID == null) {
                    throw new PDFSignatureException("Signer's signing algorithm is not set.");
                }
                byte[] signature = signer.getEncryptedDigest();
                if (signature == null) {
                    this.failSigners.add(signer);
                    publicKey.clearSensitiveData();
                    continue;
                }
                String algName = null;
                try {
                    JSAFE_AsymmetricCipher tempVerify = JSAFE_AsymmetricCipher.getInstance((String)signer.getEncryptionAlgorithmName(), (String)java);
                    algName = tempVerify.getEncryptionAlgorithm();
                    algName = "NoDigest/" + algName + "/PKCS1Block01Pad";
                }
                catch (JSAFE_Exception jsafeException) {
                    JSAFE_Signature signatureObject = JSAFE_Signature.getInstance((byte[])verifyOID, (int)0, (String)java);
                    algName = signatureObject.getSignatureAlgorithm();
                    algName = "NoDigest/" + algName + "/NoPad";
                    digestInfo = new byte[finalDigest.length];
                    System.arraycopy(finalDigest, 0, digestInfo, 0, finalDigest.length);
                }
                JSAFE_Signature verifyObject = JSAFE_Signature.getInstance((String)algName, (String)java);
                JSAFE_SecureRandom random = this.theCertJ.getRandomObject();
                verifyObject.verifyInit(publicKey, null, (SecureRandom)random, this.theCertJ.getPKCS11Sessions());
                verifyObject.verifyUpdate(digestInfo, 0, digestInfo.length);
                if (verifyObject.getSignatureAlgorithm().equals("DSA")) {
                    signature = this.getRSfromASN1(signature);
                }
                if (!verifyObject.verifyFinal(signature, 0, signature.length)) {
                    this.failSigners.add(signer);
                }
                verifyObject.clearSensitiveData();
                publicKey.clearSensitiveData();
                continue;
            }
            catch (JSAFE_Exception jsafeException) {
                throw new PDFSignatureException("Could not sign ContentInfo: " + jsafeException.getMessage(), (Throwable)jsafeException);
            }
            catch (RandomException randomException) {
                throw new PDFSignatureException("Could not sign ContentInfo: " + randomException.getMessage(), (Throwable)randomException);
            }
            catch (NoServiceException noServiceException) {
                throw new PDFSignatureException("Could not sign ContentInfo: " + noServiceException.getMessage(), (Throwable)noServiceException);
            }
        }
        if (!this.failSigners.isEmpty()) {
            throw new PDFSignatureException(this.createExceptionMessage());
        }
        return true;
    }

    private byte[] getSignerDigest(SignerInfo signer, int usage) throws PDFSignatureException, PKCS7Exception {
        if (signer == null) {
            throw new PDFSignatureException("Cannot set SignerDigest: SignerInfo is null");
        }
        byte[] finalDigest = null;
        try {
            String digestAlgName = signer.getDigestAlgorithmName();
            if (digestAlgName == null) {
                throw new PDFSignatureException("Signer's digest algorithm is not set.");
            }
            finalDigest = this.digests.get(0);
            byte[] digestAlgId = this.digestIDs.get(0);
            JSAFE_MessageDigest digestObject = JSAFE_MessageDigest.getInstance((byte[])digestAlgId, (int)0, (String)java);
            X501Attributes attr = null;
            attr = signer.getAuthenticatedAttrs();
            if (attr != null || this.pkcs7.getContent() != null && this.pkcs7.getContent().getContentType() != 1) {
                int attrLen;
                byte[] message;
                if (attr == null) {
                    attr = new X501Attributes();
                }
                X501Attribute type = null;
                type = attr.getAttributeByType(14);
                if (type == null) {
                    if (usage == 1) {
                        throw new PDFSignatureException("While decoding, ContentType attribute is missing");
                    }
                    type = new ContentType();
                }
                if (usage == 0) {
                    int oid = this.preDigestFlag ? 1 : this.pkcs7.getContent().getContentType();
                    byte[] oidType = new byte[9];
                    System.arraycopy(p7OID, 0, oidType, 0, 9);
                    oidType[8] = (byte)oid;
                    ((ContentType)type).setContentType(oidType, 0, 9);
                    attr.addAttribute(type);
                }
                X501Attribute md = null;
                md = attr.getAttributeByType(15);
                if (md == null) {
                    if (usage == 1) {
                        throw new PDFSignatureException("While decoding, MessageDigest attribute is missing");
                    }
                    md = new MessageDigest();
                }
                if (!CertJUtils.byteArraysEqual((byte[])(message = ((MessageDigest)md).getMessageDigest()), (byte[])finalDigest)) {
                    throw new PDFSignatureException("Value in MessageDigest attribute does not contain the right digest.");
                }
                byte[] attrEncoding = this.getAuthenAttrsOrgBer(signer);
                if (attrEncoding == null) {
                    attrEncoding = new byte[attr.getDERLen(0)];
                    attrLen = attr.getDEREncoding(attrEncoding, 0, 0);
                } else {
                    attrLen = attrEncoding.length;
                }
                int digestLen = digestObject.getDigestSize();
                finalDigest = new byte[digestLen];
                digestObject.digestInit();
                digestObject.digestUpdate(attrEncoding, 0, attrLen);
                finalDigest = digestObject.digestFinal();
                digestObject.clearSensitiveData();
            }
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PDFSignatureException("Could not digest ContentInfo: " + jsafeException.getMessage(), (Throwable)jsafeException);
        }
        catch (AttributeException attrException) {
            throw new PDFSignatureException("Could not DER encode Attributes: " + attrException.getMessage(), (Throwable)attrException);
        }
        return finalDigest;
    }

    private byte[] getAuthenAttrsOrgBer(SignerInfo signer) throws PKCS7Exception, AttributeException {
        byte[] authenAttrsOrgBer = null;
        X501Attributes authAttrs = null;
        if (signer.getAuthenticatedAttrs() != null) {
            authAttrs = signer.getAuthenticatedAttrs();
            authenAttrsOrgBer = new byte[authAttrs.getDERLen(0)];
            int AUTHENT_ATTR_SPECIAL = 0x810000;
            authAttrs.getDEREncoding(authenAttrsOrgBer, 0, 0x810000);
            authenAttrsOrgBer[0] = 49;
        }
        return authenAttrsOrgBer;
    }

    private byte[] getRSfromASN1(byte[] asn) throws PDFSignatureException {
        byte[] rs = new byte[40];
        SequenceContainer aSeq = new SequenceContainer(0);
        EndContainer anEnd = new EndContainer();
        IntegerContainer theR = new IntegerContainer(0);
        IntegerContainer theS = new IntegerContainer(0);
        try {
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, theR, theS, anEnd};
            ASN1.berDecode((byte[])asn, (int)0, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnExc) {
            throw new PDFSignatureException("Unable to encode R,S: " + asnExc.getMessage(), (Throwable)asnExc);
        }
        int rOffset = theR.dataOffset + theR.dataLen - 1;
        int index = 19;
        while (index >= 0) {
            rs[index] = rOffset >= theR.dataOffset ? theR.data[rOffset] : (byte)0;
            --index;
            --rOffset;
        }
        int sOffset = theS.dataOffset + theS.dataLen - 1;
        int index2 = 39;
        while (index2 >= 20) {
            rs[index2] = sOffset >= theS.dataOffset ? theS.data[sOffset] : (byte)0;
            --index2;
            --sOffset;
        }
        return rs;
    }

    private byte[] getDigestInfoBER(byte[] digestAlgorithm, byte[] digest) throws PDFSignatureException {
        if (digestAlgorithm == null) {
            throw new PDFSignatureException("DigestAlgorithm OID is null.");
        }
        try {
            byte[] tmpDigAlgo = this.checkOID(digestAlgorithm);
            SequenceContainer aSeq = new SequenceContainer(0, true, 0);
            EndContainer anEnd = new EndContainer();
            EncodedContainer oid = new EncodedContainer(12288, true, 0, tmpDigAlgo, 0, tmpDigAlgo.length);
            int digestLen = 0;
            if (digest != null) {
                digestLen = digest.length;
            }
            OctetStringContainer octets = new OctetStringContainer(0, true, 0, digest, 0, digestLen);
            ASN1Container[] asn1Def = new ASN1Container[]{aSeq, oid, octets, anEnd};
            ASN1Template templ = new ASN1Template(asn1Def);
            int len = templ.derEncodeInit();
            byte[] output = new byte[len];
            templ.derEncode(output, 0);
            return output;
        }
        catch (ASN_Exception asnException) {
            throw new PDFSignatureException("Cannot encode digestInfo: " + asnException.getMessage(), (Throwable)asnException);
        }
    }

    private byte[] checkOID(byte[] algorithmOID) throws PDFSignatureException {
        byte[] retEncoding;
        SequenceContainer aSeq = new SequenceContainer(0, true, 0);
        EndContainer anEnd = new EndContainer();
        EncodedContainer param = new EncodedContainer(65536);
        OIDContainer oid = new OIDContainer(0);
        ASN1Container[] asn1Def = new ASN1Container[]{aSeq, oid, param, anEnd};
        try {
            ASN1.berDecode((byte[])algorithmOID, (int)0, (ASN1Container[])asn1Def);
        }
        catch (ASN_Exception asnException) {
            throw new PDFSignatureException("Cannot decode algorithm OID: " + asnException.getMessage(), (Throwable)asnException);
        }
        if (param.data == null) {
            byte[] nullParam = new byte[]{5, 0};
            try {
                param.addData(nullParam, 0, nullParam.length, true, true);
                retEncoding = ASN1.derEncode((ASN1Container[])asn1Def);
            }
            catch (ASN_Exception asnException) {
                throw new PDFSignatureException("Cannot encode algorithm OID: " + asnException.getMessage(), (Throwable)asnException);
            }
        } else {
            retEncoding = algorithmOID;
        }
        return retEncoding;
    }

    private String createExceptionMessage() throws PKCS7Exception {
        StringBuilder message = new StringBuilder();
        SignerInfo signer = null;
        if (!this.failSigners.isEmpty()) {
            message.append("\nCannot verify signature for signers: ");
            for (int i = 0; i < this.failSigners.size(); ++i) {
                signer = this.failSigners.get(i);
                if (signer.getIssuerName() == null || signer.getSerialNumber() == null) continue;
                message.append("\n Issuer Name ");
                message.append(signer.getIssuerName().toString());
                message.append(" , Serial Number ");
                message.append(this.printBuffer(signer.getSerialNumber()));
            }
        }
        return message.toString();
    }

    private String printBuffer(byte[] buffer) {
        return this.printBuffer(buffer, 0, buffer.length);
    }

    private String printBuffer(byte[] buffer, int offset, int length) {
        int temp = 0;
        String hexVal = null;
        StringBuilder theLine = new StringBuilder();
        while (length > 0) {
            int index = 0;
            while (index < 8 && length != 0) {
                temp = buffer[offset] & 0xFF;
                hexVal = Integer.toHexString(temp);
                if (hexVal.length() == 1) {
                    theLine.append(" 0");
                } else {
                    theLine.append(" ");
                }
                theLine.append(hexVal);
                --length;
                ++index;
                ++offset;
            }
            theLine.append("\n");
        }
        return theLine.toString();
    }

    private void digestContentData() throws PKCS7Exception, PDFSignatureException {
        byte[] octets = null;
        try {
            if (this.contentEncoding == null) {
                if (this.pkcs7.getContent() == null) {
                    throw new PDFSignatureException("There is no content to sign.");
                }
                int contentLen = this.pkcs7.getContent().getContentInfoDERLen();
                this.contentEncoding = new byte[contentLen];
                contentLen = this.pkcs7.getContent().writeMessage(this.contentEncoding, 0);
            }
            SequenceContainer seq = new SequenceContainer(0);
            EndContainer anEnd = new EndContainer();
            OIDContainer oid = new OIDContainer(0x1000000);
            EncodedContainer encContent = new EncodedContainer(10616576);
            ASN1Container[] returnValue = new ASN1Container[]{seq, oid, encContent, anEnd};
            ASN1.berDecode((byte[])this.contentEncoding, (int)0, (ASN1Container[])returnValue);
            if (encContent.dataPresent) {
                if (CertJUtils.byteArraysEqual((byte[])oid.data, (int)oid.dataOffset, (int)(oid.dataLen - 1), (byte[])p7OID, (int)0, (int)(p7OID.length - 1))) {
                    switch (oid.data[oid.dataOffset + oid.dataLen - 1]) {
                        case 1: {
                            OctetStringContainer octetStringContainer = new OctetStringContainer(0xA10000, true, 0, encContent.data, encContent.dataOffset, encContent.dataLen);
                            ASN1Container[] octetDef = new ASN1Container[]{octetStringContainer};
                            ASN1.berDecode((byte[])encContent.data, (int)encContent.dataOffset, (ASN1Container[])octetDef);
                            if (octetStringContainer.data == null || octetStringContainer.dataLen == 0) {
                                octets = new byte[]{};
                                break;
                            }
                            octets = new byte[octetStringContainer.dataLen];
                            System.arraycopy(octetStringContainer.data, octetStringContainer.dataOffset, octets, 0, octetStringContainer.dataLen);
                            break;
                        }
                        default: {
                            int skipBytes = 1;
                            skipBytes += ASN1Lengths.determineLengthLen((byte[])encContent.data, (int)(encContent.dataOffset + 1));
                            ++skipBytes;
                            skipBytes += ASN1Lengths.determineLengthLen((byte[])encContent.data, (int)(encContent.dataOffset + skipBytes));
                            octets = new byte[encContent.dataLen - skipBytes];
                            System.arraycopy(encContent.data, encContent.dataOffset + skipBytes, octets, 0, encContent.dataLen - skipBytes);
                            break;
                        }
                    }
                }
            } else {
                octets = new byte[]{};
            }
        }
        catch (ASN_Exception asnException) {
            throw new PDFSignatureException("Could not DER encode ContentInfo: " + asnException.getMessage(), (Throwable)asnException);
        }
        byte[] digestOctets = null;
        try {
            Enumeration e = this.pkcs7.getSignerInfos().elements();
            while (e.hasMoreElements()) {
                SignerInfo signer = (SignerInfo)e.nextElement();
                String signerDigestAlgName = signer.getDigestAlgorithmName();
                if (signerDigestAlgName == null) {
                    throw new PDFSignatureException("Could not DER encode ContentInfo: Signer's digest algorithm is not set.");
                }
                if (!this.digestNames.add(signerDigestAlgName)) continue;
                byte[] signerDigestAlgId = signer.getDigestAlgorithmOID();
                this.digestIDs.add(signerDigestAlgId);
                this.digests.add(null);
            }
            if (octets == null) {
                return;
            }
            if (!this.preDigestFlag) {
                for (int index = 0; index < this.digestIDs.size(); ++index) {
                    byte[] digestOID = this.digestIDs.get(index);
                    JSAFE_MessageDigest digestObject = JSAFE_MessageDigest.getInstance((byte[])digestOID, (int)0, (String)java);
                    byte[] digest = this.digests.get(index);
                    if (digest != null) continue;
                    digestObject.digestInit();
                    digestObject.digestUpdate(octets, 0, octets.length);
                    digestOctets = digestObject.digestFinal();
                    digestObject.clearSensitiveData();
                    this.digests.set(index, digestOctets);
                }
            }
        }
        catch (JSAFE_Exception jsafeException) {
            throw new PDFSignatureException("Could not digest ContentInfo: " + jsafeException.getMessage(), (Throwable)jsafeException);
        }
    }
}

