/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.io.stream.IO;
import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Signer;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.AbstractDigester;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAPKCS7SignedDataBuilder;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSASigningUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class PKCS7Signer
extends Signer {
    protected boolean isDetached = false;
    RSAPKCS7SignedDataBuilder pkcs7PacketBuilder;
    AbstractDigester digester;

    public PKCS7Signer(RSACredentials credentials, CryptoContext ctx, boolean createDetachedSignature, AbstractDigester digester, RSAPKCS7SignedDataBuilder pkcs7PacketBuilder) {
        super((Credentials)credentials, ctx);
        this.isDetached = createDetachedSignature;
        this.digester = digester;
        this.pkcs7PacketBuilder = pkcs7PacketBuilder;
    }

    @Override
    public byte[] sign(InputStream contents) throws PDFSignatureException {
        byte[] signatureBytes = null;
        if (this.isDetached && "DSA".equals(this.cryptoContext.getSignatureAlgorithm())) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                IO.copy((InputStream)contents, (OutputStream)bos);
            }
            catch (IOException e) {
                throw new PDFSignatureException("unable to copy contents");
            }
            signatureBytes = bos.toByteArray();
        } else {
            signatureBytes = this.getSignatureBytes(contents);
        }
        return this.pkcs7PacketBuilder.buildPacket(signatureBytes, (RSACredentials)this.credentials, this.cryptoContext, false, this.isDetached);
    }

    protected byte[] getSignatureBytes(InputStream contents) throws PDFSignatureException {
        byte[] signatureBytes = null;
        try {
            this.digester.feedDataToDigester(contents);
            signatureBytes = this.digester.calculateDigest();
        }
        catch (PDFSignatureException e) {
            throw new PDFSignatureException("Error when creating message digest", (Throwable)e);
        }
        catch (PDFIOException e) {
            throw new PDFSignatureException("Error when copying inputByteStream to message digest", (Throwable)e);
        }
        return signatureBytes;
    }

    @Override
    public int getSignatureSize() throws PDFSignatureException {
        return RSASigningUtils.estimatePacketSizeUsingRSA((RSACredentials)this.credentials, this.cryptoContext, this.digester, this.isDetached);
    }
}

