/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.credentials.impl.JCECredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsCADES;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.AbstractDigester;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.JCEPKCS7SignedDataBuilder;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSARevInfoUtil;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSATimeStampingUtil;
import com.adobe.internal.pdftoolkit.services.digsig.spi.RevocationInfoProvider;
import com.adobe.internal.pdftoolkit.services.digsig.spi.TimeStampProvider;
import com.rsa.certj.cert.X501Attributes;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateEncodingException;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.x509.Certificate;

public final class JCESigningUtils {
    private JCESigningUtils() {
    }

    public static int estimatePacketSizeUsingJCE(JCECredentials credentials, CryptoContext cryptoContext, AbstractDigester msgDigester, boolean isDetached) throws PDFSignatureException {
        TimeStampProvider tsp;
        X501Attributes attrs;
        RevocationInfoProvider rip;
        int size = 1024;
        size += credentials.getCertificate().getPublicKey().getEncoded().length;
        if (!isDetached) {
            size += msgDigester.getSize();
        }
        size += credentials.getCertificate().getSerialNumber().toByteArray().length;
        size += credentials.getCertificate().getIssuerX500Principal().getEncoded().length;
        java.security.cert.Certificate[] rsaCerts = credentials.getCertificateChain();
        if (rsaCerts != null) {
            for (int i = 0; i < rsaCerts.length; ++i) {
                try {
                    size += rsaCerts[i].getEncoded().length;
                    continue;
                }
                catch (CertificateEncodingException e) {
                    // empty catch block
                }
            }
        }
        if ((rip = cryptoContext.getRevocationInfoProvider()) != null && (attrs = RSARevInfoUtil.createAdobeRevocationInfo(rip)) != null) {
            size += attrs.getDERLen(0);
        }
        if ((tsp = cryptoContext.getTimeStampProvider()) != null) {
            byte[] dummySignedData = new byte[msgDigester.getSize()];
            X501Attributes attrs2 = RSATimeStampingUtil.createTSAttribute(dummySignedData, tsp, true);
            size += attrs2.getDERLen(0);
        }
        return size;
    }

    public static int estimatePacketSizeUsingJCEForCADES(JCECredentials credentials, CryptoContext cryptoContext, AbstractDigester msgDigester, SignatureOptionsCADES sigOptions) throws PDFSignatureException {
        Attribute signingCertificateAttribute;
        int size = JCESigningUtils.estimatePacketSizeUsingJCE(credentials, cryptoContext, msgDigester, true);
        try {
            Certificate signingCertificate = Certificate.getInstance((Object)credentials.getCertificate().getEncoded());
            signingCertificateAttribute = JCEPKCS7SignedDataBuilder.createSigningCertificateAttribute(sigOptions.getCertificateHashAlgorithmName(), signingCertificate, sigOptions.isPolicyInformationInSigningCertificateAttributeEnabled());
        }
        catch (IOException | NoSuchAlgorithmException | CertificateEncodingException e) {
            throw new PDFSignatureException(e.getMessage(), e.getCause());
        }
        return size += signingCertificateAttribute.getEncoded("DER").length;
    }
}

