/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.spi.RevocationInfoProvider;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.Attribute;

public final class JCERevInfoUtil {
    private static final String ADBE_REVOCATION_INFO_ARCHIVAL_OID = "1.2.840.113583.1.1.8";

    public static Attribute createAdobeRevocationInfo(RevocationInfoProvider revProvider) throws PDFSignatureException {
        return JCERevInfoUtil.createAdobeRevocationInfoAttribute(revProvider);
    }

    public static Attribute createAdobeRevocationInfoAttribute(RevocationInfoProvider revProvider) throws PDFSignatureException {
        ASN1EncodableVector revInfo = JCERevInfoUtil.createASN(revProvider);
        if (revInfo.size() > 0) {
            return new Attribute(new ASN1ObjectIdentifier(ADBE_REVOCATION_INFO_ARCHIVAL_OID), (ASN1Set)new DLSet((ASN1Encodable)new DLSequence(revInfo)));
        }
        return null;
    }

    private static ASN1EncodableVector createASN(RevocationInfoProvider revInfoProvider) throws PDFSignatureException {
        int index;
        boolean embedCRL = revInfoProvider.embedCRL();
        boolean embedOCSP = revInfoProvider.embedOCSP();
        boolean embedOtherRevInfo = revInfoProvider.embedOtherRevInfo();
        byte[][] ocspResponseArray = revInfoProvider.getOCSPResponses();
        byte[][] crlResponseArray = revInfoProvider.getCRLS();
        byte[][] otherRevInfoArray = revInfoProvider.getOtherRevInfo();
        ASN1EncodableVector seqV = new ASN1EncodableVector();
        if (embedCRL) {
            if (crlResponseArray.length > 0) {
                try {
                    ASN1EncodableVector crlV = new ASN1EncodableVector();
                    for (index = 0; index < crlResponseArray.length; ++index) {
                        crlV.add((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])crlResponseArray[index]));
                    }
                    seqV.add((ASN1Encodable)new DERTaggedObject(0, (ASN1Encodable)new DLSequence(crlV)));
                }
                catch (IOException e) {
                    throw new PDFSignatureException("Error creating CRLInfo", (Throwable)e);
                }
            } else {
                throw new PDFSignatureException("No crl response provided for embedding into the signature");
            }
        }
        if (embedOCSP) {
            if (ocspResponseArray.length > 0) {
                try {
                    ASN1EncodableVector ocspV = new ASN1EncodableVector();
                    for (index = 0; index < ocspResponseArray.length; ++index) {
                        ocspV.add((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])ocspResponseArray[index]));
                    }
                    seqV.add((ASN1Encodable)new DERTaggedObject(1, (ASN1Encodable)new DLSequence(ocspV)));
                }
                catch (IOException e) {
                    throw new PDFSignatureException("Error creating OCSPInfo", (Throwable)e);
                }
            } else {
                throw new PDFSignatureException("No ocsp response provided for embedding into the signature");
            }
        }
        if (embedOtherRevInfo) {
            if (otherRevInfoArray.length > 0) {
                try {
                    ASN1EncodableVector otherV = new ASN1EncodableVector();
                    for (index = 0; index < otherRevInfoArray.length; ++index) {
                        otherV.add((ASN1Encodable)ASN1Primitive.fromByteArray((byte[])otherRevInfoArray[index]));
                    }
                    seqV.add((ASN1Encodable)new DERTaggedObject(2, (ASN1Encodable)new DLSequence(otherV)));
                }
                catch (IOException e) {
                    throw new PDFSignatureException("Error creating OtherRevInfo", (Throwable)e);
                }
            } else {
                throw new PDFSignatureException("No other rev info provided for embedding into the signature");
            }
        }
        return seqV;
    }

    public static void addRevocationAttributeToSignedAttributes(ASN1EncodableVector signedAttributes, RevocationInfoProvider revInfoProvider) throws PDFSignatureException {
        if (revInfoProvider == null) {
            throw new PDFSignatureException("No revocation provider has been registered with the SignatureManager");
        }
        Attribute revAttribute = JCERevInfoUtil.createAdobeRevocationInfoAttribute(revInfoProvider);
        if (revAttribute != null) {
            signedAttributes.add((ASN1Encodable)revAttribute);
        }
    }
}

