/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.credentials.impl.JCECredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsCADES;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.BCUtilities;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.JCEASNUtilities;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.JCERevInfoUtil;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.JCETimeStampingUtil;
import java.io.IOException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Security;
import java.util.ArrayList;
import java.util.Date;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.Time;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInfoGenerator;
import org.bouncycastle.cms.jcajce.JcaSignerInfoGeneratorBuilder;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.bouncycastle.util.Store;

public final class JCEPKCS7SignedDataBuilder {
    private static final String OID_SIGNING_CERTIFICATE_V2_ATTRIBUTE = "1.2.840.113549.1.9.16.2.47";
    private static final String OID_SIGNING_CERTIFICATE_OLD_ATTRIBUTE = "1.2.840.113549.1.9.16.2.12";
    public static final String CERTIFICATE_HASH_ALGORITHM_NAME_FOR_OLD_SIGNING_CERTIFICATE_ATTRIBUTE = "SHA1";
    static final DefaultSignatureAlgorithmIdentifierFinder defaultSignatureAlgorithmIdentifierFinder = new DefaultSignatureAlgorithmIdentifierFinder();

    private byte[] buildSignedData(byte[] digestBytes, JCECredentials credentials, CryptoContext ctx, boolean isDummyDigest, boolean isDetached, SignatureOptionsCADES sigOptionsCADES) throws PDFSignatureException {
        boolean embedRevocationInfo = ctx.embedRevocationInfo();
        boolean applyTimestamp = ctx.applyTimestamp() && ctx.getTimeStampProvider() != null;
        try {
            Certificate signingCertificate = Certificate.getInstance((Object)credentials.getCertificate().getEncoded());
            java.security.cert.Certificate[] certChain = credentials.getCertificateChain();
            ArrayList<java.security.cert.Certificate> certList = null;
            if (certChain != null) {
                certList = new ArrayList(certChain.length);
                for (java.security.cert.Certificate cert : certChain) {
                    certList.add(cert);
                }
            } else {
                certList = new ArrayList<java.security.cert.Certificate>();
                certList.add(credentials.getCertificate());
            }
            JcaCertStore certStore = new JcaCertStore(certList);
            CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
            String digestAlgorithm = ctx.getDigestAlgorithm();
            String signingAlgorithm = ctx.getSignatureAlgorithm();
            Provider useProvider = BCUtilities.provider;
            String useAlgorithm = digestAlgorithm + "with" + signingAlgorithm;
            if (useProvider.getService("Signature", useAlgorithm) == null) {
                Provider[] providers = Security.getProviders("Signature." + useAlgorithm);
                if (providers != null) {
                    useProvider = providers[0];
                } else {
                    throw new PDFSignatureException("no available signature providers for " + useAlgorithm);
                }
            }
            ContentSigner signer = new JcaContentSignerBuilder(useAlgorithm).setProvider(useProvider).build(credentials.getPrivateKey());
            ASN1EncodableVector signedAttributes = new ASN1EncodableVector();
            signedAttributes.add((ASN1Encodable)new Attribute(CMSAttributes.contentType, (ASN1Set)new DLSet((ASN1Encodable)PKCSObjectIdentifiers.data)));
            if (isDetached) {
                signedAttributes.add((ASN1Encodable)new Attribute(CMSAttributes.messageDigest, (ASN1Set)new DLSet((ASN1Encodable)new DEROctetString(digestBytes))));
            }
            signedAttributes.add((ASN1Encodable)new Attribute(CMSAttributes.signingTime, (ASN1Set)new DLSet((ASN1Encodable)new Time(new Date()))));
            if (sigOptionsCADES != null) {
                JCEPKCS7SignedDataBuilder.addCAdESpecificAttributesToSignedAttributes(signedAttributes, signingCertificate, sigOptionsCADES);
            }
            if (embedRevocationInfo) {
                JCERevInfoUtil.addRevocationAttributeToSignedAttributes(signedAttributes, ctx.getRevocationInfoProvider());
            }
            AttributeTable signedAttributesTable = new AttributeTable(signedAttributes);
            DefaultSignedAttributeTableGenerator signedAttributeGenerator = new DefaultSignedAttributeTableGenerator(signedAttributesTable);
            JcaSignerInfoGeneratorBuilder sigBuilder = new JcaSignerInfoGeneratorBuilder(new JcaDigestCalculatorProviderBuilder().setProvider(BCUtilities.provider).build());
            sigBuilder.setSignedAttributeGenerator((CMSAttributeTableGenerator)signedAttributeGenerator);
            if (ctx != null && ctx.getSignatureAlgorithm().equalsIgnoreCase("DSA") && isDetached) {
                sigBuilder.setSignedAttributeGenerator(null);
            }
            SignerInfoGenerator sig = sigBuilder.build(signer, new X509CertificateHolder(signingCertificate.getEncoded("DER")));
            gen.addSignerInfoGenerator(sig);
            gen.addCertificates((Store)certStore);
            CMSSignedData signedData = null;
            signedData = ctx != null && ctx.getSignatureAlgorithm().equalsIgnoreCase("DSA") || isDetached ? gen.generate((CMSTypedData)new CMSProcessableByteArray(digestBytes), false) : gen.generate((CMSTypedData)new CMSProcessableByteArray(digestBytes), true);
            if (applyTimestamp) {
                signedData = JCETimeStampingUtil.addTSAttributeToSignedData(signedData, ctx.getTimeStampProvider(), isDummyDigest);
            }
            ASN1Sequence signedSeq = ASN1Sequence.getInstance((Object)signedData.getEncoded());
            signedSeq = JCEASNUtilities.JCESigAlgorithmFixer(signedSeq, defaultSignatureAlgorithmIdentifierFinder.find(useAlgorithm));
            DLSequence derSeq = new DLSequence(signedSeq.toArray());
            return derSeq.getEncoded();
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error building CMS", (Throwable)e);
        }
    }

    private static void addCAdESpecificAttributesToSignedAttributes(ASN1EncodableVector signedAttributes, Certificate signingCertificate, SignatureOptionsCADES sigOptionsCADES) throws NoSuchAlgorithmException, PDFSignatureException, IOException {
        signedAttributes.add((ASN1Encodable)JCEPKCS7SignedDataBuilder.createSigningCertificateAttribute(sigOptionsCADES.getCertificateHashAlgorithmName(), signingCertificate, sigOptionsCADES.isPolicyInformationInSigningCertificateAttributeEnabled()));
    }

    static Attribute createSigningCertificateAttribute(String certificateDigestHashAlgorithmName, Certificate signingCertificate, boolean isPolicyInformationRequired) throws NoSuchAlgorithmException, PDFSignatureException, IOException {
        ASN1ObjectIdentifier signingCertificateOID = certificateDigestHashAlgorithmName.equalsIgnoreCase(CERTIFICATE_HASH_ALGORITHM_NAME_FOR_OLD_SIGNING_CERTIFICATE_ATTRIBUTE) ? new ASN1ObjectIdentifier(OID_SIGNING_CERTIFICATE_OLD_ATTRIBUTE) : new ASN1ObjectIdentifier(OID_SIGNING_CERTIFICATE_V2_ATTRIBUTE);
        ASN1Encodable signingCertificateVXvalue = JCEASNUtilities.getSigningCertificateVXDerEncoded(certificateDigestHashAlgorithmName, signingCertificate, isPolicyInformationRequired);
        return new Attribute(signingCertificateOID, (ASN1Set)new DLSet(signingCertificateVXvalue));
    }

    public byte[] buildPacket(byte[] signatureBytes, JCECredentials credentials, CryptoContext cryptoContext, boolean isDummyDigest, boolean isDetached) throws PDFSignatureException {
        return this.buildSignedData(signatureBytes, credentials, cryptoContext, isDummyDigest, isDetached, null);
    }

    public byte[] buildPacketForCADES(byte[] signatureBytes, JCECredentials credentials, CryptoContext cryptoContext, boolean isDummyDigest, SignatureOptionsCADES sigOptionsCADES) throws PDFSignatureException {
        return this.buildSignedData(signatureBytes, credentials, cryptoContext, isDummyDigest, true, sigOptionsCADES);
    }
}

