/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.asn1.DLSet;
import org.bouncycastle.asn1.DLTaggedObject;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.CertificatePolicies;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;

class JCEASNUtilities {
    JCEASNUtilities() {
    }

    public static AlgorithmIdentifier getASNContainerForAlgorithmIdentifer(String algorithmName) {
        DefaultDigestAlgorithmIdentifierFinder algorithmIdentifierFinder = new DefaultDigestAlgorithmIdentifierFinder();
        if ("SHA1".equalsIgnoreCase(algorithmName) || "SHA-1".equalsIgnoreCase(algorithmName)) {
            return algorithmIdentifierFinder.find("SHA-1");
        }
        if ("SHA256".equalsIgnoreCase(algorithmName) || "SHA-256".equalsIgnoreCase(algorithmName)) {
            return algorithmIdentifierFinder.find("SHA-256");
        }
        if ("SHA384".equalsIgnoreCase(algorithmName) || "SHA-384".equalsIgnoreCase(algorithmName)) {
            return algorithmIdentifierFinder.find("SHA-384");
        }
        if ("SHA512".equalsIgnoreCase(algorithmName) || "SHA-512".equalsIgnoreCase(algorithmName)) {
            return algorithmIdentifierFinder.find("SHA-512");
        }
        if ("SHA224".equalsIgnoreCase(algorithmName) || "SHA-224".equalsIgnoreCase(algorithmName)) {
            return algorithmIdentifierFinder.find("SHA-224");
        }
        return algorithmIdentifierFinder.find(algorithmName);
    }

    static ASN1Encodable getASNContainerForOtherHash(byte[] dataToBeDigested, String algorithmName) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithmName);
        byte[] digest = messageDigest.digest(dataToBeDigested);
        DEROctetString hash = new DEROctetString(digest);
        if (algorithmName.equalsIgnoreCase("SHA1")) {
            return hash;
        }
        AlgorithmIdentifier algorithmIdentifierContainer = JCEASNUtilities.getASNContainerForAlgorithmIdentifer(algorithmName);
        ASN1EncodableVector otherHashV = new ASN1EncodableVector();
        otherHashV.add((ASN1Encodable)algorithmIdentifierContainer);
        otherHashV.add((ASN1Encodable)hash);
        return new DLSequence(otherHashV);
    }

    static ASN1Encodable getASNContainerForHash(byte[] dataToBeDigested, String algorithmName) throws NoSuchAlgorithmException {
        MessageDigest messageDigest = MessageDigest.getInstance(algorithmName);
        byte[] digest = messageDigest.digest(dataToBeDigested);
        return new DEROctetString(digest);
    }

    static ASN1Encodable getASNContainerForIssuerSerial(Certificate signingCertificate) throws PDFSignatureException, IOException {
        X500Name issuerName = signingCertificate.getIssuer();
        GeneralNames issuerGeneralNames = new GeneralNames(new GeneralName(issuerName));
        ASN1Integer serlalNumber = signingCertificate.getSerialNumber();
        ASN1EncodableVector issuerSerial = new ASN1EncodableVector();
        issuerSerial.add((ASN1Encodable)issuerGeneralNames);
        issuerSerial.add((ASN1Encodable)serlalNumber);
        return new DLSequence(issuerSerial);
    }

    static ASN1Encodable getASNContainerForESSCertIDvX(String certificateHashAlgorithmName, Certificate signingCertificate) throws NoSuchAlgorithmException, IOException, PDFSignatureException {
        AlgorithmIdentifier algorithmIdentifierContainer = JCEASNUtilities.getASNContainerForAlgorithmIdentifer(certificateHashAlgorithmName);
        byte[] certificateBytesDerEncoded = signingCertificate.getEncoded("DER");
        ASN1Encodable certificateHashContainer = JCEASNUtilities.getASNContainerForHash(certificateBytesDerEncoded, certificateHashAlgorithmName);
        ASN1Encodable issuerSerialContainer = JCEASNUtilities.getASNContainerForIssuerSerial(signingCertificate);
        ASN1EncodableVector asn1DefESSCertID = new ASN1EncodableVector();
        if (!certificateHashAlgorithmName.equalsIgnoreCase("SHA1")) {
            asn1DefESSCertID.add((ASN1Encodable)algorithmIdentifierContainer);
        }
        asn1DefESSCertID.add(certificateHashContainer);
        asn1DefESSCertID.add(issuerSerialContainer);
        return new DLSequence(asn1DefESSCertID);
    }

    static ASN1Encodable getASNContainerForPolicyInformationSequence(Certificate signingCertificate) {
        PolicyInformation[] policies;
        CertificatePolicies certificatePolicies = JCEASNUtilities.getCertificatePolicies(signingCertificate);
        if (certificatePolicies != null && (policies = certificatePolicies.getPolicyInformation()).length > 0) {
            return new DLSequence((ASN1Encodable[])policies);
        }
        return null;
    }

    static ASN1Encodable getSigningCertificateVXDerEncoded(String certificateHashAlgorithmName, Certificate signingCertificate, boolean isPolicyInformationRequired) throws NoSuchAlgorithmException, PDFSignatureException, IOException {
        ASN1Encodable essCertIDvXContainer = JCEASNUtilities.getASNContainerForESSCertIDvX(certificateHashAlgorithmName, signingCertificate);
        ASN1Encodable policyInformationSequenceContainer = null;
        if (isPolicyInformationRequired) {
            policyInformationSequenceContainer = JCEASNUtilities.getASNContainerForPolicyInformationSequence(signingCertificate);
        }
        ASN1EncodableVector asn1DefSigningCertificateV2 = new ASN1EncodableVector();
        asn1DefSigningCertificateV2.add((ASN1Encodable)new DLSequence(essCertIDvXContainer));
        if (policyInformationSequenceContainer != null) {
            asn1DefSigningCertificateV2.add(policyInformationSequenceContainer);
        }
        return new DLSequence(asn1DefSigningCertificateV2);
    }

    static CertificatePolicies getCertificatePolicies(Certificate certificate) {
        CertificatePolicies certPolicies = null;
        X509CertificateHolder certHolder = new X509CertificateHolder(certificate);
        if (certHolder.getExtensions() != null) {
            certPolicies = CertificatePolicies.fromExtensions((Extensions)certHolder.getExtensions());
        }
        return certPolicies;
    }

    public static ASN1Sequence JCESigAlgorithmFixer(ASN1Sequence signedSeq, AlgorithmIdentifier signingAlgorithm) {
        try {
            ASN1Encodable[] cmsRecord = signedSeq.toArray();
            ASN1Sequence signedData = ASN1Sequence.getInstance((Object)ASN1TaggedObject.getInstance((Object)cmsRecord[1]).getObject());
            ASN1Encodable[] signedDataRecord = signedData.toArray();
            ASN1Set signerInfos = ASN1Set.getInstance((Object)signedDataRecord[signedDataRecord.length - 1]);
            ASN1Encodable[] signerInfo = signerInfos.toArray();
            for (int i = 0; i < signerInfo.length; ++i) {
                signerInfo[i] = JCEASNUtilities.fixOneSignerInfo(signerInfo[i], signingAlgorithm);
            }
            signerInfos = new DLSet(signerInfo);
            signedDataRecord[signedDataRecord.length - 1] = signerInfos;
            cmsRecord[1] = new DLTaggedObject(true, 0, (ASN1Encodable)new DLSequence(signedDataRecord));
            return new DLSequence(cmsRecord);
        }
        catch (Exception e) {
            return signedSeq;
        }
    }

    static ASN1Sequence fixOneSignerInfo(ASN1Encodable sigInfo, AlgorithmIdentifier signingAlgorithm) {
        ASN1Encodable[] sig = ASN1Sequence.getInstance((Object)sigInfo).toArray();
        for (int i = sig.length - 1; i >= 0; --i) {
            ASN1Encodable[] s;
            if (!(sig[i] instanceof ASN1Sequence) || !((s = ASN1Sequence.getInstance((Object)sig[i]).toArray())[0] instanceof ASN1ObjectIdentifier)) continue;
            sig[i] = signingAlgorithm;
            break;
        }
        return new DLSequence(sig);
    }
}

