/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Signer;
import com.adobe.internal.pdftoolkit.services.digsig.spi.TimeStampProvider;
import java.io.InputStream;

public class DocumentTimeStampSigner
extends Signer {
    TimeStampProvider timeStampProvider;

    public DocumentTimeStampSigner(CryptoContext cryptoContext, String digestMethod) throws PDFSignatureException {
        super(null, cryptoContext);
        this.timeStampProvider = cryptoContext.getTimeStampProvider();
        if (this.timeStampProvider == null) {
            throw new PDFSignatureException("Time stamp provider cant be null for a Document Time Stamp Signature");
        }
        this.timeStampProvider.setDigestAlgorithm(digestMethod);
    }

    @Override
    public int getSignatureSize() throws PDFSignatureException {
        return this.timeStampProvider.getTimestampTokenSize();
    }

    @Override
    public byte[] sign(InputStream contents) throws PDFSignatureException {
        try {
            this.timeStampProvider.setDataToTimestamp(contents);
            return this.timeStampProvider.getTimestampToken();
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error when creating message digest", (Throwable)e);
        }
    }
}

