/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.credentials.Credentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.JCECredentials;
import com.adobe.internal.pdftoolkit.core.credentials.impl.RSACredentials;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.core.securityframework.CryptoMode;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptions;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureOptionsCADES;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.CryptoContext;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.SignatureServiceProvider;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Signer;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Verifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.CADESDetachedSigner;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.CADESDetachedVerifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.DocumentTimeStampSigner;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.DocumentTimeStampVerifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.JSAFESignatureDigester;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.PKCS1Signer;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.PKCS7Signer;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAMessageDigester;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAPKCS1PacketBuilder;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAPKCS1Verifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAPKCS7DetachedVerifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAPKCS7SHA1Verifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.RSAPKCS7SignedDataBuilder;

public class CertJNonFIPSProvider
implements SignatureServiceProvider {
    private CryptoContext cryptoContext;
    private SignatureOptions sigOptions;

    public CertJNonFIPSProvider(CryptoContext context) throws PDFSignatureException {
        this.cryptoContext = context;
        if (context.getMode() == CryptoMode.FIPS_MODE) {
            throw new PDFSignatureException("This is a nonFIPS provider. It cannot be used in FIPS mode");
        }
    }

    public CertJNonFIPSProvider(CryptoContext context, SignatureOptions sigOptions) throws PDFSignatureException {
        this(context);
        this.sigOptions = sigOptions;
    }

    @Override
    public CryptoContext getCryptoContext() {
        return this.cryptoContext;
    }

    @Override
    public Signer getPKCS1Signer(Credentials credentials) throws PDFSignatureException {
        RSACredentials rsaCredentials;
        if (credentials instanceof JCECredentials && credentials.isHSM()) {
            throw new PDFSignatureException("JDK1.5 PKCS11 provider support not implemented");
        }
        String digestAlgorithm = this.cryptoContext.getDigestAlgorithm();
        String signatureAlgorithm = this.cryptoContext.getSignatureAlgorithm();
        try {
            rsaCredentials = RSACredentials.newInstance((Credentials)credentials);
        }
        catch (Exception e) {
            throw new PDFSignatureException((Throwable)e);
        }
        JSAFESignatureDigester digester = new JSAFESignatureDigester(rsaCredentials, digestAlgorithm, signatureAlgorithm);
        RSAPKCS1PacketBuilder packetBuilder = new RSAPKCS1PacketBuilder();
        return new PKCS1Signer(this.cryptoContext, digester, packetBuilder);
    }

    @Override
    public Signer getPKCS7Signer(Credentials credentials, boolean isDetached) throws PDFSignatureException {
        RSACredentials rsaCred;
        try {
            rsaCred = RSACredentials.newInstance((Credentials)credentials);
        }
        catch (Exception e) {
            throw new PDFSignatureException((Throwable)e);
        }
        String digestAlgorithm = this.cryptoContext.getDigestAlgorithm();
        RSAMessageDigester digester = new RSAMessageDigester(digestAlgorithm);
        RSAPKCS7SignedDataBuilder packetBuilder = new RSAPKCS7SignedDataBuilder();
        return new PKCS7Signer(rsaCred, this.cryptoContext, isDetached, digester, packetBuilder);
    }

    @Override
    public void setCryptoContext(CryptoContext context) {
        this.cryptoContext = context;
    }

    @Override
    public Verifier getPKCS7Verifier(boolean isDetached) throws PDFSignatureException {
        if (isDetached) {
            return new RSAPKCS7DetachedVerifier();
        }
        return new RSAPKCS7SHA1Verifier(new RSAMessageDigester("SHA1"));
    }

    @Override
    public Verifier getPKCS1Verifier(byte[][] certChain) throws PDFSignatureException {
        return new RSAPKCS1Verifier(certChain);
    }

    @Override
    public Signer getCADESDetachedSigner(Credentials credentials) throws PDFSignatureException {
        RSACredentials rsaCred;
        try {
            rsaCred = RSACredentials.newInstance((Credentials)credentials);
        }
        catch (Exception e) {
            throw new PDFSignatureException((Throwable)e);
        }
        String digestAlgorithm = this.cryptoContext.getDigestAlgorithm();
        RSAMessageDigester digester = new RSAMessageDigester(digestAlgorithm);
        RSAPKCS7SignedDataBuilder packetBuilder = new RSAPKCS7SignedDataBuilder();
        if (this.sigOptions == null || this.sigOptions instanceof SignatureOptionsCADES) {
            return new CADESDetachedSigner(rsaCred, this.cryptoContext, digester, packetBuilder, (SignatureOptionsCADES)this.sigOptions);
        }
        throw new PDFSignatureException("sigOptions not an instance of SignatureOptionsCADES");
    }

    @Override
    public Verifier getCADESDetachedVerifier() throws PDFSignatureException {
        return new CADESDetachedVerifier();
    }

    @Override
    public Signer getDocumentTimeStampSigner() throws PDFSignatureException {
        String digestAlgorithm = this.cryptoContext.getDigestAlgorithm();
        return new DocumentTimeStampSigner(this.cryptoContext, digestAlgorithm);
    }

    @Override
    public Verifier getDocumentTimeStampVerifier() throws PDFSignatureException {
        return new DocumentTimeStampVerifier();
    }
}

