/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSignatureException;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.Verifier;
import com.adobe.internal.pdftoolkit.services.digsig.cryptoprovider.impl.BCUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.cert.CertStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collection;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.ess.ESSCertID;
import org.bouncycastle.asn1.ess.ESSCertIDv2;
import org.bouncycastle.asn1.ess.SigningCertificate;
import org.bouncycastle.asn1.ess.SigningCertificateV2;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.GeneralNames;
import org.bouncycastle.asn1.x509.IssuerSerial;
import org.bouncycastle.asn1.x509.PolicyInformation;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStoreBuilder;
import org.bouncycastle.cert.selector.X509CertificateHolderSelector;
import org.bouncycastle.cert.selector.jcajce.JcaX509CertSelectorConverter;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.DefaultCMSSignatureAlgorithmNameGenerator;
import org.bouncycastle.cms.SignerId;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SignerInformationVerifier;
import org.bouncycastle.cms.bc.BcRSASignerInfoVerifierBuilder;
import org.bouncycastle.operator.DefaultDigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DefaultSignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestAlgorithmIdentifierFinder;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.SignatureAlgorithmIdentifierFinder;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.tsp.TimeStampToken;

public class CADESDetachedVerifier
extends Verifier {
    private static byte[] CONTENT_TYPE_DATA_VALUE;
    private static final String DEFAULT_CERTIFICATE_HASH_ALGORITHM_NAME = "SHA256";
    private static final String CERTIFICATE_HASH_ALGORITHM_NAME_FOR_OLD_SIGNING_CERTIFICATE_ATTRIBUTE = "SHA";

    @Override
    public boolean verify(InputStream inputStream, byte[] signaturePacketData) throws PDFSignatureException {
        try {
            byte[] dataToVerify = new byte[inputStream.available()];
            inputStream.read(dataToVerify);
            CMSSignedData s = new CMSSignedData((CMSProcessable)new CMSProcessableByteArray(dataToVerify), signaturePacketData);
            JcaCertStoreBuilder storeBuilder = new JcaCertStoreBuilder();
            storeBuilder.addCertificates(s.getCertificates());
            storeBuilder.addCRLs(s.getCRLs());
            CertStore certs = storeBuilder.build();
            SignerInformationStore signers = s.getSignerInfos();
            boolean verified = false;
            for (SignerInformation signer : signers.getSigners()) {
                SignerId signer_id = signer.getSID();
                JcaX509CertSelectorConverter conv = new JcaX509CertSelectorConverter();
                X509CertificateHolderSelector sel = new X509CertificateHolderSelector(signer_id.getIssuer(), signer_id.getSerialNumber());
                X509CertSelector signerConstraints = conv.getCertSelector(sel);
                Collection<? extends Certificate> certCollection = certs.getCertificates(signerConstraints);
                BcRSASignerInfoVerifierBuilder infoBuilder = new BcRSASignerInfoVerifierBuilder((CMSSignatureAlgorithmNameGenerator)new DefaultCMSSignatureAlgorithmNameGenerator(), (SignatureAlgorithmIdentifierFinder)new DefaultSignatureAlgorithmIdentifierFinder(), (DigestAlgorithmIdentifierFinder)new DefaultDigestAlgorithmIdentifierFinder(), (DigestCalculatorProvider)new BcDigestCalculatorProvider());
                for (X509Certificate x509Certificate : certCollection) {
                    SignerInformationVerifier sigVerifier = infoBuilder.build(new X509CertificateHolder(x509Certificate.getEncoded()));
                    if (!signer.verify(sigVerifier) || !(verified = this.verifySignedAttributes(signer, x509Certificate) && this.verifyUnsignedAttributes(signer))) continue;
                    return true;
                }
            }
        }
        catch (CMSException e) {
            return false;
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error Verifying CADES Detached Signature", (Throwable)e);
        }
        return false;
    }

    private boolean verifySignedAttributes(SignerInformation signer, X509Certificate verifyingCertificate) throws PDFSignatureException {
        AttributeTable signedAttributesTable = signer.getSignedAttributes();
        if (signedAttributesTable == null) {
            return false;
        }
        boolean result = this.verifyContentTypeAttribute(signedAttributesTable) && this.verifyMessageDigestAttribute(signedAttributesTable) && this.verifySigningCertificateAttribute(signedAttributesTable, verifyingCertificate);
        return result;
    }

    private boolean verifyUnsignedAttributes(SignerInformation signer) throws PDFSignatureException {
        AttributeTable unsignedAttributes = signer.getUnsignedAttributes();
        if (unsignedAttributes == null) {
            return true;
        }
        Attribute timeStampAttribute = unsignedAttributes.get(PKCSObjectIdentifiers.id_aa_signatureTimeStampToken);
        if (timeStampAttribute != null) {
            byte[] timeStampTokenValue = BCUtilities.getASN1EncodedAttributeValue(timeStampAttribute);
            if (timeStampTokenValue == null) {
                throw new PDFSignatureException("Time stamp attribute is present in the signature but the value corresponding to it is not.");
            }
            try {
                TimeStampToken timeStampToken = new TimeStampToken(new CMSSignedData(timeStampTokenValue));
                boolean result = BCUtilities.verifyTimestampToken(timeStampToken);
                if (!result) {
                    return false;
                }
                byte[] messageImprintDigest = timeStampToken.getTimeStampInfo().getMessageImprintDigest();
                String messageImprintAlgorithmName = SignatureUtils.getAlgorithmName(timeStampToken.getTimeStampInfo().getMessageImprintAlgOID());
                MessageDigest digester = MessageDigest.getInstance(messageImprintAlgorithmName, BCUtilities.provider);
                byte[] signatureBytes = signer.getSignature();
                digester.update(signatureBytes);
                byte[] signatureDigest = digester.digest();
                return Arrays.equals(signatureDigest, messageImprintDigest);
            }
            catch (Exception e) {
                throw new PDFSignatureException("Error validating time stamp token attribute", (Throwable)e);
            }
        }
        return true;
    }

    private boolean verifyContentTypeAttribute(AttributeTable signedAttributesTable) {
        Attribute contentTypeAttribute = signedAttributesTable.get(CMSAttributes.contentType);
        if (contentTypeAttribute == null) {
            return false;
        }
        byte[] contentTypeAttributeValue = BCUtilities.getASN1EncodedAttributeValue(contentTypeAttribute);
        return Arrays.equals(contentTypeAttributeValue, CONTENT_TYPE_DATA_VALUE);
    }

    private boolean verifyMessageDigestAttribute(AttributeTable signedAttributesTable) {
        Attribute messageDigestAttribute = signedAttributesTable.get(CMSAttributes.messageDigest);
        if (messageDigestAttribute != null) {
            return BCUtilities.getASN1EncodedAttributeValue(messageDigestAttribute) != null;
        }
        return false;
    }

    private boolean verifySigningCertificateAttribute(AttributeTable signedAttributesTable, X509Certificate verifyingCertificate) throws PDFSignatureException {
        SigningCertificate signingCertificateOLD;
        Attribute signingCertificateAttribute;
        SigningCertificateV2 signingCertificateV2;
        boolean found = false;
        Attribute signingCertificateV2Attribute = signedAttributesTable.get(PKCSObjectIdentifiers.id_aa_signingCertificateV2);
        if (signingCertificateV2Attribute != null && (signingCertificateV2 = SigningCertificateV2.getInstance((Object)BCUtilities.getASN1EncodableAttributeValue(signingCertificateV2Attribute))) != null) {
            found = true;
            if (!this.verifySigningCertificateV2Attribute(signingCertificateV2, verifyingCertificate)) {
                return false;
            }
        }
        if ((signingCertificateAttribute = signedAttributesTable.get(PKCSObjectIdentifiers.id_aa_signingCertificate)) != null && (signingCertificateOLD = SigningCertificate.getInstance((Object)BCUtilities.getASN1EncodableAttributeValue(signingCertificateAttribute))) != null) {
            found = true;
            if (!this.verifySigningCertificateOLDAttribute(signingCertificateOLD, verifyingCertificate)) {
                return false;
            }
        }
        return found;
    }

    private boolean verifySigningCertificateV2Attribute(SigningCertificateV2 signingCertificateV2, X509Certificate verifyingCertificate) throws PDFSignatureException {
        ESSCertIDv2[] essCertsIDv2 = signingCertificateV2.getCerts();
        if (essCertsIDv2 == null || essCertsIDv2.length == 0) {
            return false;
        }
        ESSCertIDv2 essCertIDv2 = essCertsIDv2[0];
        try {
            String hashAlgorithmName = essCertIDv2.getHashAlgorithm() == null ? null : SignatureUtils.getAlgorithmName(essCertIDv2.getHashAlgorithm().getAlgorithm());
            boolean result = this.verifyCertificateHashValue(verifyingCertificate, essCertIDv2.getCertHash(), hashAlgorithmName) && this.verifyIssuerSerial(verifyingCertificate, essCertIDv2.getIssuerSerial()) && this.verifyPolicyInformation(verifyingCertificate, signingCertificateV2.getPolicies());
            return result;
        }
        catch (CertificateEncodingException e) {
            throw new PDFSignatureException("Error verifying Certifcate Hash Value in SigningCertificateV2 attribute", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFSignatureException("Error verifying Certifcate Hash Value in SigningCertificateV2 attribute", (Throwable)e);
        }
    }

    private boolean verifySigningCertificateOLDAttribute(SigningCertificate signingCertificateOLD, X509Certificate verifyingCertificate) throws PDFSignatureException {
        ESSCertID[] essCertsID = signingCertificateOLD.getCerts();
        if (essCertsID == null || essCertsID.length == 0) {
            return false;
        }
        ESSCertID essCertID = essCertsID[0];
        try {
            boolean result = this.verifyCertificateHashValue(verifyingCertificate, essCertID.getCertHash(), CERTIFICATE_HASH_ALGORITHM_NAME_FOR_OLD_SIGNING_CERTIFICATE_ATTRIBUTE) && this.verifyIssuerSerial(verifyingCertificate, essCertID.getIssuerSerial()) && this.verifyPolicyInformation(verifyingCertificate, signingCertificateOLD.getPolicies());
            return result;
        }
        catch (CertificateEncodingException e) {
            throw new PDFSignatureException("Error verifying Certifcate Hash Value in SigningCertificateV2 attribute", (Throwable)e);
        }
        catch (IOException e) {
            throw new PDFSignatureException("Error verifying Certifcate Hash Value in SigningCertificateV2 attribute", (Throwable)e);
        }
    }

    private boolean verifyCertificateHashValue(X509Certificate verifyingCertificate, byte[] signedCertificateHash, String hashAlgorithmName) throws PDFSignatureException {
        try {
            byte[] verifyingCertificateBytes = verifyingCertificate.getEncoded();
            if (hashAlgorithmName == null) {
                hashAlgorithmName = DEFAULT_CERTIFICATE_HASH_ALGORITHM_NAME;
            }
            MessageDigest digester = MessageDigest.getInstance(hashAlgorithmName, BCUtilities.provider);
            digester.update(verifyingCertificateBytes);
            byte[] verifyingCertificateHash = digester.digest();
            return Arrays.equals(verifyingCertificateHash, signedCertificateHash);
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error verifying cert hash value in ESSCertV2", (Throwable)e);
        }
    }

    private boolean verifyIssuerSerial(X509Certificate verifyingCertificate, IssuerSerial issuerSerial) throws PDFSignatureException, CertificateEncodingException, IOException {
        BigInteger verifyingCertificateIssuerSerialNumber;
        if (issuerSerial == null) {
            return true;
        }
        if (issuerSerial.getSerial() == null) {
            return false;
        }
        BigInteger signedIssuerSerialNumber = issuerSerial.getSerial().getValue();
        if (!signedIssuerSerialNumber.equals(verifyingCertificateIssuerSerialNumber = verifyingCertificate.getSerialNumber())) {
            return false;
        }
        X509CertificateHolder verifyingCertH = new X509CertificateHolder(verifyingCertificate.getEncoded());
        String verifyingCertificateIssuerName = new X500Name(verifyingCertH.getIssuer().getRDNs()).toString();
        GeneralNames issuerNames = issuerSerial.getIssuer();
        if (issuerNames == null) {
            return false;
        }
        GeneralName[] issuerNamesArray = issuerNames.getNames();
        if (issuerNamesArray == null || issuerNamesArray.length != 1) {
            return false;
        }
        String signedIssuerName = issuerNamesArray[0].getName().toString();
        return signedIssuerName.equals(verifyingCertificateIssuerName);
    }

    private boolean verifyPolicyInformation(X509Certificate verifyingCertificate, PolicyInformation[] signedPolicyInformationArray) throws PDFSignatureException {
        if (signedPolicyInformationArray == null) {
            return true;
        }
        try {
            ASN1Sequence verifyingCertificatePolicyList = CADESDetachedVerifier.getPolicyListFromCertificate(verifyingCertificate);
            if (verifyingCertificatePolicyList == null) {
                return false;
            }
            for (int j = 0; j < verifyingCertificatePolicyList.size(); ++j) {
                PolicyInformation verifyingCertificatePolicy = PolicyInformation.getInstance((Object)verifyingCertificatePolicyList.getObjectAt(j));
                for (int i = 0; i < signedPolicyInformationArray.length; ++i) {
                    if (!signedPolicyInformationArray[i].getPolicyIdentifier().getId().equals(verifyingCertificatePolicy.getPolicyIdentifier().getId())) continue;
                    return true;
                }
            }
        }
        catch (Exception e) {
            throw new PDFSignatureException("Error validating policy information in signingcertificateV2 attribute", (Throwable)e);
        }
        return false;
    }

    private static ASN1Sequence getPolicyListFromCertificate(X509Certificate certificate) throws IOException, PDFInvalidParameterException {
        byte[] certificatePoliciesExtensionValue = certificate.getExtensionValue(X509Extensions.CertificatePolicies.getId());
        if (certificatePoliciesExtensionValue == null) {
            return null;
        }
        ASN1OctetString localASN1OctetString = ASN1OctetString.getInstance((Object)new ASN1InputStream(certificatePoliciesExtensionValue).readObject());
        return ASN1Sequence.getInstance((Object)new ASN1InputStream(localASN1OctetString.getOctets()).readObject());
    }

    static {
        try {
            CONTENT_TYPE_DATA_VALUE = PKCSObjectIdentifiers.data.getEncoded("DER");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

