/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.xfa.AppModel;
import com.adobe.xfa.Element;
import com.adobe.xfa.Model;
import com.adobe.xfa.Node;
import com.adobe.xfa.ProtoableNode;
import com.adobe.xfa.XFA;
import com.adobe.xfa.data.DataNode;
import com.adobe.xfa.form.FormDataListener;
import com.adobe.xfa.form.FormModel;
import com.adobe.xfa.template.containers.Container;
import com.adobe.xfa.template.containers.ContentArea;
import com.adobe.xfa.template.containers.Field;
import com.adobe.xfa.template.containers.PageArea;
import com.adobe.xfa.template.containers.PageSet;
import com.adobe.xfa.template.ui.UI;
import com.adobe.xfa.ut.Peer;
import java.util.HashMap;
import java.util.Map;

public final class XFAChangeLogger
implements Node.ChangeLogger {
    boolean recordChanges = false;
    HashMap changes = new HashMap();
    AppModel curAppModel = null;
    boolean formModified = false;

    public void enableChangeLogging() {
        this.recordChanges = true;
    }

    public boolean isFormModified() {
        if (!this.changes.isEmpty()) {
            return true;
        }
        return this.formModified;
    }

    public void setCurAppModel(AppModel curAppModel) {
        this.curAppModel = curAppModel;
    }

    public HashMap getChanges() {
        return this.changes;
    }

    public void dumpLog(HashMap changes) {
        for (Map.Entry entry : changes.entrySet()) {
            System.out.println((String)entry.getKey() + " = " + (String)entry.getValue());
        }
    }

    void setFormModified() {
        this.formModified = true;
    }

    public void logChildChange(Node container, Node child, Object userData) {
        if (container != null) {
            this.setFormModified();
            if (!this.recordChanges) {
                return;
            }
            AppModel appModel = child.getModel().getAppModel();
            String changeString = appModel != null && appModel == this.curAppModel ? "Create" : "Delete";
            Model containerModel = container.getModel();
            if (containerModel instanceof FormModel && container != containerModel) {
                if (child.isContainer()) {
                    if (container instanceof PageSet || container instanceof PageArea || container instanceof ContentArea) {
                        ProtoableNode protoableNode;
                        ProtoableNode proto;
                        if (child instanceof ProtoableNode && (proto = (protoableNode = (ProtoableNode)child).getProto()) != null) {
                            this.logFormChange("Page:" + changeString, (Container)child, proto.getSOMExpression());
                        }
                    } else {
                        this.logFormParentAndChildren("Field:" + changeString, (Container)child, changeString);
                    }
                }
            } else {
                this.logChange("Misc:" + changeString, child, changeString);
            }
        }
    }

    void logFormParentAndChildren(String changeKey, Container parent, String changeInfo) {
        Model model = parent.getModel();
        if (!(model instanceof FormModel)) {
            return;
        }
        if (parent.isContainer()) {
            this.setFormModified();
            if (!this.recordChanges) {
                return;
            }
            String logInfo = changeInfo;
            if ("Create".equals(logInfo) || "Delete".equals(logInfo)) {
                if (parent instanceof Field) {
                    UI uiElem = (UI)parent.peekElement(XFA.UITAG, true, 0);
                    if (uiElem != null) {
                        String fieldType;
                        Element curUIElem = uiElem.getUIElement(false);
                        Model parentModel = parent.getModel();
                        if (parentModel != null && curUIElem != null && (fieldType = parentModel.getSchema().getAtom(curUIElem.getClassTag())).length() > 0) {
                            logInfo = fieldType;
                        }
                    }
                } else {
                    String nodeType;
                    Model parentModel = parent.getModel();
                    if (parentModel != null && (nodeType = parentModel.getSchema().getAtom(parent.getClassTag())).length() > 0) {
                        logInfo = nodeType;
                    }
                }
            }
            String logKey = changeKey;
            this.logFormChange(logKey, parent, logInfo);
        }
        int childCount = parent.getXFAChildCount();
        for (int index = 0; index < childCount; ++index) {
            Node child = parent.getXFAChild(index);
            if (child == null || !child.isContainer()) continue;
            this.logFormParentAndChildren(changeKey, (Container)child, changeInfo);
        }
    }

    public void logDataChange(Node currentData, Node rollbackData, boolean bCurrentModelled, boolean bRollbackModelled, String currentValue, Object userData) {
        Node changedNode;
        String changeInfo;
        String change;
        boolean bInXHTML;
        boolean bModelled;
        boolean bBound;
        this.setFormModified();
        if (!this.recordChanges) {
            return;
        }
        if (currentData == null) {
            bBound = this.isBound(rollbackData);
            bModelled = bRollbackModelled;
            bInXHTML = this.inXHTML(rollbackData);
            change = "Delete";
            changeInfo = "Delete";
            changedNode = rollbackData;
        } else if (rollbackData == null) {
            bBound = this.isBound(currentData);
            bModelled = bCurrentModelled;
            bInXHTML = this.inXHTML(currentData);
            change = "Create";
            changeInfo = "Create";
            changedNode = currentData;
        } else {
            bBound = this.isBound(currentData) && this.isBound(rollbackData);
            bModelled = bCurrentModelled && bRollbackModelled;
            bInXHTML = this.inXHTML(currentData) && this.inXHTML(rollbackData);
            change = "Fill";
            changeInfo = currentValue;
            changedNode = currentData;
        }
        if (!bBound || !bModelled && !bInXHTML) {
            this.logChange("Misc:" + change, changedNode, changeInfo);
        }
    }

    public void logPropChange(Node container, String propName, String newValue, Object userData) {
        if (container != null) {
            this.setFormModified();
            if (!this.recordChanges) {
                return;
            }
            Model model = container.getModel();
            if (model instanceof FormModel && container != model) {
                if (container.isContainer()) {
                    if (container instanceof PageSet || container instanceof PageArea || container instanceof ContentArea) {
                        ProtoableNode protoable = (ProtoableNode)container;
                        ProtoableNode proto = protoable.getProto();
                        if (proto != null) {
                            this.logFormChange("PropChange - Page:Modify : PropName - " + propName + " ", (Container)container, proto.getSOMExpression());
                        }
                    } else if ("value.override".equals(propName)) {
                        this.logFormChange("PropChange - Field:Fill : PropName - " + propName + " ", (Container)container, newValue);
                    } else {
                        this.logFormChange("PropChange - Field:Modify : PropName - " + propName + " ", (Container)container, newValue);
                    }
                }
            } else {
                this.logChange("PropChange - Misc:Modify : PropName - " + propName + " ", container, newValue);
            }
        }
    }

    public void logValueChange(Node container, String newValue, Object userData) {
        if (container != null) {
            this.setFormModified();
            if (!this.recordChanges) {
                return;
            }
            Model model = container.getModel();
            if (model instanceof FormModel && container != model) {
                if (container.isContainer()) {
                    if (container instanceof PageArea || container instanceof ContentArea) {
                        assert (false);
                    } else {
                        this.logFormChange("Field:Fill", (Container)container, newValue);
                    }
                }
            } else {
                this.logChange("Misc:Fill", container, newValue);
            }
        }
    }

    void logFormChange(String key, Container node, String changeInfo) {
        this.setFormModified();
        if (!this.recordChanges) {
            return;
        }
        String changeLogKey = key;
        String changeLogInfo = changeInfo;
        if (changeLogInfo.length() <= 0) {
            changeLogInfo = "(blank)";
        }
        this.logChange(changeLogKey, (Node)node, changeLogInfo);
    }

    public void logChange(String keyName, Node node, String keyInfo) {
        this.setFormModified();
        if (!this.recordChanges) {
            return;
        }
        StringBuilder strBuilder = new StringBuilder(keyName);
        if (node != null) {
            Model model = node.getModel();
            if (model != null) {
                strBuilder.append(':').append(node.getSOMExpression((Node)model, false));
            } else {
                strBuilder.append(':').append(node.getSOMExpression());
            }
            this.formModified = true;
        }
        this.changes.put(strBuilder.toString(), keyInfo);
    }

    boolean isBound(Node dataNode) {
        if (dataNode != null) {
            int nPeer = 0;
            Peer peer = dataNode.getPeer(nPeer);
            while (peer != null) {
                Element formNode;
                if (peer instanceof FormDataListener && (formNode = ((FormDataListener)peer).getFormNode()) != null) {
                    return true;
                }
                peer = dataNode.getPeer(++nPeer);
            }
        }
        return false;
    }

    boolean inXHTML(Node dataNode) {
        if (dataNode != null) {
            if (dataNode instanceof DataNode && ((DataNode)dataNode).getContentType().equals("text/html")) {
                return true;
            }
            Node domNode = dataNode.getFirstXMLChild();
            if (domNode instanceof Element && "http://www.w3.org/1999/xhtml".equals(((Element)domNode).getNS())) {
                return true;
            }
        }
        return false;
    }
}

