/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.fontengine.font.FontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.core.types.ASName;
import com.adobe.internal.pdftoolkit.pdf.document.PDFCatalog;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.PDFResources;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFont;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.PDFFontMap;
import com.adobe.internal.pdftoolkit.pdf.graphics.font.impl.PDFFontUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFDefaultAppearance;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.pdf.page.PDFPage;
import com.adobe.internal.pdftoolkit.services.digsig.SigFieldLock;
import com.adobe.internal.pdftoolkit.services.digsig.SigSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldFactory;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldPDF;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureFieldLockXFA;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureSeedValueXFA;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.PDDoc2CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.impl.SOMExpressionUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMServiceListener;
import com.adobe.internal.pdftoolkit.services.xfa.template.XFAFont;
import com.adobe.xfa.XFA;
import com.adobe.xfa.template.containers.Field;
import java.util.Locale;
import java.util.Set;

public class SignatureFieldXFA
implements SignatureFieldInterface {
    private Field xfaField;
    private PDFDocument pdfDoc;
    private PDFFieldSignature pdfFieldSignature = null;
    private static final int ACROFORM = 0;
    private static final int DYNAMIC_XFA_DOCUMENT = 1;
    private static final int STATIC_NON_SHELL_XFA_DOCUMENT = 2;

    public SignatureFieldXFA(PDFDocument pdfDoc, Field xfaField) throws PDFInvalidParameterException {
        if (pdfDoc == null) {
            throw new PDFInvalidParameterException("PDF Document can't be null");
        }
        if (xfaField == null) {
            throw new PDFInvalidParameterException("XFA Field can't be null");
        }
        this.xfaField = xfaField;
        this.pdfDoc = pdfDoc;
    }

    @Override
    public SignatureFieldPDF getPDFField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.getPDFField(true);
    }

    private SignatureFieldPDF getPDFField(boolean generateIfNotAlready) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (this.pdfFieldSignature != null) {
                return new SignatureFieldPDF(this.pdfFieldSignature);
            }
            if (XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
                CPDField cpdField = PDDoc2CPDFields.GetCPDFieldsFromPDDoc(this.pdfDoc, true).getCPDField(SOMExpressionUtils.trimSomExpression(this.xfaField.getSOMExpression()));
                if (cpdField != null) {
                    PDFFieldNode fieldNode = cpdField.getPDFFieldNode();
                    if (fieldNode instanceof PDFFieldSignature) {
                        this.pdfFieldSignature = (PDFFieldSignature)fieldNode;
                        return new SignatureFieldPDF(this.pdfFieldSignature);
                    }
                    return null;
                }
                throw new PDFInvalidDocumentException("No signature field found in Acroform corresponding to XFA field");
            }
            if (XFAService.getDocumentType(this.pdfDoc).isDynamic() || XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticShellXFA) {
                DocumentListenerRegistry registry = this.pdfDoc.getListenerRegistry();
                XFADOMServiceListener serviceListener = (XFADOMServiceListener)registry.getListener(XFADOMServiceListener.class);
                if (serviceListener == null) {
                    XFADOMService.ensureXFADOMCreated(this.pdfDoc);
                    serviceListener = (XFADOMServiceListener)registry.getListener(XFADOMServiceListener.class);
                }
                this.pdfFieldSignature = serviceListener.getIteratedPDFFieldSignature(SOMExpressionUtils.trimSomExpression(this.xfaField.getSOMExpression()));
                if (this.pdfFieldSignature != null) {
                    return this.getPDFField();
                }
                this.pdfFieldSignature = this.searchPDFField();
                if (this.pdfFieldSignature != null) {
                    serviceListener.setIteratedSignatureField(SOMExpressionUtils.trimSomExpression(this.xfaField.getSOMExpression()), this.pdfFieldSignature, this.xfaField);
                    if (!serviceListener.isSignatureFieldGenerated(this.pdfFieldSignature.getQualifiedName())) {
                        if (this.isSigned()) {
                            serviceListener.setGeneratedSignatureFieldList(this.pdfFieldSignature.getQualifiedName());
                            return this.getPDFField();
                        }
                        if (generateIfNotAlready) {
                            PDFFieldSignature currentNode = this.pdfFieldSignature;
                            PDFFieldNode parentNode = null;
                            while ((parentNode = currentNode.getParent()) != null) {
                                if (parentNode.getChildren().size() == 1) {
                                    parentNode.removeChildren();
                                    currentNode = parentNode;
                                    continue;
                                }
                                parentNode.removeChild((PDFFieldNode)currentNode);
                                break;
                            }
                            if (parentNode == null) {
                                this.pdfDoc.requireCatalog().procureInteractiveForm().getChildren().clear();
                            }
                        }
                    } else {
                        return this.getPDFField();
                    }
                }
                if (generateIfNotAlready) {
                    SignatureFieldInterface sigField = this.generatePDFFieldSignature();
                    this.pdfFieldSignature = ((SignatureFieldPDF)sigField).getPDFFieldSignature();
                    serviceListener.setGeneratedSignatureFieldList(this.pdfFieldSignature.getQualifiedName());
                }
                return this.pdfFieldSignature != null ? this.getPDFField() : null;
            }
            throw new PDFInvalidDocumentException("Invalid XFA file provided");
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    @Override
    public SignatureFieldXFA getXFAField() {
        return this;
    }

    @Override
    public boolean isCertifyingPermitted() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SignatureManager sigMgr = SignatureManager.newInstance(this.pdfDoc);
        if (!this.isSigningPermitted()) {
            return false;
        }
        PDFInteractiveForm iform = this.pdfDoc.getInteractiveForm();
        if (iform != null && iform.getFlags() == 2) {
            return false;
        }
        return !sigMgr.hasPermissionsSignature() && !sigMgr.hasSignedSignatureFields();
    }

    @Override
    public boolean isReadOnly() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.xfaField == null) {
            throw new PDFInvalidDocumentException("Signature field is null");
        }
        String accessAttribute = this.xfaField.getAttribute(XFA.ACCESSTAG).getAttrValue();
        return accessAttribute != null && accessAttribute.equals("readOnly");
    }

    @Override
    public boolean isSigned() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SignatureFieldPDF pdfSigField = this.getPDFField(false);
        if (pdfSigField != null) {
            return pdfSigField.isSigned();
        }
        return false;
    }

    @Override
    public boolean isSigningPermitted() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.xfaField == null || this.isReadOnly() || this.isSigned()) {
            return false;
        }
        String[] providers = new String[]{"Security", "DocMDP", "UR", "XFA"};
        try {
            PermissionsManager permsMgr = PermissionsManager.newInstance((PDFDocument)this.pdfDoc, (String[])providers);
            return permsMgr.isPermitted(ObjectOperations.SIGNATURE_FILLIN);
        }
        catch (PDFConfigurationException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFIOException((Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    @Override
    public boolean isVisible() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String presenceAttr = this.xfaField.getAttribute(XFA.PRESENCETAG).getAttrValue();
        if (presenceAttr == null) {
            return true;
        }
        return !presenceAttr.equalsIgnoreCase("invisible");
    }

    @Override
    public SigFieldLock getFieldLock() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            return this.getFieldLock(2);
        }
        if (XFAService.getDocumentType(this.getPDFDocument()).isDynamic() || XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticShellXFA) {
            return this.getFieldLock(1);
        }
        return this.getFieldLock(0);
    }

    protected SigFieldLock getFieldLock(int getInPDForXFA) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            SignatureFieldPDF pdfField;
            SignatureFieldLockXFA xfaFieldLock = new SignatureFieldLockXFA(this.pdfDoc, this.xfaField);
            SigFieldLock fieldLock = null;
            if (getInPDForXFA != 0) {
                SigFieldLock pdfFieldLock;
                fieldLock = xfaFieldLock.getFieldLock();
                if (fieldLock != null && (pdfField = this.getPDFField()) != null && (pdfFieldLock = pdfField.getFieldLock(0)) != null) {
                    fieldLock.setFieldPermission(pdfFieldLock.getFieldPermission());
                }
                if (getInPDForXFA == 1) {
                    return fieldLock;
                }
            }
            if (getInPDForXFA == 2 && fieldLock == null && (pdfField = this.getPDFField()) != null) {
                return pdfField.getFieldLock(0);
            }
            return fieldLock;
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    @Override
    public void setFieldLock(SigFieldLock fieldLock) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            this.setFieldLock(fieldLock, 2);
        } else if (XFAService.getDocumentType(this.getPDFDocument()).isDynamic() || XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticShellXFA) {
            this.setFieldLock(fieldLock, 1);
        } else {
            this.setFieldLock(fieldLock, 0);
        }
    }

    protected void setFieldLock(SigFieldLock fieldLock, int setInPDF) throws PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFInvalidDocumentException {
        SignatureFieldPDF pdfField;
        if (setInPDF != 1 && (pdfField = this.getPDFField()) != null) {
            pdfField.setFieldLock(fieldLock, 0);
        }
        if (setInPDF != 0) {
            SignatureFieldLockXFA sigFieldLock = new SignatureFieldLockXFA(this.pdfDoc, this.xfaField);
            sigFieldLock.setFieldLock(fieldLock);
        }
    }

    @Override
    public SigSeedValue getSeedValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            return this.getSeedValue(2);
        }
        if (XFAService.getDocumentType(this.getPDFDocument()).isDynamic() || XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticShellXFA) {
            return this.getSeedValue(1);
        }
        return this.getSeedValue(0);
    }

    protected SigSeedValue getSeedValue(int getInPDForXFA) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            SignatureFieldPDF pdfField;
            SignatureSeedValueXFA xfaSeedValue = new SignatureSeedValueXFA(this.pdfDoc, this.xfaField);
            SigSeedValue seedValue = null;
            if (getInPDForXFA != 0) {
                seedValue = xfaSeedValue.getSeedValue();
                if (getInPDForXFA == 1) {
                    return seedValue;
                }
            }
            if (getInPDForXFA == 2 && seedValue == null && (pdfField = this.getPDFField()) != null) {
                return pdfField.getSeedValue(0);
            }
            return seedValue;
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    @Override
    public void setSeedValue(SigSeedValue seedValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            this.setSeedValue(seedValue, 2);
        }
        if (XFAService.getDocumentType(this.getPDFDocument()).isDynamic() || XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticShellXFA) {
            this.setSeedValue(seedValue, 1);
        } else {
            this.setSeedValue(seedValue, 0);
        }
    }

    protected void setSeedValue(SigSeedValue seedValue, int setInPDF) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        SignatureFieldPDF pdfField;
        if (setInPDF != 1 && (pdfField = this.getPDFField()) != null) {
            pdfField.setSeedValue(seedValue, 0);
        }
        if (setInPDF != 0) {
            SignatureSeedValueXFA sigSeedValue = new SignatureSeedValueXFA(this.pdfDoc, this.xfaField);
            sigSeedValue.setSeedValue(seedValue);
        }
    }

    @Override
    public PDFDocument getPDFDocument() {
        return this.pdfDoc;
    }

    public Field getXFAFieldSignature() {
        return this.xfaField;
    }

    private PDFFieldSignature searchPDFField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        String[] fieldNames = new String[]{SOMExpressionUtils.trimSomExpression(this.xfaField.getSOMExpression())};
        PDFFieldNode[] fieldNode = PDFFieldUtils.searchFields((String[])fieldNames, (PDFDocument)this.pdfDoc);
        if (fieldNode != null && fieldNode.length > 0 && fieldNode[0] instanceof PDFFieldSignature) {
            return (PDFFieldSignature)fieldNode[0];
        }
        return null;
    }

    private SignatureFieldInterface generatePDFFieldSignature() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (XFAService.getDocumentType(this.pdfDoc).isDynamic() || XFAService.getDocumentType(this.pdfDoc) == PDFDocument.PDFDocumentType.StaticShellXFA) {
            try {
                SignatureFieldInterface sigField = this.convertXFAAcroformSignatureField();
                if (sigField instanceof SignatureFieldPDF) {
                    return sigField;
                }
                return null;
            }
            catch (PDFConfigurationException e) {
                throw new PDFInvalidDocumentException((Throwable)e);
            }
        }
        throw new PDFInvalidDocumentException("NON-Dynamic Document found :- Generate PDF Field Signature should be called on Dynamic Document only");
    }

    private SignatureFieldInterface convertXFAAcroformSignatureField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFConfigurationException {
        try {
            PDFRectangle annotRect = PDFRectangle.newInstance((PDFDocument)this.pdfDoc, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
            PDFPage page = this.pdfDoc.requirePages().getPage(0);
            String somExpression = SOMExpressionUtils.trimSomExpression(this.xfaField.getSOMExpression());
            return this.createAcroFormSignatureField(page, annotRect, somExpression, this.isReadOnly());
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException("Invalid parameter ", (Throwable)e);
        }
    }

    private SignatureFieldInterface createAcroFormSignatureField(PDFPage page, PDFRectangle annotRect, String somExpression, boolean isReadOnly) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException {
        boolean useUnicodeEncoding = true;
        PDFCatalog cat = page.getPDFDocument().requireCatalog();
        PDFInteractiveForm form = cat.getInteractiveForm();
        PDFFieldNode parent = PDFFieldUtils.procureIntermediateFieldNodes((String)somExpression, (boolean)useUnicodeEncoding, (PDFFieldNode)form);
        SignatureFieldPDF sigField = new SignatureFieldPDF(SignatureFieldFactory.initPDFSignatureFieldWithName(page, annotRect, parent, somExpression, useUnicodeEncoding, this.doFontProcessing()));
        if (isReadOnly) {
            sigField.getPDFField().getPDFFieldSignature().setFlags(sigField.getPDFField().getPDFFieldSignature().getFlags() | 1);
        }
        return sigField;
    }

    @Override
    public String getQualifiedName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return SOMExpressionUtils.trimSomExpression(this.xfaField.getSOMExpression());
    }

    private PDFDefaultAppearance doFontProcessing() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException, PDFConfigurationException {
        PDFInteractiveForm iform = this.pdfDoc.getInteractiveForm();
        if (!this.isVisible()) {
            return null;
        }
        XFAFont xfaFont = new XFAFont(XFAUtils.getFontElement(this.xfaField, true));
        DRFontMatchData matchingFontInfo = this.getMatchingDRFont(xfaFont, iform);
        try {
            if (matchingFontInfo != null && matchingFontInfo.getPDFFont() != null) {
                return PDFDefaultAppearance.newInstance((PDFDocument)this.pdfDoc, (ASName)matchingFontInfo.getFontKeyName(), (int)((int)xfaFont.getPointSize()), (double)0.0);
            }
            PDFFont pdfFontToAdd = PDFFontUtils.createFontForEditing((PDFDocument)this.pdfDoc, (String)xfaFont.getTypeface(), (String)xfaFont.getPosture().toString(), (String)xfaFont.getWeight().toString(), (double)xfaFont.getPointSize(), (Locale)this.getFontLocale(), (boolean)false, (boolean)false);
            if (pdfFontToAdd != null) {
                return PDFDefaultAppearance.newInstance((PDFDocument)this.pdfDoc, (ASName)pdfFontToAdd.getBaseFont(), (int)((int)xfaFont.getPointSize()), (double)0.0);
            }
            throw new PDFConfigurationException("CSS look up failed - cannot find a font for the XFA signature field");
        }
        catch (FontException e) {
            throw new PDFConfigurationException("Cannot get equivalent AFEFont for XFA font using CSS look up", (Throwable)e);
        }
        catch (PDFFontException e) {
            throw new PDFConfigurationException("Cannot get equivalent AFEFont for XFA font using CSS look up", (Throwable)e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFConfigurationException("Exception occured while generating default appearance for pdf signature field.", (Throwable)e);
        }
    }

    private Locale getFontLocale() {
        String xfaLocale = XFAUtils.getLocale(this.xfaField, null);
        Locale computedLocale = this.pdfDoc.getDocumentLocale();
        if (xfaLocale != null) {
            computedLocale = new Locale(xfaLocale);
        }
        return computedLocale;
    }

    private DRFontMatchData getMatchingDRFont(XFAFont xfaFont, PDFInteractiveForm iform) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (iform != null) {
            PDFFontMap pdfFontMap = null;
            PDFResources dr = iform.getResources();
            if (dr != null) {
                pdfFontMap = dr.getFontMap();
            }
            if (pdfFontMap != null) {
                Set fontsKeySet = pdfFontMap.keySet();
                for (ASName fontKeyName : fontsKeySet) {
                    PDFFont pdfFont = pdfFontMap.get(fontKeyName);
                    if (!xfaFont.equals(pdfFont)) continue;
                    return new DRFontMatchData(pdfFont, fontKeyName);
                }
            }
        }
        return null;
    }

    private static class DRFontMatchData {
        PDFFont pdfFont;
        ASName fontKeyName;

        public ASName getFontKeyName() {
            return this.fontKeyName;
        }

        public PDFFont getPDFFont() {
            return this.pdfFont;
        }

        public DRFontMatchData(PDFFont pdfFont, ASName fontKeyName) {
            this.pdfFont = pdfFont;
            this.fontKeyName = fontKeyName;
        }
    }
}

