/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.internal.pdftoolkit.services.digsig;

import com.adobe.internal.pdftoolkit.core.exceptions.PDFConfigurationException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFFontException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFIOException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidDocumentException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidParameterException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFInvalidXMLException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFSecurityException;
import com.adobe.internal.pdftoolkit.core.exceptions.PDFUnableToCompleteOperationException;
import com.adobe.internal.pdftoolkit.core.permissionprovider.ObjectOperations;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldAction;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFFieldLock;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignature;
import com.adobe.internal.pdftoolkit.pdf.digsig.PDFSignatureFieldSeedValue;
import com.adobe.internal.pdftoolkit.pdf.document.PDFDocument;
import com.adobe.internal.pdftoolkit.pdf.document.listener.DocumentListenerRegistry;
import com.adobe.internal.pdftoolkit.pdf.graphics.PDFRectangle;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotation;
import com.adobe.internal.pdftoolkit.pdf.interactive.annotation.PDFAnnotationIterator;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldNode;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldSignature;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFFieldUtils;
import com.adobe.internal.pdftoolkit.pdf.interactive.forms.PDFInteractiveForm;
import com.adobe.internal.pdftoolkit.services.digsig.SigFieldLock;
import com.adobe.internal.pdftoolkit.services.digsig.SigSeedValue;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldInterface;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureFieldXFA;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureManager;
import com.adobe.internal.pdftoolkit.services.digsig.SignatureUtils;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureFieldLockPDF;
import com.adobe.internal.pdftoolkit.services.digsig.impl.SignatureSeedValuePDF;
import com.adobe.internal.pdftoolkit.services.permissions.PermissionsManager;
import com.adobe.internal.pdftoolkit.services.xfa.XFADOMService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAService;
import com.adobe.internal.pdftoolkit.services.xfa.XFAUtils;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.CPDField;
import com.adobe.internal.pdftoolkit.services.xfa.acroform.PDDoc2CPDFields;
import com.adobe.internal.pdftoolkit.services.xfa.impl.SOMExpressionUtils;
import com.adobe.internal.pdftoolkit.services.xfa.impl.XFADOMServiceListener;
import com.adobe.xfa.template.containers.Field;
import java.util.ArrayList;
import java.util.List;

public class SignatureFieldPDF
implements SignatureFieldInterface {
    private PDFFieldSignature pdfFieldSignature;
    private Field xfaField;
    private static final int ACROFORM = 0;
    private static final int DYNAMIC_XFA_DOCUMENT = 1;
    private static final int STATIC_NONSHELL_XFA_DOCUMENT = 2;

    public SignatureFieldPDF(PDFFieldSignature pdfFieldSignature) throws PDFInvalidParameterException {
        if (pdfFieldSignature == null) {
            throw new PDFInvalidParameterException("Signature Field provided is null");
        }
        this.pdfFieldSignature = pdfFieldSignature;
    }

    public PDFFieldSignature getPDFFieldSignature() {
        return this.pdfFieldSignature;
    }

    @Override
    public SignatureFieldPDF getPDFField() {
        return this;
    }

    @Override
    public SignatureFieldXFA getXFAField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            if (this.xfaField != null) {
                return new SignatureFieldXFA(this.getPDFDocument(), this.xfaField);
            }
            if (XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.Flat || XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.Acroform) {
                return null;
            }
            if (XFAService.getDocumentType(this.getPDFDocument()).isStatic()) {
                CPDField cpdField = PDDoc2CPDFields.GetCPDFieldsFromPDDoc(this.getPDFDocument(), true).getCPDField(this.pdfFieldSignature.getCosDictionary(), false);
                if (cpdField == null) {
                    return null;
                }
                this.xfaField = (Field)cpdField.getXFAField(true);
                if (this.xfaField == null) {
                    this.xfaField = this.searchXFAField();
                }
                if (this.xfaField == null) {
                    return null;
                }
                return new SignatureFieldXFA(this.getPDFDocument(), this.xfaField);
            }
            if (XFAService.getDocumentType(this.getPDFDocument()).isDynamic()) {
                Field xfaField = this.searchXFAField();
                if (xfaField != null) {
                    return new SignatureFieldXFA(this.getPDFDocument(), xfaField);
                }
                return null;
            }
            throw new PDFInvalidDocumentException("Get XFA Field is called on Invalid Document ");
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFFontException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    @Override
    public boolean isCertifyingPermitted() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFDocument pdfDoc = this.pdfFieldSignature.getPDFDocument();
        if (!this.isSigningPermitted()) {
            return false;
        }
        PDFInteractiveForm iform = pdfDoc.getInteractiveForm();
        if (iform != null && iform.getFlags() == 2) {
            return false;
        }
        SignatureManager sigMgr = SignatureManager.newInstance(pdfDoc);
        return !sigMgr.hasPermissionsSignature() && !sigMgr.hasSignedSignatureFields();
    }

    @Override
    public boolean isReadOnly() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfFieldSignature.isReadOnly();
    }

    @Override
    public boolean isSigned() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        PDFSignature pdfSig = this.pdfFieldSignature.getSignature();
        return pdfSig != null && SignatureUtils.getContents(pdfSig) != null;
    }

    @Override
    public boolean isSigningPermitted() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (this.pdfFieldSignature == null || this.isSigned() || this.isReadOnly()) {
            return false;
        }
        String[] providers = new String[]{"Security", "DocMDP", "UR", "XFA"};
        try {
            PermissionsManager permsMgr = PermissionsManager.newInstance((PDFDocument)this.pdfFieldSignature.getPDFDocument(), (String[])providers);
            if (!permsMgr.isPermitted(ObjectOperations.SIGNATURE_FILLIN)) {
                return false;
            }
        }
        catch (PDFConfigurationException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFInvalidXMLException e) {
            throw new PDFIOException((Throwable)e);
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        catch (PDFUnableToCompleteOperationException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
        return true;
    }

    @Override
    public boolean isVisible() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        SignatureFieldXFA xfaField;
        boolean checkXFA = true;
        PDFDocument.PDFDocumentType docType = XFAService.getDocumentType(this.getPDFDocument());
        if (docType != PDFDocument.PDFDocumentType.Acroform && (xfaField = this.getXFAField()) != null) {
            checkXFA = xfaField.isVisible();
            if (docType.isDynamic() || docType == PDFDocument.PDFDocumentType.StaticShellXFA) {
                return checkXFA;
            }
        }
        boolean checkPDF = false;
        PDFAnnotationIterator iter = this.pdfFieldSignature.getAnnotationsIterator();
        while (iter.hasNext()) {
            PDFAnnotation widget = iter.next();
            PDFRectangle rect = widget.getRect();
            checkPDF = rect.height() != 0.0 || rect.width() != 0.0;
        }
        if (docType == PDFDocument.PDFDocumentType.Acroform) {
            return checkPDF;
        }
        return checkXFA && checkPDF;
    }

    @Override
    public SigFieldLock getFieldLock() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            return this.getFieldLock(2);
        }
        if (XFAService.getDocumentType(this.getPDFDocument()).isDynamic() || XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticShellXFA) {
            return this.getFieldLock(1);
        }
        return this.getFieldLock(0);
    }

    protected SigFieldLock getFieldLock(int getInPDForXFA) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            PDFFieldLock pdfSigFieldLock;
            if (getInPDForXFA != 0) {
                SigFieldLock fieldLock;
                SignatureFieldXFA xfaField = this.getXFAField();
                if (xfaField != null && (fieldLock = xfaField.getFieldLock(1)) != null) {
                    return fieldLock;
                }
                if (getInPDForXFA == 1) {
                    return null;
                }
            }
            if ((pdfSigFieldLock = this.pdfFieldSignature.getPDFFieldLock()) == null) {
                return null;
            }
            SignatureFieldLockPDF pdfFieldLock = new SignatureFieldLockPDF(pdfSigFieldLock);
            return pdfFieldLock.getFieldLock();
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    @Override
    public void setFieldLock(SigFieldLock fieldLock) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            this.setFieldLock(fieldLock, 2);
        } else if (XFAService.getDocumentType(this.getPDFDocument()).isDynamic() || XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticShellXFA) {
            this.setFieldLock(fieldLock, 1);
        } else {
            this.setFieldLock(fieldLock, 0);
        }
    }

    protected void setFieldLock(SigFieldLock fieldLock, int setInXFA) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (setInXFA != 0) {
            SignatureFieldXFA xfaField = this.getXFAField();
            if (xfaField != null) {
                xfaField.setFieldLock(fieldLock, 1);
            }
            if (setInXFA == 1) {
                return;
            }
        }
        PDFFieldLock pdfFieldLock = this.pdfFieldSignature.getPDFFieldLock();
        if (fieldLock != null) {
            if (pdfFieldLock == null) {
                List<String> fieldList = fieldLock.getFieldList();
                PDFFieldNode[] fieldNodes = null;
                if (fieldList != null) {
                    ArrayList<String> newFieldList = new ArrayList<String>(fieldList.size());
                    for (int i = 0; i < fieldList.size(); ++i) {
                        newFieldList.add(SOMExpressionUtils.trimSomExpression(fieldList.get(i)));
                    }
                    fieldNodes = PDFFieldUtils.searchFields((String[])newFieldList.toArray(new String[newFieldList.size()]), (PDFDocument)this.getPDFDocument());
                }
                pdfFieldLock = PDFFieldLock.newInstance((PDFDocument)this.getPDFDocument(), (PDFFieldAction)fieldLock.getFieldAction(), fieldNodes);
                this.pdfFieldSignature.setPDFFieldLock(pdfFieldLock);
            }
            new SignatureFieldLockPDF(pdfFieldLock).setFieldLock(fieldLock);
        } else if (pdfFieldLock != null) {
            this.pdfFieldSignature.setPDFFieldLock(null);
        }
    }

    @Override
    public SigSeedValue getSeedValue() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        if (XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            return this.getSeedValue(2);
        }
        if (XFAService.getDocumentType(this.getPDFDocument()).isDynamic() || XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticShellXFA) {
            return this.getSeedValue(1);
        }
        return this.getSeedValue(0);
    }

    protected SigSeedValue getSeedValue(int setInPDForXFA) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        try {
            PDFSignatureFieldSeedValue pdfSigSeedValue;
            if (setInPDForXFA != 0 && setInPDForXFA != 2) {
                SigSeedValue seedValue;
                SignatureFieldXFA xfaField = this.getXFAField();
                if (xfaField != null && (seedValue = xfaField.getSeedValue(1)) != null) {
                    return seedValue;
                }
                if (setInPDForXFA == 1) {
                    return null;
                }
            }
            if ((pdfSigSeedValue = this.pdfFieldSignature.getFieldSeedValue()) != null) {
                return new SignatureSeedValuePDF(pdfSigSeedValue).getSeedValue();
            }
            return null;
        }
        catch (PDFInvalidParameterException e) {
            throw new PDFInvalidDocumentException((Throwable)e);
        }
    }

    @Override
    public void setSeedValue(SigSeedValue seedValue) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticNonShellXFA) {
            this.setSeedValue(seedValue, 2);
        } else if (XFAService.getDocumentType(this.getPDFDocument()).isDynamic() || XFAService.getDocumentType(this.getPDFDocument()) == PDFDocument.PDFDocumentType.StaticShellXFA) {
            this.setSeedValue(seedValue, 1);
        } else {
            this.setSeedValue(seedValue, 0);
        }
    }

    protected void setSeedValue(SigSeedValue seedValue, int setInXFA) throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        if (setInXFA != 0) {
            SignatureFieldXFA xfaField = this.getXFAField();
            if (xfaField != null) {
                xfaField.setSeedValue(seedValue, 1);
            }
            if (setInXFA == 1) {
                return;
            }
        }
        PDFSignatureFieldSeedValue pdfSeedValue = this.pdfFieldSignature.getFieldSeedValue();
        if (seedValue != null) {
            if (pdfSeedValue == null) {
                pdfSeedValue = PDFSignatureFieldSeedValue.newInstance((PDFDocument)this.getPDFDocument());
                this.pdfFieldSignature.setFieldSeedValue(pdfSeedValue);
            }
            SignatureSeedValuePDF sv = new SignatureSeedValuePDF(pdfSeedValue);
            sv.setSeedValue(seedValue);
        } else if (pdfSeedValue != null) {
            this.pdfFieldSignature.setFieldSeedValue(null);
        }
    }

    @Override
    public PDFDocument getPDFDocument() {
        return this.pdfFieldSignature.getPDFDocument();
    }

    private Field searchXFAField() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException, PDFInvalidParameterException {
        XFADOMService.ensureXFADOMCreated(this.getPDFDocument());
        DocumentListenerRegistry registry = this.getPDFDocument().getListenerRegistry();
        XFADOMServiceListener serviceListener = (XFADOMServiceListener)registry.getListener(XFADOMServiceListener.class);
        this.xfaField = serviceListener.getIteratedXFAField(SOMExpressionUtils.trimSomExpression(this.pdfFieldSignature.getQualifiedName()));
        if (this.xfaField != null) {
            return this.xfaField;
        }
        this.xfaField = XFAUtils.getXFASignatureField(this.getPDFDocument(), this.pdfFieldSignature.getQualifiedName());
        if (this.xfaField == null) {
            return null;
        }
        serviceListener.setIteratedSignatureField(SOMExpressionUtils.trimSomExpression(this.pdfFieldSignature.getQualifiedName()), this.pdfFieldSignature, this.xfaField);
        return this.xfaField;
    }

    @Override
    public String getQualifiedName() throws PDFInvalidDocumentException, PDFIOException, PDFSecurityException {
        return this.pdfFieldSignature.getQualifiedName();
    }
}

